"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../specs");
function isValidPointerOverEvent(mainScale, event) {
    return specs_1.isPointerOverEvent(event) && (event.unit === undefined || event.unit === mainScale.unit);
}
exports.isValidPointerOverEvent = isValidPointerOverEvent;
function hasDragged(prevProps, nextProps) {
    if (nextProps === null) {
        return false;
    }
    if (!nextProps.onBrushEnd) {
        return false;
    }
    var prevLastDrag = prevProps !== null ? prevProps.lastDrag : null;
    var nextLastDrag = nextProps !== null ? nextProps.lastDrag : null;
    if (prevLastDrag === null && nextLastDrag !== null) {
        return true;
    }
    if (prevLastDrag !== null && nextLastDrag !== null && prevLastDrag.end.time !== nextLastDrag.end.time) {
        return true;
    }
    return false;
}
exports.hasDragged = hasDragged;
//# sourceMappingURL=events.js.map