/**
 * chroma.js - JavaScript library for color conversions
 *
 * Copyright (c) 2011-2019, Gregor Aisch
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name Gregor Aisch may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GREGOR AISCH OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -------------------------------------------------------
 *
 * chroma.js includes colors from colorbrewer2.org, which are released under
 * the following license:
 *
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower,
 * and The Pennsylvania State University.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * ------------------------------------------------------
 *
 * Named colors are taken from X11 Color Names.
 * http://www.w3.org/TR/css3-color/#svg-color
 *
 * @preserve
 */

!function(t,r){"object"==typeof exports&&"undefined"!=typeof module?module.exports=r():"function"==typeof define&&define.amd?define(r):t.chroma=r()}(this,function(){"use strict";for(var n=function(t,r,n){return void 0===r&&(r=0),void 0===n&&(n=1),t<r?r:n<t?n:t},r={},t=0,e=["Boolean","Number","String","Function","Array","Date","RegExp","Undefined","Null"];t<e.length;t+=1){var o=e[t];r["[object "+o+"]"]=o.toLowerCase()}var a=function(t){return r[Object.prototype.toString.call(t)]||"object"},i=(Math.PI,function(t){t._clipped=!1,t._unclipped=t.slice(0);for(var r=0;r<=3;r++)r<3?((t[r]<0||255<t[r])&&(t._clipped=!0),t[r]=n(t[r],0,255)):3===r&&(t[r]=n(t[r],0,1));return t}),u=a,s=function(r,t){return void 0===t&&(t=null),3<=r.length?Array.prototype.slice.call(r):"object"==a(r[0])&&t?t.split("").filter(function(t){return void 0!==r[0][t]}).map(function(t){return r[0][t]}):r[0]},l=function(t){if(t.length<2)return null;var r=t.length-1;return"string"==a(t[r])?t[r].toLowerCase():null},h={format:{},autodetect:[]},c=l,f=i,p=u,g=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];if("object"===p(t[0])&&t[0].constructor&&t[0].constructor===this.constructor)return t[0];var n=c(t),e=!1;if(!n){e=!0,h.sorted||(h.autodetect=h.autodetect.sort(function(t,r){return r.p-t.p}),h.sorted=!0);for(var o=0,a=h.autodetect;o<a.length;o+=1){var i=a[o];if(n=i.test.apply(i,t))break}}if(!h.format[n])throw new Error("unknown format: "+t);var u=h.format[n].apply(null,e?t:t.slice(0,-1));this._rgb=f(u),3===this._rgb.length&&this._rgb.push(1)};g.prototype.toString=function(){return"function"==p(this.hex)?this.hex():"["+this._rgb.join(",")+"]"};var d=g,v=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(v.Color,[null].concat(t)))};v.Color=d,v.version="2.1.0";var b=v,y=s,w=l,m=function(t){return Math.round(100*t)/100},_=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=y(t,"hsla"),e=w(t)||"lsa";return n[0]=m(n[0]||0),n[1]=m(100*n[1])+"%",n[2]=m(100*n[2])+"%","hsla"===e||3<n.length&&n[3]<1?(n[3]=3<n.length?n[3]:1,e="hsla"):n.length=3,e+"("+n.join(",")+")"},x=s,M=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=(t=x(t,"rgba"))[0],e=t[1],o=t[2];n/=255,e/=255,o/=255;var a,i,u=Math.min(n,e,o),s=Math.max(n,e,o),l=(s+u)/2;return s===u?(a=0,i=Number.NaN):a=l<.5?(s-u)/(s+u):(s-u)/(2-s-u),n==s?i=(e-o)/(s-u):e==s?i=2+(o-n)/(s-u):o==s&&(i=4+(n-e)/(s-u)),(i*=60)<0&&(i+=360),3<t.length&&void 0!==t[3]?[i,a,l,t[3]]:[i,a,l]},k=s,j=l,F=Math.round,N=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=k(t,"rgba"),e=j(t)||"rgb";return"hsl"==e.substr(0,3)?_(M(n),e):(n[0]=F(n[0]),n[1]=F(n[1]),n[2]=F(n[2]),("rgba"===e||3<n.length&&n[3]<1)&&(n[3]=3<n.length?n[3]:1,e="rgba"),e+"("+n.slice(0,"rgb"===e?3:4).join(",")+")")},$=s,A=Math.round,C=function(){for(var t,r=[],n=arguments.length;n--;)r[n]=arguments[n];var e,o,a,i=(r=$(r,"hsl"))[0],u=r[1],s=r[2];if(0===u)e=o=a=255*s;else{var l=[0,0,0],h=[0,0,0],c=s<.5?s*(1+u):s+u-s*u,f=2*s-c,p=i/360;l[0]=p+1/3,l[1]=p,l[2]=p-1/3;for(var g=0;g<3;g++)l[g]<0&&(l[g]+=1),1<l[g]&&(l[g]-=1),6*l[g]<1?h[g]=f+6*(c-f)*l[g]:2*l[g]<1?h[g]=c:3*l[g]<2?h[g]=f+(c-f)*(2/3-l[g])*6:h[g]=f;e=(t=[A(255*h[0]),A(255*h[1]),A(255*h[2])])[0],o=t[1],a=t[2]}return 3<r.length?[e,o,a,r[3]]:[e,o,a,1]},E=/^rgb\(\s*(-?\d+),\s*(-?\d+)\s*,\s*(-?\d+)\s*\)$/,O=/^rgba\(\s*(-?\d+),\s*(-?\d+)\s*,\s*(-?\d+)\s*,\s*([01]|[01]?\.\d+)\)$/,S=/^rgb\(\s*(-?\d+(?:\.\d+)?)%,\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*\)$/,L=/^rgba\(\s*(-?\d+(?:\.\d+)?)%,\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)$/,I=/^hsl\(\s*(-?\d+(?:\.\d+)?),\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*\)$/,q=/^hsla\(\s*(-?\d+(?:\.\d+)?),\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)$/,B=Math.round,D=function(t){var r;if(r=(t=t.toLowerCase().trim()).match(E)){for(var n=r.slice(1,4),e=0;e<3;e++)n[e]=+n[e];return n[3]=1,n}if(r=t.match(O)){for(var o=r.slice(1,5),a=0;a<4;a++)o[a]=+o[a];return o}if(r=t.match(S)){for(var i=r.slice(1,4),u=0;u<3;u++)i[u]=B(2.55*i[u]);return i[3]=1,i}if(r=t.match(L)){for(var s=r.slice(1,5),l=0;l<3;l++)s[l]=B(2.55*s[l]);return s[3]=+s[3],s}if(r=t.match(I)){var h=r.slice(1,4);h[1]*=.01,h[2]*=.01;var c=C(h);return c[3]=1,c}if(r=t.match(q)){var f=r.slice(1,4);f[1]*=.01,f[2]*=.01;var p=C(f);return p[3]=+r[4],p}};D.test=function(t){return E.test(t)||O.test(t)||S.test(t)||L.test(t)||I.test(t)||q.test(t)};var P=D,R=u;d.prototype.css=function(t){return N(this._rgb,t)},b.css=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(d,[null].concat(t,["css"])))},h.format.css=P,h.autodetect.push({p:5,test:function(t){for(var r=[],n=arguments.length-1;0<n--;)r[n]=arguments[n+1];if(!r.length&&"string"===R(t)&&P.test(t))return"css"}});var U=s,z=l,G=Math.round,H=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=U(t,"rgba"),e=n[0],o=n[1],a=n[2],i=n[3],u=z(t)||"auto";void 0===i&&(i=1),"auto"===u&&(u=i<1?"rgba":"rgb");var s="000000"+((e=G(e))<<16|(o=G(o))<<8|(a=G(a))).toString(16);s=s.substr(s.length-6);var l="0"+G(255*i).toString(16);switch(l=l.substr(l.length-2),u.toLowerCase()){case"rgba":return"#"+s+l;case"argb":return"#"+l+s;default:return"#"+s}},J=/^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/,K=/^#?([A-Fa-f0-9]{8}|[A-Fa-f0-9]{4})$/,Q=function(t){if(t.match(J)){4!==t.length&&7!==t.length||(t=t.substr(1)),3===t.length&&(t=(t=t.split(""))[0]+t[0]+t[1]+t[1]+t[2]+t[2]);var r=parseInt(t,16);return[r>>16,r>>8&255,255&r,1]}if(t.match(K)){5!==t.length&&9!==t.length||(t=t.substr(1)),4===t.length&&(t=(t=t.split(""))[0]+t[0]+t[1]+t[1]+t[2]+t[2]+t[3]+t[3]);var n=parseInt(t,16);return[n>>24&255,n>>16&255,n>>8&255,Math.round((255&n)/255*100)/100]}throw new Error("unknown hex color: "+t)},T=u;d.prototype.hex=function(t){return H(this._rgb,t)},b.hex=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(d,[null].concat(t,["hex"])))},h.format.hex=Q,h.autodetect.push({p:4,test:function(t){for(var r=[],n=arguments.length-1;0<n--;)r[n]=arguments[n+1];if(!r.length&&"string"===T(t)&&0<=[3,4,5,6,7,8,9].indexOf(t.length))return"hex"}});var V=s,W=u;d.prototype.hsl=function(){return M(this._rgb)},b.hsl=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(d,[null].concat(t,["hsl"])))},h.format.hsl=C,h.autodetect.push({p:2,test:function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];if(t=V(t,"hsl"),"array"===W(t)&&3===t.length)return"hsl"}});var X=18,Y=.95047,Z=1,tt=1.08883,rt=.137931034,nt=.206896552,et=.12841855,ot=.008856452,at=s,it=Math.pow,ut=function(t){return(t/=255)<=.04045?t/12.92:it((t+.055)/1.055,2.4)},st=function(t){return ot<t?it(t,1/3):t/et+rt},lt=function(t,r,n){return t=ut(t),r=ut(r),n=ut(n),[st((.4124564*t+.3575761*r+.1804375*n)/Y),st((.2126729*t+.7151522*r+.072175*n)/Z),st((.0193339*t+.119192*r+.9503041*n)/tt)]},ht=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=at(t,"rgb"),e=n[0],o=n[1],a=n[2],i=lt(e,o,a),u=i[0],s=i[1],l=116*s-16;return[l<0?0:l,500*(u-s),200*(s-i[2])]},ct=s,ft=Math.pow,pt=function(t){return 255*(t<=.00304?12.92*t:1.055*ft(t,1/2.4)-.055)},gt=function(t){return nt<t?t*t*t:et*(t-rt)},dt=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n,e,o,a=(t=ct(t,"lab"))[0],i=t[1],u=t[2];return e=(a+16)/116,n=isNaN(i)?e:e+i/500,o=isNaN(u)?e:e-u/200,e=Z*gt(e),n=Y*gt(n),o=tt*gt(o),[pt(3.2404542*n-1.5371385*e-.4985314*o),pt(-.969266*n+1.8760108*e+.041556*o),pt(.0556434*n-.2040259*e+1.0572252*o),3<t.length?t[3]:1]},vt=s,bt=u;d.prototype.lab=function(){return ht(this._rgb)},b.lab=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(d,[null].concat(t,["lab"])))},h.format.lab=dt,h.autodetect.push({p:2,test:function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];if(t=vt(t,"lab"),"array"===bt(t)&&3===t.length)return"lab"}});var yt=s,wt=u,mt=Math.round;d.prototype.rgb=function(t){return void 0===t&&(t=!0),!1===t?this._rgb.slice(0,3):this._rgb.slice(0,3).map(mt)},d.prototype.rgba=function(n){return void 0===n&&(n=!0),this._rgb.slice(0,4).map(function(t,r){return r<3?!1===n?t:mt(t):t})},b.rgb=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(d,[null].concat(t,["rgb"])))},h.format.rgb=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=yt(t,"rgba");return void 0===n[3]&&(n[3]=1),n},h.autodetect.push({p:3,test:function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];if(t=yt(t,"rgba"),"array"===wt(t)&&(3===t.length||4===t.length&&"number"==wt(t[3])&&0<=t[3]&&t[3]<=1))return"rgb"}});var _t=u;d.prototype.alpha=function(t,r){return void 0===r&&(r=!1),void 0!==t&&"number"===_t(t)?r?(this._rgb[3]=t,this):new d([this._rgb[0],this._rgb[1],this._rgb[2],t],"rgb"):this._rgb[3]},d.prototype.darken=function(t){void 0===t&&(t=1);var r=this.lab();return r[0]-=X*t,new d(r,"lab").alpha(this.alpha(),!0)},d.prototype.brighten=function(t){return void 0===t&&(t=1),this.darken(-t)},d.prototype.darker=d.prototype.darken,d.prototype.brighter=d.prototype.brighten,d.prototype.get=function(t){var r=t.split("."),n=r[0],e=r[1],o=this[n]();if(e){var a=n.indexOf(e);if(-1<a)return o[a];throw new Error("unknown channel "+e+" in mode "+n)}return o};var xt={},Mt=u,kt=function(t,r,n){void 0===n&&(n=.5);for(var e=[],o=arguments.length-3;0<o--;)e[o]=arguments[o+3];var a=e[0]||"lrgb";if(xt[a]||e.length||(a=Object.keys(xt)[0]),!xt[a])throw new Error("interpolation mode "+a+" is not defined");return"object"!==Mt(t)&&(t=new d(t)),"object"!==Mt(r)&&(r=new d(r)),xt[a](t,r,n).alpha(t.alpha()+n*(r.alpha()-t.alpha()))};d.prototype.mix=d.prototype.interpolate=function(t,r){void 0===r&&(r=.5);for(var n=[],e=arguments.length-2;0<e--;)n[e]=arguments[e+2];return kt.apply(void 0,[this,t,r].concat(n))};var jt=u;d.prototype.set=function(t,r,n){void 0===n&&(n=!1);var e=t.split("."),o=e[0],a=e[1],i=this[o]();if(a){var u=o.indexOf(a);if(-1<u){if("string"==jt(r))switch(r.charAt(0)){case"+":case"-":i[u]+=+r;break;case"*":i[u]*=+r.substr(1);break;case"/":i[u]/=+r.substr(1);break;default:i[u]=+r}else{if("number"!==jt(r))throw new Error("unsupported value for Color.set");i[u]=r}var s=new d(i,o);return n?(this._rgb=s._rgb,this):s}throw new Error("unknown channel "+a+" in mode "+o)}return i};var Ft=Math.sqrt,Nt=Math.pow;xt.lrgb=function(t,r,n){var e=t._rgb,o=e[0],a=e[1],i=e[2],u=r._rgb,s=u[0],l=u[1],h=u[2];return new d(Ft(Nt(o,2)*(1-n)+Nt(s,2)*n),Ft(Nt(a,2)*(1-n)+Nt(l,2)*n),Ft(Nt(i,2)*(1-n)+Nt(h,2)*n),"rgb")};return b.mix=b.interpolate=kt,b.valid=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];try{return new(Function.prototype.bind.apply(d,[null].concat(t))),!0}catch(t){return!1}},b});
