
#ifndef KCOMPACTDISC_EXPORT_H
#define KCOMPACTDISC_EXPORT_H

#ifdef KCOMPACTDISC_STATIC_DEFINE
#  define KCOMPACTDISC_EXPORT
#  define KCOMPACTDISC_NO_EXPORT
#else
#  ifndef KCOMPACTDISC_EXPORT
#    ifdef KCompactDisc_EXPORTS
        /* We are building this library */
#      define KCOMPACTDISC_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KCOMPACTDISC_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KCOMPACTDISC_NO_EXPORT
#    define KCOMPACTDISC_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KCOMPACTDISC_DECL_DEPRECATED
#  define KCOMPACTDISC_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KCOMPACTDISC_DECL_DEPRECATED_EXPORT
#  define KCOMPACTDISC_DECL_DEPRECATED_EXPORT KCOMPACTDISC_EXPORT KCOMPACTDISC_DECL_DEPRECATED
#endif

#ifndef KCOMPACTDISC_DECL_DEPRECATED_NO_EXPORT
#  define KCOMPACTDISC_DECL_DEPRECATED_NO_EXPORT KCOMPACTDISC_NO_EXPORT KCOMPACTDISC_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCOMPACTDISC_NO_DEPRECATED
#    define KCOMPACTDISC_NO_DEPRECATED
#  endif
#endif

#define KCOMPACTDISC_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

#if defined(KCOMPACTDISC_NO_DEPRECATED)
#  undef KCOMPACTDISC_DEPRECATED
#  define KCOMPACTDISC_DEPRECATED_EXPORT KCOMPACTDISC_EXPORT
#  define KCOMPACTDISC_DEPRECATED_NO_EXPORT KCOMPACTDISC_NO_EXPORT
#elif defined(KCOMPACTDISC_NO_DEPRECATED_WARNINGS)
#  define KCOMPACTDISC_DEPRECATED
#  define KCOMPACTDISC_DEPRECATED_EXPORT KCOMPACTDISC_EXPORT
#  define KCOMPACTDISC_DEPRECATED_NO_EXPORT KCOMPACTDISC_NO_EXPORT
#else
#  define KCOMPACTDISC_DEPRECATED KCOMPACTDISC_DECL_DEPRECATED
#  define KCOMPACTDISC_DEPRECATED_EXPORT KCOMPACTDISC_DECL_DEPRECATED_EXPORT
#  define KCOMPACTDISC_DEPRECATED_NO_EXPORT KCOMPACTDISC_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCOMPACTDISC_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCOMPACTDISC_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCOMPACTDISC_NO_DEPRECATED
#  define KCOMPACTDISC_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50000
#endif
#ifdef KCOMPACTDISC_NO_DEPRECATED_WARNINGS
#  define KCOMPACTDISC_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCOMPACTDISC_DEPRECATED_WARNINGS_SINCE
#  ifdef KCOMPACTDISC_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCOMPACTDISC_DEPRECATED_WARNINGS_SINCE KCOMPACTDISC_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCOMPACTDISC_DEPRECATED_WARNINGS_SINCE 0x50000
#  endif
#endif

#ifndef KCOMPACTDISC_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCOMPACTDISC_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCOMPACTDISC_DEPRECATED
#  define KCOMPACTDISC_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KCOMPACTDISC_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCOMPACTDISC_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KCOMPACTDISC_EXPORT_H */
