/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.logstash.beats.Batch;

public class Message
implements Comparable<Message> {
    private final int sequence;
    private String identityStream;
    private Map data;
    private Batch batch;
    private ByteBuf buffer;
    public static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new AfterburnerModule());

    public Message(int sequence, Map map) {
        this.sequence = sequence;
        this.data = map;
    }

    public Message(int sequence, ByteBuf buffer) {
        this.sequence = sequence;
        this.buffer = buffer;
    }

    public int getSequence() {
        return this.sequence;
    }

    public Map getData() {
        if (this.data == null && this.buffer != null) {
            try (ByteBufInputStream byteBufInputStream = new ByteBufInputStream(this.buffer);){
                this.data = (Map)MAPPER.readValue((InputStream)byteBufInputStream, Map.class);
                this.buffer = null;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to parse beats payload ", e);
            }
        }
        return this.data;
    }

    @Override
    public int compareTo(Message o) {
        return Integer.compare(this.getSequence(), o.getSequence());
    }

    public Batch getBatch() {
        return this.batch;
    }

    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    public String getIdentityStream() {
        if (this.identityStream == null) {
            this.identityStream = this.extractIdentityStream();
        }
        return this.identityStream;
    }

    private String extractIdentityStream() {
        Map beatsData = (Map)this.getData().get("beat");
        if (beatsData != null) {
            String id = (String)beatsData.get("id");
            String resourceId = (String)beatsData.get("resource_id");
            if (id != null && resourceId != null) {
                return id + "-" + resourceId;
            }
            return beatsData.get("name") + "-" + beatsData.get("source");
        }
        return null;
    }
}

