# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class RenderTimerLog(Object):
    """
    RenderTimerLog - Asynchronously measures GPU execution times for a
    series of events.
    
    Superclass: Object
    
    This class measures the time it takes for events to occur on the GPU
    by posting timing events into the rendering command stream. This can
    be used to compute the time spent doing work on the GPU without
    stalling the CPU.
    
    To aid asynchronous usage, this class uses the concepts "Event" and
    "Frame", where a Frame is a logical collection of Events. The timer
    log can manage multiple Frames at a time:
    - The current Frame, where new Events are created.
    - Pending Frames, for which all Events have been marked, but the
      results are not available (the timer requests are still waiting to
      be processed by the graphics device).
    - Ready Frames, which have been completed by the graphics device and
      may be retrieved.
    
    Call mark_frame() to begin a new Frame. This pushes the current Frame
    to the collection of pending Frames, and creates a new one to store
    future Events.
    
    Call mark_start_event() and mark_end_event() to mark the beginning and
    end of an Event. These Events may be nested, but all child Events
    must have their end marked before the parent Event ends.
    
    Use frame_ready() and pop_first_ready_frame() to check for completed
    Frames and retrieve results.
    
    This is currently only implemented for the open_gl2 backend. The
    is_supported() method can be used to detect if there is a valid
    implementation available.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRenderTimerLog, obj, update, **traits)
    
    logging_enabled = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _logging_enabled_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLoggingEnabled,
                        self.logging_enabled_)

    frame_limit = traits.Int(32, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _frame_limit_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFrameLimit,
                        self.frame_limit)

    def frame_ready(self):
        """
        V.frame_ready() -> bool
        C++: virtual bool FrameReady()
        Returns true if there are any frames ready with complete timing
        info.
        """
        ret = self._vtk_obj.FrameReady()
        return ret
        

    def is_supported(self):
        """
        V.is_supported() -> bool
        C++: virtual bool IsSupported()
        Returns true if stream timings are implemented for the current
        graphics backend.
        """
        ret = self._vtk_obj.IsSupported()
        return ret
        

    def mark_end_event(self):
        """
        V.mark_end_event()
        C++: virtual void MarkEndEvent()"""
        ret = self._vtk_obj.MarkEndEvent()
        return ret
        

    def mark_frame(self):
        """
        V.mark_frame()
        C++: virtual void MarkFrame()
        Call to mark the start of a new frame, or the end of an old one.
        Does nothing if no events have been recorded in the current
        frame.
        """
        ret = self._vtk_obj.MarkFrame()
        return ret
        

    def mark_start_event(self, *args):
        """
        V.mark_start_event(string)
        C++: virtual void MarkStartEvent(const std::string &name)"""
        ret = self._wrap_call(self._vtk_obj.MarkStartEvent, *args)
        return ret

    def release_graphics_resources(self):
        """
        V.release_graphics_resources()
        C++: virtual void ReleaseGraphicsResources()
        Releases any resources allocated on the graphics device.
        """
        ret = self._vtk_obj.ReleaseGraphicsResources()
        return ret
        

    _updateable_traits_ = \
    (('logging_enabled', 'GetLoggingEnabled'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('frame_limit',
    'GetFrameLimit'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'logging_enabled',
    'frame_limit'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RenderTimerLog, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RenderTimerLog properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['logging_enabled'], [], ['frame_limit']),
            title='Edit RenderTimerLog properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RenderTimerLog properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

