/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mediathek.config.Icons;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Log;
import mediathek.tool.MVMessageDialog;
import org.apache.commons.lang3.SystemUtils;

public class DialogZielExportPset
extends JDialog {
    public boolean ok = false;
    public String ziel = "";
    private final Component parentComponent;
    private JButton jButtonOk;
    private JButton jButtonZiel;
    private JTextField jTextFieldPfad;

    public DialogZielExportPset(JFrame parent, boolean modal, String pfad, String name) {
        super((Frame)parent, modal);
        this.parentComponent = parent;
        this.initComponents();
        this.jButtonZiel.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
        this.jButtonOk.addActionListener(new OkBeobachter());
        this.jButtonZiel.addActionListener(new ZielBeobachter());
        if (name.isEmpty()) {
            name = "name.xml";
        }
        this.jTextFieldPfad.setText(GuiFunktionen.addsPfad(pfad.isEmpty() ? GuiFunktionen.getHomePath() : pfad, name));
        EscapeKeyHandler.installHandler(this, () -> {
            this.ok = false;
            this.dispose();
        });
    }

    private boolean check() {
        String pfad = this.jTextFieldPfad.getText();
        if (pfad.isEmpty()) {
            MVMessageDialog.showMessageDialog(this.parentComponent, "Pfad ist leer", "Fehlerhafter Pfad!", 0);
            return false;
        }
        if (new File(pfad).exists() && JOptionPane.showConfirmDialog(this.parentComponent, "Die Datei existiert schon!", "\u00dcberschreiben?", 0) == 1) {
            return false;
        }
        this.ziel = pfad;
        return true;
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this.jButtonZiel = new JButton();
        this.jTextFieldPfad = new JTextField();
        JLabel jLabel1 = new JLabel();
        this.jButtonOk = new JButton();
        this.setDefaultCloseOperation(2);
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonZiel.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonZiel.setToolTipText("Datei ausw\u00e4hlen");
        jLabel1.setText("Ziel:");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPfad, -1, 334, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonZiel).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel1).addComponent(this.jTextFieldPfad, -2, -1, -2).addComponent(this.jButtonZiel)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonZiel, this.jTextFieldPfad);
        this.jButtonOk.setText("Ok");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOk, -2, 118, -2)).addComponent(jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonOk).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private class OkBeobachter
    implements ActionListener {
        private OkBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DialogZielExportPset.this.check()) {
                DialogZielExportPset.this.ok = true;
                DialogZielExportPset.this.dispose();
            }
        }
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog((Frame)MediathekGui.ui(), "Logdatei speichern");
                chooser.setMode(1);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        DialogZielExportPset.this.jTextFieldPfad.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.errorLog(639874637, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!DialogZielExportPset.this.jTextFieldPfad.getText().isEmpty()) {
                    String pfad = DialogZielExportPset.this.jTextFieldPfad.getText();
                    if (pfad.contains(File.separator)) {
                        pfad = pfad.substring(0, pfad.lastIndexOf(File.separator));
                        chooser.setCurrentDirectory(new File(pfad));
                    } else {
                        chooser.setCurrentDirectory(new File(DialogZielExportPset.this.jTextFieldPfad.getText()));
                    }
                }
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        DialogZielExportPset.this.jTextFieldPfad.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.errorLog(362259105, ex);
                    }
                }
            }
        }
    }
}

