The Local Exploit Suggester is a post-exploitation module that you can use to check a system for local vulnerabilities. It performs local exploit checks; it does not actually run any exploits, which is useful because this means you to scan a system without being intrusive. In addition to being stealthy, it's a time saver. You don't have to manually search for local exploits that will work; it'll show you which exploits the target is vulnerable to based on the system's platform and architecture.

The Local Exploit Suggester is available for Python, PHP, Mettle, Java and Windows Meterpreter.

## Vulnerable Application

To use the Local Exploit Suggester:

* You must have an open Meterpreter or shell session.

## Verification Steps

Please see the Overview section.

## Options

You can set the following options for the Local Exploit Suggester:

* **SHOWDESCRIPTION** - Set this option to true to see more details about each exploit.
* **ValidateArch** - This option lets us toggle whether or not a mismatch in session and module architecture should be validated or ignored.
* **ValidatePlatform** - This option lets us toggle whether or not a mismatch in session and module platform should be validated or ignored.
* **ValidateMeterpreterCommands** - This option lets us toggle whether or not Meterpreter commands that are missing from the current Meterpreter implementation should be validated or ignored.
* **Colors** - Similar to the option used for `HttpTrace`. This lets us change the colors used to show valid, invalid and ignored options or incompatibilities. Unsetting this option results in no colored output.

## Scenarios

When the Local Exploit Suggester runs, it displays a list of local exploits that the target may be vulnerable to, and it tells the user the likelihood of exploitation.

It also tells the user why the `check` methods for some exploits did not complete successfully, allowing for easier debugging.

Furthermore, with the `Verbose` option turned on, a table is printed showing modules that were not considered as valid for the current session, and gives reasons as to why.

The following terms are used to help you understand how vulnerable a target is to a particular exploit:

* **Vulnerable** - Indicates that the target is vulnerable. 
* **Appears** - Indicates that the target may be vulnerable based on the file version, but the vulnerable code has not been tested. 
* **Detected** - Indicates that the target has the file, but it cannot be determined whether or not the target is vulnerable. 

## Table Output

### Valid Modules

This table is shown by default, and shows which exploits have had their `check` methods executed, and provides information on the returned result.

Below is an example of how this table could look:

```
msf6 post(multi/recon/local_exploit_suggester) > run SESSION=-1 Verbose=false

[*] ::1 - Valid modules for session 3:
============================

 #   Name                                                                Potentially Vulnerable?  Check Result
 -   ----                                                                -----------------------  ------------
 1   exploit/linux/local/cve_2021_4034_pwnkit_lpe_pkexec                 Yes                      The target is vulnerable.
 2   exploit/linux/local/cve_2022_0847_dirtypipe                         Yes                      The target appears to be vulnerable. Linux kernel version found: 5.14.0
 3   exploit/linux/local/cve_2022_0995_watch_queue                       Yes                      The target appears to be vulnerable.
 4   exploit/linux/local/desktop_privilege_escalation                    Yes                      The target is vulnerable.
 5   exploit/linux/local/network_manager_vpnc_username_priv_esc          Yes                      The service is running, but could not be validated.
 6   exploit/linux/local/pkexec                                          Yes                      The service is running, but could not be validated.
 7   exploit/linux/local/polkit_dbus_auth_bypass                         Yes                      The service is running, but could not be validated. Detected polkit framework version 0.105.
 8   exploit/linux/local/su_login                                        Yes                      The target appears to be vulnerable.
 9   exploit/android/local/futex_requeue                                 No                       The check raised an exception.
 10  exploit/linux/local/abrt_raceabrt_priv_esc                          No                       The target is not exploitable.
 11  exploit/linux/local/abrt_sosreport_priv_esc                         No                       The target is not exploitable.
 12  exploit/linux/local/af_packet_chocobo_root_priv_esc                 No                       The target is not exploitable. Linux kernel 5.14.0-kali4-amd64 #1 is not vulnerable
 13  exploit/linux/local/af_packet_packet_set_ring_priv_esc              No                       The target is not exploitable.
 14  exploit/linux/local/apport_abrt_chroot_priv_esc                     No                       The target is not exploitable.
 15  exploit/linux/local/asan_suid_executable_priv_esc                   No                       The check raised an exception.
 16  exploit/linux/local/blueman_set_dhcp_handler_dbus_priv_esc          No                       The target is not exploitable.
 ...
 More modules here
 ...
```

When output to a terminal window with the `Colors` datastore option set, the table rows are highlighted appropriately based on the `Check Result`.

### Incompatible Modules

This table is hidden behind the `Verbose` toggle.

It provides a list of modules that did not have their `check` method executed, and provides information as to why a module is not compatible with the current session.

Below is an example of how this table could look:

```
msf6 post(multi/recon/local_exploit_suggester) > run SESSION=-1 Verbose=true ValidateArch=false ValidatePlatform=true

...
Valid modules table here
...

[*] ::1 - Current Session Info:
[*] ::1 - Session Type: meterpreter
[*] ::1 - Architecture: x64
[*] ::1 - Platform: linux
[*] ::1 - Incompatible modules for session 3:
==============================

 #    Name                                                                    Reasons                                                                                Platform       Architecture                                   Session Type
 -    ----                                                                    -------                                                                                --------       ------------                                   ------------
 1    exploit/aix/local/ibstat_path                                           Not Compatible (platform, session type)                                                Unix           cmd                                            No defined session types
 2    exploit/aix/local/xorg_x11_server                                       Not Compatible (platform, session type)                                                Unix           cmd                                            shell
 3    exploit/android/local/janus                                             Not Compatible (platform)                                                              Android        dalvik                                         meterpreter
 4    exploit/freebsd/local/intel_sysret_priv_esc                             Not Compatible (platform, session type)                                                BSD            x64                                            shell
 5    exploit/freebsd/local/ip6_setpktopt_uaf_priv_esc                        Not Compatible (platform, session type)                                                BSD            x64                                            shell
 6    exploit/freebsd/local/mmap                                              Not Compatible (platform, session type)                                                BSD            x86                                            shell
 7    exploit/freebsd/local/rtld_execl_priv_esc                               Not Compatible (platform, session type)                                                BSD            x86, x64, armle, aarch64, ppc, mipsle, mipsbe  shell
 8    exploit/freebsd/local/watchguard_fix_corrupt_mail                       Not Compatible (platform, session type)                                                BSD            x64                                            shell
 9    exploit/linux/local/vmware_mount                                        Not Compatible (session type)                                                          Linux          x86                                            No defined session types
 10   exploit/openbsd/local/dynamic_loader_chpass_privesc                     Not Compatible (platform, session type)                                                BSD, Unix      cmd                                            shell
 11   exploit/osx/local/cfprefsd_race_condition                               Not Compatible (platform, session type)                                                OSX            x64                                            No defined session types
 12   exploit/osx/local/dyld_print_to_file_root                               Not Compatible (platform, session type)                                                OSX            x64                                            shell
 13   exploit/osx/local/feedback_assistant_root                               Not Compatible (platform)                                                              OSX            x64                                            meterpreter, shell
 14   exploit/osx/local/iokit_keyboard_root                                   Not Compatible (platform)                                                              OSX            x64                                            shell, meterpreter
 15   exploit/osx/local/libxpc_mitm_ssudo                                     Not Compatible (platform, session type)                                                OSX            x64                                            No defined session types
```
Note: In the table above, the session architecture is reported as `x64`. However, it is not considered as 'incompatible' as the `ValidateArch=false` option was used.

When the above is output to a terminal, the incompatibilities for a specific module (e.g. architecture or platform mismatch) are output in a different color if enabled with the `Color` datastore option.
