/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.core.ConfigSetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetUploadTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ConfigSetUploadTool() {
        this(CLIO.getOutStream());
    }

    public ConfigSetUploadTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"confname").argName("confname").hasArg().required(true).desc("Configset name in ZooKeeper.").build(), Option.builder((String)"confdir").argName("confdir").hasArg().required(true).desc("Local directory with configs.").build(), Option.builder((String)"configsetsDir").argName("configsetsDir").hasArg().required(false).desc("Parent directory of example configsets.").build(), SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_VERBOSE);
    }

    @Override
    public String getName() {
        return "upconfig";
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        if (zkHost == null) {
            throw new IllegalStateException("Solr at " + cli.getOptionValue("solrUrl") + " is running in standalone server mode, upconfig can only be used when running in SolrCloud mode.\n");
        }
        String confName = cli.getOptionValue("confname");
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(zkHost).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).build();){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            Path confPath = ConfigSetService.getConfigsetPath(cli.getOptionValue("confdir"), cli.getOptionValue("configsetsDir"));
            this.echo("Uploading " + confPath.toAbsolutePath() + " for config " + cli.getOptionValue("confname") + " to ZooKeeper at " + zkHost);
            ZkMaintenanceUtils.uploadToZK((SolrZkClient)zkClient, (Path)confPath, (String)("/configs/" + confName), (Pattern)ZkMaintenanceUtils.UPLOAD_FILENAME_EXCLUDE_PATTERN);
        }
        catch (Exception e) {
            log.error("Could not complete upconfig operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

