/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.invoke.MethodHandles;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.core.SolrCore;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.ZkIndexSchemaReader;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{a:cores|collections}/{collectionName}/schema")
public class GetSchemaZkVersionAPI
extends JerseyResource {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SolrCore solrCore;

    @Inject
    public GetSchemaZkVersionAPI(SolrCore solrCore) {
        this.solrCore = solrCore;
    }

    @GET
    @Path(value="/zkversion")
    @Produces(value={"application/json", "application/atom+xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaZkVersionResponse getSchemaZkVersion(@DefaultValue(value="-1") @QueryParam(value="refreshIfBelowVersion") Integer refreshIfBelowVersion) throws Exception {
        SchemaZkVersionResponse response = this.instantiateJerseyResponse(SchemaZkVersionResponse.class);
        int zkVersion = -1;
        if (this.solrCore.getLatestSchema() instanceof ManagedIndexSchema) {
            ManagedIndexSchema managed = (ManagedIndexSchema)this.solrCore.getLatestSchema();
            zkVersion = managed.getSchemaZkVersion();
            if (refreshIfBelowVersion != -1 && zkVersion < refreshIfBelowVersion) {
                log.info("REFRESHING SCHEMA (refreshIfBelowVersion={}, currentVersion={}) before returning version!", (Object)refreshIfBelowVersion, (Object)zkVersion);
                ZkSolrResourceLoader zkSolrResourceLoader = (ZkSolrResourceLoader)this.solrCore.getResourceLoader();
                ZkIndexSchemaReader zkIndexSchemaReader = zkSolrResourceLoader.getZkIndexSchemaReader();
                managed = zkIndexSchemaReader.refreshSchemaFromZk(refreshIfBelowVersion);
                zkVersion = managed.getSchemaZkVersion();
            }
        }
        response.zkversion = zkVersion;
        return response;
    }

    public static class SchemaZkVersionResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="zkversion")
        public int zkversion;
    }
}

