/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.RestoreCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/cores/{coreName}/install")
public class InstallCoreDataAPI
extends CoreAdminAPIBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public InstallCoreDataAPI(CoreContainer coreContainer, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(coreContainer, coreAdminAsyncTracker, req, rsp);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public SolrJerseyResponse installCoreData(@PathParam(value="coreName") String coreName, InstallCoreDataRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required request body is missing");
        }
        ZkController zkController = this.coreContainer.getZkController();
        if (zkController == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'Install Core Data' API only supported in SolrCloud clusters");
        }
        try (BackupRepository repository = this.coreContainer.newBackupRepository(requestBody.repository);
             SolrCore core = this.coreContainer.getCore(coreName);){
            String location = repository.getBackupLocation(requestBody.location);
            if (location == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a parameter or as a default repository property");
            }
            URI locationUri = repository.createDirectoryURI(location);
            CloudDescriptor cd = core.getCoreDescriptor().getCloudDescriptor();
            if (!core.readOnly) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to install data to core core=" + core.getName() + "; collection must be in read-only mode prior to installing data to a core");
            }
            RestoreCore restoreCore = RestoreCore.create(repository, core, locationUri, "");
            boolean success = restoreCore.doRestore();
            if (!success) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to install data to core=" + core.getName());
            }
            zkController.getShardTerms(cd.getCollectionName(), cd.getShardId()).ensureHighestTermsAreNotZero();
        }
        return response;
    }

    public static class InstallCoreDataRequestBody
    implements JacksonReflectMapWriter {
        @JsonProperty(value="location")
        public String location;
        @JsonProperty(value="repository")
        public String repository;
        @JsonProperty(value="async")
        public String asyncId;
    }
}

