/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.feature;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.feature.FeatureException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;

public class FieldValueFeature
extends Feature {
    protected boolean useDocValuesForStored = true;
    private String field;
    private Set<String> fieldAsSet;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
        this.fieldAsSet = Collections.singleton(field);
    }

    @Override
    public LinkedHashMap<String, Object> paramsToMap() {
        LinkedHashMap<String, Object> params = this.defaultParamsToMap();
        params.put("field", this.field);
        return params;
    }

    @Override
    protected void validate() throws FeatureException {
        if (this.field == null || this.field.isEmpty()) {
            throw new FeatureException(((Object)((Object)this)).getClass().getSimpleName() + ": field must be provided");
        }
    }

    public FieldValueFeature(String name, Map<String, Object> params) {
        super(name, params);
    }

    @Override
    public Feature.FeatureWeight createWeight(IndexSearcher searcher, boolean needsScores, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) throws IOException {
        return new FieldValueFeatureWeight(searcher, request, originalQuery, efi);
    }

    public class FieldValueFeatureWeight
    extends Feature.FeatureWeight {
        private final SchemaField schemaField;

        public FieldValueFeatureWeight(IndexSearcher searcher, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) {
            super(FieldValueFeature.this, searcher, request, originalQuery, efi);
            this.schemaField = searcher instanceof SolrIndexSearcher ? ((SolrIndexSearcher)searcher).getSchema().getFieldOrNull(FieldValueFeature.this.field) : null;
        }

        protected long readNumericDocValuesDate(long val) {
            return val;
        }

        @Override
        public Feature.FeatureWeight.FeatureScorer scorer(LeafReaderContext context) throws IOException {
            if (this.schemaField != null && (!this.schemaField.stored() || FieldValueFeature.this.useDocValuesForStored) && this.schemaField.hasDocValues()) {
                DocValuesType docValuesType;
                FieldInfo fieldInfo = context.reader().getFieldInfos().fieldInfo(FieldValueFeature.this.field);
                DocValuesType docValuesType2 = docValuesType = fieldInfo != null ? fieldInfo.getDocValuesType() : DocValuesType.NONE;
                if (DocValuesType.NUMERIC.equals((Object)docValuesType)) {
                    return new NumericDocValuesFieldValueFeatureScorer(this, context, DocIdSetIterator.all((int)Integer.MAX_VALUE), this.schemaField.getType().getNumberType());
                }
                if (DocValuesType.SORTED.equals((Object)docValuesType)) {
                    return new SortedDocValuesFieldValueFeatureScorer(this, context, DocIdSetIterator.all((int)Integer.MAX_VALUE));
                }
                if (DocValuesType.NONE.equals((Object)docValuesType)) {
                    return new DefaultValueFieldValueFeatureScorer((Feature.FeatureWeight)this, DocIdSetIterator.all((int)Integer.MAX_VALUE));
                }
                throw new IllegalArgumentException("Doc values type " + docValuesType.name() + " of field " + FieldValueFeature.this.field + " is not supported");
            }
            return new FieldValueFeatureScorer(this, context, DocIdSetIterator.all((int)Integer.MAX_VALUE));
        }

        public final class DefaultValueFieldValueFeatureScorer
        extends Feature.FeatureWeight.FeatureScorer {
            public DefaultValueFieldValueFeatureScorer(Feature.FeatureWeight weight, DocIdSetIterator itr) {
                super(weight, itr);
            }

            @Override
            public float score() throws IOException {
                return FieldValueFeature.this.getDefaultValue();
            }

            public float getMaxScore(int upTo) throws IOException {
                return Float.POSITIVE_INFINITY;
            }
        }

        public final class SortedDocValuesFieldValueFeatureScorer
        extends Feature.FeatureWeight.FeatureScorer {
            private final SortedDocValues docValues;

            public SortedDocValuesFieldValueFeatureScorer(Feature.FeatureWeight weight, LeafReaderContext context, DocIdSetIterator itr) {
                SortedDocValues docValues;
                super(weight, itr);
                try {
                    docValues = DocValues.getSorted((LeafReader)context.reader(), (String)FieldValueFeature.this.field);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read sorted docValues for field " + FieldValueFeature.this.field);
                }
                this.docValues = docValues;
            }

            @Override
            public float score() throws IOException {
                if (this.docValues.advanceExact(this.itr.docID())) {
                    int ord = this.docValues.ordValue();
                    return this.readSortedDocValues(this.docValues.lookupOrd(ord));
                }
                return FieldValueFeature.this.getDefaultValue();
            }

            private float readSortedDocValues(BytesRef bytesRef) {
                String string = bytesRef.utf8ToString();
                if (string.length() == 1) {
                    if (string.charAt(0) == BoolField.TRUE_TOKEN[0]) {
                        return 1.0f;
                    }
                    if (string.charAt(0) == BoolField.FALSE_TOKEN[0]) {
                        return 0.0f;
                    }
                }
                return FieldValueFeature.this.getDefaultValue();
            }

            public float getMaxScore(int upTo) throws IOException {
                return Float.POSITIVE_INFINITY;
            }
        }

        public final class NumericDocValuesFieldValueFeatureScorer
        extends Feature.FeatureWeight.FeatureScorer {
            private final NumericDocValues docValues;
            private final NumberType numberType;

            public NumericDocValuesFieldValueFeatureScorer(Feature.FeatureWeight weight, LeafReaderContext context, DocIdSetIterator itr, NumberType numberType) {
                NumericDocValues docValues;
                super(weight, itr);
                this.numberType = numberType;
                try {
                    docValues = DocValues.getNumeric((LeafReader)context.reader(), (String)FieldValueFeature.this.field);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read numeric docValues for field " + FieldValueFeature.this.field);
                }
                this.docValues = docValues;
            }

            @Override
            public float score() throws IOException {
                if (this.docValues.advanceExact(this.itr.docID())) {
                    return this.readNumericDocValues();
                }
                return FieldValueFeature.this.getDefaultValue();
            }

            private float readNumericDocValues() throws IOException {
                if (NumberType.FLOAT.equals((Object)this.numberType)) {
                    return Float.intBitsToFloat((int)this.docValues.longValue());
                }
                if (NumberType.DOUBLE.equals((Object)this.numberType)) {
                    return (float)Double.longBitsToDouble(this.docValues.longValue());
                }
                if (NumberType.DATE.equals((Object)this.numberType)) {
                    return FieldValueFeatureWeight.this.readNumericDocValuesDate(this.docValues.longValue());
                }
                return this.docValues.longValue();
            }

            public float getMaxScore(int upTo) throws IOException {
                return Float.POSITIVE_INFINITY;
            }
        }

        public class FieldValueFeatureScorer
        extends Feature.FeatureWeight.FeatureScorer {
            private final LeafReaderContext context;

            public FieldValueFeatureScorer(Feature.FeatureWeight weight, LeafReaderContext context, DocIdSetIterator itr) {
                super(weight, itr);
                this.context = context;
            }

            @Override
            public float score() throws IOException {
                try {
                    Document document = this.context.reader().document(this.itr.docID(), FieldValueFeature.this.fieldAsSet);
                    IndexableField indexableField = document.getField(FieldValueFeature.this.field);
                    if (indexableField == null) {
                        return FieldValueFeatureWeight.this.getDefaultValue();
                    }
                    Number number = indexableField.numericValue();
                    if (number != null) {
                        return number.floatValue();
                    }
                    String string = indexableField.stringValue();
                    if (string.length() == 1) {
                        if (string.charAt(0) == BoolField.TRUE_TOKEN[0]) {
                            return 1.0f;
                        }
                        if (string.charAt(0) == BoolField.FALSE_TOKEN[0]) {
                            return 0.0f;
                        }
                    }
                }
                catch (IOException e) {
                    throw new FeatureException(e.toString() + ": Unable to extract feature for " + this.name, e);
                }
                return FieldValueFeatureWeight.this.getDefaultValue();
            }

            public float getMaxScore(int upTo) throws IOException {
                return Float.POSITIVE_INFINITY;
            }
        }
    }
}

