/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;
import org.carrot2.util.ResourceLookup;

public class ClassRelativeResourceLookup
implements ResourceLookup {
    private final Class<?> clazz;

    public ClassRelativeResourceLookup(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public InputStream open(String resource) throws IOException {
        this.checkExists(resource);
        return this.clazz.getResourceAsStream(Objects.requireNonNull(resource));
    }

    private void checkExists(String resource) throws IOException {
        if (!this.exists(resource)) {
            throw new IOException(String.format(Locale.ROOT, "Resource %s does not exist relative to class %s.", resource, this.clazz.getName()));
        }
    }

    @Override
    public boolean exists(String resource) {
        return this.clazz.getResource(resource) != null;
    }

    @Override
    public String pathOf(String resource) {
        URL existingResource = this.clazz.getResource(resource);
        return existingResource != null ? existingResource.toExternalForm() : String.format(Locale.ROOT, "resource::(%s)/%s", this.clazz.getName(), resource);
    }
}

