/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.StringRefAddr;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.AbstractRef;
import org.apache.naming.ContextAccessController;
import org.apache.naming.ContextBindings;
import org.apache.naming.EjbRef;
import org.apache.naming.HandlerRef;
import org.apache.naming.LookupRef;
import org.apache.naming.NamingContext;
import org.apache.naming.ResourceEnvRef;
import org.apache.naming.ResourceLinkRef;
import org.apache.naming.ResourceRef;
import org.apache.naming.ServiceRef;
import org.apache.naming.TransactionRef;
import org.apache.naming.factory.ResourceLinkFactory;
import org.apache.tomcat.util.descriptor.web.ContextEjb;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextLocalEjb;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceEnvRef;
import org.apache.tomcat.util.descriptor.web.ContextResourceLink;
import org.apache.tomcat.util.descriptor.web.ContextService;
import org.apache.tomcat.util.descriptor.web.ContextTransaction;
import org.apache.tomcat.util.descriptor.web.MessageDestinationRef;
import org.apache.tomcat.util.descriptor.web.ResourceBase;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class NamingContextListener
implements LifecycleListener,
PropertyChangeListener {
    private static final Log log = LogFactory.getLog(NamingContextListener.class);
    protected static final StringManager sm = StringManager.getManager(NamingContextListener.class);
    protected String name = "/";
    protected Object container = null;
    private Object token = null;
    protected boolean initialized = false;
    protected NamingResourcesImpl namingResources = null;
    protected NamingContext namingContext = null;
    protected javax.naming.Context compCtx = null;
    protected javax.naming.Context envCtx = null;
    protected HashMap<String, ObjectName> objectNames = new HashMap();
    private boolean exceptionOnFailedWrite = true;

    public boolean getExceptionOnFailedWrite() {
        return this.exceptionOnFailedWrite;
    }

    public void setExceptionOnFailedWrite(boolean bl) {
        this.exceptionOnFailedWrite = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public javax.naming.Context getEnvContext() {
        return this.envCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        this.container = lifecycleEvent.getLifecycle();
        if (this.container instanceof Context) {
            this.namingResources = ((Context)this.container).getNamingResources();
            this.token = ((Context)this.container).getNamingToken();
        } else {
            if (!(this.container instanceof Server)) return;
            this.namingResources = ((Server)this.container).getGlobalNamingResources();
            this.token = ((Server)this.container).getNamingToken();
        }
        if ("configure_start".equals(lifecycleEvent.getType())) {
            if (this.initialized) {
                return;
            }
            try {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                this.namingContext = new NamingContext(hashtable, this.getName());
                ContextAccessController.setSecurityToken(this.getName(), this.token);
                ContextAccessController.setSecurityToken(this.container, this.token);
                ContextBindings.bindContext(this.container, this.namingContext, this.token);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("naming.bind", new Object[]{this.container}));
                }
                this.namingContext.setExceptionOnFailedWrite(this.getExceptionOnFailedWrite());
                ContextAccessController.setWritable(this.getName(), this.token);
                try {
                    this.createNamingContext();
                }
                catch (NamingException namingException) {
                    log.error((Object)sm.getString("naming.namingContextCreationFailed", new Object[]{namingException}));
                }
                this.namingResources.addPropertyChangeListener(this);
                if (this.container instanceof Context) {
                    ContextAccessController.setReadOnly(this.getName());
                    try {
                        ContextBindings.bindClassLoader(this.container, this.token, ((Context)this.container).getLoader().getClassLoader());
                    }
                    catch (NamingException namingException) {
                        log.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
                    }
                }
                if (!(this.container instanceof Server)) return;
                ResourceLinkFactory.setGlobalContext(this.namingContext);
                try {
                    ContextBindings.bindClassLoader(this.container, this.token, this.getClass().getClassLoader());
                }
                catch (NamingException namingException) {
                    log.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
                }
                if (!(this.container instanceof StandardServer)) return;
                ((StandardServer)this.container).setGlobalNamingContext(this.namingContext);
                return;
            }
            finally {
                this.initialized = true;
            }
        }
        if (!"configure_stop".equals(lifecycleEvent.getType())) return;
        if (!this.initialized) {
            return;
        }
        try {
            Object object;
            ContextAccessController.setWritable(this.getName(), this.token);
            ContextBindings.unbindContext(this.container, this.token);
            if (this.container instanceof Context) {
                ContextBindings.unbindClassLoader(this.container, this.token, ((Context)this.container).getLoader().getClassLoader());
            }
            if (this.container instanceof Server) {
                ContextBindings.unbindClassLoader(this.container, this.token, this.getClass().getClassLoader());
            }
            this.namingResources.removePropertyChangeListener(this);
            ContextAccessController.unsetSecurityToken(this.getName(), this.token);
            ContextAccessController.unsetSecurityToken(this.container, this.token);
            if (!this.objectNames.isEmpty()) {
                object = this.objectNames.values();
                Registry registry = Registry.getRegistry(null, null);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    registry.unregisterComponent(objectName);
                }
            }
            if ((object = this.getGlobalNamingContext()) == null) return;
            ResourceLinkFactory.deregisterGlobalResourceAccess((javax.naming.Context)object);
            return;
        }
        finally {
            this.objectNames.clear();
            this.namingContext = null;
            this.envCtx = null;
            this.compCtx = null;
            this.initialized = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.initialized) {
            return;
        }
        Object object = propertyChangeEvent.getSource();
        if (object == this.namingResources) {
            ContextAccessController.setWritable(this.getName(), this.token);
            this.processGlobalResourcesChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            ContextAccessController.setReadOnly(this.getName());
        }
    }

    private void processGlobalResourcesChange(String string, Object object, Object object2) {
        if (string.equals("ejb")) {
            ContextEjb contextEjb;
            if (object != null && (contextEjb = (ContextEjb)object).getName() != null) {
                this.removeEjb(contextEjb.getName());
            }
            if (object2 != null && (contextEjb = (ContextEjb)object2).getName() != null) {
                this.addEjb(contextEjb);
            }
        } else if (string.equals("environment")) {
            ContextEnvironment contextEnvironment;
            if (object != null && (contextEnvironment = (ContextEnvironment)object).getName() != null) {
                this.removeEnvironment(contextEnvironment.getName());
            }
            if (object2 != null && (contextEnvironment = (ContextEnvironment)object2).getName() != null) {
                this.addEnvironment(contextEnvironment);
            }
        } else if (string.equals("localEjb")) {
            ContextLocalEjb contextLocalEjb;
            if (object != null && (contextLocalEjb = (ContextLocalEjb)object).getName() != null) {
                this.removeLocalEjb(contextLocalEjb.getName());
            }
            if (object2 != null && (contextLocalEjb = (ContextLocalEjb)object2).getName() != null) {
                this.addLocalEjb(contextLocalEjb);
            }
        } else if (string.equals("messageDestinationRef")) {
            MessageDestinationRef messageDestinationRef;
            if (object != null && (messageDestinationRef = (MessageDestinationRef)object).getName() != null) {
                this.removeMessageDestinationRef(messageDestinationRef.getName());
            }
            if (object2 != null && (messageDestinationRef = (MessageDestinationRef)object2).getName() != null) {
                this.addMessageDestinationRef(messageDestinationRef);
            }
        } else if (string.equals("resource")) {
            ContextResource contextResource;
            if (object != null && (contextResource = (ContextResource)object).getName() != null) {
                this.removeResource(contextResource.getName());
            }
            if (object2 != null && (contextResource = (ContextResource)object2).getName() != null) {
                this.addResource(contextResource);
            }
        } else if (string.equals("resourceEnvRef")) {
            ContextResourceEnvRef contextResourceEnvRef;
            if (object != null && (contextResourceEnvRef = (ContextResourceEnvRef)object).getName() != null) {
                this.removeResourceEnvRef(contextResourceEnvRef.getName());
            }
            if (object2 != null && (contextResourceEnvRef = (ContextResourceEnvRef)object2).getName() != null) {
                this.addResourceEnvRef(contextResourceEnvRef);
            }
        } else if (string.equals("resourceLink")) {
            ContextResourceLink contextResourceLink;
            if (object != null && (contextResourceLink = (ContextResourceLink)object).getName() != null) {
                this.removeResourceLink(contextResourceLink.getName());
            }
            if (object2 != null && (contextResourceLink = (ContextResourceLink)object2).getName() != null) {
                this.addResourceLink(contextResourceLink);
            }
        } else if (string.equals("service")) {
            ContextService contextService;
            if (object != null && (contextService = (ContextService)object).getName() != null) {
                this.removeService(contextService.getName());
            }
            if (object2 != null && (contextService = (ContextService)object2).getName() != null) {
                this.addService(contextService);
            }
        }
    }

    private void createNamingContext() throws NamingException {
        int n;
        if (this.container instanceof Server) {
            this.compCtx = this.namingContext;
            this.envCtx = this.namingContext;
        } else {
            this.compCtx = this.namingContext.createSubcontext("comp");
            this.envCtx = this.compCtx.createSubcontext("env");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating JNDI naming context");
        }
        if (this.namingResources == null) {
            this.namingResources = new NamingResourcesImpl();
            this.namingResources.setContainer(this.container);
        }
        ContextResourceLink[] contextResourceLinkArray = this.namingResources.findResourceLinks();
        for (n = 0; n < contextResourceLinkArray.length; ++n) {
            this.addResourceLink(contextResourceLinkArray[n]);
        }
        ContextResource[] contextResourceArray = this.namingResources.findResources();
        for (n = 0; n < contextResourceArray.length; ++n) {
            this.addResource(contextResourceArray[n]);
        }
        ContextResourceEnvRef[] contextResourceEnvRefArray = this.namingResources.findResourceEnvRefs();
        for (n = 0; n < contextResourceEnvRefArray.length; ++n) {
            this.addResourceEnvRef(contextResourceEnvRefArray[n]);
        }
        ContextEnvironment[] contextEnvironmentArray = this.namingResources.findEnvironments();
        for (n = 0; n < contextEnvironmentArray.length; ++n) {
            this.addEnvironment(contextEnvironmentArray[n]);
        }
        ContextEjb[] contextEjbArray = this.namingResources.findEjbs();
        for (n = 0; n < contextEjbArray.length; ++n) {
            this.addEjb(contextEjbArray[n]);
        }
        MessageDestinationRef[] messageDestinationRefArray = this.namingResources.findMessageDestinationRefs();
        for (n = 0; n < messageDestinationRefArray.length; ++n) {
            this.addMessageDestinationRef(messageDestinationRefArray[n]);
        }
        ContextService[] contextServiceArray = this.namingResources.findServices();
        for (n = 0; n < contextServiceArray.length; ++n) {
            this.addService(contextServiceArray[n]);
        }
        if (this.container instanceof Context) {
            try {
                TransactionRef transactionRef = new TransactionRef();
                this.compCtx.bind("UserTransaction", (Object)transactionRef);
                ContextTransaction contextTransaction = this.namingResources.getTransaction();
                if (contextTransaction != null) {
                    Iterator iterator = contextTransaction.listProperties();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = (String)contextTransaction.getProperty(string);
                        StringRefAddr stringRefAddr = new StringRefAddr(string, string2);
                        transactionRef.add(stringRefAddr);
                    }
                }
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
            }
            catch (NamingException namingException) {
                log.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
            }
        }
        if (this.container instanceof Context) {
            try {
                this.compCtx.bind("Resources", (Object)((Context)this.container).getResources());
            }
            catch (NamingException namingException) {
                log.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
            }
        }
    }

    protected ObjectName createObjectName(ContextResource contextResource) throws MalformedObjectNameException {
        String string = null;
        if (this.container instanceof StandardServer) {
            string = ((StandardServer)this.container).getDomain();
        } else if (this.container instanceof ContainerBase) {
            string = ((ContainerBase)this.container).getDomain();
        }
        if (string == null) {
            string = "Catalina";
        }
        ObjectName objectName = null;
        String string2 = ObjectName.quote(contextResource.getName());
        if (this.container instanceof Server) {
            objectName = new ObjectName(string + ":type=DataSource,class=" + contextResource.getType() + ",name=" + string2);
        } else if (this.container instanceof Context) {
            Object object = ((Context)this.container).getName();
            if (!((String)object).startsWith("/")) {
                object = "/" + (String)object;
            }
            Host host = (Host)((Context)this.container).getParent();
            objectName = new ObjectName(string + ":type=DataSource,host=" + host.getName() + ",context=" + (String)object + ",class=" + contextResource.getType() + ",name=" + string2);
        }
        return objectName;
    }

    public void addEjb(ContextEjb contextEjb) {
        AbstractRef abstractRef = this.lookForLookupRef((ResourceBase)contextEjb);
        if (abstractRef == null) {
            abstractRef = new EjbRef(contextEjb.getType(), contextEjb.getHome(), contextEjb.getRemote(), contextEjb.getLink());
            Iterator iterator = contextEjb.listProperties();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)contextEjb.getProperty(string);
                StringRefAddr stringRefAddr = new StringRefAddr(string, string2);
                abstractRef.add(stringRefAddr);
            }
        }
        try {
            this.createSubcontexts(this.envCtx, contextEjb.getName());
            this.envCtx.bind(contextEjb.getName(), (Object)abstractRef);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEnvironment(ContextEnvironment contextEnvironment) {
        Object object = this.lookForLookupRef((ResourceBase)contextEnvironment);
        if (object == null) {
            String string = contextEnvironment.getType();
            try {
                if (string.equals("java.lang.String")) {
                    object = contextEnvironment.getValue();
                } else if (string.equals("java.lang.Byte")) {
                    object = contextEnvironment.getValue() == null ? Byte.valueOf((byte)0) : Byte.decode(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Short")) {
                    object = contextEnvironment.getValue() == null ? Short.valueOf((short)0) : Short.decode(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Integer")) {
                    object = contextEnvironment.getValue() == null ? Integer.valueOf(0) : Integer.decode(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Long")) {
                    object = contextEnvironment.getValue() == null ? Long.valueOf(0L) : Long.decode(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Boolean")) {
                    object = Boolean.valueOf(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Double")) {
                    object = contextEnvironment.getValue() == null ? Double.valueOf(0.0) : Double.valueOf(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Float")) {
                    object = contextEnvironment.getValue() == null ? Float.valueOf(0.0f) : Float.valueOf(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Character")) {
                    if (contextEnvironment.getValue() == null) {
                        object = Character.valueOf('\u0000');
                    } else {
                        if (contextEnvironment.getValue().length() != 1) throw new IllegalArgumentException();
                        object = Character.valueOf(contextEnvironment.getValue().charAt(0));
                    }
                } else {
                    object = this.constructEnvEntry(contextEnvironment.getType(), contextEnvironment.getValue());
                    if (object == null) {
                        log.error((Object)sm.getString("naming.invalidEnvEntryType", new Object[]{contextEnvironment.getName()}));
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error((Object)sm.getString("naming.invalidEnvEntryValue", new Object[]{contextEnvironment.getName()}));
            }
        }
        if (object == null) return;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("naming.addEnvEntry", new Object[]{contextEnvironment.getName()}));
            }
            this.createSubcontexts(this.envCtx, contextEnvironment.getName());
            this.envCtx.bind(contextEnvironment.getName(), object);
            return;
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.invalidEnvEntryValue", new Object[]{namingException}));
        }
    }

    private Object constructEnvEntry(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(string2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (string2.length() != 1) {
                    return null;
                }
                try {
                    constructor = clazz.getConstructor(Character.TYPE);
                    return constructor.newInstance(Character.valueOf(string2.charAt(0)));
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void addLocalEjb(ContextLocalEjb contextLocalEjb) {
    }

    public void addMessageDestinationRef(MessageDestinationRef messageDestinationRef) {
    }

    public void addService(ContextService contextService) {
        AbstractRef abstractRef = this.lookForLookupRef((ResourceBase)contextService);
        if (abstractRef == null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (contextService.getWsdlfile() != null) {
                object4 = null;
                try {
                    object3 = new URI(contextService.getWsdlfile());
                    object4 = ((URI)object3).toURL();
                }
                catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
                if (object4 == null) {
                    try {
                        object4 = ((Context)this.container).getServletContext().getResource(contextService.getWsdlfile());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (object4 == null) {
                    try {
                        object4 = ((Context)this.container).getServletContext().getResource("/" + contextService.getWsdlfile());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("naming.addSlash", new Object[]{contextService.getWsdlfile()}));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.error((Object)sm.getString("naming.wsdlFailed", new Object[]{malformedURLException}));
                    }
                }
                if (object4 == null) {
                    contextService.setWsdlfile(null);
                } else {
                    contextService.setWsdlfile(((URL)object4).toString());
                }
            }
            if (contextService.getJaxrpcmappingfile() != null) {
                object4 = null;
                try {
                    object3 = new URI(contextService.getJaxrpcmappingfile());
                    object4 = ((URI)object3).toURL();
                }
                catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
                if (object4 == null) {
                    try {
                        object4 = ((Context)this.container).getServletContext().getResource(contextService.getJaxrpcmappingfile());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (object4 == null) {
                    try {
                        object4 = ((Context)this.container).getServletContext().getResource("/" + contextService.getJaxrpcmappingfile());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("naming.addSlash", new Object[]{contextService.getJaxrpcmappingfile()}));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.error((Object)sm.getString("naming.wsdlFailed", new Object[]{malformedURLException}));
                    }
                }
                if (object4 == null) {
                    contextService.setJaxrpcmappingfile(null);
                } else {
                    contextService.setJaxrpcmappingfile(((URL)object4).toString());
                }
            }
            abstractRef = new ServiceRef(contextService.getName(), contextService.getInterface(), contextService.getServiceqname(), contextService.getWsdlfile(), contextService.getJaxrpcmappingfile());
            object4 = contextService.getServiceendpoints();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                object2 = new StringRefAddr("serviceendpointinterface", (String)object3);
                abstractRef.add((RefAddr)object2);
                object = contextService.getPortlink((String)object3);
                object2 = new StringRefAddr("portcomponentlink", (String)object);
                abstractRef.add((RefAddr)object2);
            }
            object3 = contextService.getHandlers();
            while (object3.hasNext()) {
                int n;
                String string;
                Object object5;
                object2 = (String)object3.next();
                object = contextService.getHandler((String)object2);
                HandlerRef handlerRef = new HandlerRef((String)object2, object.getHandlerclass());
                Iterator iterator = object.getLocalparts();
                while (iterator.hasNext()) {
                    object5 = (String)iterator.next();
                    string = object.getNamespaceuri((String)object5);
                    handlerRef.add(new StringRefAddr("handlerlocalpart", (String)object5));
                    handlerRef.add(new StringRefAddr("handlernamespace", string));
                }
                object5 = object.listProperties();
                while (object5.hasNext()) {
                    string = (String)object5.next();
                    String string2 = (String)object.getProperty(string);
                    handlerRef.add(new StringRefAddr("handlerparamname", string));
                    handlerRef.add(new StringRefAddr("handlerparamvalue", string2));
                }
                for (n = 0; n < object.getSoapRolesSize(); ++n) {
                    handlerRef.add(new StringRefAddr("handlersoaprole", object.getSoapRole(n)));
                }
                for (n = 0; n < object.getPortNamesSize(); ++n) {
                    handlerRef.add(new StringRefAddr("handlerportname", object.getPortName(n)));
                }
                ((ServiceRef)abstractRef).addHandler(handlerRef);
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("naming.addService", new Object[]{abstractRef, contextService.getName()}));
            }
            this.createSubcontexts(this.envCtx, contextService.getName());
            this.envCtx.bind(contextService.getName(), (Object)abstractRef);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
        }
    }

    public void addResource(ContextResource contextResource) {
        Object object;
        Object object2;
        AbstractRef abstractRef = this.lookForLookupRef((ResourceBase)contextResource);
        if (abstractRef == null) {
            abstractRef = new ResourceRef(contextResource.getType(), contextResource.getDescription(), contextResource.getScope(), contextResource.getAuth(), contextResource.getSingleton());
            object2 = contextResource.listProperties();
            while (object2.hasNext()) {
                object = (String)object2.next();
                String string = (String)contextResource.getProperty((String)object);
                StringRefAddr stringRefAddr = new StringRefAddr((String)object, string);
                abstractRef.add(stringRefAddr);
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("naming.addResourceRef", new Object[]{abstractRef, contextResource.getName()}));
            }
            this.createSubcontexts(this.envCtx, contextResource.getName());
            this.envCtx.bind(contextResource.getName(), (Object)abstractRef);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
        }
        if (("javax.sql.DataSource".equals(abstractRef.getClassName()) || "javax.sql.XADataSource".equals(abstractRef.getClassName())) && contextResource.getSingleton()) {
            object2 = null;
            try {
                object = this.createObjectName(contextResource);
                object2 = this.envCtx.lookup(contextResource.getName());
                Registry.getRegistry(null, null).registerComponent(object2, (ObjectName)object, null);
                this.objectNames.put(contextResource.getName(), (ObjectName)object);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("naming.jmxRegistrationFailed", new Object[]{exception}));
            }
            if (object2 instanceof AutoCloseable && !contextResource.getCloseMethodConfigured()) {
                contextResource.setCloseMethod("close");
            }
        }
    }

    public void addResourceEnvRef(ContextResourceEnvRef contextResourceEnvRef) {
        AbstractRef abstractRef = this.lookForLookupRef((ResourceBase)contextResourceEnvRef);
        if (abstractRef == null) {
            abstractRef = new ResourceEnvRef(contextResourceEnvRef.getType());
            Iterator iterator = contextResourceEnvRef.listProperties();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)contextResourceEnvRef.getProperty(string);
                StringRefAddr stringRefAddr = new StringRefAddr(string, string2);
                abstractRef.add(stringRefAddr);
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("naming.addResourceEnvRef", new Object[]{contextResourceEnvRef.getName()}));
            }
            this.createSubcontexts(this.envCtx, contextResourceEnvRef.getName());
            this.envCtx.bind(contextResourceEnvRef.getName(), (Object)abstractRef);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
        }
    }

    public void addResourceLink(ContextResourceLink contextResourceLink) {
        Object object;
        ResourceLinkRef resourceLinkRef = new ResourceLinkRef(contextResourceLink.getType(), contextResourceLink.getGlobal(), contextResourceLink.getFactory(), null);
        Iterator iterator = contextResourceLink.listProperties();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Object object2 = contextResourceLink.getProperty((String)object);
            if (object2 == null) continue;
            StringRefAddr stringRefAddr = new StringRefAddr((String)object, object2.toString());
            resourceLinkRef.add(stringRefAddr);
        }
        object = "UserTransaction".equals(contextResourceLink.getName()) ? this.compCtx : this.envCtx;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("naming.addResourceLink", new Object[]{contextResourceLink.getName()}));
            }
            this.createSubcontexts(this.envCtx, contextResourceLink.getName());
            object.bind(contextResourceLink.getName(), (Object)resourceLinkRef);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
        }
        ResourceLinkFactory.registerGlobalResourceAccess(this.getGlobalNamingContext(), contextResourceLink.getName(), contextResourceLink.getGlobal());
    }

    private javax.naming.Context getGlobalNamingContext() {
        Engine engine;
        Server server;
        if (this.container instanceof Context && (server = (engine = (Engine)((Context)this.container).getParent().getParent()).getService().getServer()) != null) {
            return server.getGlobalNamingContext();
        }
        return null;
    }

    public void removeEjb(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.unbindFailed", new Object[]{string}), (Throwable)namingException);
        }
    }

    public void removeEnvironment(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.unbindFailed", new Object[]{string}), (Throwable)namingException);
        }
    }

    public void removeLocalEjb(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.unbindFailed", new Object[]{string}), (Throwable)namingException);
        }
    }

    public void removeMessageDestinationRef(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.unbindFailed", new Object[]{string}), (Throwable)namingException);
        }
    }

    public void removeService(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.unbindFailed", new Object[]{string}), (Throwable)namingException);
        }
    }

    public void removeResource(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.unbindFailed", new Object[]{string}), (Throwable)namingException);
        }
        ObjectName objectName = this.objectNames.get(string);
        if (objectName != null) {
            Registry.getRegistry(null, null).unregisterComponent(objectName);
        }
    }

    public void removeResourceEnvRef(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.unbindFailed", new Object[]{string}), (Throwable)namingException);
        }
    }

    public void removeResourceLink(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.unbindFailed", new Object[]{string}), (Throwable)namingException);
        }
        ResourceLinkFactory.deregisterGlobalResourceAccess(this.getGlobalNamingContext(), string);
    }

    private void createSubcontexts(javax.naming.Context context, String string) throws NamingException {
        javax.naming.Context context2 = context;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("") || !stringTokenizer.hasMoreTokens()) continue;
            try {
                context2 = context2.createSubcontext(string2);
            }
            catch (NamingException namingException) {
                context2 = (javax.naming.Context)context2.lookup(string2);
            }
        }
    }

    private LookupRef lookForLookupRef(ResourceBase resourceBase) {
        String string = resourceBase.getLookupName();
        if (string != null && !string.equals("")) {
            return new LookupRef(resourceBase.getType(), string);
        }
        return null;
    }
}

