/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.catalina.filters.CsrfPreventionFilterBase;
import org.apache.catalina.filters.FilterBase;

public class RestCsrfPreventionFilter
extends CsrfPreventionFilterBase {
    private static final Pattern NON_MODIFYING_METHODS_PATTERN = Pattern.compile("GET|HEAD|OPTIONS");
    private static final Predicate<String> nonModifyingMethods = string -> Objects.nonNull(string) && NON_MODIFYING_METHODS_PATTERN.matcher((CharSequence)string).matches();
    private Set<String> pathsAcceptingParams = new HashSet<String>();
    private String pathsDelimiter = ",";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        filterConfig.getServletContext().setAttribute("org.apache.catalina.filters.CSRF_REST_NONCE_HEADER_NAME", (Object)"X-CSRF-Token");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            RestCsrfPreventionStrategy restCsrfPreventionStrategy;
            MethodType methodType = MethodType.MODIFYING_METHOD;
            if (nonModifyingMethods.test(((HttpServletRequest)servletRequest).getMethod())) {
                methodType = MethodType.NON_MODIFYING_METHOD;
            }
            switch (methodType) {
                case NON_MODIFYING_METHOD: {
                    restCsrfPreventionStrategy = new FetchRequest();
                    break;
                }
                default: {
                    restCsrfPreventionStrategy = new StateChangingRequest();
                }
            }
            if (!restCsrfPreventionStrategy.apply((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse)) {
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void setPathsAcceptingParams(String string2) {
        if (Objects.nonNull(string2)) {
            Arrays.asList(string2.split(this.pathsDelimiter)).forEach(string -> this.pathsAcceptingParams.add(string.trim()));
        }
    }

    public Set<String> getPathsAcceptingParams() {
        return this.pathsAcceptingParams;
    }

    private static enum MethodType {
        NON_MODIFYING_METHOD,
        MODIFYING_METHOD;

    }

    private class FetchRequest
    implements RestCsrfPreventionStrategy {
        private final Predicate<String> fetchRequest = "Fetch"::equalsIgnoreCase;

        private FetchRequest() {
        }

        @Override
        public boolean apply(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            if (this.fetchRequest.test((String)nonceFromRequestHeader.getNonce(httpServletRequest, "X-CSRF-Token"))) {
                String string = (String)nonceFromSession.getNonce(httpServletRequest.getSession(false), "org.apache.catalina.filters.CSRF_REST_NONCE");
                if (string == null) {
                    string = RestCsrfPreventionFilter.this.generateNonce(httpServletRequest);
                    nonceToSession.setNonce(Objects.requireNonNull(httpServletRequest.getSession(true)), "org.apache.catalina.filters.CSRF_REST_NONCE", string);
                }
                nonceToResponse.setNonce(httpServletResponse, "X-CSRF-Token", string);
                if (RestCsrfPreventionFilter.this.getLogger().isDebugEnabled()) {
                    RestCsrfPreventionFilter.this.getLogger().debug((Object)FilterBase.sm.getString("restCsrfPreventionFilter.fetch.debug", new Object[]{httpServletRequest.getMethod(), httpServletRequest.getRequestURI()}));
                }
            }
            return true;
        }
    }

    private class StateChangingRequest
    implements RestCsrfPreventionStrategy {
        private StateChangingRequest() {
        }

        @Override
        public boolean apply(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
            HttpSession httpSession;
            String string;
            String string2 = this.extractNonceFromRequest(httpServletRequest);
            if (this.isValidStateChangingRequest(string2, string = (String)nonceFromSession.getNonce(httpSession = httpServletRequest.getSession(false), "org.apache.catalina.filters.CSRF_REST_NONCE"))) {
                return true;
            }
            nonceToResponse.setNonce(httpServletResponse, "X-CSRF-Token", "Required");
            httpServletResponse.sendError(RestCsrfPreventionFilter.this.getDenyStatus(), FilterBase.sm.getString("restCsrfPreventionFilter.invalidNonce"));
            if (RestCsrfPreventionFilter.this.getLogger().isDebugEnabled()) {
                RestCsrfPreventionFilter.this.getLogger().debug((Object)FilterBase.sm.getString("restCsrfPreventionFilter.invalidNonce.debug", new Object[]{httpServletRequest.getMethod(), httpServletRequest.getRequestURI(), httpServletRequest.getRequestedSessionId() != null, httpSession, string2 != null, string != null}));
            }
            return false;
        }

        private boolean isValidStateChangingRequest(String string, String string2) {
            return Objects.nonNull(string) && Objects.nonNull(string2) && Objects.equals(string, string2);
        }

        private String extractNonceFromRequest(HttpServletRequest httpServletRequest) {
            String string = (String)nonceFromRequestHeader.getNonce(httpServletRequest, "X-CSRF-Token");
            if ((Objects.isNull(string) || Objects.equals("", string)) && !RestCsrfPreventionFilter.this.getPathsAcceptingParams().isEmpty() && RestCsrfPreventionFilter.this.getPathsAcceptingParams().contains(RestCsrfPreventionFilter.this.getRequestedPath(httpServletRequest))) {
                string = this.extractNonceFromRequestParams(httpServletRequest);
            }
            return string;
        }

        private String extractNonceFromRequestParams(HttpServletRequest httpServletRequest) {
            String[] stringArray = (String[])nonceFromRequestParams.getNonce(httpServletRequest, "X-CSRF-Token");
            if (Objects.nonNull(stringArray) && stringArray.length > 0) {
                String string = stringArray[0];
                for (String string2 : stringArray) {
                    if (Objects.equals(string2, string)) continue;
                    if (RestCsrfPreventionFilter.this.getLogger().isDebugEnabled()) {
                        RestCsrfPreventionFilter.this.getLogger().debug((Object)FilterBase.sm.getString("restCsrfPreventionFilter.multipleNonce.debug", new Object[]{httpServletRequest.getMethod(), httpServletRequest.getRequestURI()}));
                    }
                    return null;
                }
                return string;
            }
            return null;
        }
    }

    private static interface RestCsrfPreventionStrategy {
        public static final NonceSupplier<HttpServletRequest, String> nonceFromRequestHeader = HttpServletRequest::getHeader;
        public static final NonceSupplier<HttpServletRequest, String[]> nonceFromRequestParams = ServletRequest::getParameterValues;
        public static final NonceSupplier<HttpSession, String> nonceFromSession = (httpSession, string) -> Objects.isNull(httpSession) ? null : (String)httpSession.getAttribute(string);
        public static final NonceConsumer<HttpServletResponse> nonceToResponse = HttpServletResponse::setHeader;
        public static final NonceConsumer<HttpSession> nonceToSession = HttpSession::setAttribute;

        public boolean apply(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }

    @FunctionalInterface
    private static interface NonceConsumer<T> {
        public void setNonce(T var1, String var2, String var3);
    }

    @FunctionalInterface
    private static interface NonceSupplier<T, R> {
        public R getNonce(T var1, String var2);
    }
}

