/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Buffer;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.util.buf.ByteBufferUtils;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.openssl.OpenSSLSessionContext;
import org.apache.tomcat.util.net.openssl.OpenSSLX509Certificate;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import org.apache.tomcat.util.res.StringManager;

public final class OpenSSLEngine
extends SSLEngine
implements SSLUtil.ProtocolInfo {
    private static final Log logger = LogFactory.getLog(OpenSSLEngine.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLEngine.class);
    private static final Certificate[] EMPTY_CERTIFICATES = new Certificate[0];
    public static final Set<String> AVAILABLE_CIPHER_SUITES;
    public static final Set<String> IMPLEMENTED_PROTOCOLS_SET;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private static final int MAX_COMPRESSED_LENGTH = 17408;
    private static final int MAX_CIPHERTEXT_LENGTH = 18432;
    static final int VERIFY_DEPTH = 10;
    static final int MAX_ENCRYPTED_PACKET_LENGTH = 18713;
    static final int MAX_ENCRYPTION_OVERHEAD_LENGTH = 2329;
    private static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    private static final long EMPTY_ADDR;
    private final OpenSSLState state;
    private final Cleaner.Cleanable cleanable;
    private Accepted accepted = Accepted.NOT;
    private boolean handshakeFinished;
    private int currentHandshake;
    private boolean receivedShutdown;
    private volatile boolean destroyed;
    private volatile String version;
    private volatile String cipher;
    private volatile String applicationProtocol;
    private volatile Certificate[] peerCerts;
    @Deprecated
    private volatile X509Certificate[] x509PeerCerts;
    private volatile ClientAuthMode clientAuth = ClientAuthMode.NONE;
    private boolean isInboundDone;
    private boolean isOutboundDone;
    private boolean engineClosed;
    private boolean sendHandshakeError = false;
    private final boolean clientMode;
    private final String fallbackApplicationProtocol;
    private final OpenSSLSessionContext sessionContext;
    private final boolean alpn;
    private final boolean initialized;
    private final int certificateVerificationDepth;
    private final boolean certificateVerificationOptionalNoCA;
    private String selectedProtocol = null;
    private final OpenSSLSession session;

    OpenSSLEngine(Cleaner cleaner, long l, String string, boolean bl, OpenSSLSessionContext openSSLSessionContext, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (l == 0L) {
            throw new IllegalArgumentException(sm.getString("engine.noSSLContext"));
        }
        this.session = new OpenSSLSession();
        long l2 = SSL.newSSL((long)l, (!bl ? 1 : 0) != 0);
        long l3 = SSL.makeNetworkBIO((long)l2);
        this.state = new OpenSSLState(l2, l3);
        this.cleanable = cleaner.register(this, this.state);
        this.fallbackApplicationProtocol = string;
        this.clientMode = bl;
        this.sessionContext = openSSLSessionContext;
        this.alpn = bl2;
        this.initialized = bl3;
        this.certificateVerificationDepth = n;
        this.certificateVerificationOptionalNoCA = bl4;
    }

    @Override
    public String getNegotiatedProtocol() {
        return this.selectedProtocol;
    }

    public synchronized void shutdown() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.cleanable.clean();
            this.engineClosed = true;
            this.isOutboundDone = true;
            this.isInboundDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlaintextData(long l, ByteBuffer byteBuffer) throws SSLException {
        int n;
        OpenSSLEngine.clearLastError();
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        int n4 = Math.min(n3 - n2, 16384);
        if (byteBuffer.isDirect()) {
            long l2 = Buffer.address((ByteBuffer)byteBuffer) + (long)n2;
            n = SSL.writeToSSL((long)l, (long)l2, (int)n4);
            if (n <= 0) {
                this.checkLastError();
            }
            if (n >= 0) {
                byteBuffer.position(n2 + n);
                return n;
            }
        } else {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n4);
            try {
                long l3 = Buffer.address((ByteBuffer)byteBuffer2);
                byteBuffer.limit(n2 + n4);
                byteBuffer2.put(byteBuffer);
                byteBuffer.limit(n3);
                n = SSL.writeToSSL((long)l, (long)l3, (int)n4);
                if (n <= 0) {
                    this.checkLastError();
                }
                if (n >= 0) {
                    byteBuffer.position(n2 + n);
                    int n5 = n;
                    return n5;
                }
                byteBuffer.position(n2);
            }
            finally {
                byteBuffer2.clear();
                ByteBufferUtils.cleanDirectBuffer((ByteBuffer)byteBuffer2);
            }
        }
        throw new IllegalStateException(sm.getString("engine.writeToSSLFailed", new Object[]{Integer.toString(n)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeEncryptedData(long l, ByteBuffer byteBuffer) throws SSLException {
        OpenSSLEngine.clearLastError();
        int n = byteBuffer.position();
        int n2 = byteBuffer.remaining();
        if (byteBuffer.isDirect()) {
            long l2 = Buffer.address((ByteBuffer)byteBuffer) + (long)n;
            int n3 = SSL.writeToBIO((long)l, (long)l2, (int)n2);
            if (n3 <= 0) {
                this.checkLastError();
            }
            if (n3 >= 0) {
                byteBuffer.position(n + n3);
                return n3;
            }
        } else {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n2);
            try {
                long l3 = Buffer.address((ByteBuffer)byteBuffer2);
                byteBuffer2.put(byteBuffer);
                int n4 = SSL.writeToBIO((long)l, (long)l3, (int)n2);
                if (n4 <= 0) {
                    this.checkLastError();
                }
                if (n4 >= 0) {
                    byteBuffer.position(n + n4);
                    int n5 = n4;
                    return n5;
                }
                byteBuffer.position(n);
            }
            finally {
                byteBuffer2.clear();
                ByteBufferUtils.cleanDirectBuffer((ByteBuffer)byteBuffer2);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlaintextData(long l, ByteBuffer byteBuffer) throws SSLException {
        OpenSSLEngine.clearLastError();
        if (byteBuffer.isDirect()) {
            int n;
            int n2 = byteBuffer.position();
            long l2 = Buffer.address((ByteBuffer)byteBuffer) + (long)n2;
            int n3 = SSL.readFromSSL((long)l, (long)l2, (int)(n = byteBuffer.limit() - n2));
            if (n3 > 0) {
                byteBuffer.position(n2 + n3);
                return n3;
            }
            this.checkLastError();
        } else {
            int n = byteBuffer.position();
            int n4 = byteBuffer.limit();
            int n5 = Math.min(18713, n4 - n);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n5);
            try {
                long l3 = Buffer.address((ByteBuffer)byteBuffer2);
                int n6 = SSL.readFromSSL((long)l, (long)l3, (int)n5);
                if (n6 > 0) {
                    byteBuffer2.limit(n6);
                    byteBuffer.limit(n + n6);
                    byteBuffer.put(byteBuffer2);
                    byteBuffer.limit(n4);
                    int n7 = n6;
                    return n7;
                }
                this.checkLastError();
            }
            finally {
                byteBuffer2.clear();
                ByteBufferUtils.cleanDirectBuffer((ByteBuffer)byteBuffer2);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readEncryptedData(long l, ByteBuffer byteBuffer, int n) throws SSLException {
        OpenSSLEngine.clearLastError();
        if (byteBuffer.isDirect() && byteBuffer.remaining() >= n) {
            int n2 = byteBuffer.position();
            long l2 = Buffer.address((ByteBuffer)byteBuffer) + (long)n2;
            int n3 = SSL.readFromBIO((long)l, (long)l2, (int)n);
            if (n3 > 0) {
                byteBuffer.position(n2 + n3);
                return n3;
            }
            this.checkLastError();
        } else {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
            try {
                long l3 = Buffer.address((ByteBuffer)byteBuffer2);
                int n4 = SSL.readFromBIO((long)l, (long)l3, (int)n);
                if (n4 > 0) {
                    byteBuffer2.limit(n4);
                    int n5 = byteBuffer.limit();
                    byteBuffer.limit(byteBuffer.position() + n4);
                    byteBuffer.put(byteBuffer2);
                    byteBuffer.limit(n5);
                    int n6 = n4;
                    return n6;
                }
                this.checkLastError();
            }
            finally {
                byteBuffer2.clear();
                ByteBufferUtils.cleanDirectBuffer((ByteBuffer)byteBuffer2);
            }
        }
        return 0;
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        if (this.destroyed) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (byteBufferArray == null || byteBuffer == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullBuffer"));
        }
        if (n >= byteBufferArray.length || n + n2 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException(sm.getString("engine.invalidBufferArray", new Object[]{Integer.toString(n), Integer.toString(n2), Integer.toString(byteBufferArray.length)}));
        }
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (this.accepted == Accepted.NOT) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        }
        int n3 = 0;
        int n4 = SSL.pendingWrittenBytesInBIO((long)this.state.networkBIO);
        if (n4 > 0) {
            int n5 = byteBuffer.remaining();
            if (n5 < n4) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, 0);
            }
            try {
                n3 = this.readEncryptedData(this.state.networkBIO, byteBuffer, n4);
            }
            catch (Exception exception) {
                throw new SSLException(exception);
            }
            if (this.isOutboundDone) {
                this.shutdown();
            }
            return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), 0, n3);
        }
        int n6 = 0;
        int n7 = n + n2;
        for (int i = n; i < n7; ++i) {
            ByteBuffer byteBuffer2 = byteBufferArray[i];
            if (byteBuffer2 == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullBufferInArray"));
            }
            while (byteBuffer2.hasRemaining()) {
                try {
                    n6 += this.writePlaintextData(this.state.ssl, byteBuffer2);
                }
                catch (Exception exception) {
                    throw new SSLException(exception);
                }
                n4 = SSL.pendingWrittenBytesInBIO((long)this.state.networkBIO);
                if (n4 <= 0) continue;
                int n8 = byteBuffer.remaining();
                if (n8 < n4) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), n6, n3);
                }
                try {
                }
                catch (Exception exception) {
                    throw new SSLException(exception);
                }
                return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), n6, n3 += this.readEncryptedData(this.state.networkBIO, byteBuffer, n4));
            }
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), n6, n3);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        if (this.destroyed) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (byteBuffer == null || byteBufferArray == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullBuffer"));
        }
        if (n >= byteBufferArray.length || n + n2 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException(sm.getString("engine.invalidBufferArray", new Object[]{Integer.toString(n), Integer.toString(n2), Integer.toString(byteBufferArray.length)}));
        }
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            ByteBuffer byteBuffer2 = byteBufferArray[i];
            if (byteBuffer2 == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullBufferInArray"));
            }
            if (byteBuffer2.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            n3 += byteBuffer2.remaining();
        }
        if (this.accepted == Accepted.NOT) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        }
        int n5 = byteBuffer.remaining();
        if (n5 > 18713) {
            this.isInboundDone = true;
            this.isOutboundDone = true;
            this.engineClosed = true;
            this.shutdown();
            throw new SSLException(sm.getString("engine.oversizedPacket"));
        }
        int n6 = 0;
        try {
            n6 = this.writeEncryptedData(this.state.networkBIO, byteBuffer);
        }
        catch (Exception exception) {
            throw new SSLException(exception);
        }
        int n7 = this.pendingReadableBytesInSSL();
        if (!this.handshakeFinished) {
            n7 = 0;
        }
        int n8 = 0;
        int n9 = n;
        if (n3 == 0) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), n6, 0);
        }
        while (n7 > 0) {
            if (n9 == n4) {
                throw new IllegalStateException(sm.getString("engine.invalidDestinationBuffersState"));
            }
            while (n9 < n4) {
                int n10;
                ByteBuffer byteBuffer3 = byteBufferArray[n9];
                if (!byteBuffer3.hasRemaining()) {
                    ++n9;
                    continue;
                }
                if (n7 <= 0) break;
                try {
                    n10 = this.readPlaintextData(this.state.ssl, byteBuffer3);
                }
                catch (Exception exception) {
                    throw new SSLException(exception);
                }
                if (n10 == 0) {
                    throw new IllegalStateException(sm.getString("engine.failedToReadAvailableBytes"));
                }
                n8 += n10;
                n7 -= n10;
                n3 -= n10;
                if (byteBuffer3.hasRemaining()) continue;
                ++n9;
            }
            if (n3 == 0) break;
            if (n7 != 0) continue;
            n7 = this.pendingReadableBytesInSSL();
        }
        if (!this.receivedShutdown && (SSL.getShutdown((long)this.state.ssl) & 2) == 2) {
            this.receivedShutdown = true;
            this.closeOutbound();
            this.closeInbound();
        }
        if (n8 == 0 && (n6 == 0 || n6 > 0 && !byteBuffer.hasRemaining() && this.handshakeFinished)) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), n6, 0);
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), n6, n8);
    }

    private int pendingReadableBytesInSSL() throws SSLException {
        OpenSSLEngine.clearLastError();
        int n = SSL.readFromSSL((long)this.state.ssl, (long)EMPTY_ADDR, (int)0);
        if (n <= 0) {
            this.checkLastError();
        }
        int n2 = SSL.pendingReadableBytesInSSL((long)this.state.ssl);
        if ("TLSv1".equals(this.version) && n == 0 && n2 == 0) {
            n = SSL.readFromSSL((long)this.state.ssl, (long)EMPTY_ADDR, (int)0);
            if (n <= 0) {
                this.checkLastError();
            }
            n2 = SSL.pendingReadableBytesInSSL((long)this.state.ssl);
        }
        return n2;
    }

    @Override
    public Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        this.engineClosed = true;
        this.shutdown();
        if (this.accepted != Accepted.NOT && !this.receivedShutdown) {
            throw new SSLException(sm.getString("engine.inboundClose"));
        }
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.isInboundDone || this.engineClosed;
    }

    @Override
    public synchronized void closeOutbound() {
        if (this.isOutboundDone) {
            return;
        }
        this.isOutboundDone = true;
        this.engineClosed = true;
        if (this.accepted != Accepted.NOT && !this.destroyed) {
            int n = SSL.getShutdown((long)this.state.ssl);
            if ((n & 1) != 1) {
                SSL.shutdownSSL((long)this.state.ssl);
            }
        } else {
            this.shutdown();
        }
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.isOutboundDone;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        Set<String> set = AVAILABLE_CIPHER_SUITES;
        return set.toArray(new String[0]);
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        if (this.destroyed) {
            return new String[0];
        }
        String[] stringArray = SSL.getCiphers((long)this.state.ssl);
        if (stringArray == null) {
            return new String[0];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = OpenSSLCipherConfigurationParser.openSSLToJsse(stringArray[i]);
            if (string == null) continue;
            stringArray[i] = string;
        }
        return stringArray;
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        if (this.initialized) {
            return;
        }
        if (stringArray == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullCipherSuite"));
        }
        if (this.destroyed) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null) break;
            String string2 = OpenSSLCipherConfigurationParser.jsseToOpenSSL(string);
            if (!AVAILABLE_CIPHER_SUITES.contains(string)) {
                logger.debug((Object)sm.getString("engine.unsupportedCipher", new Object[]{string, string2}));
            }
            if (string2 != null) {
                string = string2;
            }
            stringBuilder.append(string);
            stringBuilder.append(':');
        }
        if (stringBuilder.length() == 0) {
            throw new IllegalArgumentException(sm.getString("engine.emptyCipherSuite"));
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        String string = stringBuilder.toString();
        try {
            SSL.setCipherSuites((long)this.state.ssl, (String)string);
        }
        catch (Exception exception) {
            throw new IllegalStateException(sm.getString("engine.failedCipherSuite", new Object[]{string}), exception);
        }
    }

    @Override
    public String[] getSupportedProtocols() {
        return IMPLEMENTED_PROTOCOLS_SET.toArray(new String[0]);
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        if (this.destroyed) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("SSLv2Hello");
        int n = SSL.getOptions((long)this.state.ssl);
        if ((n & 0x4000000) == 0) {
            arrayList.add("TLSv1");
        }
        if ((n & 0x10000000) == 0) {
            arrayList.add("TLSv1.1");
        }
        if ((n & 0x8000000) == 0) {
            arrayList.add("TLSv1.2");
        }
        if ((n & 0x1000000) == 0) {
            arrayList.add("SSLv2");
        }
        if ((n & 0x2000000) == 0) {
            arrayList.add("SSLv3");
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        if (this.initialized) {
            return;
        }
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        if (this.destroyed) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (String string : stringArray) {
            if (!IMPLEMENTED_PROTOCOLS_SET.contains(string)) {
                throw new IllegalArgumentException(sm.getString("engine.unsupportedProtocol", new Object[]{string}));
            }
            if (string.equals("SSLv2")) {
                bl = true;
                continue;
            }
            if (string.equals("SSLv3")) {
                bl2 = true;
                continue;
            }
            if (string.equals("TLSv1")) {
                bl3 = true;
                continue;
            }
            if (string.equals("TLSv1.1")) {
                bl4 = true;
                continue;
            }
            if (!string.equals("TLSv1.2")) continue;
            bl5 = true;
        }
        SSL.setOptions((long)this.state.ssl, (int)4095);
        if (!bl) {
            SSL.setOptions((long)this.state.ssl, (int)0x1000000);
        }
        if (!bl2) {
            SSL.setOptions((long)this.state.ssl, (int)0x2000000);
        }
        if (!bl3) {
            SSL.setOptions((long)this.state.ssl, (int)0x4000000);
        }
        if (!bl4) {
            SSL.setOptions((long)this.state.ssl, (int)0x10000000);
        }
        if (!bl5) {
            SSL.setOptions((long)this.state.ssl, (int)0x8000000);
        }
    }

    @Override
    public SSLSession getSession() {
        return this.session;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.engineClosed || this.destroyed) {
            throw new SSLException(sm.getString("engine.engineClosed"));
        }
        switch (this.accepted) {
            case NOT: {
                this.handshake();
                this.accepted = Accepted.EXPLICIT;
                break;
            }
            case IMPLICIT: {
                this.accepted = Accepted.EXPLICIT;
                break;
            }
            case EXPLICIT: {
                this.renegotiate();
            }
        }
    }

    private void beginHandshakeImplicitly() throws SSLException {
        this.handshake();
        this.accepted = Accepted.IMPLICIT;
    }

    private void handshake() throws SSLException {
        this.currentHandshake = SSL.getHandshakeCount((long)this.state.ssl);
        OpenSSLEngine.clearLastError();
        int n = SSL.doHandshake((long)this.state.ssl);
        if (n <= 0) {
            this.checkLastError();
        } else {
            if (this.alpn) {
                this.selectedProtocol = SSL.getAlpnSelected((long)this.state.ssl);
            }
            this.session.lastAccessedTime = System.currentTimeMillis();
            this.handshakeFinished = true;
        }
    }

    private synchronized void renegotiate() throws SSLException {
        OpenSSLEngine.clearLastError();
        int n = SSL.getVersion((long)this.state.ssl).equals("TLSv1.3") ? SSL.verifyClientPostHandshake((long)this.state.ssl) : SSL.renegotiate((long)this.state.ssl);
        if (n <= 0) {
            this.checkLastError();
        }
        this.handshakeFinished = false;
        this.peerCerts = null;
        this.x509PeerCerts = null;
        this.currentHandshake = SSL.getHandshakeCount((long)this.state.ssl);
        int n2 = SSL.doHandshake((long)this.state.ssl);
        if (n2 <= 0) {
            this.checkLastError();
        }
    }

    private void checkLastError() throws SSLException {
        String string = OpenSSLEngine.getLastError();
        if (string != null) {
            if (!this.handshakeFinished) {
                this.sendHandshakeError = true;
            } else {
                throw new SSLException(string);
            }
        }
    }

    private static void clearLastError() {
        OpenSSLEngine.getLastError();
    }

    private static String getLastError() {
        long l;
        String string = null;
        while ((l = (long)SSL.getLastErrorNumber()) != 0L) {
            String string2 = SSL.getErrorString((long)l);
            if (string == null) {
                string = string2;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)sm.getString("engine.openSSLError", new Object[]{Long.toString(l), string2}));
        }
        return string;
    }

    private SSLEngineResult.Status getEngineStatus() {
        return this.engineClosed ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.accepted == Accepted.NOT || this.destroyed) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        if (!this.handshakeFinished) {
            if (this.sendHandshakeError || SSL.pendingWrittenBytesInBIO((long)this.state.networkBIO) != 0) {
                if (this.sendHandshakeError) {
                    this.sendHandshakeError = false;
                    ++this.currentHandshake;
                }
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            int n = SSL.getHandshakeCount((long)this.state.ssl);
            if (n != this.currentHandshake && SSL.renegotiatePending((long)this.state.ssl) == 0 && SSL.getPostHandshakeAuthInProgress((long)this.state.ssl) == 0) {
                if (this.alpn) {
                    this.selectedProtocol = SSL.getAlpnSelected((long)this.state.ssl);
                }
                this.session.lastAccessedTime = System.currentTimeMillis();
                this.version = SSL.getVersion((long)this.state.ssl);
                this.handshakeFinished = true;
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.engineClosed) {
            if (SSL.pendingWrittenBytesInBIO((long)this.state.networkBIO) != 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    @Override
    public void setUseClientMode(boolean bl) {
        if (bl != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public void setNeedClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuthMode.REQUIRE : ClientAuthMode.NONE);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuthMode.REQUIRE;
    }

    @Override
    public void setWantClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuthMode.OPTIONAL : ClientAuthMode.NONE);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.clientAuth == ClientAuthMode.OPTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuthMode clientAuthMode) {
        if (this.clientMode) {
            return;
        }
        OpenSSLEngine openSSLEngine = this;
        synchronized (openSSLEngine) {
            if (this.clientAuth == clientAuthMode) {
                return;
            }
            switch (clientAuthMode) {
                case NONE: {
                    SSL.setVerify((long)this.state.ssl, (int)0, (int)this.certificateVerificationDepth);
                    break;
                }
                case REQUIRE: {
                    SSL.setVerify((long)this.state.ssl, (int)2, (int)this.certificateVerificationDepth);
                    break;
                }
                case OPTIONAL: {
                    SSL.setVerify((long)this.state.ssl, (int)(this.certificateVerificationOptionalNoCA ? 3 : 1), (int)this.certificateVerificationDepth);
                }
            }
            this.clientAuth = clientAuthMode;
        }
    }

    @Override
    public void setEnableSessionCreation(boolean bl) {
        if (!bl) {
            String string = sm.getString("engine.noRestrictSessionCreation");
            throw new UnsupportedOperationException(string);
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(128);
        long l = Pool.create((long)0L);
        try {
            long l2 = SSLContext.make((long)l, (int)SSL.SSL_PROTOCOL_ALL, (int)1);
            try {
                SSLContext.setOptions((long)l2, (int)4095);
                SSLContext.setCipherSuite((long)l2, (String)"ALL");
                long l3 = SSL.newSSL((long)l2, (boolean)true);
                try {
                    for (String string : SSL.getCiphers((long)l3)) {
                        if (string == null || string.length() == 0 || linkedHashSet.contains(string)) continue;
                        linkedHashSet.add(OpenSSLCipherConfigurationParser.openSSLToJsse(string));
                    }
                }
                finally {
                    SSL.freeSSL((long)l3);
                }
            }
            finally {
                SSLContext.free((long)l2);
            }
        }
        catch (Exception exception) {
            logger.warn((Object)sm.getString("engine.ciphersFailure"), (Throwable)exception);
        }
        finally {
            Pool.destroy((long)l);
        }
        AVAILABLE_CIPHER_SUITES = Collections.unmodifiableSet(linkedHashSet);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("SSLv2Hello");
        hashSet.add("SSLv2");
        hashSet.add("SSLv3");
        hashSet.add("TLSv1");
        hashSet.add("TLSv1.1");
        hashSet.add("TLSv1.2");
        if (SSL.version() >= 0x1010100F) {
            hashSet.add("TLSv1.3");
        }
        IMPLEMENTED_PROTOCOLS_SET = Collections.unmodifiableSet(hashSet);
        EMPTY_ADDR = Buffer.address((ByteBuffer)ByteBuffer.allocate(0));
    }

    private static enum Accepted {
        NOT,
        IMPLICIT,
        EXPLICIT;

    }

    static enum ClientAuthMode {
        NONE,
        OPTIONAL,
        REQUIRE;

    }

    private class OpenSSLSession
    implements SSLSession {
        private Map<String, Object> values;
        private long lastAccessedTime = -1L;

        private OpenSSLSession() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getId() {
            byte[] byArray = null;
            OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
            synchronized (openSSLEngine) {
                if (!OpenSSLEngine.this.destroyed) {
                    byArray = SSL.getSessionId((long)OpenSSLEngine.this.state.ssl);
                }
            }
            return byArray;
        }

        @Override
        public SSLSessionContext getSessionContext() {
            return OpenSSLEngine.this.sessionContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCreationTime() {
            long l = 0L;
            OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
            synchronized (openSSLEngine) {
                if (!OpenSSLEngine.this.destroyed) {
                    l = SSL.getTime((long)OpenSSLEngine.this.state.ssl);
                }
            }
            return l * 1000L;
        }

        @Override
        public long getLastAccessedTime() {
            return this.lastAccessedTime > 0L ? this.lastAccessedTime : this.getCreationTime();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void putValue(String string, Object object) {
            if (string == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            if (object == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullValue"));
            }
            Map<String, Object> map = this.values;
            if (map == null) {
                map = this.values = new HashMap<String, Object>(2);
            }
            Object object2 = map.put(string, object);
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueBound(new SSLSessionBindingEvent(this, string));
            }
            this.notifyUnbound(object2, string);
        }

        @Override
        public Object getValue(String string) {
            if (string == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            if (this.values == null) {
                return null;
            }
            return this.values.get(string);
        }

        @Override
        public void removeValue(String string) {
            if (string == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            Map<String, Object> map = this.values;
            if (map == null) {
                return;
            }
            Object object = map.remove(string);
            this.notifyUnbound(object, string);
        }

        @Override
        public String[] getValueNames() {
            Map<String, Object> map = this.values;
            if (map == null || map.isEmpty()) {
                return new String[0];
            }
            return map.keySet().toArray(new String[0]);
        }

        private void notifyUnbound(Object object, String string) {
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueUnbound(new SSLSessionBindingEvent(this, string));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            Certificate[] certificateArray = OpenSSLEngine.this.peerCerts;
            if (certificateArray == null) {
                Certificate[] certificateArray2;
                byte[] byArray;
                byte[][] byArray2;
                OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
                synchronized (openSSLEngine) {
                    if (OpenSSLEngine.this.destroyed || SSL.isInInit((long)OpenSSLEngine.this.state.ssl) != 0) {
                        throw new SSLPeerUnverifiedException(sm.getString("engine.unverifiedPeer"));
                    }
                    byArray2 = SSL.getPeerCertChain((long)OpenSSLEngine.this.state.ssl);
                    byArray = !OpenSSLEngine.this.clientMode ? SSL.getPeerCertificate((long)OpenSSLEngine.this.state.ssl) : null;
                }
                if (byArray2 == null && byArray == null) {
                    return null;
                }
                int n = 0;
                if (byArray2 != null) {
                    n += byArray2.length;
                }
                int n2 = 0;
                if (byArray != null) {
                    certificateArray2 = new Certificate[++n];
                    certificateArray2[n2++] = new OpenSSLX509Certificate(byArray);
                } else {
                    certificateArray2 = new Certificate[n];
                }
                if (byArray2 != null) {
                    int n3 = 0;
                    while (n2 < certificateArray2.length) {
                        certificateArray2[n2] = new OpenSSLX509Certificate(byArray2[n3++]);
                        ++n2;
                    }
                }
                OpenSSLEngine.this.peerCerts = certificateArray2;
                certificateArray = certificateArray2;
            }
            return certificateArray;
        }

        @Override
        public Certificate[] getLocalCertificates() {
            return EMPTY_CERTIFICATES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @Deprecated
        public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
            X509Certificate[] x509CertificateArray = OpenSSLEngine.this.x509PeerCerts;
            if (x509CertificateArray != null) return x509CertificateArray;
            X509Certificate[] x509CertificateArray2 = OpenSSLEngine.this;
            synchronized (OpenSSLEngine.this) {
                if (OpenSSLEngine.this.destroyed) throw new SSLPeerUnverifiedException(sm.getString("engine.unverifiedPeer"));
                if (SSL.isInInit((long)OpenSSLEngine.this.state.ssl) != 0) {
                    throw new SSLPeerUnverifiedException(sm.getString("engine.unverifiedPeer"));
                }
                byte[][] byArray = SSL.getPeerCertChain((long)OpenSSLEngine.this.state.ssl);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (byArray == null) {
                    throw new SSLPeerUnverifiedException(sm.getString("engine.unverifiedPeer"));
                }
                x509CertificateArray2 = new X509Certificate[byArray.length];
                for (int i = 0; i < x509CertificateArray2.length; ++i) {
                    try {
                        x509CertificateArray2[i] = X509Certificate.getInstance(byArray[i]);
                        continue;
                    }
                    catch (CertificateException certificateException) {
                        throw new IllegalStateException(certificateException);
                    }
                }
                OpenSSLEngine.this.x509PeerCerts = x509CertificateArray2;
                return x509CertificateArray2;
            }
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            Certificate[] certificateArray = this.getPeerCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                return null;
            }
            return this.principal(certificateArray);
        }

        @Override
        public Principal getLocalPrincipal() {
            Certificate[] certificateArray = this.getLocalCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                return null;
            }
            return this.principal(certificateArray);
        }

        private Principal principal(Certificate[] certificateArray) {
            return ((java.security.cert.X509Certificate)certificateArray[0]).getIssuerX500Principal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getCipherSuite() {
            if (OpenSSLEngine.this.cipher == null) {
                String string;
                Object object = OpenSSLEngine.this;
                synchronized (object) {
                    if (!OpenSSLEngine.this.handshakeFinished) {
                        return OpenSSLEngine.INVALID_CIPHER;
                    }
                    if (OpenSSLEngine.this.destroyed) {
                        return OpenSSLEngine.INVALID_CIPHER;
                    }
                    string = SSL.getCipherForSSL((long)OpenSSLEngine.this.state.ssl);
                }
                object = OpenSSLCipherConfigurationParser.openSSLToJsse(string);
                if (object != null) {
                    OpenSSLEngine.this.cipher = object;
                }
            }
            return OpenSSLEngine.this.cipher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getProtocol() {
            String string = OpenSSLEngine.this.applicationProtocol;
            if (string == null) {
                string = OpenSSLEngine.this.fallbackApplicationProtocol;
                if (string != null) {
                    OpenSSLEngine.this.applicationProtocol = string.replace(':', '_');
                } else {
                    string = "";
                    OpenSSLEngine.this.applicationProtocol = "";
                }
            }
            String string2 = null;
            OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
            synchronized (openSSLEngine) {
                if (!OpenSSLEngine.this.destroyed) {
                    string2 = SSL.getVersion((long)OpenSSLEngine.this.state.ssl);
                }
            }
            if (string.isEmpty()) {
                return string2;
            }
            return string2 + ":" + string;
        }

        @Override
        public String getPeerHost() {
            return null;
        }

        @Override
        public int getPeerPort() {
            return 0;
        }

        @Override
        public int getPacketBufferSize() {
            return 18713;
        }

        @Override
        public int getApplicationBufferSize() {
            return 16384;
        }
    }

    private static class OpenSSLState
    implements Runnable {
        private final long ssl;
        private final long networkBIO;

        private OpenSSLState(long l, long l2) {
            this.ssl = l;
            this.networkBIO = l2;
        }

        @Override
        public void run() {
            if (this.networkBIO != 0L) {
                SSL.freeBIO((long)this.networkBIO);
            }
            if (this.ssl != 0L) {
                SSL.freeSSL((long)this.ssl);
            }
        }
    }
}

