﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotevents-data/IoTEventsDataRequest.h>
#include <aws/iotevents-data/IoTEventsData_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoTEventsData {
namespace Model {

/**
 */
class DescribeDetectorRequest : public IoTEventsDataRequest {
 public:
  AWS_IOTEVENTSDATA_API DescribeDetectorRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeDetector"; }

  AWS_IOTEVENTSDATA_API Aws::String SerializePayload() const override;

  AWS_IOTEVENTSDATA_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The name of the detector model whose detectors (instances) you want
   * information about.</p>
   */
  inline const Aws::String& GetDetectorModelName() const { return m_detectorModelName; }
  inline bool DetectorModelNameHasBeenSet() const { return m_detectorModelNameHasBeenSet; }
  template <typename DetectorModelNameT = Aws::String>
  void SetDetectorModelName(DetectorModelNameT&& value) {
    m_detectorModelNameHasBeenSet = true;
    m_detectorModelName = std::forward<DetectorModelNameT>(value);
  }
  template <typename DetectorModelNameT = Aws::String>
  DescribeDetectorRequest& WithDetectorModelName(DetectorModelNameT&& value) {
    SetDetectorModelName(std::forward<DetectorModelNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A filter used to limit results to detectors (instances) created because of
   * the given key ID.</p>
   */
  inline const Aws::String& GetKeyValue() const { return m_keyValue; }
  inline bool KeyValueHasBeenSet() const { return m_keyValueHasBeenSet; }
  template <typename KeyValueT = Aws::String>
  void SetKeyValue(KeyValueT&& value) {
    m_keyValueHasBeenSet = true;
    m_keyValue = std::forward<KeyValueT>(value);
  }
  template <typename KeyValueT = Aws::String>
  DescribeDetectorRequest& WithKeyValue(KeyValueT&& value) {
    SetKeyValue(std::forward<KeyValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_detectorModelName;

  Aws::String m_keyValue;
  bool m_detectorModelNameHasBeenSet = false;
  bool m_keyValueHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTEventsData
}  // namespace Aws
