/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet.sheets.csv;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;
import org.gephi.io.importer.plugin.file.spreadsheet.sheets.csv.CSVSheetRow;

public class CSVSheetParser
implements SheetParser {
    private final CSVParser parser;

    public CSVSheetParser(CSVParser parser) {
        this.parser = parser;
    }

    @Override
    public Map<String, Integer> getHeaderMap() {
        Map map = this.parser.getHeaderMap();
        if (map == null) {
            return Collections.emptyMap();
        }
        map.remove(null);
        return map;
    }

    @Override
    public long getCurrentRecordNumber() {
        return this.parser.getRecordNumber();
    }

    @Override
    public Iterator<SheetRow> iterator() {
        return new CSVIterator();
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    private class ErrorRow
    implements SheetRow {
        private final String errorMessage;

        public ErrorRow(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public boolean isConsistent() {
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String get(int index) {
            if (index == 0) {
                return this.errorMessage;
            }
            return null;
        }
    }

    private class CSVIterator
    implements Iterator<SheetRow> {
        private final Iterator<CSVRecord> iterator;
        private ErrorRow errorFound = null;

        public CSVIterator() {
            this.iterator = CSVSheetParser.this.parser.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.errorFound != null) {
                return false;
            }
            try {
                return this.iterator.hasNext();
            }
            catch (Exception e) {
                this.errorFound = new ErrorRow(e.getMessage());
                Logger.getLogger("").severe(e.getMessage());
                return true;
            }
        }

        @Override
        public SheetRow next() {
            if (this.errorFound != null) {
                return this.errorFound;
            }
            return new CSVSheetRow(this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

