---
stage: Analytics
group: Platform Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: レスポンダーのオンコールスケジュールとローテーションを管理します。これには、インシデント対応のためのスケジュールとローテーションの作成、編集、削除が含まれます。
title: オンコールスケジュール管理
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

オンコールスケジュール管理を使用して、レスポンダーがオンコール担当をローテーションするためのスケジュールを作成します。チームをオンコールにすることで、ソフトウェアサービスの可用性を維持します。[エスカレーションポリシー](escalation_policies.md)とオンコールスケジュールにより、問題が発生した場合、チームはすぐに通知を受け、サービス停止や中断に迅速に対応できます。

オンコールスケジュールを使用するには、以下を実行します:

1. [スケジュールを作成](#schedules)。
1. [スケジュールにローテーションを追加](#rotations)。

## スケジュール {#schedules}

チームのローテーションを追加するためのオンコールスケジュールを設定します。

前提要件:

- メンテナーロール以上が必要です。

オンコールスケジュールを作成するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**モニタリング**> **通話スケジュール**を選択します。
1. **Add a schedule**（スケジュールを追加） を選択します。
1. スケジュールの名前と説明を入力し、タイムゾーンを選択します。
1. **スケジュールを追加**を選択します。

これで、ローテーションのない空のスケジュールが作成されました。これは空の状態として表示され、スケジュールの[ローテーション](#rotations)を作成するように求められます。

![空のスケジュールグリッド](img/oncall_schedule_empty_grid_v13_10.png)

### スケジュールを編集 {#edit-a-schedule}

スケジュールを更新するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**モニタリング**> **通話スケジュール**を選択します。
1. **スケジュールを編集**（{{< icon name="pencil" >}}）を選択します。
1. 情報を編集します。
1. **変更を保存**を選択します。

スケジュールのタイムゾーンを変更すると、GitLabは、ローテーションの制限時間間隔（設定されている場合）を新しいタイムゾーンの対応する時間に自動的に更新します。

### スケジュールを削除 {#delete-a-schedule}

スケジュールを削除するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**モニタリング**> **通話スケジュール**を選択します。
1. **エスカレーションポリシーを削除**（{{< icon name="remove" >}}）を選択します。
1. 確認ダイアログで、**スケジュールを削除**を選択します。

## ローテーション {#rotations}

既存のスケジュールにローテーションを追加して、チームメンバーをオンコールにします。

ローテーションを作成するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**モニタリング**> **通話スケジュール**を選択します。
1. **ローテーションを追加**リンクを選択します。
1. 次の情報を入力します:

   - **名前**: ローテーション名。
   - **参加者**: ローテーションに参加させるユーザー。
   - **ローテーションの長さ**: ローテーションの期間。
   - **開始日時:**: ローテーションが開始する日時。
   - **終了日時を有効にする**: この切替をオンにすると、ローテーションが終了する日時を選択できます。
   - **時間間隔を制限する**: 切替をオンにすると、選択した期間にローテーションを制限できます。

### ローテーションを編集 {#edit-a-rotation}

ローテーションを編集するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**モニタリング**> **通話スケジュール**を選択します。
1. **ローテーション**セクションで、**ローテーションを編集**（{{< icon name="pencil" >}}）を選択します。
1. 情報を編集します。
1. **変更を保存**を選択します。

### ローテーションを削除 {#delete-a-rotation}

ローテーションを削除するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**モニタリング**> **通話スケジュール**を選択します。
1. **ローテーション**セクションで、**ローテーションを削除**（{{< icon name="remove" >}}）を選択します。
1. 確認ダイアログで、**ローテーションを削除**を選択します。

## スケジュールのローテーションを表示 {#view-schedule-rotations}

1日または2週間のオンコールスケジュールを表示できます。これらの期間を切り替えるには、スケジュールで**1日**または**2週間**のボタンを選択します。デフォルトでは2週間の表示です。

スケジュール内のローテーションシフトの参加者にカーソルを合わせると、個々のシフトの詳細が表示されます。

![1日のグリッド表示](img/oncall_schedule_day_grid_v13_10.png)

## オンコールのレスポンダーを呼び出す {#page-an-on-call-responder}

詳細については、[呼び出し](paging.md#paging)を参照してください。

## オンコールユーザーの削除または削除 {#removal-or-deletion-of-on-call-user}

オンコールユーザーがプロジェクトまたはグループから削除された場合、またはそのアカウントが削除された場合、確認モーダルには、そのユーザーのオンコールスケジュールのリストが表示されます。ユーザーの削除または削除が確認されると、GitLabはオンコールローテーションを再計算し、プロジェクトオーナーとローテーションの参加者にメールを送信します。
