"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenIdAuthentication = void 0;
var fs = _interopRequireWildcard(require("fs"));
var _wreck = _interopRequireDefault(require("@hapi/wreck"));
var _proxyAgent = require("proxy-agent");
var _security_cookie = require("../../../session/security_cookie");
var _routes = require("./routes");
var _authentication_type = require("../authentication_type");
var _helper = require("./helper");
var _object_properties_defined = require("../../../utils/object_properties_defined");
var _common = require("../../../../common");
var _cookie_splitter = require("../../../session/cookie_splitter");
var _http = require("../../../../../../src/core/server/http");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          *   Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *   Licensed under the Apache License, Version 2.0 (the "License").
                                                                                                                                                                                                                                                                                                                          *   You may not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                          *   A copy of the License is located at
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *       http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *   or in the "license" file accompanying this file. This file is distributed
                                                                                                                                                                                                                                                                                                                          *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
                                                                                                                                                                                                                                                                                                                          *   express or implied. See the License for the specific language governing
                                                                                                                                                                                                                                                                                                                          *   permissions and limitations under the License.
                                                                                                                                                                                                                                                                                                                          */
class OpenIdAuthentication extends _authentication_type.AuthenticationType {
  constructor(config, sessionStorageFactory, router, esClient, core, logger) {
    var _this$config$openid, _this$config$openid2;
    super(config, sessionStorageFactory, router, esClient, core, logger);
    _defineProperty(this, "type", _common.AuthType.OPEN_ID);
    _defineProperty(this, "openIdAuthConfig", void 0);
    _defineProperty(this, "authHeaderName", void 0);
    _defineProperty(this, "openIdConnectUrl", void 0);
    _defineProperty(this, "wreckClient", void 0);
    _defineProperty(this, "wreckHttpsOption", {});
    _defineProperty(this, "redirectOIDCCapture", (request, toolkit) => {
      const nextUrl = this.generateNextUrl(request);
      const clearOldVersionCookie = (0, _security_cookie.clearOldVersionCookieValue)(this.config);
      return toolkit.redirected({
        location: `${this.coreSetup.http.basePath.serverBasePath}/auth/openid/captureUrlFragment?nextUrl=${nextUrl}`,
        'set-cookie': clearOldVersionCookie
      });
    });
    this.wreckClient = this.createWreckClient();
    this.openIdAuthConfig = {};
    this.authHeaderName = ((_this$config$openid = this.config.openid) === null || _this$config$openid === void 0 ? void 0 : _this$config$openid.header) || '';
    this.openIdAuthConfig.authHeaderName = this.authHeaderName;
    this.openIdConnectUrl = ((_this$config$openid2 = this.config.openid) === null || _this$config$openid2 === void 0 ? void 0 : _this$config$openid2.connect_url) || '';
    let scope = this.config.openid.scope;
    if (scope.indexOf('openid') < 0) {
      scope = `openid ${scope}`;
    }
    this.openIdAuthConfig.scope = scope;
  }
  async init() {
    try {
      const response = await this.wreckClient.get(this.openIdConnectUrl);
      const payload = JSON.parse(response.payload);
      this.openIdAuthConfig.authorizationEndpoint = payload.authorization_endpoint;
      this.openIdAuthConfig.tokenEndpoint = payload.token_endpoint;
      this.openIdAuthConfig.endSessionEndpoint = payload.end_session_endpoint || undefined;
      this.createExtraStorage();
      const routes = new _routes.OpenIdAuthRoutes(this.router, this.config, this.sessionStorageFactory, this.openIdAuthConfig, this.securityClient, this.coreSetup, this.wreckClient);
      routes.setupRoutes();
    } catch (error) {
      this.logger.error(error); // TODO: log more info
      throw new Error('Failed when trying to obtain the endpoints from your IdP');
    }
  }
  generateNextUrl(request) {
    let path = (0, _http.getRedirectUrl)({
      request,
      basePath: this.coreSetup.http.basePath.serverBasePath,
      nextUrl: request.url.pathname || '/app/opensearch-dashboards'
    });
    if (request.url.search) {
      path += request.url.search;
    }
    return escape(path);
  }
  createWreckClient() {
    var _this$config$openid3, _this$config$openid4, _this$config$openid5, _this$config$openid6, _this$config$openid7, _this$config$openid9;
    if ((_this$config$openid3 = this.config.openid) !== null && _this$config$openid3 !== void 0 && _this$config$openid3.root_ca) {
      this.wreckHttpsOption.ca = [fs.readFileSync(this.config.openid.root_ca)];
      this.logger.debug(`Using CA Cert: ${this.config.openid.root_ca}`);
    }
    if ((_this$config$openid4 = this.config.openid) !== null && _this$config$openid4 !== void 0 && _this$config$openid4.pfx) {
      // Use PFX or PKCS12 if provided
      this.logger.debug(`Using PFX or PKCS12: ${this.config.openid.pfx}`);
      this.wreckHttpsOption.pfx = [fs.readFileSync(this.config.openid.pfx)];
    } else if ((_this$config$openid5 = this.config.openid) !== null && _this$config$openid5 !== void 0 && _this$config$openid5.certificate && (_this$config$openid6 = this.config.openid) !== null && _this$config$openid6 !== void 0 && _this$config$openid6.private_key) {
      // Use 'certificate' and 'private_key' if provided
      this.logger.debug(`Using Certificate: ${this.config.openid.certificate}`);
      this.logger.debug(`Using Private Key: ${this.config.openid.private_key}`);
      this.wreckHttpsOption.cert = [fs.readFileSync(this.config.openid.certificate)];
      this.wreckHttpsOption.key = [fs.readFileSync(this.config.openid.private_key)];
    } else {
      this.logger.debug(`Client certificates not provided. Mutual TLS will not be used to obtain endpoints.`);
    }
    // Check if passphrase is provided, use it for 'pfx' and 'key'
    if (((_this$config$openid7 = this.config.openid) === null || _this$config$openid7 === void 0 ? void 0 : _this$config$openid7.passphrase) !== '') {
      var _this$config$openid8;
      this.logger.debug(`Passphrase not provided for private key and/or pfx.`);
      this.wreckHttpsOption.passphrase = (_this$config$openid8 = this.config.openid) === null || _this$config$openid8 === void 0 ? void 0 : _this$config$openid8.passphrase;
    }
    if (((_this$config$openid9 = this.config.openid) === null || _this$config$openid9 === void 0 ? void 0 : _this$config$openid9.verify_hostnames) === false) {
      this.logger.debug(`openId auth 'verify_hostnames' option is off.`);
      this.wreckHttpsOption.checkServerIdentity = (host, cert) => {
        return undefined;
      };
    }
    this.logger.info((0, _object_properties_defined.getObjectProperties)(this.wreckHttpsOption, 'WreckHttpsOptions'));

    // Use proxy agent to allow usage of e.g. http_proxy environment variable
    const httpAgent = new _proxyAgent.ProxyAgent();
    const httpsAllowUnauthorizedAgent = new _proxyAgent.ProxyAgent({
      rejectUnauthorized: false
    });
    let httpsAgent = new _proxyAgent.ProxyAgent();
    if (Object.keys(this.wreckHttpsOption).length > 0) {
      httpsAgent = new _proxyAgent.ProxyAgent(this.wreckHttpsOption);
    }
    return _wreck.default.defaults({
      agents: {
        http: httpAgent,
        https: httpsAgent,
        httpsAllowUnauthorized: httpsAllowUnauthorizedAgent
      }
    });
  }
  getWreckHttpsOptions() {
    return this.wreckHttpsOption;
  }
  createExtraStorage() {
    // @ts-ignore
    const hapiServer = this.sessionStorageFactory.asScoped({}).server;
    const extraCookiePrefix = this.config.openid.extra_storage.cookie_prefix;
    const extraCookieSettings = {
      isSecure: this.config.cookie.secure,
      isSameSite: this.config.cookie.isSameSite,
      password: this.config.cookie.password,
      domain: this.config.cookie.domain,
      path: this.coreSetup.http.basePath.serverBasePath || '/',
      clearInvalid: false,
      isHttpOnly: true,
      ignoreErrors: true,
      encoding: 'iron' // Same as hapi auth cookie
    };

    for (let i = 1; i <= this.config.openid.extra_storage.additional_cookies; i++) {
      hapiServer.states.add(extraCookiePrefix + i, extraCookieSettings);
    }
  }
  getExtraAuthStorageOptions() {
    // If we're here, we will always have the openid configuration
    return {
      cookiePrefix: this.config.openid.extra_storage.cookie_prefix,
      additionalCookies: this.config.openid.extra_storage.additional_cookies,
      logger: this.logger
    };
  }
  requestIncludesAuthInfo(request) {
    return request.headers.authorization ? true : false;
  }
  async getAdditionalAuthHeader(request) {
    return {};
  }
  getCookie(request, authInfo) {
    (0, _cookie_splitter.setExtraAuthStorage)(request, request.headers.authorization, this.getExtraAuthStorageOptions());
    return {
      username: authInfo.user_name,
      credentials: {
        authHeaderValueExtra: true
      },
      authType: this.type,
      expiryTime: Date.now() + this.config.session.ttl
    };
  }
  getKeepAliveExpiry(cookie, request) {
    return Date.now() + this.config.session.ttl;
  }

  // TODO: Add token expiration check here
  async isValidCookie(cookie, request) {
    var _cookie$credentials;
    if (cookie.authType !== this.type || !cookie.username || !cookie.expiryTime || !((_cookie$credentials = cookie.credentials) !== null && _cookie$credentials !== void 0 && _cookie$credentials.authHeaderValue) && !this.getExtraAuthStorageValue(request, cookie)) {
      return false;
    }
    if (cookie.credentials.expiryTime > Date.now()) {
      return true;
    }

    // need to renew id token
    if (cookie.credentials.refresh_token) {
      try {
        var _this$config$openid10, _this$config$openid11;
        const query = {
          grant_type: 'refresh_token',
          client_id: (_this$config$openid10 = this.config.openid) === null || _this$config$openid10 === void 0 ? void 0 : _this$config$openid10.client_id,
          client_secret: (_this$config$openid11 = this.config.openid) === null || _this$config$openid11 === void 0 ? void 0 : _this$config$openid11.client_secret,
          refresh_token: cookie.credentials.refresh_token
        };
        const refreshTokenResponse = await (0, _helper.callTokenEndpoint)(this.openIdAuthConfig.tokenEndpoint, query, this.wreckClient);

        // if no id_token from refresh token call, maybe the Idp doesn't allow refresh id_token
        if (refreshTokenResponse.idToken) {
          cookie.credentials = {
            authHeaderValueExtra: true,
            refresh_token: refreshTokenResponse.refreshToken,
            expiryTime: (0, _helper.getExpirationDate)(refreshTokenResponse)
          };
          (0, _cookie_splitter.setExtraAuthStorage)(request, `Bearer ${refreshTokenResponse.idToken}`, this.getExtraAuthStorageOptions());
          return true;
        } else {
          return false;
        }
      } catch (error) {
        this.logger.error(error);
        return false;
      }
    } else {
      // no refresh token, and current token is expired
      return false;
    }
  }
  handleUnauthedRequest(request, response, toolkit) {
    if (this.isPageRequest(request)) {
      return this.redirectOIDCCapture(request, toolkit);
    } else {
      return response.unauthorized();
    }
  }
  getExtraAuthStorageValue(request, cookie) {
    var _cookie$credentials2;
    let extraValue = '';
    if (!((_cookie$credentials2 = cookie.credentials) !== null && _cookie$credentials2 !== void 0 && _cookie$credentials2.authHeaderValueExtra)) {
      return extraValue;
    }
    try {
      extraValue = (0, _cookie_splitter.getExtraAuthStorageValue)(request, this.getExtraAuthStorageOptions());
    } catch (error) {
      this.logger.info(error);
    }
    return extraValue;
  }
  buildAuthHeaderFromCookie(cookie, request) {
    var _cookie$credentials3;
    const header = {};
    if (cookie.credentials.authHeaderValueExtra) {
      try {
        const extraAuthStorageValue = this.getExtraAuthStorageValue(request, cookie);
        header.authorization = extraAuthStorageValue;
        return header;
      } catch (error) {
        this.logger.error(error);
        // TODO Re-throw?
        // throw error;
      }
    }

    const authHeaderValue = (_cookie$credentials3 = cookie.credentials) === null || _cookie$credentials3 === void 0 ? void 0 : _cookie$credentials3.authHeaderValue;
    if (authHeaderValue) {
      header.authorization = authHeaderValue;
    }
    return header;
  }
}
exports.OpenIdAuthentication = OpenIdAuthentication;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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