/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.AlgorithmFinder;
import com.password4j.Argon2Function;
import com.password4j.BadParametersException;
import com.password4j.BcryptFunction;
import com.password4j.BenchmarkResult;
import com.password4j.PBKDF2Function;
import com.password4j.SaltGenerator;
import com.password4j.ScryptFunction;
import com.password4j.Utils;
import com.password4j.types.Argon2;
import com.password4j.types.Bcrypt;
import com.password4j.types.Hmac;
import java.util.List;
import java.util.Set;

public class SystemChecker {
    private static final String TO_BE_HASHED = "abcDEF123@~# xyz+-*/=456spqr";
    private static final String SALT = Utils.fromBytesToString(SaltGenerator.generate());
    private static final int WARMUP_ROUNDS = 20;

    private SystemChecker() {
    }

    public static boolean isPBKDF2Supported(String algorithm) {
        if (algorithm == null) {
            throw new BadParametersException("Algorithm cannot be null.");
        }
        List<String> variants = AlgorithmFinder.getAllPBKDF2Variants();
        for (String variant : variants) {
            if (!algorithm.equals(variant)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMessageDigestSupported(String algorithm) {
        if (algorithm == null) {
            throw new BadParametersException("Algorithm cannot be null.");
        }
        Set<String> mds = AlgorithmFinder.getAllMessageDigests();
        for (String md : mds) {
            if (!algorithm.equals(md)) continue;
            return true;
        }
        return false;
    }

    public static BenchmarkResult<BcryptFunction> benchmarkBcrypt(long maxMilliseconds) {
        SystemChecker.warmUpBcrypt();
        long finalElapsed = -1L;
        BcryptFunction prototype = null;
        int rounds = 4;
        while (true) {
            BcryptFunction tmp = new BcryptFunction(Bcrypt.B, rounds);
            long start = System.currentTimeMillis();
            tmp.hash(TO_BE_HASHED);
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            if (elapsed > maxMilliseconds) break;
            finalElapsed = elapsed;
            prototype = tmp;
            ++rounds;
        }
        return new BenchmarkResult<BcryptFunction>(prototype, finalElapsed);
    }

    public static BenchmarkResult<Argon2Function> benchmarkForArgon2(long maxMilliseconds, int memory, int parallelism, int outputLength, Argon2 type) {
        SystemChecker.warmUpArgon2();
        long finalElapsed = -1L;
        Argon2Function prototype = null;
        int iterations = 1;
        while (true) {
            Argon2Function tmp = new Argon2Function(memory, iterations, parallelism, outputLength, type, 19);
            long start = System.currentTimeMillis();
            tmp.hash(TO_BE_HASHED);
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            if (elapsed > maxMilliseconds) break;
            finalElapsed = elapsed;
            prototype = tmp;
            ++iterations;
        }
        if (finalElapsed == -1L && memory <= 4) {
            return SystemChecker.benchmarkForArgon2(maxMilliseconds, memory / 2, parallelism, outputLength, type);
        }
        return new BenchmarkResult<Argon2Function>(prototype, finalElapsed);
    }

    public static BenchmarkResult<PBKDF2Function> benchmarkPBKDF2(long maxMilliseconds, Hmac algorithm, int length) {
        SystemChecker.warmUpPBKDF2(algorithm, length);
        long finalElapsed = -1L;
        int iterations = 150;
        PBKDF2Function prototype = null;
        while (true) {
            PBKDF2Function tmp = new PBKDF2Function(algorithm, iterations, length);
            long start = System.currentTimeMillis();
            tmp.hash(TO_BE_HASHED);
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            if (elapsed > maxMilliseconds) break;
            finalElapsed = elapsed;
            prototype = tmp;
            iterations += 150;
        }
        return new BenchmarkResult<PBKDF2Function>(prototype, finalElapsed);
    }

    public static BenchmarkResult<ScryptFunction> findWorkFactorForScrypt(long maxMilliseconds, int resources, int parallelization) {
        int workFactor = 2;
        SystemChecker.warmUpScrypt(workFactor, parallelization);
        long finalElapsed = -1L;
        ScryptFunction prototype = null;
        while (true) {
            ScryptFunction tmp = new ScryptFunction(workFactor, resources, parallelization);
            long start = System.currentTimeMillis();
            tmp.hash(TO_BE_HASHED);
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            if (elapsed > maxMilliseconds) break;
            finalElapsed = elapsed;
            prototype = tmp;
            workFactor *= 2;
        }
        return new BenchmarkResult<ScryptFunction>(prototype, finalElapsed);
    }

    public static BenchmarkResult<ScryptFunction> findResourcesForScrypt(long maxMilliseconds, int workFactor, int parallelization) {
        SystemChecker.warmUpScrypt(workFactor, parallelization);
        int resources = 1;
        long finalElapsed = -1L;
        ScryptFunction prototype = null;
        while (true) {
            ScryptFunction tmp = new ScryptFunction(workFactor, resources, parallelization);
            long start = System.currentTimeMillis();
            tmp.hash(TO_BE_HASHED);
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            if (elapsed > maxMilliseconds) break;
            finalElapsed = elapsed;
            prototype = tmp;
            ++resources;
        }
        return new BenchmarkResult<ScryptFunction>(prototype, finalElapsed);
    }

    private static void warmUpBcrypt() {
        for (int i = 0; i < 20; ++i) {
            BcryptFunction.getInstance(4).hash(TO_BE_HASHED);
        }
    }

    private static void warmUpArgon2() {
        for (int i = 0; i < 20; ++i) {
            Argon2Function.getInstance(8, 1, 1, 32, Argon2.ID).hash(TO_BE_HASHED);
        }
    }

    private static void warmUpPBKDF2(Hmac algorithm, int length) {
        for (int i = 0; i < 20; ++i) {
            PBKDF2Function.getInstance(algorithm, 1, length).hash(TO_BE_HASHED, SALT);
        }
    }

    private static void warmUpScrypt(int workFactor, int parallelization) {
        for (int i = 0; i < 20; ++i) {
            ScryptFunction.getInstance(workFactor, 1, parallelization).hash(TO_BE_HASHED);
        }
    }
}

