/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.logic;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class ProfileIdPredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    @NotEmpty
    private final String profileId;

    public ProfileIdPredicate(@Nonnull @ParameterName(name="id") @NotEmpty String id) {
        this.profileId = Constraint.isNotNull(StringSupport.trimOrNull(id), "Profile ID cannot be null or empty");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        return input != null && this.profileId.equals(input.getProfileId());
    }
}

