/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.lang3.EnumUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class ScanPolicy {
    private static final Logger LOGGER = LogManager.getLogger(ScanPolicy.class);
    private String name;
    private String statsId;
    private boolean readOnly;
    private boolean locked;
    private PluginFactory pluginFactory = new PluginFactory();
    private Plugin.AlertThreshold defaultThreshold;
    private Plugin.AttackStrength defaultStrength;
    private ZapXmlConfiguration conf;

    public ScanPolicy() {
        this.conf = new ZapXmlConfiguration();
        this.name = this.conf.getString("policy", "");
        this.pluginFactory.loadAllPlugin((Configuration)this.conf);
        this.setDefaultThreshold(Plugin.AlertThreshold.MEDIUM);
        this.setDefaultStrength(Plugin.AttackStrength.MEDIUM);
    }

    public ScanPolicy(ZapXmlConfiguration conf) throws ConfigurationException {
        this.conf = conf;
        this.name = conf.getString("policy", "");
        this.statsId = conf.getString("statsId", null);
        this.readOnly = conf.getBoolean("readonly", false);
        this.locked = conf.getBoolean("locked", false);
        if (this.statsId == null && this.name.equals(Constant.messages.getString("ascan.policymgr.default.name"))) {
            this.statsId = "default";
        }
        this.pluginFactory.setLocked(this.locked);
        this.pluginFactory.loadAllPlugin((Configuration)conf);
        this.setDefaultThreshold(this.getAlertThresholdFromConfig());
        this.setDefaultStrength(this.getAttackStrengthFromConfig());
    }

    public ScanPolicy(FileConfiguration conf) throws ConfigurationException {
        this.pluginFactory.loadAllPlugin((Configuration)conf);
        this.conf = new ZapXmlConfiguration();
        this.name = "";
        this.setDefaultThreshold(Plugin.AlertThreshold.MEDIUM);
        this.setDefaultStrength(Plugin.AttackStrength.MEDIUM);
    }

    public ScanPolicy clonePolicy() throws ConfigurationException {
        return new ScanPolicy((ZapXmlConfiguration)((Object)this.conf.clone()));
    }

    public void cloneInto(ScanPolicy policy) {
        policy.pluginFactory.loadFrom(this.pluginFactory);
        policy.defaultStrength = this.getDefaultStrength();
        policy.defaultThreshold = this.getDefaultThreshold();
        policy.statsId = this.statsId;
        policy.readOnly = this.readOnly;
        policy.locked = this.locked;
    }

    public void saveTo(Configuration conf) throws ConfigurationException {
        conf.setProperty("policy", (Object)this.getName());
        conf.setProperty("locked", (Object)this.isLocked());
        conf.setProperty("scanner.level", (Object)this.getDefaultThreshold().name());
        conf.setProperty("scanner.strength", (Object)this.getDefaultStrength().name());
        this.getPluginFactory().saveTo(conf);
    }

    public String getName() {
        return this.name;
    }

    public PluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    public Plugin.AlertThreshold getDefaultThreshold() {
        return this.defaultThreshold;
    }

    public Plugin.AttackStrength getDefaultStrength() {
        return this.defaultStrength;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefaultThreshold(Plugin.AlertThreshold defaultThreshold) {
        if (defaultThreshold == Plugin.AlertThreshold.DEFAULT) {
            throw new IllegalArgumentException("Default threshold must be one of OFF, LOW, MEDIUM, or HIGH.");
        }
        this.defaultThreshold = defaultThreshold;
        for (Plugin plugin : this.pluginFactory.getAllPlugin()) {
            plugin.setDefaultAlertThreshold(defaultThreshold);
        }
    }

    public void setDefaultStrength(Plugin.AttackStrength defaultStrength) {
        if (defaultStrength == Plugin.AttackStrength.DEFAULT) {
            throw new IllegalArgumentException("Default strength must be one of LOW, MEDIUM, HIGH, or INSANE.");
        }
        this.defaultStrength = defaultStrength;
        for (Plugin plugin : this.pluginFactory.getAllPlugin()) {
            plugin.setDefaultAttackStrength(defaultStrength);
        }
    }

    public void save() throws ConfigurationException {
        this.conf.save();
    }

    private Plugin.AlertThreshold getAlertThresholdFromConfig() {
        String alertThreshold = this.conf.getString("scanner.level", "");
        if (alertThreshold.isEmpty() || !EnumUtils.isValidEnum(Plugin.AlertThreshold.class, (String)alertThreshold) || Plugin.AlertThreshold.DEFAULT.name().equals(alertThreshold)) {
            LOGGER.warn("Found illegal value {} for alert threshold, using MEDIUM instead.", (Object)alertThreshold);
            return Plugin.AlertThreshold.MEDIUM;
        }
        return Plugin.AlertThreshold.valueOf(alertThreshold);
    }

    private Plugin.AttackStrength getAttackStrengthFromConfig() {
        String attackStrength = this.conf.getString("scanner.strength", "");
        if (attackStrength.isEmpty() || !EnumUtils.isValidEnum(Plugin.AttackStrength.class, (String)attackStrength) || Plugin.AttackStrength.DEFAULT.name().equals(attackStrength)) {
            LOGGER.warn("Found illegal value {} for attack strength, using MEDIUM instead.", (Object)attackStrength);
            return Plugin.AttackStrength.MEDIUM;
        }
        return Plugin.AttackStrength.valueOf(attackStrength);
    }

    public String getStatsId() {
        return this.statsId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.pluginFactory.setLocked(locked);
    }
}

