// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanCookiebannersMetrics_h
#define mozilla_GleanCookiebannersMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace cookie_banners {
  /**
   * generated from cookie.banners.google_gdpr_choice_cookie
   * Records the GDPR choice on Google Search based on the "SOCS" cookie of the Google Search domains. The value could be "Accept", "Reject" or "Custom". We use the label to record different choices on different Google domains. We only collect this if the default search engine is Google.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> google_gdpr_choice_cookie(4630);

  /**
   * generated from cookie.banners.google_gdpr_choice_cookie_event
   */
  struct GoogleGdprChoiceCookieEventExtra {
    mozilla::Maybe<nsCString> choice;
    mozilla::Maybe<nsCString> region;
    mozilla::Maybe<nsCString> searchDomain;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (choice) {
        extraKeys.AppendElement()->AssignASCII("choice");
        extraValues.EmplaceBack(choice.value());
      }
      if (region) {
        extraKeys.AppendElement()->AssignASCII("region");
        extraValues.EmplaceBack(region.value());
      }
      if (searchDomain) {
        extraKeys.AppendElement()->AssignASCII("search_domain");
        extraValues.EmplaceBack(searchDomain.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded whenever a GDPR choice is made on a Google Search page. We assess the "SOCS" cookie to know the GDPR choice.
   */
  constexpr impl::EventMetric<GoogleGdprChoiceCookieEventExtra> google_gdpr_choice_cookie_event(4631);

  /**
   * generated from cookie.banners.google_gdpr_choice_cookie_event_pbm
   */
  struct GoogleGdprChoiceCookieEventPbmExtra {
    mozilla::Maybe<nsCString> choice;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (choice) {
        extraKeys.AppendElement()->AssignASCII("choice");
        extraValues.EmplaceBack(choice.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded whenever a GDPR choice is made on a Google Search page on private browsing windows. We assess the "SOCS" cookie to know the GDPR choice.
   */
  constexpr impl::EventMetric<GoogleGdprChoiceCookieEventPbmExtra> google_gdpr_choice_cookie_event_pbm(4632);

  /**
   * generated from cookie.banners.normal_window_service_mode
   */
  enum class NormalWindowServiceModeLabel: uint16_t {
    eDisabled = 0,
    eReject = 1,
    eRejectOrAccept = 2,
    eInvalid = 3,
    e__Other__,
  };
  /**
   * The pref value of the cookie banner service mode for normal windows.
   */
  constexpr impl::Labeled<impl::BooleanMetric, NormalWindowServiceModeLabel> normal_window_service_mode(4633);

  /**
   * generated from cookie.banners.private_window_service_mode
   */
  enum class PrivateWindowServiceModeLabel: uint16_t {
    eDisabled = 0,
    eReject = 1,
    eRejectOrAccept = 2,
    eInvalid = 3,
    e__Other__,
  };
  /**
   * The pref value of the cookie banner service mode for private windows.
   */
  constexpr impl::Labeled<impl::BooleanMetric, PrivateWindowServiceModeLabel> private_window_service_mode(4634);

  /**
   * generated from cookie.banners.service_detect_only
   * Tracks the value of the cookiebanners.service.detectOnly pref.
   */
  constexpr impl::BooleanMetric service_detect_only(4635);
}

} // namespace mozilla::glean

#endif // mozilla_GleanCookiebannersMetrics_h
