//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/gmp/PChromiumCDMChild.h"
#include "ChromiumCDMParent.h"
#include "GMPMessageUtils.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/gmp/PGMPContentChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace gmp {


MOZ_IMPLICIT PChromiumCDMChild::PChromiumCDMChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PChromiumCDMChild);
}

PChromiumCDMChild::~PChromiumCDMChild()
{
    MOZ_COUNT_DTOR(PChromiumCDMChild);
}

auto PChromiumCDMChild::ActorAlloc() -> void
{
    AddRef();
}

auto PChromiumCDMChild::ActorDealloc() -> void
{
    Release();
}

auto PChromiumCDMChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PChromiumCDMChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PChromiumCDMChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PChromiumCDMChild::Manager() const -> PGMPContentChild*
{
    return static_cast<PGMPContentChild*>(IProtocol::Manager());
}

auto PChromiumCDMChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PChromiumCDMChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PChromiumCDMChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PChromiumCDMChild::Send__delete__(PChromiumCDMChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PChromiumCDMChild::SendOnResolvePromiseWithKeyStatus(
        const uint32_t& aPromiseId,
        const uint32_t& aKeyStatus) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_OnResolvePromiseWithKeyStatus(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aKeyStatus);
    // Sentinel = 'aKeyStatus'
    ((&(writer__)))->WriteSentinel(358679567);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnResolvePromiseWithKeyStatus", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendOnResolveNewSessionPromise(
        const uint32_t& aPromiseId,
        const nsACString& aSessionId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_OnResolveNewSessionPromise(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aSessionId);
    // Sentinel = 'aSessionId'
    ((&(writer__)))->WriteSentinel(365364211);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnResolveNewSessionPromise", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendOnResolvePromise(const uint32_t& aPromiseId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_OnResolvePromise(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnResolvePromise", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendOnRejectPromise(
        const uint32_t& aPromiseId,
        const uint32_t& aException,
        const uint32_t& aSystemCode,
        const nsACString& aErrorMessage) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_OnRejectPromise(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aException);
    // Sentinel = 'aException'
    ((&(writer__)))->WriteSentinel(362480657);
    IPC::WriteParam((&(writer__)), aSystemCode);
    // Sentinel = 'aSystemCode'
    ((&(writer__)))->WriteSentinel(444466274);
    IPC::WriteParam((&(writer__)), aErrorMessage);
    // Sentinel = 'aErrorMessage'
    ((&(writer__)))->WriteSentinel(601949489);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnRejectPromise", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendOnSessionMessage(
        const nsACString& aSessionId,
        const uint32_t& aMessageType,
        mozilla::Span<uint8_t const> aMessage) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_OnSessionMessage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aSessionId);
    // Sentinel = 'aSessionId'
    ((&(writer__)))->WriteSentinel(365364211);
    IPC::WriteParam((&(writer__)), aMessageType);
    // Sentinel = 'aMessageType'
    ((&(writer__)))->WriteSentinel(512099529);
    IPC::WriteParam((&(writer__)), aMessage);
    // Sentinel = 'aMessage'
    ((&(writer__)))->WriteSentinel(233440039);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnSessionMessage", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendOnSessionKeysChange(
        const nsACString& aSessionId,
        mozilla::Span<CDMKeyInformation const> aKeysInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_OnSessionKeysChange(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aSessionId);
    // Sentinel = 'aSessionId'
    ((&(writer__)))->WriteSentinel(365364211);
    IPC::WriteParam((&(writer__)), aKeysInfo);
    // Sentinel = 'aKeysInfo'
    ((&(writer__)))->WriteSentinel(290128778);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnSessionKeysChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendOnExpirationChange(
        const nsACString& aSessionId,
        const double& aSecondsSinceEpoch) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_OnExpirationChange(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aSessionId);
    // Sentinel = 'aSessionId'
    ((&(writer__)))->WriteSentinel(365364211);
    IPC::WriteParam((&(writer__)), aSecondsSinceEpoch);
    // Sentinel = 'aSecondsSinceEpoch'
    ((&(writer__)))->WriteSentinel(1121126162);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnExpirationChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendOnSessionClosed(const nsACString& aSessionId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_OnSessionClosed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aSessionId);
    // Sentinel = 'aSessionId'
    ((&(writer__)))->WriteSentinel(365364211);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnSessionClosed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendOnQueryOutputProtectionStatus() -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_OnQueryOutputProtectionStatus(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnQueryOutputProtectionStatus", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendResolveLoadSessionPromise(
        const uint32_t& aPromiseId,
        const bool& aSuccessful) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_ResolveLoadSessionPromise(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aSuccessful);
    // Sentinel = 'aSuccessful'
    ((&(writer__)))->WriteSentinel(441386114);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_ResolveLoadSessionPromise", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendDecryptedShmem(
        const uint32_t& aId,
        const uint32_t& aStatus,
        Shmem&& aData) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_DecryptedShmem(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aId);
    // Sentinel = 'aId'
    ((&(writer__)))->WriteSentinel(35389711);
    IPC::WriteParam((&(writer__)), aStatus);
    // Sentinel = 'aStatus'
    ((&(writer__)))->WriteSentinel(186712806);
    IPC::WriteParam((&(writer__)), std::move(aData));
    // Sentinel = 'aData'
    ((&(writer__)))->WriteSentinel(90571228);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecryptedShmem", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendDecryptedData(
        const uint32_t& aId,
        const uint32_t& aStatus,
        mozilla::Span<uint8_t const> aData) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_DecryptedData(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aId);
    // Sentinel = 'aId'
    ((&(writer__)))->WriteSentinel(35389711);
    IPC::WriteParam((&(writer__)), aStatus);
    // Sentinel = 'aStatus'
    ((&(writer__)))->WriteSentinel(186712806);
    IPC::WriteParam((&(writer__)), aData);
    // Sentinel = 'aData'
    ((&(writer__)))->WriteSentinel(90571228);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecryptedData", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendDecryptFailed(
        const uint32_t& aId,
        const uint32_t& aStatus) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_DecryptFailed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aId);
    // Sentinel = 'aId'
    ((&(writer__)))->WriteSentinel(35389711);
    IPC::WriteParam((&(writer__)), aStatus);
    // Sentinel = 'aStatus'
    ((&(writer__)))->WriteSentinel(186712806);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecryptFailed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendOnDecoderInitDone(const uint32_t& aStatus) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_OnDecoderInitDone(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aStatus);
    // Sentinel = 'aStatus'
    ((&(writer__)))->WriteSentinel(186712806);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnDecoderInitDone", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendDecodedShmem(
        const CDMVideoFrame& aFrame,
        Shmem&& aData) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_DecodedShmem(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aFrame);
    // Sentinel = 'aFrame'
    ((&(writer__)))->WriteSentinel(131334733);
    IPC::WriteParam((&(writer__)), std::move(aData));
    // Sentinel = 'aData'
    ((&(writer__)))->WriteSentinel(90571228);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecodedShmem", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendDecodedData(
        const CDMVideoFrame& aFrame,
        mozilla::Span<uint8_t const> aData) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_DecodedData(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aFrame);
    // Sentinel = 'aFrame'
    ((&(writer__)))->WriteSentinel(131334733);
    IPC::WriteParam((&(writer__)), aData);
    // Sentinel = 'aData'
    ((&(writer__)))->WriteSentinel(90571228);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecodedData", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendDecodeFailed(const uint32_t& aStatus) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_DecodeFailed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aStatus);
    // Sentinel = 'aStatus'
    ((&(writer__)))->WriteSentinel(186712806);


    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecodeFailed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendResetVideoDecoderComplete() -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_ResetVideoDecoderComplete(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_ResetVideoDecoderComplete", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendDrainComplete() -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_DrainComplete(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DrainComplete", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendShutdown() -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_Shutdown(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Shutdown", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::SendIncreaseShmemPoolSize() -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_IncreaseShmemPoolSize(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_IncreaseShmemPoolSize", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PChromiumCDMChild::OnMessageReceived(const Message& msg__) -> PChromiumCDMChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PChromiumCDM::Msg_Init__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Init", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aAllowDistinctiveIdentifier = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aAllowDistinctiveIdentifier) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aAllowDistinctiveIdentifier = *maybe__aAllowDistinctiveIdentifier;
            // Sentinel = 'aAllowDistinctiveIdentifier'
            if ((!(((&(reader__)))->ReadSentinel(2530609898)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__aAllowPersistentState = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aAllowPersistentState) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aAllowPersistentState = *maybe__aAllowPersistentState;
            // Sentinel = 'aAllowPersistentState'
            if ((!(((&(reader__)))->ReadSentinel(1556285587)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PChromiumCDM::Reply_Init(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aSuccess'
                    ((&(writer__)))->WriteSentinel(236323643);

                    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PChromiumCDMChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvInit(std::move(aAllowDistinctiveIdentifier), std::move(aAllowPersistentState), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_GetStatusForPolicy__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_GetStatusForPolicy", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aMinHdcpVersion = IPC::ReadParam<HdcpVersion>((&(reader__)));
            if (!maybe__aMinHdcpVersion) {
                FatalError("Error deserializing 'HdcpVersion'");
                return MsgValueError;

            }
            auto& aMinHdcpVersion = *maybe__aMinHdcpVersion;
            // Sentinel = 'aMinHdcpVersion'
            if ((!(((&(reader__)))->ReadSentinel(766576107)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HdcpVersion'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvGetStatusForPolicy(std::move(aPromiseId), std::move(aMinHdcpVersion));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_SetServerCertificate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_SetServerCertificate", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aServerCert = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__aServerCert) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& aServerCert = *maybe__aServerCert;
            // Sentinel = 'aServerCert'
            if ((!(((&(reader__)))->ReadSentinel(435553383)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetServerCertificate(std::move(aPromiseId), std::move(aServerCert));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_CreateSessionAndGenerateRequest__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_CreateSessionAndGenerateRequest", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aSessionType = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aSessionType) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aSessionType = *maybe__aSessionType;
            // Sentinel = 'aSessionType'
            if ((!(((&(reader__)))->ReadSentinel(526189800)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aInitDataType = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aInitDataType) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aInitDataType = *maybe__aInitDataType;
            // Sentinel = 'aInitDataType'
            if ((!(((&(reader__)))->ReadSentinel(582092050)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aInitData = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__aInitData) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& aInitData = *maybe__aInitData;
            // Sentinel = 'aInitData'
            if ((!(((&(reader__)))->ReadSentinel(284296048)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCreateSessionAndGenerateRequest(std::move(aPromiseId), std::move(aSessionType), std::move(aInitDataType), std::move(aInitData));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_LoadSession__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_LoadSession", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aSessionType = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aSessionType) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aSessionType = *maybe__aSessionType;
            // Sentinel = 'aSessionType'
            if ((!(((&(reader__)))->ReadSentinel(526189800)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aSessionId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aSessionId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aSessionId = *maybe__aSessionId;
            // Sentinel = 'aSessionId'
            if ((!(((&(reader__)))->ReadSentinel(365364211)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvLoadSession(std::move(aPromiseId), std::move(aSessionType), std::move(aSessionId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_UpdateSession__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_UpdateSession", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aSessionId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aSessionId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aSessionId = *maybe__aSessionId;
            // Sentinel = 'aSessionId'
            if ((!(((&(reader__)))->ReadSentinel(365364211)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aResponse = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__aResponse) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& aResponse = *maybe__aResponse;
            // Sentinel = 'aResponse'
            if ((!(((&(reader__)))->ReadSentinel(301466545)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvUpdateSession(std::move(aPromiseId), std::move(aSessionId), std::move(aResponse));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_CloseSession__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_CloseSession", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aSessionId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aSessionId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aSessionId = *maybe__aSessionId;
            // Sentinel = 'aSessionId'
            if ((!(((&(reader__)))->ReadSentinel(365364211)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCloseSession(std::move(aPromiseId), std::move(aSessionId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_RemoveSession__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_RemoveSession", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aSessionId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aSessionId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aSessionId = *maybe__aSessionId;
            // Sentinel = 'aSessionId'
            if ((!(((&(reader__)))->ReadSentinel(365364211)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvRemoveSession(std::move(aPromiseId), std::move(aSessionId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_CompleteQueryOutputProtectionStatus__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_CompleteQueryOutputProtectionStatus", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSuccess = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aSuccess) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aSuccess = *maybe__aSuccess;
            // Sentinel = 'aSuccess'
            if ((!(((&(reader__)))->ReadSentinel(236323643)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__aLinkMask = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aLinkMask) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aLinkMask = *maybe__aLinkMask;
            // Sentinel = 'aLinkMask'
            if ((!(((&(reader__)))->ReadSentinel(285475708)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aProtectionMask = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aProtectionMask) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aProtectionMask = *maybe__aProtectionMask;
            // Sentinel = 'aProtectionMask'
            if ((!(((&(reader__)))->ReadSentinel(812385813)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCompleteQueryOutputProtectionStatus(std::move(aSuccess), std::move(aLinkMask), std::move(aProtectionMask));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_Decrypt__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Decrypt", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aId = *maybe__aId;
            // Sentinel = 'aId'
            if ((!(((&(reader__)))->ReadSentinel(35389711)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aBuffer = IPC::ReadParam<CDMInputBuffer>((&(reader__)));
            if (!maybe__aBuffer) {
                FatalError("Error deserializing 'CDMInputBuffer'");
                return MsgValueError;

            }
            auto& aBuffer = *maybe__aBuffer;
            // Sentinel = 'aBuffer'
            if ((!(((&(reader__)))->ReadSentinel(176751292)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CDMInputBuffer'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDecrypt(std::move(aId), std::move(aBuffer));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_InitializeVideoDecoder__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_InitializeVideoDecoder", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aConfig = IPC::ReadParam<CDMVideoDecoderConfig>((&(reader__)));
            if (!maybe__aConfig) {
                FatalError("Error deserializing 'CDMVideoDecoderConfig'");
                return MsgValueError;

            }
            auto& aConfig = *maybe__aConfig;
            // Sentinel = 'aConfig'
            if ((!(((&(reader__)))->ReadSentinel(177078968)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CDMVideoDecoderConfig'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvInitializeVideoDecoder(std::move(aConfig));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_DeinitializeVideoDecoder__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DeinitializeVideoDecoder", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeinitializeVideoDecoder();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_ResetVideoDecoder__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_ResetVideoDecoder", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvResetVideoDecoder();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_DecryptAndDecodeFrame__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecryptAndDecodeFrame", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aBuffer = IPC::ReadParam<CDMInputBuffer>((&(reader__)));
            if (!maybe__aBuffer) {
                FatalError("Error deserializing 'CDMInputBuffer'");
                return MsgValueError;

            }
            auto& aBuffer = *maybe__aBuffer;
            // Sentinel = 'aBuffer'
            if ((!(((&(reader__)))->ReadSentinel(176751292)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CDMInputBuffer'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDecryptAndDecodeFrame(std::move(aBuffer));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_Drain__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Drain", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDrain();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_Destroy__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Destroy", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDestroy();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_GiveBuffer__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_GiveBuffer", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aShmem = IPC::ReadParam<Shmem>((&(reader__)));
            if (!maybe__aShmem) {
                FatalError("Error deserializing 'Shmem'");
                return MsgValueError;

            }
            auto& aShmem = *maybe__aShmem;
            // Sentinel = 'aShmem'
            if ((!(((&(reader__)))->ReadSentinel(134808156)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Shmem'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvGiveBuffer(std::move(aShmem));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_PurgeShmems__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_PurgeShmems", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvPurgeShmems();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PChromiumCDMChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PChromiumCDMChild::Result
{
    return MsgNotKnown;
}



} // namespace gmp
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::gmp::PChromiumCDMChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PChromiumCDM'
    (aWriter)->WriteSentinel(490931305);
}

auto ParamTraits<::mozilla::gmp::PChromiumCDMChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PChromiumCDM actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PChromiumCDM'
    if ((!((aReader)->ReadSentinel(490931305)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PChromiumCDM actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PChromiumCDMMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PChromiumCDM)");

        return {};
    }
    return static_cast<::mozilla::gmp::PChromiumCDMChild*>(actor);
}

} // namespace IPC
