struct cs_clip_box_shadow_TEXTURE_2D_common {
struct Samplers {
 sampler2D_impl sColor0_impl;
 int sColor0_slot;
 sampler2D_impl sGpuCache_impl;
 int sGpuCache_slot;
 sampler2D_impl sRenderTasks_impl;
 int sRenderTasks_slot;
 sampler2D_impl sTransformPalette_impl;
 int sTransformPalette_slot;
 bool set_slot(int index, int value) {
  switch (index) {
  case 5:
   sColor0_slot = value;
   return true;
  case 2:
   sGpuCache_slot = value;
   return true;
  case 1:
   sRenderTasks_slot = value;
   return true;
  case 3:
   sTransformPalette_slot = value;
   return true;
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aClipDeviceArea = NULL_ATTRIB;
 int aClipOrigins = NULL_ATTRIB;
 int aDevicePixelScale = NULL_ATTRIB;
 int aTransformIds = NULL_ATTRIB;
 int aClipDataResourceAddress = NULL_ATTRIB;
 int aClipSrcRectSize = NULL_ATTRIB;
 int aClipMode = NULL_ATTRIB;
 int aStretchMode = NULL_ATTRIB;
 int aClipDestRect = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aClipDeviceArea", name) == 0) { aClipDeviceArea = index; return; }
  if (strcmp("aClipOrigins", name) == 0) { aClipOrigins = index; return; }
  if (strcmp("aDevicePixelScale", name) == 0) { aDevicePixelScale = index; return; }
  if (strcmp("aTransformIds", name) == 0) { aTransformIds = index; return; }
  if (strcmp("aClipDataResourceAddress", name) == 0) { aClipDataResourceAddress = index; return; }
  if (strcmp("aClipSrcRectSize", name) == 0) { aClipSrcRectSize = index; return; }
  if (strcmp("aClipMode", name) == 0) { aClipMode = index; return; }
  if (strcmp("aStretchMode", name) == 0) { aStretchMode = index; return; }
  if (strcmp("aClipDestRect", name) == 0) { aClipDestRect = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aClipDeviceArea", name) == 0) { return aClipDeviceArea != NULL_ATTRIB ? aClipDeviceArea : -1; }
  if (strcmp("aClipOrigins", name) == 0) { return aClipOrigins != NULL_ATTRIB ? aClipOrigins : -1; }
  if (strcmp("aDevicePixelScale", name) == 0) { return aDevicePixelScale != NULL_ATTRIB ? aDevicePixelScale : -1; }
  if (strcmp("aTransformIds", name) == 0) { return aTransformIds != NULL_ATTRIB ? aTransformIds : -1; }
  if (strcmp("aClipDataResourceAddress", name) == 0) { return aClipDataResourceAddress != NULL_ATTRIB ? aClipDataResourceAddress : -1; }
  if (strcmp("aClipSrcRectSize", name) == 0) { return aClipSrcRectSize != NULL_ATTRIB ? aClipSrcRectSize : -1; }
  if (strcmp("aClipMode", name) == 0) { return aClipMode != NULL_ATTRIB ? aClipMode : -1; }
  if (strcmp("aStretchMode", name) == 0) { return aStretchMode != NULL_ATTRIB ? aStretchMode : -1; }
  if (strcmp("aClipDestRect", name) == 0) { return aClipDestRect != NULL_ATTRIB ? aClipDestRect : -1; }
  return -1;
 }
} attrib_locations;
vec4_scalar vTransformBounds;
vec4_scalar vUvBounds;
vec4_scalar vEdge;
vec4_scalar vUvBounds_NoClamp;
vec2_scalar vClipMode;
sampler2D sColor0;
sampler2D sGpuCache;
sampler2D sRenderTasks;
sampler2D sTransformPalette;
mat4_scalar uTransform;
void bind_textures() {
 sColor0 = lookup_sampler(&samplers.sColor0_impl, samplers.sColor0_slot);
 sGpuCache = lookup_sampler(&samplers.sGpuCache_impl, samplers.sGpuCache_slot);
 sRenderTasks = lookup_sampler(&samplers.sRenderTasks_impl, samplers.sRenderTasks_slot);
 sTransformPalette = lookup_sampler(&samplers.sTransformPalette_impl, samplers.sTransformPalette_slot);
}
};
struct cs_clip_box_shadow_TEXTURE_2D_vert : VertexShaderImpl, cs_clip_box_shadow_TEXTURE_2D_common {
private:
typedef cs_clip_box_shadow_TEXTURE_2D_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// sampler2D sRenderTasks;
struct RenderTaskData_scalar {
RectWithEndpoint_scalar task_rect;
vec4_scalar user_data;
RenderTaskData_scalar() = default;
RenderTaskData_scalar(RectWithEndpoint_scalar task_rect, vec4_scalar user_data) : task_rect(task_rect), user_data(user_data){}
};
struct RenderTaskData {
RectWithEndpoint task_rect;
vec4 user_data;
RenderTaskData() = default;
RenderTaskData(RectWithEndpoint task_rect, vec4 user_data) : task_rect(task_rect), user_data(user_data){}
RenderTaskData(RectWithEndpoint_scalar task_rect, vec4_scalar user_data):task_rect(task_rect),user_data(user_data){
}
IMPLICIT RenderTaskData(RenderTaskData_scalar s):task_rect(s.task_rect),user_data(s.user_data){
}
friend RenderTaskData if_then_else(I32 c, RenderTaskData t, RenderTaskData e) { return RenderTaskData(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct PictureTask_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar content_origin;
PictureTask_scalar() = default;
PictureTask_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
};
struct PictureTask {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 content_origin;
PictureTask() = default;
PictureTask(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
PictureTask(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),content_origin(content_origin){
}
IMPLICIT PictureTask(PictureTask_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),content_origin(s.content_origin){
}
friend PictureTask if_then_else(I32 c, PictureTask t, PictureTask e) { return PictureTask(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.content_origin, e.content_origin));
}};
struct ClipArea_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar screen_origin;
ClipArea_scalar() = default;
ClipArea_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
};
struct ClipArea {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 screen_origin;
ClipArea() = default;
ClipArea(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
ClipArea(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),screen_origin(screen_origin){
}
IMPLICIT ClipArea(ClipArea_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),screen_origin(s.screen_origin){
}
friend ClipArea if_then_else(I32 c, ClipArea t, ClipArea e) { return ClipArea(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.screen_origin, e.screen_origin));
}};
// sampler2D sGpuCache;
struct ImageSource_scalar {
RectWithEndpoint_scalar uv_rect;
vec4_scalar user_data;
ImageSource_scalar() = default;
ImageSource_scalar(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data) : uv_rect(uv_rect), user_data(user_data){}
};
struct ImageSource {
RectWithEndpoint uv_rect;
vec4 user_data;
ImageSource() = default;
ImageSource(RectWithEndpoint uv_rect, vec4 user_data) : uv_rect(uv_rect), user_data(user_data){}
ImageSource(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data):uv_rect(uv_rect),user_data(user_data){
}
IMPLICIT ImageSource(ImageSource_scalar s):uv_rect(s.uv_rect),user_data(s.user_data){
}
friend ImageSource if_then_else(I32 c, ImageSource t, ImageSource e) { return ImageSource(
if_then_else(c, t.uv_rect, e.uv_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct ImageSourceExtra_scalar {
vec4_scalar st_tl;
vec4_scalar st_tr;
vec4_scalar st_bl;
vec4_scalar st_br;
ImageSourceExtra_scalar() = default;
ImageSourceExtra_scalar(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
};
struct ImageSourceExtra {
vec4 st_tl;
vec4 st_tr;
vec4 st_bl;
vec4 st_br;
ImageSourceExtra() = default;
ImageSourceExtra(vec4 st_tl, vec4 st_tr, vec4 st_bl, vec4 st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
ImageSourceExtra(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br):st_tl(st_tl),st_tr(st_tr),st_bl(st_bl),st_br(st_br){
}
IMPLICIT ImageSourceExtra(ImageSourceExtra_scalar s):st_tl(s.st_tl),st_tr(s.st_tr),st_bl(s.st_bl),st_br(s.st_br){
}
friend ImageSourceExtra if_then_else(I32 c, ImageSourceExtra t, ImageSourceExtra e) { return ImageSourceExtra(
if_then_else(c, t.st_tl, e.st_tl), if_then_else(c, t.st_tr, e.st_tr), if_then_else(c, t.st_bl, e.st_bl), if_then_else(c, t.st_br, e.st_br));
}};
// vec4_scalar vTransformBounds;
// sampler2D sTransformPalette;
struct Transform_scalar {
mat4_scalar m;
mat4_scalar inv_m;
bool is_axis_aligned;
Transform_scalar() = default;
Transform_scalar(mat4_scalar m, mat4_scalar inv_m, bool is_axis_aligned) : m(m), inv_m(inv_m), is_axis_aligned(is_axis_aligned){}
};
struct Transform {
mat4 m;
mat4 inv_m;
Bool is_axis_aligned;
Transform() = default;
Transform(mat4 m, mat4 inv_m, Bool is_axis_aligned) : m(m), inv_m(inv_m), is_axis_aligned(is_axis_aligned){}
Transform(mat4_scalar m, mat4_scalar inv_m, bool is_axis_aligned):m(m),inv_m(inv_m),is_axis_aligned(is_axis_aligned){
}
IMPLICIT Transform(Transform_scalar s):m(s.m),inv_m(s.inv_m),is_axis_aligned(s.is_axis_aligned){
}
friend Transform if_then_else(I32 c, Transform t, Transform e) { return Transform(
if_then_else(c, t.m, e.m), if_then_else(c, t.inv_m, e.inv_m), if_then_else(c, t.is_axis_aligned, e.is_axis_aligned));
}};
vec4_scalar aClipDeviceArea;
vec4_scalar aClipOrigins;
float aDevicePixelScale;
ivec2_scalar aTransformIds;
struct ClipMaskInstanceCommon_scalar {
RectWithEndpoint_scalar sub_rect;
vec2_scalar task_origin;
vec2_scalar screen_origin;
float device_pixel_scale;
int32_t clip_transform_id;
int32_t prim_transform_id;
ClipMaskInstanceCommon_scalar() = default;
ClipMaskInstanceCommon_scalar(RectWithEndpoint_scalar sub_rect, vec2_scalar task_origin, vec2_scalar screen_origin, float device_pixel_scale, int32_t clip_transform_id, int32_t prim_transform_id) : sub_rect(sub_rect), task_origin(task_origin), screen_origin(screen_origin), device_pixel_scale(device_pixel_scale), clip_transform_id(clip_transform_id), prim_transform_id(prim_transform_id){}
};
struct ClipMaskInstanceCommon {
RectWithEndpoint sub_rect;
vec2 task_origin;
vec2 screen_origin;
Float device_pixel_scale;
I32 clip_transform_id;
I32 prim_transform_id;
ClipMaskInstanceCommon() = default;
ClipMaskInstanceCommon(RectWithEndpoint sub_rect, vec2 task_origin, vec2 screen_origin, Float device_pixel_scale, I32 clip_transform_id, I32 prim_transform_id) : sub_rect(sub_rect), task_origin(task_origin), screen_origin(screen_origin), device_pixel_scale(device_pixel_scale), clip_transform_id(clip_transform_id), prim_transform_id(prim_transform_id){}
ClipMaskInstanceCommon(RectWithEndpoint_scalar sub_rect, vec2_scalar task_origin, vec2_scalar screen_origin, float device_pixel_scale, int32_t clip_transform_id, int32_t prim_transform_id):sub_rect(sub_rect),task_origin(task_origin),screen_origin(screen_origin),device_pixel_scale(device_pixel_scale),clip_transform_id(clip_transform_id),prim_transform_id(prim_transform_id){
}
IMPLICIT ClipMaskInstanceCommon(ClipMaskInstanceCommon_scalar s):sub_rect(s.sub_rect),task_origin(s.task_origin),screen_origin(s.screen_origin),device_pixel_scale(s.device_pixel_scale),clip_transform_id(s.clip_transform_id),prim_transform_id(s.prim_transform_id){
}
friend ClipMaskInstanceCommon if_then_else(I32 c, ClipMaskInstanceCommon t, ClipMaskInstanceCommon e) { return ClipMaskInstanceCommon(
if_then_else(c, t.sub_rect, e.sub_rect), if_then_else(c, t.task_origin, e.task_origin), if_then_else(c, t.screen_origin, e.screen_origin), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.clip_transform_id, e.clip_transform_id), if_then_else(c, t.prim_transform_id, e.prim_transform_id));
}};
struct ClipVertexInfo_scalar {
vec4_scalar local_pos;
RectWithEndpoint_scalar clipped_local_rect;
ClipVertexInfo_scalar() = default;
ClipVertexInfo_scalar(vec4_scalar local_pos, RectWithEndpoint_scalar clipped_local_rect) : local_pos(local_pos), clipped_local_rect(clipped_local_rect){}
};
struct ClipVertexInfo {
vec4 local_pos;
RectWithEndpoint clipped_local_rect;
ClipVertexInfo() = default;
ClipVertexInfo(vec4 local_pos, RectWithEndpoint clipped_local_rect) : local_pos(local_pos), clipped_local_rect(clipped_local_rect){}
ClipVertexInfo(vec4_scalar local_pos, RectWithEndpoint_scalar clipped_local_rect):local_pos(local_pos),clipped_local_rect(clipped_local_rect){
}
IMPLICIT ClipVertexInfo(ClipVertexInfo_scalar s):local_pos(s.local_pos),clipped_local_rect(s.clipped_local_rect){
}
friend ClipVertexInfo if_then_else(I32 c, ClipVertexInfo t, ClipVertexInfo e) { return ClipVertexInfo(
if_then_else(c, t.local_pos, e.local_pos), if_then_else(c, t.clipped_local_rect, e.clipped_local_rect));
}};
vec4 vLocalPos;
vec2 vUv;
// vec4_scalar vUvBounds;
// vec4_scalar vEdge;
// vec4_scalar vUvBounds_NoClamp;
// vec2_scalar vClipMode;
ivec2_scalar aClipDataResourceAddress;
vec2_scalar aClipSrcRectSize;
int32_t aClipMode;
ivec2_scalar aStretchMode;
vec4_scalar aClipDestRect;
struct ClipMaskInstanceBoxShadow_scalar {
ClipMaskInstanceCommon_scalar base;
ivec2_scalar resource_address;
ClipMaskInstanceBoxShadow_scalar() = default;
ClipMaskInstanceBoxShadow_scalar(ClipMaskInstanceCommon_scalar base, ivec2_scalar resource_address) : base(base), resource_address(resource_address){}
};
struct ClipMaskInstanceBoxShadow {
ClipMaskInstanceCommon base;
ivec2 resource_address;
ClipMaskInstanceBoxShadow() = default;
ClipMaskInstanceBoxShadow(ClipMaskInstanceCommon base, ivec2 resource_address) : base(base), resource_address(resource_address){}
ClipMaskInstanceBoxShadow(ClipMaskInstanceCommon_scalar base, ivec2_scalar resource_address):base(base),resource_address(resource_address){
}
IMPLICIT ClipMaskInstanceBoxShadow(ClipMaskInstanceBoxShadow_scalar s):base(s.base),resource_address(s.resource_address){
}
friend ClipMaskInstanceBoxShadow if_then_else(I32 c, ClipMaskInstanceBoxShadow t, ClipMaskInstanceBoxShadow e) { return ClipMaskInstanceBoxShadow(
if_then_else(c, t.base, e.base), if_then_else(c, t.resource_address, e.resource_address));
}};
struct BoxShadowData_scalar {
vec2_scalar src_rect_size;
int32_t clip_mode;
int32_t stretch_mode_x;
int32_t stretch_mode_y;
RectWithEndpoint_scalar dest_rect;
BoxShadowData_scalar() = default;
BoxShadowData_scalar(vec2_scalar src_rect_size, int32_t clip_mode, int32_t stretch_mode_x, int32_t stretch_mode_y, RectWithEndpoint_scalar dest_rect) : src_rect_size(src_rect_size), clip_mode(clip_mode), stretch_mode_x(stretch_mode_x), stretch_mode_y(stretch_mode_y), dest_rect(dest_rect){}
};
struct BoxShadowData {
vec2 src_rect_size;
I32 clip_mode;
I32 stretch_mode_x;
I32 stretch_mode_y;
RectWithEndpoint dest_rect;
BoxShadowData() = default;
BoxShadowData(vec2 src_rect_size, I32 clip_mode, I32 stretch_mode_x, I32 stretch_mode_y, RectWithEndpoint dest_rect) : src_rect_size(src_rect_size), clip_mode(clip_mode), stretch_mode_x(stretch_mode_x), stretch_mode_y(stretch_mode_y), dest_rect(dest_rect){}
BoxShadowData(vec2_scalar src_rect_size, int32_t clip_mode, int32_t stretch_mode_x, int32_t stretch_mode_y, RectWithEndpoint_scalar dest_rect):src_rect_size(src_rect_size),clip_mode(clip_mode),stretch_mode_x(stretch_mode_x),stretch_mode_y(stretch_mode_y),dest_rect(dest_rect){
}
IMPLICIT BoxShadowData(BoxShadowData_scalar s):src_rect_size(s.src_rect_size),clip_mode(s.clip_mode),stretch_mode_x(s.stretch_mode_x),stretch_mode_y(s.stretch_mode_y),dest_rect(s.dest_rect){
}
friend BoxShadowData if_then_else(I32 c, BoxShadowData t, BoxShadowData e) { return BoxShadowData(
if_then_else(c, t.src_rect_size, e.src_rect_size), if_then_else(c, t.clip_mode, e.clip_mode), if_then_else(c, t.stretch_mode_x, e.stretch_mode_x), if_then_else(c, t.stretch_mode_y, e.stretch_mode_y), if_then_else(c, t.dest_rect, e.dest_rect));
}};
ClipMaskInstanceCommon_scalar fetch_clip_item_common() {
 ClipMaskInstanceCommon_scalar cmi;
 (cmi).sub_rect = RectWithEndpoint_scalar((aClipDeviceArea).sel(X,Y), (aClipDeviceArea).sel(Z,W));
 (cmi).task_origin = (aClipOrigins).sel(X,Y);
 (cmi).screen_origin = (aClipOrigins).sel(Z,W);
 (cmi).device_pixel_scale = aDevicePixelScale;
 (cmi).clip_transform_id = (aTransformIds).x;
 (cmi).prim_transform_id = (aTransformIds).y;
 return cmi;
}
ClipMaskInstanceBoxShadow_scalar fetch_clip_item() {
 ClipMaskInstanceBoxShadow_scalar cmi;
 (cmi).base = fetch_clip_item_common();
 (cmi).resource_address = aClipDataResourceAddress;
 return cmi;
}
Transform_scalar fetch_transform(int32_t id) {
 Transform_scalar transform;
 (transform).is_axis_aligned = ((id)>>(23))==(0);
 int32_t index = (id)&(8388607);
 ivec2_scalar uv = make_ivec2(make_int((8u)*((make_uint(index))%((1024u)/(8u)))), make_int((make_uint(index))/((1024u)/(8u))));
 ivec2_scalar uv0 = make_ivec2(((uv).x)+(0), (uv).y);
 auto sTransformPalette_uv0_fetch = texelFetchPtr(sTransformPalette, uv0, 0, 7, 0, 0);
 (transform).m[0] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 0, 0);
 (transform).m[1] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 1, 0);
 (transform).m[2] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 2, 0);
 (transform).m[3] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 3, 0);
 (transform).inv_m[0] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 4, 0);
 (transform).inv_m[1] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 5, 0);
 (transform).inv_m[2] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 6, 0);
 (transform).inv_m[3] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 7, 0);
 return transform;
}
BoxShadowData_scalar fetch_data() {
 BoxShadowData_scalar bs_data = BoxShadowData_scalar(aClipSrcRectSize, aClipMode, (aStretchMode).x, (aStretchMode).y, RectWithEndpoint_scalar((aClipDestRect).sel(X,Y), (aClipDestRect).sel(Z,W)));
 return bs_data;
}
Array<vec4_scalar,2> fetch_from_gpu_cache_2_direct(ivec2_scalar address) {
 auto sGpuCache_address_fetch = texelFetchPtr(sGpuCache, address, 0, 1, 0, 0);
 return Array<vec4_scalar,2>{{texelFetchUnchecked(sGpuCache, sGpuCache_address_fetch, 0, 0), texelFetchUnchecked(sGpuCache, sGpuCache_address_fetch, 1, 0)}};
}
ImageSource_scalar fetch_image_source_direct(ivec2_scalar address) {
 Array<vec4_scalar,2> data = fetch_from_gpu_cache_2_direct(address);
 RectWithEndpoint_scalar uv_rect = RectWithEndpoint_scalar((data[0]).sel(X,Y), (data[0]).sel(Z,W));
 return ImageSource_scalar(uv_rect, data[1]);
}
Bool ray_plane(vec3_scalar normal, vec3_scalar pt, vec3 ray_origin, vec3_scalar ray_dir, Float& t) {
 float denom = dot(normal, ray_dir);
 if ((abs(denom))>(0.000001f)) {
  {
   vec3 d = (pt)-(ray_origin);
   t = (dot(d, normal))/(denom);
   return (t)>=(0.f);
  }
 }
 return false;
}
vec4 untransform(vec2 ref, vec3_scalar n, vec3_scalar a, mat4_scalar inv_transform) {
 vec3 p = make_vec3(ref, -(10000.f));
 vec3_scalar d = make_vec3(0, 0, 1.f);
 Float t = 0.f;
 ray_plane(n, a, p, d, t);
 Float z = ((p).z)+(((d).z)*(t));
 vec4 r = (inv_transform)*(make_vec4(ref, z, 1.f));
 return r;
}
vec4 get_node_pos(vec2 pos, Transform_scalar transform) {
 vec4_scalar ah = ((transform).m)*(make_vec4(0.f, 0.f, 0.f, 1.f));
 vec3_scalar a = ((ah).sel(X,Y,Z))/((ah).w);
 vec3_scalar n = (transpose(make_mat3((transform).inv_m)))*(make_vec3(0.f, 0.f, 1.f));
 return untransform(pos, n, a, (transform).inv_m);
}
void rectangle_aa_vertex(vec4_scalar local_bounds) {
 vTransformBounds = local_bounds;
}
ClipVertexInfo write_clip_tile_vertex(RectWithEndpoint_scalar local_clip_rect, Transform_scalar prim_transform, Transform_scalar clip_transform, RectWithEndpoint_scalar sub_rect, vec2_scalar task_origin, vec2_scalar screen_origin, float device_pixel_scale) {
 vec2 device_pos = (screen_origin)+(mix((sub_rect).p0, (sub_rect).p1, (aPosition).sel(X,Y)));
 vec2 world_pos = (device_pos)/(device_pixel_scale);
 vec4 pos = ((prim_transform).m)*(make_vec4(world_pos, 0.f, 1.f));
 (pos).lsel(X,Y,Z) /= (pos).w;
 vec4 p = get_node_pos((pos).sel(X,Y), clip_transform);
 vec4 local_pos = (p)*((pos).w);
 vec4 vertex_pos = make_vec4((task_origin)+(mix((sub_rect).p0, (sub_rect).p1, (aPosition).sel(X,Y))), 0.f, 1.f);
 gl_Position = (uTransform)*(vertex_pos);
 rectangle_aa_vertex(make_vec4((local_clip_rect).p0, (local_clip_rect).p1));
 ClipVertexInfo vi = ClipVertexInfo(local_pos, local_clip_rect);
 return vi;
}
vec2_scalar rect_size(RectWithEndpoint_scalar rect) {
 return ((rect).p1)-((rect).p0);
}
ALWAYS_INLINE void main(void) {
 ClipMaskInstanceBoxShadow_scalar cmi = fetch_clip_item();
 Transform_scalar clip_transform = fetch_transform(((cmi).base).clip_transform_id);
 Transform_scalar prim_transform = fetch_transform(((cmi).base).prim_transform_id);
 BoxShadowData_scalar bs_data = fetch_data();
 ImageSource_scalar res = fetch_image_source_direct((cmi).resource_address);
 RectWithEndpoint_scalar dest_rect = (bs_data).dest_rect;
 ClipVertexInfo vi = write_clip_tile_vertex(dest_rect, prim_transform, clip_transform, ((cmi).base).sub_rect, ((cmi).base).task_origin, ((cmi).base).screen_origin, ((cmi).base).device_pixel_scale);
 (vClipMode).x = make_float((bs_data).clip_mode);
 vec2_scalar texture_size = make_vec2(textureSize(sColor0, 0));
 vec2 local_pos = (((vi).local_pos).sel(X,Y))/(((vi).local_pos).w);
 vLocalPos = (vi).local_pos;
 vec2_scalar dest_rect_size = rect_size(dest_rect);
 switch ((bs_data).stretch_mode_x) {
  case 0:
   {
    (vEdge).x = 0.5f;
    (vEdge).z = (((dest_rect_size).x)/(((bs_data).src_rect_size).x))-(0.5f);
    (vUv).x = (((local_pos).x)-(((dest_rect).p0).x))/(((bs_data).src_rect_size).x);
    break;
   }
  case 1:
  default:
   {
    (vEdge).lsel(X,Z) = make_vec2(1.f);
    (vUv).x = (((local_pos).x)-(((dest_rect).p0).x))/((dest_rect_size).x);
    break;
   }
 }
 switch ((bs_data).stretch_mode_y) {
  case 0:
   {
    (vEdge).y = 0.5f;
    (vEdge).w = (((dest_rect_size).y)/(((bs_data).src_rect_size).y))-(0.5f);
    (vUv).y = (((local_pos).y)-(((dest_rect).p0).y))/(((bs_data).src_rect_size).y);
    break;
   }
  case 1:
  default:
   {
    (vEdge).lsel(Y,W) = make_vec2(1.f);
    (vUv).y = (((local_pos).y)-(((dest_rect).p0).y))/((dest_rect_size).y);
    break;
   }
 }
 vUv *= ((vi).local_pos).w;
 vec2_scalar uv0 = ((res).uv_rect).p0;
 vec2_scalar uv1 = ((res).uv_rect).p1;
 vUvBounds = (make_vec4((uv0)+(make_vec2(0.5f)), (uv1)-(make_vec2(0.5f))))/((texture_size).sel(X,Y,X,Y));
 vUvBounds_NoClamp = (make_vec4(uv0, uv1))/((texture_size).sel(X,Y,X,Y));
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 5:
  assert(0); // sColor0
  break;
 case 2:
  assert(0); // sGpuCache
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 3:
  assert(0); // sTransformPalette
  break;
 case 4:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 5:
  assert(0); // sColor0
  break;
 case 2:
  assert(0); // sGpuCache
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 3:
  assert(0); // sTransformPalette
  break;
 case 4:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 5:
  assert(0); // sColor0
  break;
 case 2:
  assert(0); // sGpuCache
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 3:
  assert(0); // sTransformPalette
  break;
 case 4:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_flat_attrib(self->aClipDeviceArea, attribs[self->attrib_locations.aClipDeviceArea], start, instance, count);
 load_flat_attrib(self->aClipOrigins, attribs[self->attrib_locations.aClipOrigins], start, instance, count);
 load_flat_attrib(self->aDevicePixelScale, attribs[self->attrib_locations.aDevicePixelScale], start, instance, count);
 load_flat_attrib(self->aTransformIds, attribs[self->attrib_locations.aTransformIds], start, instance, count);
 load_flat_attrib(self->aClipDataResourceAddress, attribs[self->attrib_locations.aClipDataResourceAddress], start, instance, count);
 load_flat_attrib(self->aClipSrcRectSize, attribs[self->attrib_locations.aClipSrcRectSize], start, instance, count);
 load_flat_attrib(self->aClipMode, attribs[self->attrib_locations.aClipMode], start, instance, count);
 load_flat_attrib(self->aStretchMode, attribs[self->attrib_locations.aStretchMode], start, instance, count);
 load_flat_attrib(self->aClipDestRect, attribs[self->attrib_locations.aClipDestRect], start, instance, count);
}
public:
struct InterpOutputs {
vec4_scalar vLocalPos;
vec2_scalar vUv;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->vLocalPos = get_nth(vLocalPos, n);
    dest->vUv = get_nth(vUv, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
cs_clip_box_shadow_TEXTURE_2D_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct cs_clip_box_shadow_TEXTURE_2D_frag : FragmentShaderImpl, cs_clip_box_shadow_TEXTURE_2D_vert {
private:
typedef cs_clip_box_shadow_TEXTURE_2D_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// sampler2D sGpuCache;
// vec4_scalar vTransformBounds;
vec4 vLocalPos;
vec2 vUv;
// vec4_scalar vUvBounds;
// vec4_scalar vEdge;
// vec4_scalar vUvBounds_NoClamp;
// vec2_scalar vClipMode;
Float point_inside_rect(vec2 p, vec2_scalar p0, vec2_scalar p1) {
 vec2 s = (step(p0, p))-(step(p1, p));
 return ((s).x)*((s).y);
}
Float rectangle_aa_rough_fragment(vec2 local_pos) {
 return point_inside_rect(local_pos, (vTransformBounds).sel(X,Y), (vTransformBounds).sel(Z,W));
}
ALWAYS_INLINE void main(void) {
 vec2 uv_linear = (vUv)/((vLocalPos).w);
 vec2 uv = clamp(uv_linear, make_vec2(0.f), (vEdge).sel(X,Y));
 uv += max(make_vec2(0.f), (uv_linear)-((vEdge).sel(Z,W)));
 uv = mix((vUvBounds_NoClamp).sel(X,Y), (vUvBounds_NoClamp).sel(Z,W), uv);
 uv = clamp(uv, (vUvBounds).sel(X,Y), (vUvBounds).sel(Z,W));
 Float in_shadow_rect = rectangle_aa_rough_fragment(((vLocalPos).sel(X,Y))/((vLocalPos).w));
 Float texel = (texture(sColor0, (uv).sel(X,Y))).x;
 Float alpha = mix(texel, (1.f)-(texel), (vClipMode).x);
 Float result = if_then_else(((vLocalPos).w)>(0.f), mix((vClipMode).x, alpha, in_shadow_rect), 0.f);
 oFragColor = make_vec4(result);
}
void swgl_drawSpanR8() {
 if (((swgl_interpStep(vLocalPos)).w)!=(0.f)) {
  {
   return;
  }
 }
 float w = swgl_forceScalar((vLocalPos).w);
 if ((w)<=(0.f)) {
  {
   swgl_commitSolidR8(0.f);
   return;
  }
 }
 w = (1.f)/(w);
 vec2 uv_linear = (vUv)*(w);
 vec2_scalar uv_linear0 = swgl_forceScalar(uv_linear);
 vec2_scalar uv_linear_step = ((swgl_interpStep(vUv)).sel(X,Y))*(w);
 vec2 local_pos = ((vLocalPos).sel(X,Y))*(w);
 vec2_scalar local_pos0 = swgl_forceScalar(local_pos);
 vec2_scalar local_step = ((swgl_interpStep(vLocalPos)).sel(X,Y))*(w);
 vec4_scalar clip_dist = (mix(vTransformBounds, (vTransformBounds).sel(Z,W,X,Y), (lessThan(local_step, make_vec2(0.f))).sel(X,Y,X,Y)))-((local_pos0).sel(X,Y,X,Y));
 clip_dist = mix((1000000.f)*(step(0.f, clip_dist)), (clip_dist)*((recip(local_step)).sel(X,Y,X,Y)), (notEqual(local_step, make_vec2(0.f))).sel(X,Y,X,Y));
 float shadow_start = max((clip_dist).x, (clip_dist).y);
 float shadow_end = min((clip_dist).z, (clip_dist).w);
 ivec2_scalar shadow_steps = make_ivec2(clamp((swgl_SpanLength)-((swgl_StepSize)*(make_vec2(floor(shadow_start), ceil(shadow_end)))), 0.f, swgl_SpanLength));
 int32_t shadow_start_len = (shadow_steps).x;
 int32_t shadow_end_len = (shadow_steps).y;
 vec4_scalar opaque_dist = (mix(vEdge, (vEdge).sel(Z,W,X,Y), (lessThan(uv_linear_step, make_vec2(0.f))).sel(X,Y,X,Y)))-((uv_linear0).sel(X,Y,X,Y));
 opaque_dist = mix((1000000.f)*(step(0.f, opaque_dist)), (opaque_dist)*((recip(uv_linear_step)).sel(X,Y,X,Y)), (notEqual(uv_linear_step, make_vec2(0.f))).sel(X,Y,X,Y));
 ivec4_scalar opaque_steps = make_ivec4(clamp((swgl_SpanLength)-((swgl_StepSize)*(make_vec4(floor((opaque_dist).x), floor((opaque_dist).y), floor((opaque_dist).z), floor((opaque_dist).w)))), shadow_end_len, swgl_SpanLength));
 if ((swgl_SpanLength)>(shadow_start_len)) {
  {
   int32_t num_before = (swgl_SpanLength)-(shadow_start_len);
   swgl_commitPartialSolidR8(num_before, (vClipMode).x);
   float steps_before = make_float((num_before)/(swgl_StepSize));
   uv_linear += (steps_before)*(uv_linear_step);
   local_pos += (steps_before)*(local_step);
  }
 }
 while ((swgl_SpanLength)>(0))  {
  {
   vec2 uv = clamp(uv_linear, make_vec2(0.f), (vEdge).sel(X,Y));
   uv += max(make_vec2(0.f), (uv_linear)-((vEdge).sel(Z,W)));
   uv = mix((vUvBounds_NoClamp).sel(X,Y), (vUvBounds_NoClamp).sel(Z,W), uv);
   uv = clamp(uv, (vUvBounds).sel(X,Y), (vUvBounds).sel(Z,W));
   Float in_shadow_rect = rectangle_aa_rough_fragment(local_pos);
   Float texel = (texture(sColor0, (uv).sel(X,Y))).x;
   Float alpha = mix(texel, (1.f)-(texel), (vClipMode).x);
   Float result = mix((vClipMode).x, alpha, in_shadow_rect);
   swgl_commitColorR8(result);
   uv_linear += uv_linear_step;
   local_pos += local_step;
  }
  if ((swgl_SpanLength)<=(shadow_end_len)) {
   {
    break;
   }
  }
  int32_t num_inside = ((swgl_SpanLength)-(swgl_StepSize))-(shadow_end_len);
  vec4_scalar uv_bounds = vUvBounds;
  if ((swgl_SpanLength)>=((opaque_steps).y)) {
   {
    num_inside = min(num_inside, (swgl_SpanLength)-((opaque_steps).y));
   }
  } else   if ((swgl_SpanLength)>=((opaque_steps).w)) {
   {
    num_inside = min(num_inside, (swgl_SpanLength)-((opaque_steps).w));
    (uv_bounds).lsel(Y,W) = make_vec2(clamp(mix((vUvBounds_NoClamp).y, (vUvBounds_NoClamp).w, (vEdge).y), (vUvBounds).y, (vUvBounds).w));
   }
  }
  if ((swgl_SpanLength)>=((opaque_steps).x)) {
   {
    num_inside = min(num_inside, (swgl_SpanLength)-((opaque_steps).x));
   }
  } else   if ((swgl_SpanLength)>=((opaque_steps).z)) {
   {
    num_inside = min(num_inside, (swgl_SpanLength)-((opaque_steps).z));
    (uv_bounds).lsel(X,Z) = make_vec2(clamp(mix((vUvBounds_NoClamp).x, (vUvBounds_NoClamp).z, (vEdge).x), (vUvBounds).x, (vUvBounds).z));
   }
  }
  if ((num_inside)>(0)) {
   {
    vec2 uv = clamp(uv_linear, make_vec2(0.f), (vEdge).sel(X,Y));
    uv += max(make_vec2(0.f), (uv_linear)-((vEdge).sel(Z,W)));
    uv = mix((vUvBounds_NoClamp).sel(X,Y), (vUvBounds_NoClamp).sel(Z,W), uv);
    if (((uv_bounds).sel(X,Y))==((uv_bounds).sel(Z,W))) {
     {
      uv = clamp(uv, (uv_bounds).sel(X,Y), (uv_bounds).sel(Z,W));
      Float texel = (texture(sColor0, (uv).sel(X,Y))).x;
      Float alpha = mix(texel, (1.f)-(texel), (vClipMode).x);
      swgl_commitPartialSolidR8(num_inside, alpha);
     }
    } else     if (((vClipMode).x)!=(0.f)) {
     {
      swgl_commitPartialTextureLinearInvertR8(num_inside, sColor0, uv, uv_bounds);
     }
    } else     {
     swgl_commitPartialTextureLinearR8(num_inside, sColor0, uv, uv_bounds);
    }
    float steps_inside = make_float((num_inside)/(swgl_StepSize));
    uv_linear += (steps_inside)*(uv_linear_step);
    local_pos += (steps_inside)*(local_step);
   }
  }
 }
 if ((swgl_SpanLength)>(0)) {
  {
   swgl_commitPartialSolidR8(swgl_SpanLength, (vClipMode).x);
  }
 }
}
typedef cs_clip_box_shadow_TEXTURE_2D_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec4 vLocalPos;
vec2 vUv;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->vLocalPos = init_interp(init->vLocalPos, step->vLocalPos);
  self->interp_step.vLocalPos = step->vLocalPos * 4.0f;
  self->vUv = init_interp(init->vUv, step->vUv);
  self->interp_step.vUv = step->vUv * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.vLocalPos = init_interp(init->vLocalPos, step->vLocalPos);
  self->vLocalPos = self->interp_perspective.vLocalPos * w;
  self->interp_step.vLocalPos = step->vLocalPos * 4.0f;
  self->interp_perspective.vUv = init_interp(init->vUv, step->vUv);
  self->vUv = self->interp_perspective.vUv * w;
  self->interp_step.vUv = step->vUv * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  vLocalPos += interp_step.vLocalPos * chunks;
  vUv += interp_step.vUv * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.vLocalPos += interp_step.vLocalPos * chunks;
  vLocalPos = w * interp_perspective.vLocalPos;
  interp_perspective.vUv += interp_step.vUv * chunks;
  vUv = w * interp_perspective.vUv;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
static int draw_span_R8(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl; DISPATCH_DRAW_SPAN(self, R8); }
public:
cs_clip_box_shadow_TEXTURE_2D_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 draw_span_R8_func = &draw_span_R8;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct cs_clip_box_shadow_TEXTURE_2D_program : ProgramImpl, cs_clip_box_shadow_TEXTURE_2D_frag {
int get_uniform(const char *name) const override {
 if (strcmp("sColor0", name) == 0) { return 5; }
 if (strcmp("sGpuCache", name) == 0) { return 2; }
 if (strcmp("sRenderTasks", name) == 0) { return 1; }
 if (strcmp("sTransformPalette", name) == 0) { return 3; }
 if (strcmp("uTransform", name) == 0) { return 4; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "cs_clip_box_shadow_TEXTURE_2D"; }
static ProgramImpl* loader() { return new cs_clip_box_shadow_TEXTURE_2D_program; }
};

