/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.3
 *
 * Copyright (c) 2023 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qimagereader.sip"
#include <qimagereader.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"

#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qiodevice.sip"
#include <qiodevice.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"
#line 27 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qimageiohandler.sip"
#include <qimageiohandler.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qimageiohandler.sip"
#include <qimageiohandler.h>
#line 48 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qcolor.sip"
#include <qcolor.h>
#line 51 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"
#line 36 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 54 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qimage.sip"
#include <qimage.h>
#line 57 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 60 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qsize.sip"
#include <qsize.h>
#line 63 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQImageReader.cpp"


PyDoc_STRVAR(doc_QImageReader_setFormat, "setFormat(self, format: Union[QByteArray, bytes, bytearray])");

extern "C" {static PyObject *meth_QImageReader_setFormat(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QImageReader, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            sipCpp->setFormat(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setFormat, doc_QImageReader_setFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_format, "format(self) -> QByteArray");

extern "C" {static PyObject *meth_QImageReader_format(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_format(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->format());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_format, doc_QImageReader_format);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setDevice, "setDevice(self, device: Optional[QIODevice])");

extern "C" {static PyObject *meth_QImageReader_setDevice(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setDevice(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QIODevice* a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QImageReader, &sipCpp, sipType_QIODevice, &a0))
        {
            sipCpp->setDevice(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setDevice, doc_QImageReader_setDevice);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_device, "device(self) -> Optional[QIODevice]");

extern "C" {static PyObject *meth_QImageReader_device(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_device(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QIODevice*sipRes;

            sipRes = sipCpp->device();

            return sipConvertFromType(sipRes, sipType_QIODevice, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_device, doc_QImageReader_device);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setFileName, "setFileName(self, fileName: Optional[str])");

extern "C" {static PyObject *meth_QImageReader_setFileName(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setFileName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QImageReader, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setFileName(*a0);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setFileName, doc_QImageReader_setFileName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_fileName, "fileName(self) -> str");

extern "C" {static PyObject *meth_QImageReader_fileName(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_fileName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->fileName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_fileName, doc_QImageReader_fileName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_size, "size(self) -> QSize");

extern "C" {static PyObject *meth_QImageReader_size(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QSize*sipRes;

            sipRes = new ::QSize(sipCpp->size());

            return sipConvertFromNewType(sipRes, sipType_QSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_size, doc_QImageReader_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setClipRect, "setClipRect(self, rect: QRect)");

extern "C" {static PyObject *meth_QImageReader_setClipRect(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setClipRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRect* a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QImageReader, &sipCpp, sipType_QRect, &a0))
        {
            sipCpp->setClipRect(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setClipRect, doc_QImageReader_setClipRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_clipRect, "clipRect(self) -> QRect");

extern "C" {static PyObject *meth_QImageReader_clipRect(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_clipRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QRect*sipRes;

            sipRes = new ::QRect(sipCpp->clipRect());

            return sipConvertFromNewType(sipRes, sipType_QRect, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_clipRect, doc_QImageReader_clipRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setScaledSize, "setScaledSize(self, size: QSize)");

extern "C" {static PyObject *meth_QImageReader_setScaledSize(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setScaledSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSize* a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QImageReader, &sipCpp, sipType_QSize, &a0))
        {
            sipCpp->setScaledSize(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setScaledSize, doc_QImageReader_setScaledSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_scaledSize, "scaledSize(self) -> QSize");

extern "C" {static PyObject *meth_QImageReader_scaledSize(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_scaledSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QSize*sipRes;

            sipRes = new ::QSize(sipCpp->scaledSize());

            return sipConvertFromNewType(sipRes, sipType_QSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_scaledSize, doc_QImageReader_scaledSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setScaledClipRect, "setScaledClipRect(self, rect: QRect)");

extern "C" {static PyObject *meth_QImageReader_setScaledClipRect(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setScaledClipRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRect* a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QImageReader, &sipCpp, sipType_QRect, &a0))
        {
            sipCpp->setScaledClipRect(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setScaledClipRect, doc_QImageReader_setScaledClipRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_scaledClipRect, "scaledClipRect(self) -> QRect");

extern "C" {static PyObject *meth_QImageReader_scaledClipRect(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_scaledClipRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QRect*sipRes;

            sipRes = new ::QRect(sipCpp->scaledClipRect());

            return sipConvertFromNewType(sipRes, sipType_QRect, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_scaledClipRect, doc_QImageReader_scaledClipRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_canRead, "canRead(self) -> bool");

extern "C" {static PyObject *meth_QImageReader_canRead(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_canRead(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->canRead();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_canRead, doc_QImageReader_canRead);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_read, "read(self) -> QImage\n"
"read(self, image: Optional[QImage]) -> bool");

extern "C" {static PyObject *meth_QImageReader_read(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_read(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QImage*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::QImage(sipCpp->read());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QImage, SIP_NULLPTR);
        }
    }

    {
        ::QImage* a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QImageReader, &sipCpp, sipType_QImage, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->read(a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_read, doc_QImageReader_read);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_jumpToNextImage, "jumpToNextImage(self) -> bool");

extern "C" {static PyObject *meth_QImageReader_jumpToNextImage(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_jumpToNextImage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->jumpToNextImage();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_jumpToNextImage, doc_QImageReader_jumpToNextImage);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_jumpToImage, "jumpToImage(self, imageNumber: int) -> bool");

extern "C" {static PyObject *meth_QImageReader_jumpToImage(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_jumpToImage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QImageReader, &sipCpp, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->jumpToImage(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_jumpToImage, doc_QImageReader_jumpToImage);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_loopCount, "loopCount(self) -> int");

extern "C" {static PyObject *meth_QImageReader_loopCount(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_loopCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->loopCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_loopCount, doc_QImageReader_loopCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_imageCount, "imageCount(self) -> int");

extern "C" {static PyObject *meth_QImageReader_imageCount(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_imageCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->imageCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_imageCount, doc_QImageReader_imageCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_nextImageDelay, "nextImageDelay(self) -> int");

extern "C" {static PyObject *meth_QImageReader_nextImageDelay(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_nextImageDelay(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->nextImageDelay();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_nextImageDelay, doc_QImageReader_nextImageDelay);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_currentImageNumber, "currentImageNumber(self) -> int");

extern "C" {static PyObject *meth_QImageReader_currentImageNumber(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_currentImageNumber(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->currentImageNumber();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_currentImageNumber, doc_QImageReader_currentImageNumber);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_currentImageRect, "currentImageRect(self) -> QRect");

extern "C" {static PyObject *meth_QImageReader_currentImageRect(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_currentImageRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QRect*sipRes;

            sipRes = new ::QRect(sipCpp->currentImageRect());

            return sipConvertFromNewType(sipRes, sipType_QRect, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_currentImageRect, doc_QImageReader_currentImageRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_error, "error(self) -> QImageReader.ImageReaderError");

extern "C" {static PyObject *meth_QImageReader_error(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_error(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QImageReader::ImageReaderError sipRes;

            sipRes = sipCpp->error();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QImageReader_ImageReaderError);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_error, doc_QImageReader_error);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_errorString, "errorString(self) -> str");

extern "C" {static PyObject *meth_QImageReader_errorString(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_errorString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->errorString());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_errorString, doc_QImageReader_errorString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_imageFormat, "imageFormat(fileName: Optional[str]) -> QByteArray\n"
"imageFormat(device: Optional[QIODevice]) -> QByteArray\n"
"imageFormat(self) -> QImage.Format");

extern "C" {static PyObject *meth_QImageReader_imageFormat(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_imageFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QString, &a0, &a0State))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QImageReader::imageFormat(*a0));
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        ::QIODevice* a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J8", sipType_QIODevice, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QImageReader::imageFormat(a0));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QImage::Format sipRes;

            sipRes = sipCpp->imageFormat();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QImage_Format);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_imageFormat, doc_QImageReader_imageFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_supportedImageFormats, "supportedImageFormats() -> List[QByteArray]");

extern "C" {static PyObject *meth_QImageReader_supportedImageFormats(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_supportedImageFormats(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            QList<::QByteArray>*sipRes;

            sipRes = new QList<::QByteArray>(::QImageReader::supportedImageFormats());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_supportedImageFormats, doc_QImageReader_supportedImageFormats);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_textKeys, "textKeys(self) -> List[str]");

extern "C" {static PyObject *meth_QImageReader_textKeys(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_textKeys(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(sipCpp->textKeys());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_textKeys, doc_QImageReader_textKeys);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_text, "text(self, key: Optional[str]) -> str");

extern "C" {static PyObject *meth_QImageReader_text(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_text(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QImageReader, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->text(*a0));
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_text, doc_QImageReader_text);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setBackgroundColor, "setBackgroundColor(self, color: Union[QColor, Qt.GlobalColor])");

extern "C" {static PyObject *meth_QImageReader_setBackgroundColor(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setBackgroundColor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColor* a0;
        int a0State = 0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QImageReader, &sipCpp, sipType_QColor, &a0, &a0State))
        {
            sipCpp->setBackgroundColor(*a0);
            sipReleaseType(const_cast<::QColor *>(a0), sipType_QColor, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setBackgroundColor, doc_QImageReader_setBackgroundColor);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_backgroundColor, "backgroundColor(self) -> QColor");

extern "C" {static PyObject *meth_QImageReader_backgroundColor(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_backgroundColor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QColor*sipRes;

            sipRes = new ::QColor(sipCpp->backgroundColor());

            return sipConvertFromNewType(sipRes, sipType_QColor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_backgroundColor, doc_QImageReader_backgroundColor);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_supportsAnimation, "supportsAnimation(self) -> bool");

extern "C" {static PyObject *meth_QImageReader_supportsAnimation(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_supportsAnimation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->supportsAnimation();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_supportsAnimation, doc_QImageReader_supportsAnimation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setQuality, "setQuality(self, quality: int)");

extern "C" {static PyObject *meth_QImageReader_setQuality(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setQuality(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QImageReader, &sipCpp, &a0))
        {
            sipCpp->setQuality(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setQuality, doc_QImageReader_setQuality);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_quality, "quality(self) -> int");

extern "C" {static PyObject *meth_QImageReader_quality(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_quality(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->quality();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_quality, doc_QImageReader_quality);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_supportsOption, "supportsOption(self, option: QImageIOHandler.ImageOption) -> bool");

extern "C" {static PyObject *meth_QImageReader_supportsOption(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_supportsOption(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QImageIOHandler::ImageOption a0;
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QImageReader, &sipCpp, sipType_QImageIOHandler_ImageOption, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->supportsOption(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_supportsOption, doc_QImageReader_supportsOption);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setAutoDetectImageFormat, "setAutoDetectImageFormat(self, enabled: bool)");

extern "C" {static PyObject *meth_QImageReader_setAutoDetectImageFormat(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setAutoDetectImageFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QImageReader, &sipCpp, &a0))
        {
            sipCpp->setAutoDetectImageFormat(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setAutoDetectImageFormat, doc_QImageReader_setAutoDetectImageFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_autoDetectImageFormat, "autoDetectImageFormat(self) -> bool");

extern "C" {static PyObject *meth_QImageReader_autoDetectImageFormat(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_autoDetectImageFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->autoDetectImageFormat();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_autoDetectImageFormat, doc_QImageReader_autoDetectImageFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setDecideFormatFromContent, "setDecideFormatFromContent(self, ignored: bool)");

extern "C" {static PyObject *meth_QImageReader_setDecideFormatFromContent(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setDecideFormatFromContent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QImageReader, &sipCpp, &a0))
        {
            sipCpp->setDecideFormatFromContent(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setDecideFormatFromContent, doc_QImageReader_setDecideFormatFromContent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_decideFormatFromContent, "decideFormatFromContent(self) -> bool");

extern "C" {static PyObject *meth_QImageReader_decideFormatFromContent(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_decideFormatFromContent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->decideFormatFromContent();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_decideFormatFromContent, doc_QImageReader_decideFormatFromContent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_supportedMimeTypes, "supportedMimeTypes() -> List[QByteArray]");

extern "C" {static PyObject *meth_QImageReader_supportedMimeTypes(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_supportedMimeTypes(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            QList<::QByteArray>*sipRes;

            sipRes = new QList<::QByteArray>(::QImageReader::supportedMimeTypes());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_supportedMimeTypes, doc_QImageReader_supportedMimeTypes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_subType, "subType(self) -> QByteArray");

extern "C" {static PyObject *meth_QImageReader_subType(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_subType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->subType());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_subType, doc_QImageReader_subType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_supportedSubTypes, "supportedSubTypes(self) -> List[QByteArray]");

extern "C" {static PyObject *meth_QImageReader_supportedSubTypes(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_supportedSubTypes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            QList<::QByteArray>*sipRes;

            sipRes = new QList<::QByteArray>(sipCpp->supportedSubTypes());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_supportedSubTypes, doc_QImageReader_supportedSubTypes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_transformation, "transformation(self) -> QImageIOHandler.Transformations");

extern "C" {static PyObject *meth_QImageReader_transformation(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_transformation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            ::QImageIOHandler::Transformations*sipRes;

            sipRes = new ::QImageIOHandler::Transformations(sipCpp->transformation());

            return sipConvertFromNewType(sipRes, sipType_QImageIOHandler_Transformations, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_transformation, doc_QImageReader_transformation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setAutoTransform, "setAutoTransform(self, enabled: bool)");

extern "C" {static PyObject *meth_QImageReader_setAutoTransform(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setAutoTransform(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QImageReader, &sipCpp, &a0))
        {
            sipCpp->setAutoTransform(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setAutoTransform, doc_QImageReader_setAutoTransform);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_autoTransform, "autoTransform(self) -> bool");

extern "C" {static PyObject *meth_QImageReader_autoTransform(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_autoTransform(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->autoTransform();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_autoTransform, doc_QImageReader_autoTransform);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_setGamma, "setGamma(self, gamma: float)");

extern "C" {static PyObject *meth_QImageReader_setGamma(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_setGamma(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QImageReader, &sipCpp, &a0))
        {
            sipCpp->setGamma(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_setGamma, doc_QImageReader_setGamma);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_gamma, "gamma(self) -> float");

extern "C" {static PyObject *meth_QImageReader_gamma(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_gamma(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImageReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QImageReader, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->gamma();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_gamma, doc_QImageReader_gamma);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QImageReader_imageFormatsForMimeType, "imageFormatsForMimeType(mimeType: Union[QByteArray, bytes, bytearray]) -> List[QByteArray]");

extern "C" {static PyObject *meth_QImageReader_imageFormatsForMimeType(PyObject *, PyObject *);}
static PyObject *meth_QImageReader_imageFormatsForMimeType(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QByteArray, &a0, &a0State))
        {
            QList<::QByteArray>*sipRes;

            sipRes = new QList<::QByteArray>(::QImageReader::imageFormatsForMimeType(*a0));
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QImageReader, sipName_imageFormatsForMimeType, doc_QImageReader_imageFormatsForMimeType);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QImageReader(void *, int);}
static void release_QImageReader(void *sipCppV, int)
{
    delete reinterpret_cast<::QImageReader *>(sipCppV);
}


extern "C" {static void *array_QImageReader(Py_ssize_t);}
static void *array_QImageReader(Py_ssize_t sipNrElem)
{
    return new ::QImageReader[sipNrElem];
}


extern "C" {static void array_delete_QImageReader(void *);}
static void array_delete_QImageReader(void *sipCpp)
{
    delete[] reinterpret_cast<::QImageReader *>(sipCpp);
}


extern "C" {static void dealloc_QImageReader(sipSimpleWrapper *);}
static void dealloc_QImageReader(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QImageReader(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QImageReader(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QImageReader(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QImageReader *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QImageReader();

            return sipCpp;
        }
    }

    {
        ::QIODevice* a0;
        const ::QByteArray& a1def = QByteArray();
        const ::QByteArray* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_format,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8|J1", sipType_QIODevice, &a0, sipType_QByteArray, &a1, &a1State))
        {
            sipCpp = new ::QImageReader(a0, *a1);
            sipReleaseType(const_cast<::QByteArray *>(a1), sipType_QByteArray, a1State);

            return sipCpp;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QByteArray& a1def = QByteArray();
        const ::QByteArray* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_format,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|J1", sipType_QString, &a0, &a0State, sipType_QByteArray, &a1, &a1State))
        {
            sipCpp = new ::QImageReader(*a0, *a1);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast<::QByteArray *>(a1), sipType_QByteArray, a1State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QImageReader[] = {
    {sipName_autoDetectImageFormat, meth_QImageReader_autoDetectImageFormat, METH_VARARGS, doc_QImageReader_autoDetectImageFormat},
    {sipName_autoTransform, meth_QImageReader_autoTransform, METH_VARARGS, doc_QImageReader_autoTransform},
    {sipName_backgroundColor, meth_QImageReader_backgroundColor, METH_VARARGS, doc_QImageReader_backgroundColor},
    {sipName_canRead, meth_QImageReader_canRead, METH_VARARGS, doc_QImageReader_canRead},
    {sipName_clipRect, meth_QImageReader_clipRect, METH_VARARGS, doc_QImageReader_clipRect},
    {sipName_currentImageNumber, meth_QImageReader_currentImageNumber, METH_VARARGS, doc_QImageReader_currentImageNumber},
    {sipName_currentImageRect, meth_QImageReader_currentImageRect, METH_VARARGS, doc_QImageReader_currentImageRect},
    {sipName_decideFormatFromContent, meth_QImageReader_decideFormatFromContent, METH_VARARGS, doc_QImageReader_decideFormatFromContent},
    {sipName_device, meth_QImageReader_device, METH_VARARGS, doc_QImageReader_device},
    {sipName_error, meth_QImageReader_error, METH_VARARGS, doc_QImageReader_error},
    {sipName_errorString, meth_QImageReader_errorString, METH_VARARGS, doc_QImageReader_errorString},
    {sipName_fileName, meth_QImageReader_fileName, METH_VARARGS, doc_QImageReader_fileName},
    {sipName_format, meth_QImageReader_format, METH_VARARGS, doc_QImageReader_format},
    {sipName_gamma, meth_QImageReader_gamma, METH_VARARGS, doc_QImageReader_gamma},
    {sipName_imageCount, meth_QImageReader_imageCount, METH_VARARGS, doc_QImageReader_imageCount},
    {sipName_imageFormat, meth_QImageReader_imageFormat, METH_VARARGS, doc_QImageReader_imageFormat},
    {sipName_imageFormatsForMimeType, meth_QImageReader_imageFormatsForMimeType, METH_VARARGS, doc_QImageReader_imageFormatsForMimeType},
    {sipName_jumpToImage, meth_QImageReader_jumpToImage, METH_VARARGS, doc_QImageReader_jumpToImage},
    {sipName_jumpToNextImage, meth_QImageReader_jumpToNextImage, METH_VARARGS, doc_QImageReader_jumpToNextImage},
    {sipName_loopCount, meth_QImageReader_loopCount, METH_VARARGS, doc_QImageReader_loopCount},
    {sipName_nextImageDelay, meth_QImageReader_nextImageDelay, METH_VARARGS, doc_QImageReader_nextImageDelay},
    {sipName_quality, meth_QImageReader_quality, METH_VARARGS, doc_QImageReader_quality},
    {sipName_read, meth_QImageReader_read, METH_VARARGS, doc_QImageReader_read},
    {sipName_scaledClipRect, meth_QImageReader_scaledClipRect, METH_VARARGS, doc_QImageReader_scaledClipRect},
    {sipName_scaledSize, meth_QImageReader_scaledSize, METH_VARARGS, doc_QImageReader_scaledSize},
    {sipName_setAutoDetectImageFormat, meth_QImageReader_setAutoDetectImageFormat, METH_VARARGS, doc_QImageReader_setAutoDetectImageFormat},
    {sipName_setAutoTransform, meth_QImageReader_setAutoTransform, METH_VARARGS, doc_QImageReader_setAutoTransform},
    {sipName_setBackgroundColor, meth_QImageReader_setBackgroundColor, METH_VARARGS, doc_QImageReader_setBackgroundColor},
    {sipName_setClipRect, meth_QImageReader_setClipRect, METH_VARARGS, doc_QImageReader_setClipRect},
    {sipName_setDecideFormatFromContent, meth_QImageReader_setDecideFormatFromContent, METH_VARARGS, doc_QImageReader_setDecideFormatFromContent},
    {sipName_setDevice, meth_QImageReader_setDevice, METH_VARARGS, doc_QImageReader_setDevice},
    {sipName_setFileName, meth_QImageReader_setFileName, METH_VARARGS, doc_QImageReader_setFileName},
    {sipName_setFormat, meth_QImageReader_setFormat, METH_VARARGS, doc_QImageReader_setFormat},
    {sipName_setGamma, meth_QImageReader_setGamma, METH_VARARGS, doc_QImageReader_setGamma},
    {sipName_setQuality, meth_QImageReader_setQuality, METH_VARARGS, doc_QImageReader_setQuality},
    {sipName_setScaledClipRect, meth_QImageReader_setScaledClipRect, METH_VARARGS, doc_QImageReader_setScaledClipRect},
    {sipName_setScaledSize, meth_QImageReader_setScaledSize, METH_VARARGS, doc_QImageReader_setScaledSize},
    {sipName_size, meth_QImageReader_size, METH_VARARGS, doc_QImageReader_size},
    {sipName_subType, meth_QImageReader_subType, METH_VARARGS, doc_QImageReader_subType},
    {sipName_supportedImageFormats, meth_QImageReader_supportedImageFormats, METH_VARARGS, doc_QImageReader_supportedImageFormats},
    {sipName_supportedMimeTypes, meth_QImageReader_supportedMimeTypes, METH_VARARGS, doc_QImageReader_supportedMimeTypes},
    {sipName_supportedSubTypes, meth_QImageReader_supportedSubTypes, METH_VARARGS, doc_QImageReader_supportedSubTypes},
    {sipName_supportsAnimation, meth_QImageReader_supportsAnimation, METH_VARARGS, doc_QImageReader_supportsAnimation},
    {sipName_supportsOption, meth_QImageReader_supportsOption, METH_VARARGS, doc_QImageReader_supportsOption},
    {sipName_text, meth_QImageReader_text, METH_VARARGS, doc_QImageReader_text},
    {sipName_textKeys, meth_QImageReader_textKeys, METH_VARARGS, doc_QImageReader_textKeys},
    {sipName_transformation, meth_QImageReader_transformation, METH_VARARGS, doc_QImageReader_transformation}
};

static sipEnumMemberDef enummembers_QImageReader[] = {
    {sipName_DeviceError, static_cast<int>(::QImageReader::DeviceError), 81},
    {sipName_FileNotFoundError, static_cast<int>(::QImageReader::FileNotFoundError), 81},
    {sipName_InvalidDataError, static_cast<int>(::QImageReader::InvalidDataError), 81},
    {sipName_UnknownError, static_cast<int>(::QImageReader::UnknownError), 81},
    {sipName_UnsupportedFormatError, static_cast<int>(::QImageReader::UnsupportedFormatError), 81},
};

PyDoc_STRVAR(doc_QImageReader, "\1QImageReader()\n"
"QImageReader(device: Optional[QIODevice], format: Union[QByteArray, bytes, bytearray] = QByteArray())\n"
"QImageReader(fileName: Optional[str], format: Union[QByteArray, bytes, bytearray] = QByteArray())");


static pyqt5ClassPluginDef plugin_QImageReader = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGui_QImageReader = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QImageReader,
        SIP_NULLPTR,
        &plugin_QImageReader,
    },
    {
        sipNameNr_QImageReader,
        {0, 0, 1},
        47, methods_QImageReader,
        5, enummembers_QImageReader,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QImageReader,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QImageReader,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QImageReader,
    SIP_NULLPTR,
    array_QImageReader,
    SIP_NULLPTR,
    release_QImageReader,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QImageReader,
    sizeof (::QImageReader),
};
