/* SPDX-License-Identifier: LGPL-2.1-or-later */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "sd-bus.h"
#include "sd-bus-vtable.h"
#include "sd-daemon.h"
#include "sd-device.h"
#include "sd-event.h"
#include "sd-hwdb.h"
#include "sd-id128.h"
#include "sd-journal.h"
#include "sd-json.h"
#include "sd-login.h"
#include "sd-path.h"
#include "sd-varlink.h"
#include "sd-varlink-idl.h"

/* We want to check deprecated symbols too, without complaining */
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"


struct symbol {
        const char *name;
        const void *symbol;
};
static struct symbol symbols_from_sym[] = {
        { "sd_journal_print", sd_journal_print },
        { "sd_journal_printv", sd_journal_printv },
        { "sd_journal_send", sd_journal_send },
        { "sd_journal_sendv", sd_journal_sendv },
        { "sd_journal_stream_fd", sd_journal_stream_fd },
        { "sd_journal_open", sd_journal_open },
        { "sd_journal_close", sd_journal_close },
        { "sd_journal_previous", sd_journal_previous },
        { "sd_journal_next", sd_journal_next },
        { "sd_journal_previous_skip", sd_journal_previous_skip },
        { "sd_journal_next_skip", sd_journal_next_skip },
        { "sd_journal_get_realtime_usec", sd_journal_get_realtime_usec },
        { "sd_journal_get_monotonic_usec", sd_journal_get_monotonic_usec },
        { "sd_journal_get_data", sd_journal_get_data },
        { "sd_journal_enumerate_data", sd_journal_enumerate_data },
        { "sd_journal_restart_data", sd_journal_restart_data },
        { "sd_journal_add_match", sd_journal_add_match },
        { "sd_journal_flush_matches", sd_journal_flush_matches },
        { "sd_journal_seek_head", sd_journal_seek_head },
        { "sd_journal_seek_tail", sd_journal_seek_tail },
        { "sd_journal_seek_monotonic_usec", sd_journal_seek_monotonic_usec },
        { "sd_journal_seek_realtime_usec", sd_journal_seek_realtime_usec },
        { "sd_journal_seek_cursor", sd_journal_seek_cursor },
        { "sd_journal_get_cursor", sd_journal_get_cursor },
        { "sd_journal_get_fd", sd_journal_get_fd },
        { "sd_journal_process", sd_journal_process },
        { "sd_journal_print_with_location", sd_journal_print_with_location },
        { "sd_journal_printv_with_location", sd_journal_printv_with_location },
        { "sd_journal_send_with_location", sd_journal_send_with_location },
        { "sd_journal_sendv_with_location", sd_journal_sendv_with_location },
        { "sd_journal_get_cutoff_realtime_usec", sd_journal_get_cutoff_realtime_usec },
        { "sd_journal_get_cutoff_monotonic_usec", sd_journal_get_cutoff_monotonic_usec },
        { "sd_journal_wait", sd_journal_wait },
        { "sd_journal_open_directory", sd_journal_open_directory },
        { "sd_journal_add_disjunction", sd_journal_add_disjunction },
        { "sd_journal_perror", sd_journal_perror },
        { "sd_journal_perror_with_location", sd_journal_perror_with_location },
        { "sd_journal_get_usage", sd_journal_get_usage },
        { "sd_journal_test_cursor", sd_journal_test_cursor },
        { "sd_journal_query_unique", sd_journal_query_unique },
        { "sd_journal_enumerate_unique", sd_journal_enumerate_unique },
        { "sd_journal_restart_unique", sd_journal_restart_unique },
        { "sd_journal_get_catalog", sd_journal_get_catalog },
        { "sd_journal_get_catalog_for_message_id", sd_journal_get_catalog_for_message_id },
        { "sd_journal_set_data_threshold", sd_journal_set_data_threshold },
        { "sd_journal_get_data_threshold", sd_journal_get_data_threshold },
        { "sd_journal_reliable_fd", sd_journal_reliable_fd },
        { "sd_journal_get_events", sd_journal_get_events },
        { "sd_journal_get_timeout", sd_journal_get_timeout },
        { "sd_journal_add_conjunction", sd_journal_add_conjunction },
        { "sd_journal_open_files", sd_journal_open_files },
        { "sd_journal_open_container", sd_journal_open_container },
        { "sd_booted", sd_booted },
        { "sd_is_fifo", sd_is_fifo },
        { "sd_is_mq", sd_is_mq },
        { "sd_is_socket", sd_is_socket },
        { "sd_is_socket_inet", sd_is_socket_inet },
        { "sd_is_socket_unix", sd_is_socket_unix },
        { "sd_is_special", sd_is_special },
        { "sd_listen_fds", sd_listen_fds },
        { "sd_notify", sd_notify },
        { "sd_notifyf", sd_notifyf },
        { "sd_watchdog_enabled", sd_watchdog_enabled },
        { "sd_id128_to_string", sd_id128_to_string },
        { "sd_id128_from_string", sd_id128_from_string },
        { "sd_id128_randomize", sd_id128_randomize },
        { "sd_id128_get_machine", sd_id128_get_machine },
        { "sd_id128_get_boot", sd_id128_get_boot },
        { "sd_get_seats", sd_get_seats },
        { "sd_get_sessions", sd_get_sessions },
        { "sd_get_uids", sd_get_uids },
        { "sd_login_monitor_flush", sd_login_monitor_flush },
        { "sd_login_monitor_get_fd", sd_login_monitor_get_fd },
        { "sd_login_monitor_new", sd_login_monitor_new },
        { "sd_login_monitor_unref", sd_login_monitor_unref },
        { "sd_pid_get_owner_uid", sd_pid_get_owner_uid },
        { "sd_pid_get_session", sd_pid_get_session },
        { "sd_seat_can_multi_session", sd_seat_can_multi_session },
        { "sd_seat_get_active", sd_seat_get_active },
        { "sd_seat_get_sessions", sd_seat_get_sessions },
        { "sd_session_get_seat", sd_session_get_seat },
        { "sd_session_get_uid", sd_session_get_uid },
        { "sd_session_is_active", sd_session_is_active },
        { "sd_uid_get_seats", sd_uid_get_seats },
        { "sd_uid_get_sessions", sd_uid_get_sessions },
        { "sd_uid_get_state", sd_uid_get_state },
        { "sd_uid_is_on_seat", sd_uid_is_on_seat },
        { "sd_pid_get_unit", sd_pid_get_unit },
        { "sd_session_get_service", sd_session_get_service },
        { "sd_session_get_type", sd_session_get_type },
        { "sd_session_get_class", sd_session_get_class },
        { "sd_session_get_display", sd_session_get_display },
        { "sd_session_get_state", sd_session_get_state },
        { "sd_seat_can_tty", sd_seat_can_tty },
        { "sd_seat_can_graphical", sd_seat_can_graphical },
        { "sd_session_get_tty", sd_session_get_tty },
        { "sd_login_monitor_get_events", sd_login_monitor_get_events },
        { "sd_login_monitor_get_timeout", sd_login_monitor_get_timeout },
        { "sd_pid_get_user_unit", sd_pid_get_user_unit },
        { "sd_pid_get_machine_name", sd_pid_get_machine_name },
        { "sd_get_machine_names", sd_get_machine_names },
        { "sd_pid_get_slice", sd_pid_get_slice },
        { "sd_session_get_vt", sd_session_get_vt },
        { "sd_session_is_remote", sd_session_is_remote },
        { "sd_session_get_remote_user", sd_session_get_remote_user },
        { "sd_session_get_remote_host", sd_session_get_remote_host },
        { "sd_machine_get_class", sd_machine_get_class },
        { "sd_peer_get_session", sd_peer_get_session },
        { "sd_peer_get_owner_uid", sd_peer_get_owner_uid },
        { "sd_peer_get_unit", sd_peer_get_unit },
        { "sd_peer_get_user_unit", sd_peer_get_user_unit },
        { "sd_peer_get_machine_name", sd_peer_get_machine_name },
        { "sd_peer_get_slice", sd_peer_get_slice },
        { "sd_uid_get_display", sd_uid_get_display },
        { "sd_pid_notify", sd_pid_notify },
        { "sd_pid_notifyf", sd_pid_notifyf },
        { "sd_machine_get_ifindices", sd_machine_get_ifindices },
        { "sd_session_get_desktop", sd_session_get_desktop },
        { "sd_pid_notify_with_fds", sd_pid_notify_with_fds },
        { "sd_pid_get_user_slice", sd_pid_get_user_slice },
        { "sd_peer_get_user_slice", sd_peer_get_user_slice },
        { "sd_bus_default", sd_bus_default },
        { "sd_bus_default_user", sd_bus_default_user },
        { "sd_bus_default_system", sd_bus_default_system },
        { "sd_bus_open", sd_bus_open },
        { "sd_bus_open_user", sd_bus_open_user },
        { "sd_bus_open_system", sd_bus_open_system },
        { "sd_bus_open_system_remote", sd_bus_open_system_remote },
        { "sd_bus_open_system_machine", sd_bus_open_system_machine },
        { "sd_bus_new", sd_bus_new },
        { "sd_bus_set_address", sd_bus_set_address },
        { "sd_bus_set_fd", sd_bus_set_fd },
        { "sd_bus_set_exec", sd_bus_set_exec },
        { "sd_bus_get_address", sd_bus_get_address },
        { "sd_bus_set_bus_client", sd_bus_set_bus_client },
        { "sd_bus_is_bus_client", sd_bus_is_bus_client },
        { "sd_bus_set_server", sd_bus_set_server },
        { "sd_bus_is_server", sd_bus_is_server },
        { "sd_bus_set_anonymous", sd_bus_set_anonymous },
        { "sd_bus_is_anonymous", sd_bus_is_anonymous },
        { "sd_bus_set_trusted", sd_bus_set_trusted },
        { "sd_bus_is_trusted", sd_bus_is_trusted },
        { "sd_bus_set_monitor", sd_bus_set_monitor },
        { "sd_bus_is_monitor", sd_bus_is_monitor },
        { "sd_bus_set_description", sd_bus_set_description },
        { "sd_bus_get_description", sd_bus_get_description },
        { "sd_bus_negotiate_creds", sd_bus_negotiate_creds },
        { "sd_bus_negotiate_timestamp", sd_bus_negotiate_timestamp },
        { "sd_bus_negotiate_fds", sd_bus_negotiate_fds },
        { "sd_bus_can_send", sd_bus_can_send },
        { "sd_bus_get_creds_mask", sd_bus_get_creds_mask },
        { "sd_bus_set_allow_interactive_authorization", sd_bus_set_allow_interactive_authorization },
        { "sd_bus_get_allow_interactive_authorization", sd_bus_get_allow_interactive_authorization },
        { "sd_bus_start", sd_bus_start },
        { "sd_bus_close", sd_bus_close },
        { "sd_bus_try_close", sd_bus_try_close },
        { "sd_bus_ref", sd_bus_ref },
        { "sd_bus_unref", sd_bus_unref },
        { "sd_bus_is_open", sd_bus_is_open },
        { "sd_bus_get_bus_id", sd_bus_get_bus_id },
        { "sd_bus_get_scope", sd_bus_get_scope },
        { "sd_bus_get_tid", sd_bus_get_tid },
        { "sd_bus_get_owner_creds", sd_bus_get_owner_creds },
        { "sd_bus_send", sd_bus_send },
        { "sd_bus_send_to", sd_bus_send_to },
        { "sd_bus_call", sd_bus_call },
        { "sd_bus_call_async", sd_bus_call_async },
        { "sd_bus_get_fd", sd_bus_get_fd },
        { "sd_bus_get_events", sd_bus_get_events },
        { "sd_bus_get_timeout", sd_bus_get_timeout },
        { "sd_bus_process", sd_bus_process },
        { "sd_bus_process_priority", sd_bus_process_priority },
        { "sd_bus_wait", sd_bus_wait },
        { "sd_bus_flush", sd_bus_flush },
        { "sd_bus_get_current_slot", sd_bus_get_current_slot },
        { "sd_bus_get_current_message", sd_bus_get_current_message },
        { "sd_bus_get_current_handler", sd_bus_get_current_handler },
        { "sd_bus_get_current_userdata", sd_bus_get_current_userdata },
        { "sd_bus_attach_event", sd_bus_attach_event },
        { "sd_bus_detach_event", sd_bus_detach_event },
        { "sd_bus_get_event", sd_bus_get_event },
        { "sd_bus_add_filter", sd_bus_add_filter },
        { "sd_bus_add_match", sd_bus_add_match },
        { "sd_bus_add_object", sd_bus_add_object },
        { "sd_bus_add_fallback", sd_bus_add_fallback },
        { "sd_bus_add_object_vtable", sd_bus_add_object_vtable },
        { "sd_bus_add_fallback_vtable", sd_bus_add_fallback_vtable },
        { "sd_bus_add_node_enumerator", sd_bus_add_node_enumerator },
        { "sd_bus_add_object_manager", sd_bus_add_object_manager },
        { "sd_bus_slot_ref", sd_bus_slot_ref },
        { "sd_bus_slot_unref", sd_bus_slot_unref },
        { "sd_bus_slot_get_bus", sd_bus_slot_get_bus },
        { "sd_bus_slot_get_userdata", sd_bus_slot_get_userdata },
        { "sd_bus_slot_set_userdata", sd_bus_slot_set_userdata },
        { "sd_bus_slot_get_description", sd_bus_slot_get_description },
        { "sd_bus_slot_set_description", sd_bus_slot_set_description },
        { "sd_bus_slot_get_current_message", sd_bus_slot_get_current_message },
        { "sd_bus_slot_get_current_handler", sd_bus_slot_get_current_handler },
        { "sd_bus_slot_get_current_userdata", sd_bus_slot_get_current_userdata },
        { "sd_bus_message_new_signal", sd_bus_message_new_signal },
        { "sd_bus_message_new_method_call", sd_bus_message_new_method_call },
        { "sd_bus_message_new_method_return", sd_bus_message_new_method_return },
        { "sd_bus_message_new_method_error", sd_bus_message_new_method_error },
        { "sd_bus_message_new_method_errorf", sd_bus_message_new_method_errorf },
        { "sd_bus_message_new_method_errno", sd_bus_message_new_method_errno },
        { "sd_bus_message_new_method_errnof", sd_bus_message_new_method_errnof },
        { "sd_bus_message_ref", sd_bus_message_ref },
        { "sd_bus_message_unref", sd_bus_message_unref },
        { "sd_bus_message_get_type", sd_bus_message_get_type },
        { "sd_bus_message_get_cookie", sd_bus_message_get_cookie },
        { "sd_bus_message_get_reply_cookie", sd_bus_message_get_reply_cookie },
        { "sd_bus_message_get_priority", sd_bus_message_get_priority },
        { "sd_bus_message_get_expect_reply", sd_bus_message_get_expect_reply },
        { "sd_bus_message_get_auto_start", sd_bus_message_get_auto_start },
        { "sd_bus_message_get_allow_interactive_authorization", sd_bus_message_get_allow_interactive_authorization },
        { "sd_bus_message_get_signature", sd_bus_message_get_signature },
        { "sd_bus_message_get_path", sd_bus_message_get_path },
        { "sd_bus_message_get_interface", sd_bus_message_get_interface },
        { "sd_bus_message_get_member", sd_bus_message_get_member },
        { "sd_bus_message_get_destination", sd_bus_message_get_destination },
        { "sd_bus_message_get_sender", sd_bus_message_get_sender },
        { "sd_bus_message_get_error", sd_bus_message_get_error },
        { "sd_bus_message_get_errno", sd_bus_message_get_errno },
        { "sd_bus_message_get_monotonic_usec", sd_bus_message_get_monotonic_usec },
        { "sd_bus_message_get_realtime_usec", sd_bus_message_get_realtime_usec },
        { "sd_bus_message_get_seqnum", sd_bus_message_get_seqnum },
        { "sd_bus_message_get_bus", sd_bus_message_get_bus },
        { "sd_bus_message_get_creds", sd_bus_message_get_creds },
        { "sd_bus_message_is_signal", sd_bus_message_is_signal },
        { "sd_bus_message_is_method_call", sd_bus_message_is_method_call },
        { "sd_bus_message_is_method_error", sd_bus_message_is_method_error },
        { "sd_bus_message_is_empty", sd_bus_message_is_empty },
        { "sd_bus_message_has_signature", sd_bus_message_has_signature },
        { "sd_bus_message_set_expect_reply", sd_bus_message_set_expect_reply },
        { "sd_bus_message_set_auto_start", sd_bus_message_set_auto_start },
        { "sd_bus_message_set_allow_interactive_authorization", sd_bus_message_set_allow_interactive_authorization },
        { "sd_bus_message_set_destination", sd_bus_message_set_destination },
        { "sd_bus_message_set_priority", sd_bus_message_set_priority },
        { "sd_bus_message_append", sd_bus_message_append },
        { "sd_bus_message_append_basic", sd_bus_message_append_basic },
        { "sd_bus_message_append_array", sd_bus_message_append_array },
        { "sd_bus_message_append_array_space", sd_bus_message_append_array_space },
        { "sd_bus_message_append_array_iovec", sd_bus_message_append_array_iovec },
        { "sd_bus_message_append_array_memfd", sd_bus_message_append_array_memfd },
        { "sd_bus_message_append_string_space", sd_bus_message_append_string_space },
        { "sd_bus_message_append_string_iovec", sd_bus_message_append_string_iovec },
        { "sd_bus_message_append_string_memfd", sd_bus_message_append_string_memfd },
        { "sd_bus_message_append_strv", sd_bus_message_append_strv },
        { "sd_bus_message_open_container", sd_bus_message_open_container },
        { "sd_bus_message_close_container", sd_bus_message_close_container },
        { "sd_bus_message_copy", sd_bus_message_copy },
        { "sd_bus_message_read", sd_bus_message_read },
        { "sd_bus_message_read_basic", sd_bus_message_read_basic },
        { "sd_bus_message_read_array", sd_bus_message_read_array },
        { "sd_bus_message_read_strv", sd_bus_message_read_strv },
        { "sd_bus_message_skip", sd_bus_message_skip },
        { "sd_bus_message_enter_container", sd_bus_message_enter_container },
        { "sd_bus_message_exit_container", sd_bus_message_exit_container },
        { "sd_bus_message_peek_type", sd_bus_message_peek_type },
        { "sd_bus_message_verify_type", sd_bus_message_verify_type },
        { "sd_bus_message_at_end", sd_bus_message_at_end },
        { "sd_bus_message_rewind", sd_bus_message_rewind },
        { "sd_bus_get_unique_name", sd_bus_get_unique_name },
        { "sd_bus_request_name", sd_bus_request_name },
        { "sd_bus_release_name", sd_bus_release_name },
        { "sd_bus_list_names", sd_bus_list_names },
        { "sd_bus_get_name_creds", sd_bus_get_name_creds },
        { "sd_bus_get_name_machine_id", sd_bus_get_name_machine_id },
        { "sd_bus_call_method", sd_bus_call_method },
        { "sd_bus_call_method_async", sd_bus_call_method_async },
        { "sd_bus_get_property", sd_bus_get_property },
        { "sd_bus_get_property_trivial", sd_bus_get_property_trivial },
        { "sd_bus_get_property_string", sd_bus_get_property_string },
        { "sd_bus_get_property_strv", sd_bus_get_property_strv },
        { "sd_bus_set_property", sd_bus_set_property },
        { "sd_bus_reply_method_return", sd_bus_reply_method_return },
        { "sd_bus_reply_method_error", sd_bus_reply_method_error },
        { "sd_bus_reply_method_errorf", sd_bus_reply_method_errorf },
        { "sd_bus_reply_method_errno", sd_bus_reply_method_errno },
        { "sd_bus_reply_method_errnof", sd_bus_reply_method_errnof },
        { "sd_bus_emit_signal", sd_bus_emit_signal },
        { "sd_bus_emit_properties_changed_strv", sd_bus_emit_properties_changed_strv },
        { "sd_bus_emit_properties_changed", sd_bus_emit_properties_changed },
        { "sd_bus_emit_interfaces_added_strv", sd_bus_emit_interfaces_added_strv },
        { "sd_bus_emit_interfaces_added", sd_bus_emit_interfaces_added },
        { "sd_bus_emit_interfaces_removed_strv", sd_bus_emit_interfaces_removed_strv },
        { "sd_bus_emit_interfaces_removed", sd_bus_emit_interfaces_removed },
        { "sd_bus_query_sender_creds", sd_bus_query_sender_creds },
        { "sd_bus_query_sender_privilege", sd_bus_query_sender_privilege },
        { "sd_bus_creds_new_from_pid", sd_bus_creds_new_from_pid },
        { "sd_bus_creds_ref", sd_bus_creds_ref },
        { "sd_bus_creds_unref", sd_bus_creds_unref },
        { "sd_bus_creds_get_mask", sd_bus_creds_get_mask },
        { "sd_bus_creds_get_augmented_mask", sd_bus_creds_get_augmented_mask },
        { "sd_bus_creds_get_pid", sd_bus_creds_get_pid },
        { "sd_bus_creds_get_ppid", sd_bus_creds_get_ppid },
        { "sd_bus_creds_get_tid", sd_bus_creds_get_tid },
        { "sd_bus_creds_get_uid", sd_bus_creds_get_uid },
        { "sd_bus_creds_get_euid", sd_bus_creds_get_euid },
        { "sd_bus_creds_get_suid", sd_bus_creds_get_suid },
        { "sd_bus_creds_get_fsuid", sd_bus_creds_get_fsuid },
        { "sd_bus_creds_get_gid", sd_bus_creds_get_gid },
        { "sd_bus_creds_get_egid", sd_bus_creds_get_egid },
        { "sd_bus_creds_get_sgid", sd_bus_creds_get_sgid },
        { "sd_bus_creds_get_fsgid", sd_bus_creds_get_fsgid },
        { "sd_bus_creds_get_supplementary_gids", sd_bus_creds_get_supplementary_gids },
        { "sd_bus_creds_get_comm", sd_bus_creds_get_comm },
        { "sd_bus_creds_get_tid_comm", sd_bus_creds_get_tid_comm },
        { "sd_bus_creds_get_exe", sd_bus_creds_get_exe },
        { "sd_bus_creds_get_cmdline", sd_bus_creds_get_cmdline },
        { "sd_bus_creds_get_cgroup", sd_bus_creds_get_cgroup },
        { "sd_bus_creds_get_unit", sd_bus_creds_get_unit },
        { "sd_bus_creds_get_slice", sd_bus_creds_get_slice },
        { "sd_bus_creds_get_user_unit", sd_bus_creds_get_user_unit },
        { "sd_bus_creds_get_user_slice", sd_bus_creds_get_user_slice },
        { "sd_bus_creds_get_session", sd_bus_creds_get_session },
        { "sd_bus_creds_get_owner_uid", sd_bus_creds_get_owner_uid },
        { "sd_bus_creds_has_effective_cap", sd_bus_creds_has_effective_cap },
        { "sd_bus_creds_has_permitted_cap", sd_bus_creds_has_permitted_cap },
        { "sd_bus_creds_has_inheritable_cap", sd_bus_creds_has_inheritable_cap },
        { "sd_bus_creds_has_bounding_cap", sd_bus_creds_has_bounding_cap },
        { "sd_bus_creds_get_selinux_context", sd_bus_creds_get_selinux_context },
        { "sd_bus_creds_get_audit_session_id", sd_bus_creds_get_audit_session_id },
        { "sd_bus_creds_get_audit_login_uid", sd_bus_creds_get_audit_login_uid },
        { "sd_bus_creds_get_tty", sd_bus_creds_get_tty },
        { "sd_bus_creds_get_unique_name", sd_bus_creds_get_unique_name },
        { "sd_bus_creds_get_well_known_names", sd_bus_creds_get_well_known_names },
        { "sd_bus_creds_get_description", sd_bus_creds_get_description },
        { "sd_bus_error_free", sd_bus_error_free },
        { "sd_bus_error_set", sd_bus_error_set },
        { "sd_bus_error_setf", sd_bus_error_setf },
        { "sd_bus_error_set_const", sd_bus_error_set_const },
        { "sd_bus_error_set_errno", sd_bus_error_set_errno },
        { "sd_bus_error_set_errnof", sd_bus_error_set_errnof },
        { "sd_bus_error_set_errnofv", sd_bus_error_set_errnofv },
        { "sd_bus_error_get_errno", sd_bus_error_get_errno },
        { "sd_bus_error_copy", sd_bus_error_copy },
        { "sd_bus_error_is_set", sd_bus_error_is_set },
        { "sd_bus_error_has_name", sd_bus_error_has_name },
        { "sd_bus_error_add_map", sd_bus_error_add_map },
        { "sd_bus_path_encode", sd_bus_path_encode },
        { "sd_bus_path_decode", sd_bus_path_decode },
        { "sd_bus_track_new", sd_bus_track_new },
        { "sd_bus_track_ref", sd_bus_track_ref },
        { "sd_bus_track_unref", sd_bus_track_unref },
        { "sd_bus_track_get_bus", sd_bus_track_get_bus },
        { "sd_bus_track_get_userdata", sd_bus_track_get_userdata },
        { "sd_bus_track_set_userdata", sd_bus_track_set_userdata },
        { "sd_bus_track_add_sender", sd_bus_track_add_sender },
        { "sd_bus_track_remove_sender", sd_bus_track_remove_sender },
        { "sd_bus_track_add_name", sd_bus_track_add_name },
        { "sd_bus_track_remove_name", sd_bus_track_remove_name },
        { "sd_bus_track_count", sd_bus_track_count },
        { "sd_bus_track_contains", sd_bus_track_contains },
        { "sd_bus_track_first", sd_bus_track_first },
        { "sd_bus_track_next", sd_bus_track_next },
        { "sd_event_default", sd_event_default },
        { "sd_event_new", sd_event_new },
        { "sd_event_ref", sd_event_ref },
        { "sd_event_unref", sd_event_unref },
        { "sd_event_add_io", sd_event_add_io },
        { "sd_event_add_time", sd_event_add_time },
        { "sd_event_add_signal", sd_event_add_signal },
        { "sd_event_add_child", sd_event_add_child },
        { "sd_event_add_defer", sd_event_add_defer },
        { "sd_event_add_post", sd_event_add_post },
        { "sd_event_add_exit", sd_event_add_exit },
        { "sd_event_prepare", sd_event_prepare },
        { "sd_event_wait", sd_event_wait },
        { "sd_event_dispatch", sd_event_dispatch },
        { "sd_event_run", sd_event_run },
        { "sd_event_loop", sd_event_loop },
        { "sd_event_exit", sd_event_exit },
        { "sd_event_now", sd_event_now },
        { "sd_event_get_fd", sd_event_get_fd },
        { "sd_event_get_state", sd_event_get_state },
        { "sd_event_get_tid", sd_event_get_tid },
        { "sd_event_get_exit_code", sd_event_get_exit_code },
        { "sd_event_set_watchdog", sd_event_set_watchdog },
        { "sd_event_get_watchdog", sd_event_get_watchdog },
        { "sd_event_source_ref", sd_event_source_ref },
        { "sd_event_source_unref", sd_event_source_unref },
        { "sd_event_source_get_event", sd_event_source_get_event },
        { "sd_event_source_get_userdata", sd_event_source_get_userdata },
        { "sd_event_source_set_userdata", sd_event_source_set_userdata },
        { "sd_event_source_set_description", sd_event_source_set_description },
        { "sd_event_source_get_description", sd_event_source_get_description },
        { "sd_event_source_set_prepare", sd_event_source_set_prepare },
        { "sd_event_source_get_pending", sd_event_source_get_pending },
        { "sd_event_source_get_priority", sd_event_source_get_priority },
        { "sd_event_source_set_priority", sd_event_source_set_priority },
        { "sd_event_source_get_enabled", sd_event_source_get_enabled },
        { "sd_event_source_set_enabled", sd_event_source_set_enabled },
        { "sd_event_source_get_io_fd", sd_event_source_get_io_fd },
        { "sd_event_source_set_io_fd", sd_event_source_set_io_fd },
        { "sd_event_source_get_io_events", sd_event_source_get_io_events },
        { "sd_event_source_set_io_events", sd_event_source_set_io_events },
        { "sd_event_source_get_io_revents", sd_event_source_get_io_revents },
        { "sd_event_source_get_time", sd_event_source_get_time },
        { "sd_event_source_set_time", sd_event_source_set_time },
        { "sd_event_source_set_time_accuracy", sd_event_source_set_time_accuracy },
        { "sd_event_source_get_time_accuracy", sd_event_source_get_time_accuracy },
        { "sd_event_source_get_time_clock", sd_event_source_get_time_clock },
        { "sd_event_source_get_signal", sd_event_source_get_signal },
        { "sd_event_source_get_child_pid", sd_event_source_get_child_pid },
        { "sd_bus_emit_object_added", sd_bus_emit_object_added },
        { "sd_bus_emit_object_removed", sd_bus_emit_object_removed },
        { "sd_bus_flush_close_unref", sd_bus_flush_close_unref },
        { "sd_pid_get_cgroup", sd_pid_get_cgroup },
        { "sd_peer_get_cgroup", sd_peer_get_cgroup },
        { "sd_bus_default_flush_close", sd_bus_default_flush_close },
        { "sd_bus_path_decode_many", sd_bus_path_decode_many },
        { "sd_bus_path_encode_many", sd_bus_path_encode_many },
        { "sd_listen_fds_with_names", sd_listen_fds_with_names },
        { "sd_journal_has_runtime_files", sd_journal_has_runtime_files },
        { "sd_journal_has_persistent_files", sd_journal_has_persistent_files },
        { "sd_journal_enumerate_fields", sd_journal_enumerate_fields },
        { "sd_journal_restart_fields", sd_journal_restart_fields },
        { "sd_journal_open_directory_fd", sd_journal_open_directory_fd },
        { "sd_journal_open_files_fd", sd_journal_open_files_fd },
        { "sd_event_get_iteration", sd_event_get_iteration },
        { "sd_bus_track_set_recursive", sd_bus_track_set_recursive },
        { "sd_bus_track_get_recursive", sd_bus_track_get_recursive },
        { "sd_bus_track_count_name", sd_bus_track_count_name },
        { "sd_bus_track_count_sender", sd_bus_track_count_sender },
        { "sd_bus_set_exit_on_disconnect", sd_bus_set_exit_on_disconnect },
        { "sd_bus_get_exit_on_disconnect", sd_bus_get_exit_on_disconnect },
        { "sd_id128_get_invocation", sd_id128_get_invocation },
        { "sd_id128_get_machine_app_specific", sd_id128_get_machine_app_specific },
        { "sd_is_socket_sockaddr", sd_is_socket_sockaddr },
        { "sd_bus_message_appendv", sd_bus_message_appendv },
        { "sd_bus_message_new", sd_bus_message_new },
        { "sd_bus_message_seal", sd_bus_message_seal },
        { "sd_bus_set_watch_bind", sd_bus_set_watch_bind },
        { "sd_bus_get_watch_bind", sd_bus_get_watch_bind },
        { "sd_bus_request_name_async", sd_bus_request_name_async },
        { "sd_bus_release_name_async", sd_bus_release_name_async },
        { "sd_bus_add_match_async", sd_bus_add_match_async },
        { "sd_bus_match_signal", sd_bus_match_signal },
        { "sd_bus_match_signal_async", sd_bus_match_signal_async },
        { "sd_bus_is_ready", sd_bus_is_ready },
        { "sd_bus_set_connected_signal", sd_bus_set_connected_signal },
        { "sd_bus_get_connected_signal", sd_bus_get_connected_signal },
        { "sd_bus_set_sender", sd_bus_set_sender },
        { "sd_bus_get_sender", sd_bus_get_sender },
        { "sd_bus_message_set_sender", sd_bus_message_set_sender },
        { "sd_event_source_get_io_fd_own", sd_event_source_get_io_fd_own },
        { "sd_event_source_set_io_fd_own", sd_event_source_set_io_fd_own },
        { "sd_bus_get_n_queued_read", sd_bus_get_n_queued_read },
        { "sd_bus_get_n_queued_write", sd_bus_get_n_queued_write },
        { "sd_bus_open_with_description", sd_bus_open_with_description },
        { "sd_bus_open_user_with_description", sd_bus_open_user_with_description },
        { "sd_bus_open_system_with_description", sd_bus_open_system_with_description },
        { "sd_bus_slot_get_floating", sd_bus_slot_get_floating },
        { "sd_bus_slot_set_floating", sd_bus_slot_set_floating },
        { "sd_bus_slot_get_destroy_callback", sd_bus_slot_get_destroy_callback },
        { "sd_bus_slot_set_destroy_callback", sd_bus_slot_set_destroy_callback },
        { "sd_bus_track_get_destroy_callback", sd_bus_track_get_destroy_callback },
        { "sd_bus_track_set_destroy_callback", sd_bus_track_set_destroy_callback },
        { "sd_event_add_inotify", sd_event_add_inotify },
        { "sd_event_source_get_inotify_mask", sd_event_source_get_inotify_mask },
        { "sd_event_source_set_destroy_callback", sd_event_source_set_destroy_callback },
        { "sd_event_source_get_destroy_callback", sd_event_source_get_destroy_callback },
        { "sd_bus_message_readv", sd_bus_message_readv },
        { "sd_bus_set_method_call_timeout", sd_bus_set_method_call_timeout },
        { "sd_bus_get_method_call_timeout", sd_bus_get_method_call_timeout },
        { "sd_bus_error_move", sd_bus_error_move },
        { "sd_bus_set_close_on_exit", sd_bus_set_close_on_exit },
        { "sd_bus_get_close_on_exit", sd_bus_get_close_on_exit },
        { "sd_device_ref", sd_device_ref },
        { "sd_device_unref", sd_device_unref },
        { "sd_device_new_from_syspath", sd_device_new_from_syspath },
        { "sd_device_new_from_devnum", sd_device_new_from_devnum },
        { "sd_device_new_from_subsystem_sysname", sd_device_new_from_subsystem_sysname },
        { "sd_device_new_from_device_id", sd_device_new_from_device_id },
        { "sd_device_get_parent", sd_device_get_parent },
        { "sd_device_get_parent_with_subsystem_devtype", sd_device_get_parent_with_subsystem_devtype },
        { "sd_device_get_syspath", sd_device_get_syspath },
        { "sd_device_get_subsystem", sd_device_get_subsystem },
        { "sd_device_get_devtype", sd_device_get_devtype },
        { "sd_device_get_devnum", sd_device_get_devnum },
        { "sd_device_get_ifindex", sd_device_get_ifindex },
        { "sd_device_get_driver", sd_device_get_driver },
        { "sd_device_get_devpath", sd_device_get_devpath },
        { "sd_device_get_devname", sd_device_get_devname },
        { "sd_device_get_sysname", sd_device_get_sysname },
        { "sd_device_get_sysnum", sd_device_get_sysnum },
        { "sd_device_get_is_initialized", sd_device_get_is_initialized },
        { "sd_device_get_usec_since_initialized", sd_device_get_usec_since_initialized },
        { "sd_device_get_tag_first", sd_device_get_tag_first },
        { "sd_device_get_tag_next", sd_device_get_tag_next },
        { "sd_device_get_devlink_first", sd_device_get_devlink_first },
        { "sd_device_get_devlink_next", sd_device_get_devlink_next },
        { "sd_device_get_property_first", sd_device_get_property_first },
        { "sd_device_get_property_next", sd_device_get_property_next },
        { "sd_device_get_sysattr_first", sd_device_get_sysattr_first },
        { "sd_device_get_sysattr_next", sd_device_get_sysattr_next },
        { "sd_device_has_tag", sd_device_has_tag },
        { "sd_device_get_property_value", sd_device_get_property_value },
        { "sd_device_get_sysattr_value", sd_device_get_sysattr_value },
        { "sd_device_set_sysattr_value", sd_device_set_sysattr_value },
        { "sd_device_enumerator_new", sd_device_enumerator_new },
        { "sd_device_enumerator_ref", sd_device_enumerator_ref },
        { "sd_device_enumerator_unref", sd_device_enumerator_unref },
        { "sd_device_enumerator_get_device_first", sd_device_enumerator_get_device_first },
        { "sd_device_enumerator_get_device_next", sd_device_enumerator_get_device_next },
        { "sd_device_enumerator_get_subsystem_first", sd_device_enumerator_get_subsystem_first },
        { "sd_device_enumerator_get_subsystem_next", sd_device_enumerator_get_subsystem_next },
        { "sd_device_enumerator_add_match_subsystem", sd_device_enumerator_add_match_subsystem },
        { "sd_device_enumerator_add_match_sysattr", sd_device_enumerator_add_match_sysattr },
        { "sd_device_enumerator_add_match_property", sd_device_enumerator_add_match_property },
        { "sd_device_enumerator_add_match_sysname", sd_device_enumerator_add_match_sysname },
        { "sd_device_enumerator_add_match_tag", sd_device_enumerator_add_match_tag },
        { "sd_device_enumerator_add_match_parent", sd_device_enumerator_add_match_parent },
        { "sd_device_enumerator_allow_uninitialized", sd_device_enumerator_allow_uninitialized },
        { "sd_hwdb_ref", sd_hwdb_ref },
        { "sd_hwdb_unref", sd_hwdb_unref },
        { "sd_hwdb_new", sd_hwdb_new },
        { "sd_hwdb_get", sd_hwdb_get },
        { "sd_hwdb_seek", sd_hwdb_seek },
        { "sd_hwdb_enumerate", sd_hwdb_enumerate },
        { "sd_id128_get_boot_app_specific", sd_id128_get_boot_app_specific },
        { "sd_device_monitor_new", sd_device_monitor_new },
        { "sd_device_monitor_ref", sd_device_monitor_ref },
        { "sd_device_monitor_unref", sd_device_monitor_unref },
        { "sd_device_monitor_set_receive_buffer_size", sd_device_monitor_set_receive_buffer_size },
        { "sd_device_monitor_attach_event", sd_device_monitor_attach_event },
        { "sd_device_monitor_detach_event", sd_device_monitor_detach_event },
        { "sd_device_monitor_get_event", sd_device_monitor_get_event },
        { "sd_device_monitor_get_event_source", sd_device_monitor_get_event_source },
        { "sd_device_monitor_start", sd_device_monitor_start },
        { "sd_device_monitor_stop", sd_device_monitor_stop },
        { "sd_device_monitor_filter_add_match_subsystem_devtype", sd_device_monitor_filter_add_match_subsystem_devtype },
        { "sd_device_monitor_filter_add_match_tag", sd_device_monitor_filter_add_match_tag },
        { "sd_device_monitor_filter_update", sd_device_monitor_filter_update },
        { "sd_device_monitor_filter_remove", sd_device_monitor_filter_remove },
        { "sd_event_source_get_floating", sd_event_source_get_floating },
        { "sd_event_source_set_floating", sd_event_source_set_floating },
        { "sd_bus_close_unref", sd_bus_close_unref },
        { "sd_bus_object_vtable_format", &sd_bus_object_vtable_format },
        { "sd_event_source_disable_unref", sd_event_source_disable_unref },
        { "sd_bus_enqueue_for_read", sd_bus_enqueue_for_read },
        { "sd_bus_message_dump", sd_bus_message_dump },
        { "sd_bus_message_sensitive", sd_bus_message_sensitive },
        { "sd_event_add_child_pidfd", sd_event_add_child_pidfd },
        { "sd_event_source_get_child_pidfd", sd_event_source_get_child_pidfd },
        { "sd_event_source_get_child_pidfd_own", sd_event_source_get_child_pidfd_own },
        { "sd_event_source_set_child_pidfd_own", sd_event_source_set_child_pidfd_own },
        { "sd_event_source_get_child_process_own", sd_event_source_get_child_process_own },
        { "sd_event_source_set_child_process_own", sd_event_source_set_child_process_own },
        { "sd_event_source_send_child_signal", sd_event_source_send_child_signal },
        { "sd_journal_open_namespace", sd_journal_open_namespace },
        { "sd_bus_interface_name_is_valid", sd_bus_interface_name_is_valid },
        { "sd_bus_service_name_is_valid", sd_bus_service_name_is_valid },
        { "sd_bus_member_name_is_valid", sd_bus_member_name_is_valid },
        { "sd_bus_object_path_is_valid", sd_bus_object_path_is_valid },
        { "sd_bus_call_methodv", sd_bus_call_methodv },
        { "sd_bus_call_method_asyncv", sd_bus_call_method_asyncv },
        { "sd_bus_emit_signalv", sd_bus_emit_signalv },
        { "sd_bus_reply_method_errnofv", sd_bus_reply_method_errnofv },
        { "sd_bus_reply_method_errorfv", sd_bus_reply_method_errorfv },
        { "sd_bus_reply_method_returnv", sd_bus_reply_method_returnv },
        { "sd_bus_set_propertyv", sd_bus_set_propertyv },
        { "sd_path_lookup", sd_path_lookup },
        { "sd_path_lookup_strv", sd_path_lookup_strv },
        { "sd_notify_barrier", sd_notify_barrier },
        { "sd_journal_enumerate_available_data", sd_journal_enumerate_available_data },
        { "sd_journal_enumerate_available_unique", sd_journal_enumerate_available_unique },
        { "sd_event_add_time_relative", sd_event_add_time_relative },
        { "sd_event_source_set_time_relative", sd_event_source_set_time_relative },
        { "sd_event_source_get_exit_on_failure", sd_event_source_get_exit_on_failure },
        { "sd_event_source_set_exit_on_failure", sd_event_source_set_exit_on_failure },
        { "sd_bus_error_has_names_sentinel", sd_bus_error_has_names_sentinel },
        { "sd_device_get_current_tag_first", sd_device_get_current_tag_first },
        { "sd_device_get_current_tag_next", sd_device_get_current_tag_next },
        { "sd_device_has_current_tag", sd_device_has_current_tag },
        { "sd_device_set_sysattr_valuef", sd_device_set_sysattr_valuef },
        { "sd_bus_open_user_machine", sd_bus_open_user_machine },
        { "sd_bus_message_send", sd_bus_message_send },
        { "sd_event_source_set_ratelimit", sd_event_source_set_ratelimit },
        { "sd_event_source_get_ratelimit", sd_event_source_get_ratelimit },
        { "sd_event_source_is_ratelimited", sd_event_source_is_ratelimited },
        { "sd_device_get_action", sd_device_get_action },
        { "sd_device_get_seqnum", sd_device_get_seqnum },
        { "sd_device_new_from_stat_rdev", sd_device_new_from_stat_rdev },
        { "sd_device_trigger", sd_device_trigger },
        { "sd_device_monitor_filter_add_match_sysattr", sd_device_monitor_filter_add_match_sysattr },
        { "sd_device_monitor_filter_add_match_parent", sd_device_monitor_filter_add_match_parent },
        { "sd_device_get_usec_initialized", sd_device_get_usec_initialized },
        { "sd_device_trigger_with_uuid", sd_device_trigger_with_uuid },
        { "sd_device_get_trigger_uuid", sd_device_get_trigger_uuid },
        { "sd_device_new_from_ifname", sd_device_new_from_ifname },
        { "sd_device_new_from_ifindex", sd_device_new_from_ifindex },
        { "sd_device_get_diskseq", sd_device_get_diskseq },
        { "sd_event_add_inotify_fd", sd_event_add_inotify_fd },
        { "sd_event_source_set_ratelimit_expire_callback", sd_event_source_set_ratelimit_expire_callback },
        { "sd_id128_to_uuid_string", sd_id128_to_uuid_string },
        { "sd_device_new_from_devname", sd_device_new_from_devname },
        { "sd_device_new_from_path", sd_device_new_from_path },
        { "sd_device_open", sd_device_open },
        { "sd_device_enumerator_add_nomatch_sysname", sd_device_enumerator_add_nomatch_sysname },
        { "sd_bus_message_read_strv_extend", sd_bus_message_read_strv_extend },
        { "sd_bus_error_setfv", sd_bus_error_setfv },
        { "sd_device_new_child", sd_device_new_child },
        { "sd_device_get_child_first", sd_device_get_child_first },
        { "sd_device_get_child_next", sd_device_get_child_next },
        { "sd_device_monitor_set_description", sd_device_monitor_set_description },
        { "sd_device_monitor_get_description", sd_device_monitor_get_description },
        { "sd_event_set_signal_exit", sd_event_set_signal_exit },
        { "sd_id128_string_equal", sd_id128_string_equal },
        { "sd_hwdb_new_from_path", sd_hwdb_new_from_path },
        { "sd_bus_emit_signal_to", sd_bus_emit_signal_to },
        { "sd_bus_emit_signal_tov", sd_bus_emit_signal_tov },
        { "sd_bus_message_new_signal_to", sd_bus_message_new_signal_to },
        { "sd_pidfd_get_cgroup", sd_pidfd_get_cgroup },
        { "sd_pidfd_get_machine_name", sd_pidfd_get_machine_name },
        { "sd_pidfd_get_owner_uid", sd_pidfd_get_owner_uid },
        { "sd_pidfd_get_session", sd_pidfd_get_session },
        { "sd_pidfd_get_slice", sd_pidfd_get_slice },
        { "sd_pidfd_get_unit", sd_pidfd_get_unit },
        { "sd_pidfd_get_user_slice", sd_pidfd_get_user_slice },
        { "sd_pidfd_get_user_unit", sd_pidfd_get_user_unit },
        { "sd_journal_get_seqnum", sd_journal_get_seqnum },
        { "sd_session_get_username", sd_session_get_username },
        { "sd_session_get_start_time", sd_session_get_start_time },
        { "sd_uid_get_login_time", sd_uid_get_login_time },
        { "sd_pid_notifyf_with_fds", sd_pid_notifyf_with_fds },
        { "sd_event_add_memory_pressure", sd_event_add_memory_pressure },
        { "sd_event_source_set_memory_pressure_type", sd_event_source_set_memory_pressure_type },
        { "sd_event_source_set_memory_pressure_period", sd_event_source_set_memory_pressure_period },
        { "sd_event_trim_memory", sd_event_trim_memory },
        { "sd_pid_notify_barrier", sd_pid_notify_barrier },
        { "sd_event_source_leave_ratelimit", sd_event_source_leave_ratelimit },
        { "sd_journal_step_one", sd_journal_step_one },
        { "sd_session_get_leader", sd_session_get_leader },
        { "sd_id128_get_app_specific", sd_id128_get_app_specific },
        { "sd_device_enumerator_add_match_property_required", sd_device_enumerator_add_match_property_required },
        { "sd_bus_creds_get_pidfd_dup", sd_bus_creds_get_pidfd_dup },
        { "sd_bus_creds_new_from_pidfd", sd_bus_creds_new_from_pidfd },
        { "sd_id128_get_invocation_app_specific", sd_id128_get_invocation_app_specific },
        { "sd_journal_stream_fd_with_namespace", sd_journal_stream_fd_with_namespace },
        { "sd_event_source_get_inotify_path", sd_event_source_get_inotify_path },
        { "sd_bus_pending_method_calls", sd_bus_pending_method_calls },
        { "sd_json_build", sd_json_build },
        { "sd_json_buildv", sd_json_buildv },
        { "sd_json_dispatch", sd_json_dispatch },
        { "sd_json_dispatch_const_string", sd_json_dispatch_const_string },
        { "sd_json_dispatch_double", sd_json_dispatch_double },
        { "sd_json_dispatch_full", sd_json_dispatch_full },
        { "sd_json_dispatch_id128", sd_json_dispatch_id128 },
        { "sd_json_dispatch_int16", sd_json_dispatch_int16 },
        { "sd_json_dispatch_int32", sd_json_dispatch_int32 },
        { "sd_json_dispatch_int64", sd_json_dispatch_int64 },
        { "sd_json_dispatch_int8", sd_json_dispatch_int8 },
        { "sd_json_dispatch_intbool", sd_json_dispatch_intbool },
        { "sd_json_dispatch_stdbool", sd_json_dispatch_stdbool },
        { "sd_json_dispatch_string", sd_json_dispatch_string },
        { "sd_json_dispatch_strv", sd_json_dispatch_strv },
        { "sd_json_dispatch_tristate", sd_json_dispatch_tristate },
        { "sd_json_dispatch_uid_gid", sd_json_dispatch_uid_gid },
        { "sd_json_dispatch_uint16", sd_json_dispatch_uint16 },
        { "sd_json_dispatch_uint32", sd_json_dispatch_uint32 },
        { "sd_json_dispatch_uint64", sd_json_dispatch_uint64 },
        { "sd_json_dispatch_uint8", sd_json_dispatch_uint8 },
        { "sd_json_dispatch_signal", sd_json_dispatch_signal },
        { "sd_json_dispatch_unsupported", sd_json_dispatch_unsupported },
        { "sd_json_dispatch_variant", sd_json_dispatch_variant },
        { "sd_json_dispatch_variant_noref", sd_json_dispatch_variant_noref },
        { "sd_json_parse", sd_json_parse },
        { "sd_json_parse_continue", sd_json_parse_continue },
        { "sd_json_parse_file", sd_json_parse_file },
        { "sd_json_parse_file_at", sd_json_parse_file_at },
        { "sd_json_parse_with_source", sd_json_parse_with_source },
        { "sd_json_parse_with_source_continue", sd_json_parse_with_source_continue },
        { "sd_json_variant_append_array", sd_json_variant_append_array },
        { "sd_json_variant_append_array_nodup", sd_json_variant_append_array_nodup },
        { "sd_json_variant_append_arrayb", sd_json_variant_append_arrayb },
        { "sd_json_variant_boolean", sd_json_variant_boolean },
        { "sd_json_variant_by_index", sd_json_variant_by_index },
        { "sd_json_variant_by_key", sd_json_variant_by_key },
        { "sd_json_variant_by_key_full", sd_json_variant_by_key_full },
        { "sd_json_variant_dump", sd_json_variant_dump },
        { "sd_json_variant_elements", sd_json_variant_elements },
        { "sd_json_variant_equal", sd_json_variant_equal },
        { "sd_json_variant_filter", sd_json_variant_filter },
        { "sd_json_variant_find", sd_json_variant_find },
        { "sd_json_variant_format", sd_json_variant_format },
        { "sd_json_variant_get_source", sd_json_variant_get_source },
        { "sd_json_variant_has_type", sd_json_variant_has_type },
        { "sd_json_variant_integer", sd_json_variant_integer },
        { "sd_json_variant_is_array", sd_json_variant_is_array },
        { "sd_json_variant_is_blank_array", sd_json_variant_is_blank_array },
        { "sd_json_variant_is_blank_object", sd_json_variant_is_blank_object },
        { "sd_json_variant_is_boolean", sd_json_variant_is_boolean },
        { "sd_json_variant_is_integer", sd_json_variant_is_integer },
        { "sd_json_variant_is_negative", sd_json_variant_is_negative },
        { "sd_json_variant_is_normalized", sd_json_variant_is_normalized },
        { "sd_json_variant_is_null", sd_json_variant_is_null },
        { "sd_json_variant_is_number", sd_json_variant_is_number },
        { "sd_json_variant_is_object", sd_json_variant_is_object },
        { "sd_json_variant_is_real", sd_json_variant_is_real },
        { "sd_json_variant_is_sensitive", sd_json_variant_is_sensitive },
        { "sd_json_variant_is_sensitive_recursive", sd_json_variant_is_sensitive_recursive },
        { "sd_json_variant_is_sorted", sd_json_variant_is_sorted },
        { "sd_json_variant_is_string", sd_json_variant_is_string },
        { "sd_json_variant_is_unsigned", sd_json_variant_is_unsigned },
        { "sd_json_variant_merge_object", sd_json_variant_merge_object },
        { "sd_json_variant_merge_objectb", sd_json_variant_merge_objectb },
        { "sd_json_variant_new_array", sd_json_variant_new_array },
        { "sd_json_variant_new_array_bytes", sd_json_variant_new_array_bytes },
        { "sd_json_variant_new_array_strv", sd_json_variant_new_array_strv },
        { "sd_json_variant_new_base32hex", sd_json_variant_new_base32hex },
        { "sd_json_variant_new_base64", sd_json_variant_new_base64 },
        { "sd_json_variant_new_boolean", sd_json_variant_new_boolean },
        { "sd_json_variant_new_hex", sd_json_variant_new_hex },
        { "sd_json_variant_new_id128", sd_json_variant_new_id128 },
        { "sd_json_variant_new_integer", sd_json_variant_new_integer },
        { "sd_json_variant_new_null", sd_json_variant_new_null },
        { "sd_json_variant_new_object", sd_json_variant_new_object },
        { "sd_json_variant_new_octescape", sd_json_variant_new_octescape },
        { "sd_json_variant_new_real", sd_json_variant_new_real },
        { "sd_json_variant_new_string", sd_json_variant_new_string },
        { "sd_json_variant_new_stringn", sd_json_variant_new_stringn },
        { "sd_json_variant_new_unsigned", sd_json_variant_new_unsigned },
        { "sd_json_variant_new_uuid", sd_json_variant_new_uuid },
        { "sd_json_variant_normalize", sd_json_variant_normalize },
        { "sd_json_variant_real", sd_json_variant_real },
        { "sd_json_variant_ref", sd_json_variant_ref },
        { "sd_json_variant_sensitive", sd_json_variant_sensitive },
        { "sd_json_variant_set_field", sd_json_variant_set_field },
        { "sd_json_variant_set_field_boolean", sd_json_variant_set_field_boolean },
        { "sd_json_variant_set_field_id128", sd_json_variant_set_field_id128 },
        { "sd_json_variant_set_field_integer", sd_json_variant_set_field_integer },
        { "sd_json_variant_set_field_string", sd_json_variant_set_field_string },
        { "sd_json_variant_set_field_strv", sd_json_variant_set_field_strv },
        { "sd_json_variant_set_field_unsigned", sd_json_variant_set_field_unsigned },
        { "sd_json_variant_set_field_uuid", sd_json_variant_set_field_uuid },
        { "sd_json_variant_set_fieldb", sd_json_variant_set_fieldb },
        { "sd_json_variant_sort", sd_json_variant_sort },
        { "sd_json_variant_string", sd_json_variant_string },
        { "sd_json_variant_strv", sd_json_variant_strv },
        { "sd_json_variant_type", sd_json_variant_type },
        { "sd_json_variant_unbase64", sd_json_variant_unbase64 },
        { "sd_json_variant_unhex", sd_json_variant_unhex },
        { "sd_json_variant_unref", sd_json_variant_unref },
        { "sd_json_variant_unref_many", sd_json_variant_unref_many },
        { "sd_json_variant_unsigned", sd_json_variant_unsigned },
        { "sd_varlink_attach_event", sd_varlink_attach_event },
        { "sd_varlink_bind_reply", sd_varlink_bind_reply },
        { "sd_varlink_call", sd_varlink_call },
        { "sd_varlink_call_full", sd_varlink_call_full },
        { "sd_varlink_callb", sd_varlink_callb },
        { "sd_varlink_callb_ap", sd_varlink_callb_ap },
        { "sd_varlink_callb_full", sd_varlink_callb_full },
        { "sd_varlink_close", sd_varlink_close },
        { "sd_varlink_close_unref", sd_varlink_close_unref },
        { "sd_varlink_collect", sd_varlink_collect },
        { "sd_varlink_collect_full", sd_varlink_collect_full },
        { "sd_varlink_collectb", sd_varlink_collectb },
        { "sd_varlink_connect_address", sd_varlink_connect_address },
        { "sd_varlink_connect_exec", sd_varlink_connect_exec },
        { "sd_varlink_connect_fd", sd_varlink_connect_fd },
        { "sd_varlink_connect_fd_pair", sd_varlink_connect_fd_pair },
        { "sd_varlink_connect_url", sd_varlink_connect_url },
        { "sd_varlink_detach_event", sd_varlink_detach_event },
        { "sd_varlink_dispatch", sd_varlink_dispatch },
        { "sd_varlink_dispatch_again", sd_varlink_dispatch_again },
        { "sd_varlink_error", sd_varlink_error },
        { "sd_varlink_error_errno", sd_varlink_error_errno },
        { "sd_varlink_error_invalid_parameter", sd_varlink_error_invalid_parameter },
        { "sd_varlink_error_invalid_parameter_name", sd_varlink_error_invalid_parameter_name },
        { "sd_varlink_error_is_invalid_parameter", sd_varlink_error_is_invalid_parameter },
        { "sd_varlink_error_to_errno", sd_varlink_error_to_errno },
        { "sd_varlink_errorb", sd_varlink_errorb },
        { "sd_varlink_flush", sd_varlink_flush },
        { "sd_varlink_flush_close_unref", sd_varlink_flush_close_unref },
        { "sd_varlink_get_current_parameters", sd_varlink_get_current_parameters },
        { "sd_varlink_get_event", sd_varlink_get_event },
        { "sd_varlink_get_events", sd_varlink_get_events },
        { "sd_varlink_get_fd", sd_varlink_get_fd },
        { "sd_varlink_get_peer_gid", sd_varlink_get_peer_gid },
        { "sd_varlink_get_peer_pid", sd_varlink_get_peer_pid },
        { "sd_varlink_get_peer_pidfd", sd_varlink_get_peer_pidfd },
        { "sd_varlink_get_peer_uid", sd_varlink_get_peer_uid },
        { "sd_varlink_get_server", sd_varlink_get_server },
        { "sd_varlink_get_timeout", sd_varlink_get_timeout },
        { "sd_varlink_get_userdata", sd_varlink_get_userdata },
        { "sd_varlink_idl_dump", sd_varlink_idl_dump },
        { "sd_varlink_idl_format", sd_varlink_idl_format },
        { "sd_varlink_idl_format_full", sd_varlink_idl_format_full },
        { "sd_varlink_invocation", sd_varlink_invocation },
        { "sd_varlink_invoke", sd_varlink_invoke },
        { "sd_varlink_invokeb", sd_varlink_invokeb },
        { "sd_varlink_is_idle", sd_varlink_is_idle },
        { "sd_varlink_notify", sd_varlink_notify },
        { "sd_varlink_notifyb", sd_varlink_notifyb },
        { "sd_varlink_observe", sd_varlink_observe },
        { "sd_varlink_observeb", sd_varlink_observeb },
        { "sd_varlink_peek_dup_fd", sd_varlink_peek_dup_fd },
        { "sd_varlink_peek_fd", sd_varlink_peek_fd },
        { "sd_varlink_process", sd_varlink_process },
        { "sd_varlink_push_dup_fd", sd_varlink_push_dup_fd },
        { "sd_varlink_push_fd", sd_varlink_push_fd },
        { "sd_varlink_ref", sd_varlink_ref },
        { "sd_varlink_reply", sd_varlink_reply },
        { "sd_varlink_replyb", sd_varlink_replyb },
        { "sd_varlink_send", sd_varlink_send },
        { "sd_varlink_sendb", sd_varlink_sendb },
        { "sd_varlink_server_add_connection", sd_varlink_server_add_connection },
        { "sd_varlink_server_add_connection_pair", sd_varlink_server_add_connection_pair },
        { "sd_varlink_server_add_connection_stdio", sd_varlink_server_add_connection_stdio },
        { "sd_varlink_server_add_interface", sd_varlink_server_add_interface },
        { "sd_varlink_server_add_interface_many_internal", sd_varlink_server_add_interface_many_internal },
        { "sd_varlink_server_attach_event", sd_varlink_server_attach_event },
        { "sd_varlink_server_bind_connect", sd_varlink_server_bind_connect },
        { "sd_varlink_server_bind_disconnect", sd_varlink_server_bind_disconnect },
        { "sd_varlink_server_bind_method", sd_varlink_server_bind_method },
        { "sd_varlink_server_bind_method_many_internal", sd_varlink_server_bind_method_many_internal },
        { "sd_varlink_server_connections_max", sd_varlink_server_connections_max },
        { "sd_varlink_server_connections_per_uid_max", sd_varlink_server_connections_per_uid_max },
        { "sd_varlink_server_current_connections", sd_varlink_server_current_connections },
        { "sd_varlink_server_detach_event", sd_varlink_server_detach_event },
        { "sd_varlink_server_get_event", sd_varlink_server_get_event },
        { "sd_varlink_server_get_userdata", sd_varlink_server_get_userdata },
        { "sd_varlink_server_listen_address", sd_varlink_server_listen_address },
        { "sd_varlink_server_listen_auto", sd_varlink_server_listen_auto },
        { "sd_varlink_server_listen_fd", sd_varlink_server_listen_fd },
        { "sd_varlink_server_loop_auto", sd_varlink_server_loop_auto },
        { "sd_varlink_server_new", sd_varlink_server_new },
        { "sd_varlink_server_ref", sd_varlink_server_ref },
        { "sd_varlink_server_set_connections_max", sd_varlink_server_set_connections_max },
        { "sd_varlink_server_set_connections_per_uid_max", sd_varlink_server_set_connections_per_uid_max },
        { "sd_varlink_server_set_description", sd_varlink_server_set_description },
        { "sd_varlink_server_set_info", sd_varlink_server_set_info },
        { "sd_varlink_server_set_exit_on_idle", sd_varlink_server_set_exit_on_idle },
        { "sd_varlink_server_set_userdata", sd_varlink_server_set_userdata },
        { "sd_varlink_server_shutdown", sd_varlink_server_shutdown },
        { "sd_varlink_server_unref", sd_varlink_server_unref },
        { "sd_varlink_set_allow_fd_passing_input", sd_varlink_set_allow_fd_passing_input },
        { "sd_varlink_set_allow_fd_passing_output", sd_varlink_set_allow_fd_passing_output },
        { "sd_varlink_set_description", sd_varlink_set_description },
        { "sd_varlink_set_input_sensitive", sd_varlink_set_input_sensitive },
        { "sd_varlink_set_relative_timeout", sd_varlink_set_relative_timeout },
        { "sd_varlink_set_userdata", sd_varlink_set_userdata },
        { "sd_varlink_take_fd", sd_varlink_take_fd },
        { "sd_varlink_unref", sd_varlink_unref },
        { "sd_varlink_wait", sd_varlink_wait },
        { "sd_device_get_device_id", sd_device_get_device_id },
        { "sd_device_get_driver_subsystem", sd_device_get_driver_subsystem },
        { "sd_device_monitor_is_running", sd_device_monitor_is_running },
        { "sd_device_monitor_get_fd", sd_device_monitor_get_fd },
        { "sd_device_monitor_get_events", sd_device_monitor_get_events },
        { "sd_device_monitor_get_timeout", sd_device_monitor_get_timeout },
        { "sd_device_monitor_receive", sd_device_monitor_receive },
        { "sd_bus_message_dump_json", sd_bus_message_dump_json },
        { "sd_device_enumerator_add_all_parents", sd_device_enumerator_add_all_parents },
        { "sd_device_get_sysattr_value_with_size", sd_device_get_sysattr_value_with_size },
        { "sd_json_variant_type_from_string", sd_json_variant_type_from_string },
        { "sd_json_variant_type_to_string", sd_json_variant_type_to_string },
        { "sd_pidfd_get_inode_id", sd_pidfd_get_inode_id },
        { "sd_varlink_get_current_method", sd_varlink_get_current_method },
        { "sd_varlink_get_description", sd_varlink_get_description },
        { "sd_varlink_get_input_fd", sd_varlink_get_input_fd },
        { "sd_varlink_get_n_fds", sd_varlink_get_n_fds },
        { "sd_varlink_get_output_fd", sd_varlink_get_output_fd },
        { "sd_varlink_idl_parse", sd_varlink_idl_parse },
        { "sd_varlink_interface_free", sd_varlink_interface_free },
        { "sd_varlink_reset_fds", sd_varlink_reset_fds },
        { "sd_varlink_server_listen_name", sd_varlink_server_listen_name },
        {}
}, symbols_from_header[] = {
        { "sd_bus_interface_name_is_valid", sd_bus_interface_name_is_valid },
        { "sd_bus_service_name_is_valid", sd_bus_service_name_is_valid },
        { "sd_bus_member_name_is_valid", sd_bus_member_name_is_valid },
        { "sd_bus_object_path_is_valid", sd_bus_object_path_is_valid },
        { "sd_bus_default", sd_bus_default },
        { "sd_bus_default_user", sd_bus_default_user },
        { "sd_bus_default_system", sd_bus_default_system },
        { "sd_bus_open", sd_bus_open },
        { "sd_bus_open_with_description", sd_bus_open_with_description },
        { "sd_bus_open_user", sd_bus_open_user },
        { "sd_bus_open_user_with_description", sd_bus_open_user_with_description },
        { "sd_bus_open_user_machine", sd_bus_open_user_machine },
        { "sd_bus_open_system", sd_bus_open_system },
        { "sd_bus_open_system_with_description", sd_bus_open_system_with_description },
        { "sd_bus_open_system_remote", sd_bus_open_system_remote },
        { "sd_bus_open_system_machine", sd_bus_open_system_machine },
        { "sd_bus_new", sd_bus_new },
        { "sd_bus_set_address", sd_bus_set_address },
        { "sd_bus_set_fd", sd_bus_set_fd },
        { "sd_bus_set_exec", sd_bus_set_exec },
        { "sd_bus_get_address", sd_bus_get_address },
        { "sd_bus_set_bus_client", sd_bus_set_bus_client },
        { "sd_bus_is_bus_client", sd_bus_is_bus_client },
        { "sd_bus_set_server", sd_bus_set_server },
        { "sd_bus_is_server", sd_bus_is_server },
        { "sd_bus_set_anonymous", sd_bus_set_anonymous },
        { "sd_bus_is_anonymous", sd_bus_is_anonymous },
        { "sd_bus_set_trusted", sd_bus_set_trusted },
        { "sd_bus_is_trusted", sd_bus_is_trusted },
        { "sd_bus_set_monitor", sd_bus_set_monitor },
        { "sd_bus_is_monitor", sd_bus_is_monitor },
        { "sd_bus_set_description", sd_bus_set_description },
        { "sd_bus_get_description", sd_bus_get_description },
        { "sd_bus_negotiate_creds", sd_bus_negotiate_creds },
        { "sd_bus_negotiate_timestamp", sd_bus_negotiate_timestamp },
        { "sd_bus_negotiate_fds", sd_bus_negotiate_fds },
        { "sd_bus_can_send", sd_bus_can_send },
        { "sd_bus_get_creds_mask", sd_bus_get_creds_mask },
        { "sd_bus_set_allow_interactive_authorization", sd_bus_set_allow_interactive_authorization },
        { "sd_bus_get_allow_interactive_authorization", sd_bus_get_allow_interactive_authorization },
        { "sd_bus_set_exit_on_disconnect", sd_bus_set_exit_on_disconnect },
        { "sd_bus_get_exit_on_disconnect", sd_bus_get_exit_on_disconnect },
        { "sd_bus_set_close_on_exit", sd_bus_set_close_on_exit },
        { "sd_bus_get_close_on_exit", sd_bus_get_close_on_exit },
        { "sd_bus_set_watch_bind", sd_bus_set_watch_bind },
        { "sd_bus_get_watch_bind", sd_bus_get_watch_bind },
        { "sd_bus_set_connected_signal", sd_bus_set_connected_signal },
        { "sd_bus_get_connected_signal", sd_bus_get_connected_signal },
        { "sd_bus_set_sender", sd_bus_set_sender },
        { "sd_bus_get_sender", sd_bus_get_sender },
        { "sd_bus_start", sd_bus_start },
        { "sd_bus_try_close", sd_bus_try_close },
        { "sd_bus_close", sd_bus_close },
        { "sd_bus_ref", sd_bus_ref },
        { "sd_bus_unref", sd_bus_unref },
        { "sd_bus_close_unref", sd_bus_close_unref },
        { "sd_bus_flush_close_unref", sd_bus_flush_close_unref },
        { "sd_bus_default_flush_close", sd_bus_default_flush_close },
        { "sd_bus_is_open", sd_bus_is_open },
        { "sd_bus_is_ready", sd_bus_is_ready },
        { "sd_bus_get_bus_id", sd_bus_get_bus_id },
        { "sd_bus_get_scope", sd_bus_get_scope },
        { "sd_bus_get_tid", sd_bus_get_tid },
        { "sd_bus_get_owner_creds", sd_bus_get_owner_creds },
        { "sd_bus_send", sd_bus_send },
        { "sd_bus_send_to", sd_bus_send_to },
        { "sd_bus_call", sd_bus_call },
        { "sd_bus_call_async", sd_bus_call_async },
        { "sd_bus_get_fd", sd_bus_get_fd },
        { "sd_bus_get_events", sd_bus_get_events },
        { "sd_bus_get_timeout", sd_bus_get_timeout },
        { "sd_bus_process", sd_bus_process },
        { "sd_bus_process_priority", sd_bus_process_priority },
        { "sd_bus_wait", sd_bus_wait },
        { "sd_bus_flush", sd_bus_flush },
        { "sd_bus_enqueue_for_read", sd_bus_enqueue_for_read },
        { "sd_bus_get_current_slot", sd_bus_get_current_slot },
        { "sd_bus_get_current_message", sd_bus_get_current_message },
        { "sd_bus_get_current_handler", sd_bus_get_current_handler },
        { "sd_bus_get_current_userdata", sd_bus_get_current_userdata },
        { "sd_bus_attach_event", sd_bus_attach_event },
        { "sd_bus_detach_event", sd_bus_detach_event },
        { "sd_bus_get_event", sd_bus_get_event },
        { "sd_bus_get_n_queued_read", sd_bus_get_n_queued_read },
        { "sd_bus_get_n_queued_write", sd_bus_get_n_queued_write },
        { "sd_bus_set_method_call_timeout", sd_bus_set_method_call_timeout },
        { "sd_bus_get_method_call_timeout", sd_bus_get_method_call_timeout },
        { "sd_bus_add_filter", sd_bus_add_filter },
        { "sd_bus_add_match", sd_bus_add_match },
        { "sd_bus_add_match_async", sd_bus_add_match_async },
        { "sd_bus_add_object", sd_bus_add_object },
        { "sd_bus_add_fallback", sd_bus_add_fallback },
        { "sd_bus_add_object_vtable", sd_bus_add_object_vtable },
        { "sd_bus_add_fallback_vtable", sd_bus_add_fallback_vtable },
        { "sd_bus_add_node_enumerator", sd_bus_add_node_enumerator },
        { "sd_bus_add_object_manager", sd_bus_add_object_manager },
        { "sd_bus_pending_method_calls", sd_bus_pending_method_calls },
        { "sd_bus_slot_ref", sd_bus_slot_ref },
        { "sd_bus_slot_unref", sd_bus_slot_unref },
        { "sd_bus_slot_get_bus", sd_bus_slot_get_bus },
        { "sd_bus_slot_get_userdata", sd_bus_slot_get_userdata },
        { "sd_bus_slot_set_userdata", sd_bus_slot_set_userdata },
        { "sd_bus_slot_set_description", sd_bus_slot_set_description },
        { "sd_bus_slot_get_description", sd_bus_slot_get_description },
        { "sd_bus_slot_get_floating", sd_bus_slot_get_floating },
        { "sd_bus_slot_set_floating", sd_bus_slot_set_floating },
        { "sd_bus_slot_set_destroy_callback", sd_bus_slot_set_destroy_callback },
        { "sd_bus_slot_get_destroy_callback", sd_bus_slot_get_destroy_callback },
        { "sd_bus_slot_get_current_message", sd_bus_slot_get_current_message },
        { "sd_bus_slot_get_current_handler", sd_bus_slot_get_current_handler },
        { "sd_bus_slot_get_current_userdata", sd_bus_slot_get_current_userdata },
        { "sd_bus_message_new", sd_bus_message_new },
        { "sd_bus_message_new_signal", sd_bus_message_new_signal },
        { "sd_bus_message_new_signal_to", sd_bus_message_new_signal_to },
        { "sd_bus_message_new_method_call", sd_bus_message_new_method_call },
        { "sd_bus_message_new_method_return", sd_bus_message_new_method_return },
        { "sd_bus_message_new_method_error", sd_bus_message_new_method_error },
        { "sd_bus_message_new_method_errorf", sd_bus_message_new_method_errorf },
        { "sd_bus_message_new_method_errno", sd_bus_message_new_method_errno },
        { "sd_bus_message_new_method_errnof", sd_bus_message_new_method_errnof },
        { "sd_bus_message_ref", sd_bus_message_ref },
        { "sd_bus_message_unref", sd_bus_message_unref },
        { "sd_bus_message_seal", sd_bus_message_seal },
        { "sd_bus_message_get_type", sd_bus_message_get_type },
        { "sd_bus_message_get_cookie", sd_bus_message_get_cookie },
        { "sd_bus_message_get_reply_cookie", sd_bus_message_get_reply_cookie },
        { "sd_bus_message_get_priority", sd_bus_message_get_priority },
        { "sd_bus_message_get_expect_reply", sd_bus_message_get_expect_reply },
        { "sd_bus_message_get_auto_start", sd_bus_message_get_auto_start },
        { "sd_bus_message_get_allow_interactive_authorization", sd_bus_message_get_allow_interactive_authorization },
        { "sd_bus_message_get_signature", sd_bus_message_get_signature },
        { "sd_bus_message_get_path", sd_bus_message_get_path },
        { "sd_bus_message_get_interface", sd_bus_message_get_interface },
        { "sd_bus_message_get_member", sd_bus_message_get_member },
        { "sd_bus_message_get_destination", sd_bus_message_get_destination },
        { "sd_bus_message_get_sender", sd_bus_message_get_sender },
        { "sd_bus_message_get_error", sd_bus_message_get_error },
        { "sd_bus_message_get_errno", sd_bus_message_get_errno },
        { "sd_bus_message_get_monotonic_usec", sd_bus_message_get_monotonic_usec },
        { "sd_bus_message_get_realtime_usec", sd_bus_message_get_realtime_usec },
        { "sd_bus_message_get_seqnum", sd_bus_message_get_seqnum },
        { "sd_bus_message_get_bus", sd_bus_message_get_bus },
        { "sd_bus_message_get_creds", sd_bus_message_get_creds },
        { "sd_bus_message_is_signal", sd_bus_message_is_signal },
        { "sd_bus_message_is_method_call", sd_bus_message_is_method_call },
        { "sd_bus_message_is_method_error", sd_bus_message_is_method_error },
        { "sd_bus_message_is_empty", sd_bus_message_is_empty },
        { "sd_bus_message_has_signature", sd_bus_message_has_signature },
        { "sd_bus_message_set_expect_reply", sd_bus_message_set_expect_reply },
        { "sd_bus_message_set_auto_start", sd_bus_message_set_auto_start },
        { "sd_bus_message_set_allow_interactive_authorization", sd_bus_message_set_allow_interactive_authorization },
        { "sd_bus_message_set_destination", sd_bus_message_set_destination },
        { "sd_bus_message_set_sender", sd_bus_message_set_sender },
        { "sd_bus_message_set_priority", sd_bus_message_set_priority },
        { "sd_bus_message_append", sd_bus_message_append },
        { "sd_bus_message_appendv", sd_bus_message_appendv },
        { "sd_bus_message_append_basic", sd_bus_message_append_basic },
        { "sd_bus_message_append_array", sd_bus_message_append_array },
        { "sd_bus_message_append_array_space", sd_bus_message_append_array_space },
        { "sd_bus_message_append_array_iovec", sd_bus_message_append_array_iovec },
        { "sd_bus_message_append_array_memfd", sd_bus_message_append_array_memfd },
        { "sd_bus_message_append_string_space", sd_bus_message_append_string_space },
        { "sd_bus_message_append_string_iovec", sd_bus_message_append_string_iovec },
        { "sd_bus_message_append_string_memfd", sd_bus_message_append_string_memfd },
        { "sd_bus_message_append_strv", sd_bus_message_append_strv },
        { "sd_bus_message_open_container", sd_bus_message_open_container },
        { "sd_bus_message_close_container", sd_bus_message_close_container },
        { "sd_bus_message_copy", sd_bus_message_copy },
        { "sd_bus_message_read", sd_bus_message_read },
        { "sd_bus_message_readv", sd_bus_message_readv },
        { "sd_bus_message_read_basic", sd_bus_message_read_basic },
        { "sd_bus_message_read_array", sd_bus_message_read_array },
        { "sd_bus_message_read_strv", sd_bus_message_read_strv },
        { "sd_bus_message_read_strv_extend", sd_bus_message_read_strv_extend },
        { "sd_bus_message_skip", sd_bus_message_skip },
        { "sd_bus_message_enter_container", sd_bus_message_enter_container },
        { "sd_bus_message_exit_container", sd_bus_message_exit_container },
        { "sd_bus_message_peek_type", sd_bus_message_peek_type },
        { "sd_bus_message_verify_type", sd_bus_message_verify_type },
        { "sd_bus_message_at_end", sd_bus_message_at_end },
        { "sd_bus_message_rewind", sd_bus_message_rewind },
        { "sd_bus_message_sensitive", sd_bus_message_sensitive },
        { "sd_bus_message_dump", sd_bus_message_dump },
        { "sd_bus_message_dump_json", sd_bus_message_dump_json },
        { "sd_bus_get_unique_name", sd_bus_get_unique_name },
        { "sd_bus_request_name", sd_bus_request_name },
        { "sd_bus_request_name_async", sd_bus_request_name_async },
        { "sd_bus_release_name", sd_bus_release_name },
        { "sd_bus_release_name_async", sd_bus_release_name_async },
        { "sd_bus_list_names", sd_bus_list_names },
        { "sd_bus_get_name_creds", sd_bus_get_name_creds },
        { "sd_bus_get_name_machine_id", sd_bus_get_name_machine_id },
        { "sd_bus_message_send", sd_bus_message_send },
        { "sd_bus_call_methodv", sd_bus_call_methodv },
        { "sd_bus_call_method", sd_bus_call_method },
        { "sd_bus_call_method_asyncv", sd_bus_call_method_asyncv },
        { "sd_bus_call_method_async", sd_bus_call_method_async },
        { "sd_bus_get_property", sd_bus_get_property },
        { "sd_bus_get_property_trivial", sd_bus_get_property_trivial },
        { "sd_bus_get_property_string", sd_bus_get_property_string },
        { "sd_bus_get_property_strv", sd_bus_get_property_strv },
        { "sd_bus_set_propertyv", sd_bus_set_propertyv },
        { "sd_bus_set_property", sd_bus_set_property },
        { "sd_bus_reply_method_returnv", sd_bus_reply_method_returnv },
        { "sd_bus_reply_method_return", sd_bus_reply_method_return },
        { "sd_bus_reply_method_error", sd_bus_reply_method_error },
        { "sd_bus_reply_method_errorfv", sd_bus_reply_method_errorfv },
        { "sd_bus_reply_method_errorf", sd_bus_reply_method_errorf },
        { "sd_bus_reply_method_errno", sd_bus_reply_method_errno },
        { "sd_bus_reply_method_errnofv", sd_bus_reply_method_errnofv },
        { "sd_bus_reply_method_errnof", sd_bus_reply_method_errnof },
        { "sd_bus_emit_signalv", sd_bus_emit_signalv },
        { "sd_bus_emit_signal", sd_bus_emit_signal },
        { "sd_bus_emit_signal_tov", sd_bus_emit_signal_tov },
        { "sd_bus_emit_signal_to", sd_bus_emit_signal_to },
        { "sd_bus_emit_properties_changed_strv", sd_bus_emit_properties_changed_strv },
        { "sd_bus_emit_properties_changed", sd_bus_emit_properties_changed },
        { "sd_bus_emit_object_added", sd_bus_emit_object_added },
        { "sd_bus_emit_object_removed", sd_bus_emit_object_removed },
        { "sd_bus_emit_interfaces_added_strv", sd_bus_emit_interfaces_added_strv },
        { "sd_bus_emit_interfaces_added", sd_bus_emit_interfaces_added },
        { "sd_bus_emit_interfaces_removed_strv", sd_bus_emit_interfaces_removed_strv },
        { "sd_bus_emit_interfaces_removed", sd_bus_emit_interfaces_removed },
        { "sd_bus_query_sender_creds", sd_bus_query_sender_creds },
        { "sd_bus_query_sender_privilege", sd_bus_query_sender_privilege },
        { "sd_bus_match_signal", sd_bus_match_signal },
        { "sd_bus_match_signal_async", sd_bus_match_signal_async },
        { "sd_bus_creds_new_from_pid", sd_bus_creds_new_from_pid },
        { "sd_bus_creds_new_from_pidfd", sd_bus_creds_new_from_pidfd },
        { "sd_bus_creds_ref", sd_bus_creds_ref },
        { "sd_bus_creds_unref", sd_bus_creds_unref },
        { "sd_bus_creds_get_mask", sd_bus_creds_get_mask },
        { "sd_bus_creds_get_augmented_mask", sd_bus_creds_get_augmented_mask },
        { "sd_bus_creds_get_pid", sd_bus_creds_get_pid },
        { "sd_bus_creds_get_pidfd_dup", sd_bus_creds_get_pidfd_dup },
        { "sd_bus_creds_get_ppid", sd_bus_creds_get_ppid },
        { "sd_bus_creds_get_tid", sd_bus_creds_get_tid },
        { "sd_bus_creds_get_uid", sd_bus_creds_get_uid },
        { "sd_bus_creds_get_euid", sd_bus_creds_get_euid },
        { "sd_bus_creds_get_suid", sd_bus_creds_get_suid },
        { "sd_bus_creds_get_fsuid", sd_bus_creds_get_fsuid },
        { "sd_bus_creds_get_gid", sd_bus_creds_get_gid },
        { "sd_bus_creds_get_egid", sd_bus_creds_get_egid },
        { "sd_bus_creds_get_sgid", sd_bus_creds_get_sgid },
        { "sd_bus_creds_get_fsgid", sd_bus_creds_get_fsgid },
        { "sd_bus_creds_get_supplementary_gids", sd_bus_creds_get_supplementary_gids },
        { "sd_bus_creds_get_comm", sd_bus_creds_get_comm },
        { "sd_bus_creds_get_tid_comm", sd_bus_creds_get_tid_comm },
        { "sd_bus_creds_get_exe", sd_bus_creds_get_exe },
        { "sd_bus_creds_get_cmdline", sd_bus_creds_get_cmdline },
        { "sd_bus_creds_get_cgroup", sd_bus_creds_get_cgroup },
        { "sd_bus_creds_get_unit", sd_bus_creds_get_unit },
        { "sd_bus_creds_get_slice", sd_bus_creds_get_slice },
        { "sd_bus_creds_get_user_unit", sd_bus_creds_get_user_unit },
        { "sd_bus_creds_get_user_slice", sd_bus_creds_get_user_slice },
        { "sd_bus_creds_get_session", sd_bus_creds_get_session },
        { "sd_bus_creds_get_owner_uid", sd_bus_creds_get_owner_uid },
        { "sd_bus_creds_has_effective_cap", sd_bus_creds_has_effective_cap },
        { "sd_bus_creds_has_permitted_cap", sd_bus_creds_has_permitted_cap },
        { "sd_bus_creds_has_inheritable_cap", sd_bus_creds_has_inheritable_cap },
        { "sd_bus_creds_has_bounding_cap", sd_bus_creds_has_bounding_cap },
        { "sd_bus_creds_get_selinux_context", sd_bus_creds_get_selinux_context },
        { "sd_bus_creds_get_audit_session_id", sd_bus_creds_get_audit_session_id },
        { "sd_bus_creds_get_audit_login_uid", sd_bus_creds_get_audit_login_uid },
        { "sd_bus_creds_get_tty", sd_bus_creds_get_tty },
        { "sd_bus_creds_get_unique_name", sd_bus_creds_get_unique_name },
        { "sd_bus_creds_get_well_known_names", sd_bus_creds_get_well_known_names },
        { "sd_bus_creds_get_description", sd_bus_creds_get_description },
        { "sd_bus_error_free", sd_bus_error_free },
        { "sd_bus_error_set", sd_bus_error_set },
        { "sd_bus_error_setf", sd_bus_error_setf },
        { "sd_bus_error_setfv", sd_bus_error_setfv },
        { "sd_bus_error_set_const", sd_bus_error_set_const },
        { "sd_bus_error_set_errno", sd_bus_error_set_errno },
        { "sd_bus_error_set_errnof", sd_bus_error_set_errnof },
        { "sd_bus_error_set_errnofv", sd_bus_error_set_errnofv },
        { "sd_bus_error_get_errno", sd_bus_error_get_errno },
        { "sd_bus_error_copy", sd_bus_error_copy },
        { "sd_bus_error_move", sd_bus_error_move },
        { "sd_bus_error_is_set", sd_bus_error_is_set },
        { "sd_bus_error_has_name", sd_bus_error_has_name },
        { "sd_bus_error_has_names_sentinel", sd_bus_error_has_names_sentinel },
        { "sd_bus_error_add_map", sd_bus_error_add_map },
        { "sd_bus_path_encode", sd_bus_path_encode },
        { "sd_bus_path_encode_many", sd_bus_path_encode_many },
        { "sd_bus_path_decode", sd_bus_path_decode },
        { "sd_bus_path_decode_many", sd_bus_path_decode_many },
        { "sd_bus_track_new", sd_bus_track_new },
        { "sd_bus_track_ref", sd_bus_track_ref },
        { "sd_bus_track_unref", sd_bus_track_unref },
        { "sd_bus_track_get_bus", sd_bus_track_get_bus },
        { "sd_bus_track_get_userdata", sd_bus_track_get_userdata },
        { "sd_bus_track_set_userdata", sd_bus_track_set_userdata },
        { "sd_bus_track_add_sender", sd_bus_track_add_sender },
        { "sd_bus_track_remove_sender", sd_bus_track_remove_sender },
        { "sd_bus_track_add_name", sd_bus_track_add_name },
        { "sd_bus_track_remove_name", sd_bus_track_remove_name },
        { "sd_bus_track_set_recursive", sd_bus_track_set_recursive },
        { "sd_bus_track_get_recursive", sd_bus_track_get_recursive },
        { "sd_bus_track_count", sd_bus_track_count },
        { "sd_bus_track_count_sender", sd_bus_track_count_sender },
        { "sd_bus_track_count_name", sd_bus_track_count_name },
        { "sd_bus_track_contains", sd_bus_track_contains },
        { "sd_bus_track_first", sd_bus_track_first },
        { "sd_bus_track_next", sd_bus_track_next },
        { "sd_bus_track_set_destroy_callback", sd_bus_track_set_destroy_callback },
        { "sd_bus_track_get_destroy_callback", sd_bus_track_get_destroy_callback },
        { "sd_bus_unref", sd_bus_unref },
        { "sd_bus_close_unref", sd_bus_close_unref },
        { "sd_bus_flush_close_unref", sd_bus_flush_close_unref },
        { "sd_bus_slot_unref", sd_bus_slot_unref },
        { "sd_bus_message_unref", sd_bus_message_unref },
        { "sd_bus_creds_unref", sd_bus_creds_unref },
        { "sd_bus_track_unref", sd_bus_track_unref },
        { "sd_bus_object_vtable_format", &sd_bus_object_vtable_format },
        { "sd_listen_fds", sd_listen_fds },
        { "sd_listen_fds_with_names", sd_listen_fds_with_names },
        { "sd_is_fifo", sd_is_fifo },
        { "sd_is_special", sd_is_special },
        { "sd_is_socket", sd_is_socket },
        { "sd_is_socket_inet", sd_is_socket_inet },
        { "sd_is_socket_sockaddr", sd_is_socket_sockaddr },
        { "sd_is_socket_unix", sd_is_socket_unix },
        { "sd_is_mq", sd_is_mq },
        { "sd_notify", sd_notify },
        { "sd_notifyf", sd_notifyf },
        { "sd_pid_notify", sd_pid_notify },
        { "sd_pid_notifyf", sd_pid_notifyf },
        { "sd_pid_notify_with_fds", sd_pid_notify_with_fds },
        { "sd_pid_notifyf_with_fds", sd_pid_notifyf_with_fds },
        { "sd_notify_barrier", sd_notify_barrier },
        { "sd_pid_notify_barrier", sd_pid_notify_barrier },
        { "sd_pidfd_get_inode_id", sd_pidfd_get_inode_id },
        { "sd_booted", sd_booted },
        { "sd_watchdog_enabled", sd_watchdog_enabled },
        { "sd_device_ref", sd_device_ref },
        { "sd_device_unref", sd_device_unref },
        { "sd_device_new_from_syspath", sd_device_new_from_syspath },
        { "sd_device_new_from_devnum", sd_device_new_from_devnum },
        { "sd_device_new_from_subsystem_sysname", sd_device_new_from_subsystem_sysname },
        { "sd_device_new_from_device_id", sd_device_new_from_device_id },
        { "sd_device_new_from_stat_rdev", sd_device_new_from_stat_rdev },
        { "sd_device_new_from_devname", sd_device_new_from_devname },
        { "sd_device_new_from_path", sd_device_new_from_path },
        { "sd_device_new_from_ifname", sd_device_new_from_ifname },
        { "sd_device_new_from_ifindex", sd_device_new_from_ifindex },
        { "sd_device_new_child", sd_device_new_child },
        { "sd_device_get_parent", sd_device_get_parent },
        { "sd_device_get_parent_with_subsystem_devtype", sd_device_get_parent_with_subsystem_devtype },
        { "sd_device_get_syspath", sd_device_get_syspath },
        { "sd_device_get_subsystem", sd_device_get_subsystem },
        { "sd_device_get_driver_subsystem", sd_device_get_driver_subsystem },
        { "sd_device_get_devtype", sd_device_get_devtype },
        { "sd_device_get_devnum", sd_device_get_devnum },
        { "sd_device_get_ifindex", sd_device_get_ifindex },
        { "sd_device_get_driver", sd_device_get_driver },
        { "sd_device_get_devpath", sd_device_get_devpath },
        { "sd_device_get_devname", sd_device_get_devname },
        { "sd_device_get_sysname", sd_device_get_sysname },
        { "sd_device_get_sysnum", sd_device_get_sysnum },
        { "sd_device_get_action", sd_device_get_action },
        { "sd_device_get_seqnum", sd_device_get_seqnum },
        { "sd_device_get_diskseq", sd_device_get_diskseq },
        { "sd_device_get_device_id", sd_device_get_device_id },
        { "sd_device_get_is_initialized", sd_device_get_is_initialized },
        { "sd_device_get_usec_initialized", sd_device_get_usec_initialized },
        { "sd_device_get_usec_since_initialized", sd_device_get_usec_since_initialized },
        { "sd_device_get_tag_first", sd_device_get_tag_first },
        { "sd_device_get_tag_next", sd_device_get_tag_next },
        { "sd_device_get_current_tag_first", sd_device_get_current_tag_first },
        { "sd_device_get_current_tag_next", sd_device_get_current_tag_next },
        { "sd_device_get_devlink_first", sd_device_get_devlink_first },
        { "sd_device_get_devlink_next", sd_device_get_devlink_next },
        { "sd_device_get_property_first", sd_device_get_property_first },
        { "sd_device_get_property_next", sd_device_get_property_next },
        { "sd_device_get_sysattr_first", sd_device_get_sysattr_first },
        { "sd_device_get_sysattr_next", sd_device_get_sysattr_next },
        { "sd_device_get_child_first", sd_device_get_child_first },
        { "sd_device_get_child_next", sd_device_get_child_next },
        { "sd_device_has_tag", sd_device_has_tag },
        { "sd_device_has_current_tag", sd_device_has_current_tag },
        { "sd_device_get_property_value", sd_device_get_property_value },
        { "sd_device_get_trigger_uuid", sd_device_get_trigger_uuid },
        { "sd_device_get_sysattr_value_with_size", sd_device_get_sysattr_value_with_size },
        { "sd_device_get_sysattr_value", sd_device_get_sysattr_value },
        { "sd_device_set_sysattr_value", sd_device_set_sysattr_value },
        { "sd_device_set_sysattr_valuef", sd_device_set_sysattr_valuef },
        { "sd_device_trigger", sd_device_trigger },
        { "sd_device_trigger_with_uuid", sd_device_trigger_with_uuid },
        { "sd_device_open", sd_device_open },
        { "sd_device_enumerator_new", sd_device_enumerator_new },
        { "sd_device_enumerator_ref", sd_device_enumerator_ref },
        { "sd_device_enumerator_unref", sd_device_enumerator_unref },
        { "sd_device_enumerator_get_device_first", sd_device_enumerator_get_device_first },
        { "sd_device_enumerator_get_device_next", sd_device_enumerator_get_device_next },
        { "sd_device_enumerator_get_subsystem_first", sd_device_enumerator_get_subsystem_first },
        { "sd_device_enumerator_get_subsystem_next", sd_device_enumerator_get_subsystem_next },
        { "sd_device_enumerator_add_match_subsystem", sd_device_enumerator_add_match_subsystem },
        { "sd_device_enumerator_add_match_sysattr", sd_device_enumerator_add_match_sysattr },
        { "sd_device_enumerator_add_match_property", sd_device_enumerator_add_match_property },
        { "sd_device_enumerator_add_match_property_required", sd_device_enumerator_add_match_property_required },
        { "sd_device_enumerator_add_match_sysname", sd_device_enumerator_add_match_sysname },
        { "sd_device_enumerator_add_nomatch_sysname", sd_device_enumerator_add_nomatch_sysname },
        { "sd_device_enumerator_add_match_tag", sd_device_enumerator_add_match_tag },
        { "sd_device_enumerator_add_match_parent", sd_device_enumerator_add_match_parent },
        { "sd_device_enumerator_allow_uninitialized", sd_device_enumerator_allow_uninitialized },
        { "sd_device_enumerator_add_all_parents", sd_device_enumerator_add_all_parents },
        { "sd_device_monitor_new", sd_device_monitor_new },
        { "sd_device_monitor_ref", sd_device_monitor_ref },
        { "sd_device_monitor_unref", sd_device_monitor_unref },
        { "sd_device_monitor_get_fd", sd_device_monitor_get_fd },
        { "sd_device_monitor_get_events", sd_device_monitor_get_events },
        { "sd_device_monitor_get_timeout", sd_device_monitor_get_timeout },
        { "sd_device_monitor_set_receive_buffer_size", sd_device_monitor_set_receive_buffer_size },
        { "sd_device_monitor_attach_event", sd_device_monitor_attach_event },
        { "sd_device_monitor_detach_event", sd_device_monitor_detach_event },
        { "sd_device_monitor_get_event", sd_device_monitor_get_event },
        { "sd_device_monitor_get_event_source", sd_device_monitor_get_event_source },
        { "sd_device_monitor_set_description", sd_device_monitor_set_description },
        { "sd_device_monitor_get_description", sd_device_monitor_get_description },
        { "sd_device_monitor_is_running", sd_device_monitor_is_running },
        { "sd_device_monitor_start", sd_device_monitor_start },
        { "sd_device_monitor_stop", sd_device_monitor_stop },
        { "sd_device_monitor_receive", sd_device_monitor_receive },
        { "sd_device_monitor_filter_add_match_subsystem_devtype", sd_device_monitor_filter_add_match_subsystem_devtype },
        { "sd_device_monitor_filter_add_match_tag", sd_device_monitor_filter_add_match_tag },
        { "sd_device_monitor_filter_add_match_sysattr", sd_device_monitor_filter_add_match_sysattr },
        { "sd_device_monitor_filter_add_match_parent", sd_device_monitor_filter_add_match_parent },
        { "sd_device_monitor_filter_update", sd_device_monitor_filter_update },
        { "sd_device_monitor_filter_remove", sd_device_monitor_filter_remove },
        { "sd_device_unref", sd_device_unref },
        { "sd_device_enumerator_unref", sd_device_enumerator_unref },
        { "sd_device_monitor_unref", sd_device_monitor_unref },
        { "sd_event_default", sd_event_default },
        { "sd_event_new", sd_event_new },
        { "sd_event_ref", sd_event_ref },
        { "sd_event_unref", sd_event_unref },
        { "sd_event_add_io", sd_event_add_io },
        { "sd_event_add_time", sd_event_add_time },
        { "sd_event_add_time_relative", sd_event_add_time_relative },
        { "sd_event_add_signal", sd_event_add_signal },
        { "sd_event_add_child", sd_event_add_child },
        { "sd_event_add_child_pidfd", sd_event_add_child_pidfd },
        { "sd_event_add_inotify", sd_event_add_inotify },
        { "sd_event_add_inotify_fd", sd_event_add_inotify_fd },
        { "sd_event_add_defer", sd_event_add_defer },
        { "sd_event_add_post", sd_event_add_post },
        { "sd_event_add_exit", sd_event_add_exit },
        { "sd_event_add_memory_pressure", sd_event_add_memory_pressure },
        { "sd_event_prepare", sd_event_prepare },
        { "sd_event_wait", sd_event_wait },
        { "sd_event_dispatch", sd_event_dispatch },
        { "sd_event_run", sd_event_run },
        { "sd_event_loop", sd_event_loop },
        { "sd_event_exit", sd_event_exit },
        { "sd_event_now", sd_event_now },
        { "sd_event_get_fd", sd_event_get_fd },
        { "sd_event_get_state", sd_event_get_state },
        { "sd_event_get_tid", sd_event_get_tid },
        { "sd_event_get_exit_code", sd_event_get_exit_code },
        { "sd_event_set_watchdog", sd_event_set_watchdog },
        { "sd_event_get_watchdog", sd_event_get_watchdog },
        { "sd_event_get_iteration", sd_event_get_iteration },
        { "sd_event_set_signal_exit", sd_event_set_signal_exit },
        { "sd_event_source_ref", sd_event_source_ref },
        { "sd_event_source_unref", sd_event_source_unref },
        { "sd_event_source_disable_unref", sd_event_source_disable_unref },
        { "sd_event_source_get_event", sd_event_source_get_event },
        { "sd_event_source_get_userdata", sd_event_source_get_userdata },
        { "sd_event_source_set_userdata", sd_event_source_set_userdata },
        { "sd_event_source_set_description", sd_event_source_set_description },
        { "sd_event_source_get_description", sd_event_source_get_description },
        { "sd_event_source_set_prepare", sd_event_source_set_prepare },
        { "sd_event_source_get_pending", sd_event_source_get_pending },
        { "sd_event_source_get_priority", sd_event_source_get_priority },
        { "sd_event_source_set_priority", sd_event_source_set_priority },
        { "sd_event_source_get_enabled", sd_event_source_get_enabled },
        { "sd_event_source_set_enabled", sd_event_source_set_enabled },
        { "sd_event_source_get_io_fd", sd_event_source_get_io_fd },
        { "sd_event_source_set_io_fd", sd_event_source_set_io_fd },
        { "sd_event_source_get_io_fd_own", sd_event_source_get_io_fd_own },
        { "sd_event_source_set_io_fd_own", sd_event_source_set_io_fd_own },
        { "sd_event_source_get_io_events", sd_event_source_get_io_events },
        { "sd_event_source_set_io_events", sd_event_source_set_io_events },
        { "sd_event_source_get_io_revents", sd_event_source_get_io_revents },
        { "sd_event_source_get_time", sd_event_source_get_time },
        { "sd_event_source_set_time", sd_event_source_set_time },
        { "sd_event_source_set_time_relative", sd_event_source_set_time_relative },
        { "sd_event_source_get_time_accuracy", sd_event_source_get_time_accuracy },
        { "sd_event_source_set_time_accuracy", sd_event_source_set_time_accuracy },
        { "sd_event_source_get_time_clock", sd_event_source_get_time_clock },
        { "sd_event_source_get_signal", sd_event_source_get_signal },
        { "sd_event_source_get_child_pid", sd_event_source_get_child_pid },
        { "sd_event_source_get_child_pidfd", sd_event_source_get_child_pidfd },
        { "sd_event_source_get_child_pidfd_own", sd_event_source_get_child_pidfd_own },
        { "sd_event_source_set_child_pidfd_own", sd_event_source_set_child_pidfd_own },
        { "sd_event_source_get_child_process_own", sd_event_source_get_child_process_own },
        { "sd_event_source_set_child_process_own", sd_event_source_set_child_process_own },
        { "sd_event_source_send_child_signal", sd_event_source_send_child_signal },
        { "sd_event_source_send_child_signal", sd_event_source_send_child_signal },
        { "sd_event_source_get_inotify_mask", sd_event_source_get_inotify_mask },
        { "sd_event_source_get_inotify_path", sd_event_source_get_inotify_path },
        { "sd_event_source_set_memory_pressure_type", sd_event_source_set_memory_pressure_type },
        { "sd_event_source_set_memory_pressure_period", sd_event_source_set_memory_pressure_period },
        { "sd_event_source_set_destroy_callback", sd_event_source_set_destroy_callback },
        { "sd_event_source_get_destroy_callback", sd_event_source_get_destroy_callback },
        { "sd_event_source_get_floating", sd_event_source_get_floating },
        { "sd_event_source_set_floating", sd_event_source_set_floating },
        { "sd_event_source_get_exit_on_failure", sd_event_source_get_exit_on_failure },
        { "sd_event_source_set_exit_on_failure", sd_event_source_set_exit_on_failure },
        { "sd_event_source_set_ratelimit", sd_event_source_set_ratelimit },
        { "sd_event_source_get_ratelimit", sd_event_source_get_ratelimit },
        { "sd_event_source_is_ratelimited", sd_event_source_is_ratelimited },
        { "sd_event_source_set_ratelimit_expire_callback", sd_event_source_set_ratelimit_expire_callback },
        { "sd_event_source_leave_ratelimit", sd_event_source_leave_ratelimit },
        { "sd_event_trim_memory", sd_event_trim_memory },
        { "sd_event_unref", sd_event_unref },
        { "sd_event_source_unref", sd_event_source_unref },
        { "sd_event_source_disable_unref", sd_event_source_disable_unref },
        { "sd_hwdb_ref", sd_hwdb_ref },
        { "sd_hwdb_unref", sd_hwdb_unref },
        { "sd_hwdb_new", sd_hwdb_new },
        { "sd_hwdb_new_from_path", sd_hwdb_new_from_path },
        { "sd_hwdb_get", sd_hwdb_get },
        { "sd_hwdb_seek", sd_hwdb_seek },
        { "sd_hwdb_enumerate", sd_hwdb_enumerate },
        { "sd_hwdb_unref", sd_hwdb_unref },
        { "sd_id128_to_string", sd_id128_to_string },
        { "sd_id128_to_uuid_string", sd_id128_to_uuid_string },
        { "sd_id128_from_string", sd_id128_from_string },
        { "sd_id128_randomize", sd_id128_randomize },
        { "sd_id128_get_machine", sd_id128_get_machine },
        { "sd_id128_get_boot", sd_id128_get_boot },
        { "sd_id128_get_invocation", sd_id128_get_invocation },
        { "sd_id128_get_app_specific", sd_id128_get_app_specific },
        { "sd_id128_get_machine_app_specific", sd_id128_get_machine_app_specific },
        { "sd_id128_get_boot_app_specific", sd_id128_get_boot_app_specific },
        { "sd_id128_get_invocation_app_specific", sd_id128_get_invocation_app_specific },
        { "sd_id128_string_equal", sd_id128_string_equal },
        { "sd_journal_print", sd_journal_print },
        { "sd_journal_printv", sd_journal_printv },
        { "sd_journal_send", sd_journal_send },
        { "sd_journal_sendv", sd_journal_sendv },
        { "sd_journal_perror", sd_journal_perror },
        { "sd_journal_print_with_location", sd_journal_print_with_location },
        { "sd_journal_printv_with_location", sd_journal_printv_with_location },
        { "sd_journal_send_with_location", sd_journal_send_with_location },
        { "sd_journal_sendv_with_location", sd_journal_sendv_with_location },
        { "sd_journal_perror_with_location", sd_journal_perror_with_location },
        { "sd_journal_stream_fd", sd_journal_stream_fd },
        { "sd_journal_stream_fd_with_namespace", sd_journal_stream_fd_with_namespace },
        { "sd_journal_open", sd_journal_open },
        { "sd_journal_open_namespace", sd_journal_open_namespace },
        { "sd_journal_open_directory", sd_journal_open_directory },
        { "sd_journal_open_directory_fd", sd_journal_open_directory_fd },
        { "sd_journal_open_files", sd_journal_open_files },
        { "sd_journal_open_files_fd", sd_journal_open_files_fd },
        { "sd_journal_open_container", sd_journal_open_container },
        { "sd_journal_close", sd_journal_close },
        { "sd_journal_previous", sd_journal_previous },
        { "sd_journal_next", sd_journal_next },
        { "sd_journal_step_one", sd_journal_step_one },
        { "sd_journal_previous_skip", sd_journal_previous_skip },
        { "sd_journal_next_skip", sd_journal_next_skip },
        { "sd_journal_get_realtime_usec", sd_journal_get_realtime_usec },
        { "sd_journal_get_monotonic_usec", sd_journal_get_monotonic_usec },
        { "sd_journal_get_seqnum", sd_journal_get_seqnum },
        { "sd_journal_set_data_threshold", sd_journal_set_data_threshold },
        { "sd_journal_get_data_threshold", sd_journal_get_data_threshold },
        { "sd_journal_get_data", sd_journal_get_data },
        { "sd_journal_enumerate_data", sd_journal_enumerate_data },
        { "sd_journal_enumerate_available_data", sd_journal_enumerate_available_data },
        { "sd_journal_restart_data", sd_journal_restart_data },
        { "sd_journal_add_match", sd_journal_add_match },
        { "sd_journal_add_disjunction", sd_journal_add_disjunction },
        { "sd_journal_add_conjunction", sd_journal_add_conjunction },
        { "sd_journal_flush_matches", sd_journal_flush_matches },
        { "sd_journal_seek_head", sd_journal_seek_head },
        { "sd_journal_seek_tail", sd_journal_seek_tail },
        { "sd_journal_seek_monotonic_usec", sd_journal_seek_monotonic_usec },
        { "sd_journal_seek_realtime_usec", sd_journal_seek_realtime_usec },
        { "sd_journal_seek_cursor", sd_journal_seek_cursor },
        { "sd_journal_get_cursor", sd_journal_get_cursor },
        { "sd_journal_test_cursor", sd_journal_test_cursor },
        { "sd_journal_get_cutoff_realtime_usec", sd_journal_get_cutoff_realtime_usec },
        { "sd_journal_get_cutoff_monotonic_usec", sd_journal_get_cutoff_monotonic_usec },
        { "sd_journal_get_usage", sd_journal_get_usage },
        { "sd_journal_query_unique", sd_journal_query_unique },
        { "sd_journal_enumerate_unique", sd_journal_enumerate_unique },
        { "sd_journal_enumerate_available_unique", sd_journal_enumerate_available_unique },
        { "sd_journal_restart_unique", sd_journal_restart_unique },
        { "sd_journal_enumerate_fields", sd_journal_enumerate_fields },
        { "sd_journal_restart_fields", sd_journal_restart_fields },
        { "sd_journal_get_fd", sd_journal_get_fd },
        { "sd_journal_get_events", sd_journal_get_events },
        { "sd_journal_get_timeout", sd_journal_get_timeout },
        { "sd_journal_process", sd_journal_process },
        { "sd_journal_wait", sd_journal_wait },
        { "sd_journal_reliable_fd", sd_journal_reliable_fd },
        { "sd_journal_get_catalog", sd_journal_get_catalog },
        { "sd_journal_get_catalog_for_message_id", sd_journal_get_catalog_for_message_id },
        { "sd_journal_has_runtime_files", sd_journal_has_runtime_files },
        { "sd_journal_has_persistent_files", sd_journal_has_persistent_files },
        { "sd_journal_close", sd_journal_close },
        { "sd_json_variant_new_string", sd_json_variant_new_string },
        { "sd_json_variant_new_stringn", sd_json_variant_new_stringn },
        { "sd_json_variant_new_base64", sd_json_variant_new_base64 },
        { "sd_json_variant_new_base32hex", sd_json_variant_new_base32hex },
        { "sd_json_variant_new_hex", sd_json_variant_new_hex },
        { "sd_json_variant_new_octescape", sd_json_variant_new_octescape },
        { "sd_json_variant_new_integer", sd_json_variant_new_integer },
        { "sd_json_variant_new_unsigned", sd_json_variant_new_unsigned },
        { "sd_json_variant_new_real", sd_json_variant_new_real },
        { "sd_json_variant_new_boolean", sd_json_variant_new_boolean },
        { "sd_json_variant_new_array", sd_json_variant_new_array },
        { "sd_json_variant_new_array_bytes", sd_json_variant_new_array_bytes },
        { "sd_json_variant_new_array_strv", sd_json_variant_new_array_strv },
        { "sd_json_variant_new_object", sd_json_variant_new_object },
        { "sd_json_variant_new_null", sd_json_variant_new_null },
        { "sd_json_variant_new_id128", sd_json_variant_new_id128 },
        { "sd_json_variant_new_uuid", sd_json_variant_new_uuid },
        { "sd_json_variant_ref", sd_json_variant_ref },
        { "sd_json_variant_unref", sd_json_variant_unref },
        { "sd_json_variant_unref_many", sd_json_variant_unref_many },
        { "sd_json_variant_unref", sd_json_variant_unref },
        { "sd_json_variant_string", sd_json_variant_string },
        { "sd_json_variant_integer", sd_json_variant_integer },
        { "sd_json_variant_unsigned", sd_json_variant_unsigned },
        { "sd_json_variant_real", sd_json_variant_real },
        { "sd_json_variant_boolean", sd_json_variant_boolean },
        { "sd_json_variant_type", sd_json_variant_type },
        { "sd_json_variant_has_type", sd_json_variant_has_type },
        { "sd_json_variant_is_string", sd_json_variant_is_string },
        { "sd_json_variant_is_integer", sd_json_variant_is_integer },
        { "sd_json_variant_is_unsigned", sd_json_variant_is_unsigned },
        { "sd_json_variant_is_real", sd_json_variant_is_real },
        { "sd_json_variant_is_number", sd_json_variant_is_number },
        { "sd_json_variant_is_boolean", sd_json_variant_is_boolean },
        { "sd_json_variant_is_array", sd_json_variant_is_array },
        { "sd_json_variant_is_object", sd_json_variant_is_object },
        { "sd_json_variant_is_null", sd_json_variant_is_null },
        { "sd_json_variant_is_negative", sd_json_variant_is_negative },
        { "sd_json_variant_is_blank_object", sd_json_variant_is_blank_object },
        { "sd_json_variant_is_blank_array", sd_json_variant_is_blank_array },
        { "sd_json_variant_is_normalized", sd_json_variant_is_normalized },
        { "sd_json_variant_is_sorted", sd_json_variant_is_sorted },
        { "sd_json_variant_elements", sd_json_variant_elements },
        { "sd_json_variant_by_index", sd_json_variant_by_index },
        { "sd_json_variant_by_key", sd_json_variant_by_key },
        { "sd_json_variant_by_key_full", sd_json_variant_by_key_full },
        { "sd_json_variant_equal", sd_json_variant_equal },
        { "sd_json_variant_sensitive", sd_json_variant_sensitive },
        { "sd_json_variant_is_sensitive", sd_json_variant_is_sensitive },
        { "sd_json_variant_is_sensitive_recursive", sd_json_variant_is_sensitive_recursive },
        { "sd_json_variant_get_source", sd_json_variant_get_source },
        { "sd_json_variant_format", sd_json_variant_format },
        { "sd_json_variant_dump", sd_json_variant_dump },
        { "sd_json_variant_filter", sd_json_variant_filter },
        { "sd_json_variant_set_field", sd_json_variant_set_field },
        { "sd_json_variant_set_fieldb", sd_json_variant_set_fieldb },
        { "sd_json_variant_set_field_string", sd_json_variant_set_field_string },
        { "sd_json_variant_set_field_id128", sd_json_variant_set_field_id128 },
        { "sd_json_variant_set_field_uuid", sd_json_variant_set_field_uuid },
        { "sd_json_variant_set_field_integer", sd_json_variant_set_field_integer },
        { "sd_json_variant_set_field_unsigned", sd_json_variant_set_field_unsigned },
        { "sd_json_variant_set_field_boolean", sd_json_variant_set_field_boolean },
        { "sd_json_variant_set_field_strv", sd_json_variant_set_field_strv },
        { "sd_json_variant_find", sd_json_variant_find },
        { "sd_json_variant_append_array", sd_json_variant_append_array },
        { "sd_json_variant_append_arrayb", sd_json_variant_append_arrayb },
        { "sd_json_variant_append_array_nodup", sd_json_variant_append_array_nodup },
        { "sd_json_variant_merge_object", sd_json_variant_merge_object },
        { "sd_json_variant_merge_objectb", sd_json_variant_merge_objectb },
        { "sd_json_variant_sort", sd_json_variant_sort },
        { "sd_json_variant_normalize", sd_json_variant_normalize },
        { "sd_json_parse_with_source", sd_json_parse_with_source },
        { "sd_json_parse_with_source_continue", sd_json_parse_with_source_continue },
        { "sd_json_parse", sd_json_parse },
        { "sd_json_parse_continue", sd_json_parse_continue },
        { "sd_json_parse_file_at", sd_json_parse_file_at },
        { "sd_json_parse_file", sd_json_parse_file },
        { "sd_json_build", sd_json_build },
        { "sd_json_buildv", sd_json_buildv },
        { "sd_json_dispatch_full", sd_json_dispatch_full },
        { "sd_json_dispatch", sd_json_dispatch },
        { "sd_json_dispatch_string", sd_json_dispatch_string },
        { "sd_json_dispatch_const_string", sd_json_dispatch_const_string },
        { "sd_json_dispatch_strv", sd_json_dispatch_strv },
        { "sd_json_dispatch_stdbool", sd_json_dispatch_stdbool },
        { "sd_json_dispatch_intbool", sd_json_dispatch_intbool },
        { "sd_json_dispatch_tristate", sd_json_dispatch_tristate },
        { "sd_json_dispatch_variant", sd_json_dispatch_variant },
        { "sd_json_dispatch_variant_noref", sd_json_dispatch_variant_noref },
        { "sd_json_dispatch_int64", sd_json_dispatch_int64 },
        { "sd_json_dispatch_uint64", sd_json_dispatch_uint64 },
        { "sd_json_dispatch_uint32", sd_json_dispatch_uint32 },
        { "sd_json_dispatch_int32", sd_json_dispatch_int32 },
        { "sd_json_dispatch_uint16", sd_json_dispatch_uint16 },
        { "sd_json_dispatch_int16", sd_json_dispatch_int16 },
        { "sd_json_dispatch_int8", sd_json_dispatch_int8 },
        { "sd_json_dispatch_uint8", sd_json_dispatch_uint8 },
        { "sd_json_dispatch_double", sd_json_dispatch_double },
        { "sd_json_dispatch_uid_gid", sd_json_dispatch_uid_gid },
        { "sd_json_dispatch_id128", sd_json_dispatch_id128 },
        { "sd_json_dispatch_signal", sd_json_dispatch_signal },
        { "sd_json_dispatch_unsupported", sd_json_dispatch_unsupported },
        { "sd_json_variant_strv", sd_json_variant_strv },
        { "sd_json_variant_unbase64", sd_json_variant_unbase64 },
        { "sd_json_variant_unhex", sd_json_variant_unhex },
        { "sd_json_variant_type_to_string", sd_json_variant_type_to_string },
        { "sd_json_variant_type_from_string", sd_json_variant_type_from_string },
        { "sd_pid_get_session", sd_pid_get_session },
        { "sd_pid_get_owner_uid", sd_pid_get_owner_uid },
        { "sd_pid_get_unit", sd_pid_get_unit },
        { "sd_pid_get_user_unit", sd_pid_get_user_unit },
        { "sd_pid_get_slice", sd_pid_get_slice },
        { "sd_pid_get_user_slice", sd_pid_get_user_slice },
        { "sd_pid_get_machine_name", sd_pid_get_machine_name },
        { "sd_pid_get_cgroup", sd_pid_get_cgroup },
        { "sd_pidfd_get_session", sd_pidfd_get_session },
        { "sd_pidfd_get_owner_uid", sd_pidfd_get_owner_uid },
        { "sd_pidfd_get_unit", sd_pidfd_get_unit },
        { "sd_pidfd_get_user_unit", sd_pidfd_get_user_unit },
        { "sd_pidfd_get_slice", sd_pidfd_get_slice },
        { "sd_pidfd_get_user_slice", sd_pidfd_get_user_slice },
        { "sd_pidfd_get_machine_name", sd_pidfd_get_machine_name },
        { "sd_pidfd_get_cgroup", sd_pidfd_get_cgroup },
        { "sd_peer_get_session", sd_peer_get_session },
        { "sd_peer_get_owner_uid", sd_peer_get_owner_uid },
        { "sd_peer_get_unit", sd_peer_get_unit },
        { "sd_peer_get_user_unit", sd_peer_get_user_unit },
        { "sd_peer_get_slice", sd_peer_get_slice },
        { "sd_peer_get_user_slice", sd_peer_get_user_slice },
        { "sd_peer_get_machine_name", sd_peer_get_machine_name },
        { "sd_peer_get_cgroup", sd_peer_get_cgroup },
        { "sd_uid_get_state", sd_uid_get_state },
        { "sd_uid_get_display", sd_uid_get_display },
        { "sd_uid_get_login_time", sd_uid_get_login_time },
        { "sd_uid_is_on_seat", sd_uid_is_on_seat },
        { "sd_uid_get_sessions", sd_uid_get_sessions },
        { "sd_uid_get_seats", sd_uid_get_seats },
        { "sd_session_is_active", sd_session_is_active },
        { "sd_session_is_remote", sd_session_is_remote },
        { "sd_session_get_state", sd_session_get_state },
        { "sd_session_get_uid", sd_session_get_uid },
        { "sd_session_get_username", sd_session_get_username },
        { "sd_session_get_seat", sd_session_get_seat },
        { "sd_session_get_start_time", sd_session_get_start_time },
        { "sd_session_get_service", sd_session_get_service },
        { "sd_session_get_type", sd_session_get_type },
        { "sd_session_get_class", sd_session_get_class },
        { "sd_session_get_desktop", sd_session_get_desktop },
        { "sd_session_get_display", sd_session_get_display },
        { "sd_session_get_leader", sd_session_get_leader },
        { "sd_session_get_remote_host", sd_session_get_remote_host },
        { "sd_session_get_remote_user", sd_session_get_remote_user },
        { "sd_session_get_tty", sd_session_get_tty },
        { "sd_session_get_vt", sd_session_get_vt },
        { "sd_seat_get_active", sd_seat_get_active },
        { "sd_seat_get_sessions", sd_seat_get_sessions },
        { "sd_seat_can_multi_session", sd_seat_can_multi_session },
        { "sd_seat_can_tty", sd_seat_can_tty },
        { "sd_seat_can_graphical", sd_seat_can_graphical },
        { "sd_machine_get_class", sd_machine_get_class },
        { "sd_machine_get_ifindices", sd_machine_get_ifindices },
        { "sd_get_seats", sd_get_seats },
        { "sd_get_sessions", sd_get_sessions },
        { "sd_get_uids", sd_get_uids },
        { "sd_get_machine_names", sd_get_machine_names },
        { "sd_login_monitor_new", sd_login_monitor_new },
        { "sd_login_monitor_unref", sd_login_monitor_unref },
        { "sd_login_monitor_flush", sd_login_monitor_flush },
        { "sd_login_monitor_get_fd", sd_login_monitor_get_fd },
        { "sd_login_monitor_get_events", sd_login_monitor_get_events },
        { "sd_login_monitor_get_timeout", sd_login_monitor_get_timeout },
        { "sd_login_monitor_unref", sd_login_monitor_unref },
        { "sd_path_lookup", sd_path_lookup },
        { "sd_path_lookup_strv", sd_path_lookup_strv },
        { "sd_varlink_connect_address", sd_varlink_connect_address },
        { "sd_varlink_connect_exec", sd_varlink_connect_exec },
        { "sd_varlink_connect_url", sd_varlink_connect_url },
        { "sd_varlink_connect_fd", sd_varlink_connect_fd },
        { "sd_varlink_connect_fd_pair", sd_varlink_connect_fd_pair },
        { "sd_varlink_ref", sd_varlink_ref },
        { "sd_varlink_unref", sd_varlink_unref },
        { "sd_varlink_get_fd", sd_varlink_get_fd },
        { "sd_varlink_get_input_fd", sd_varlink_get_input_fd },
        { "sd_varlink_get_output_fd", sd_varlink_get_output_fd },
        { "sd_varlink_get_events", sd_varlink_get_events },
        { "sd_varlink_get_timeout", sd_varlink_get_timeout },
        { "sd_varlink_attach_event", sd_varlink_attach_event },
        { "sd_varlink_detach_event", sd_varlink_detach_event },
        { "sd_varlink_get_event", sd_varlink_get_event },
        { "sd_varlink_process", sd_varlink_process },
        { "sd_varlink_wait", sd_varlink_wait },
        { "sd_varlink_is_idle", sd_varlink_is_idle },
        { "sd_varlink_flush", sd_varlink_flush },
        { "sd_varlink_close", sd_varlink_close },
        { "sd_varlink_flush_close_unref", sd_varlink_flush_close_unref },
        { "sd_varlink_close_unref", sd_varlink_close_unref },
        { "sd_varlink_send", sd_varlink_send },
        { "sd_varlink_sendb", sd_varlink_sendb },
        { "sd_varlink_call_full", sd_varlink_call_full },
        { "sd_varlink_call", sd_varlink_call },
        { "sd_varlink_callb_ap", sd_varlink_callb_ap },
        { "sd_varlink_callb_full", sd_varlink_callb_full },
        { "sd_varlink_callb", sd_varlink_callb },
        { "sd_varlink_collect_full", sd_varlink_collect_full },
        { "sd_varlink_collect", sd_varlink_collect },
        { "sd_varlink_collectb", sd_varlink_collectb },
        { "sd_varlink_invoke", sd_varlink_invoke },
        { "sd_varlink_invokeb", sd_varlink_invokeb },
        { "sd_varlink_observe", sd_varlink_observe },
        { "sd_varlink_observeb", sd_varlink_observeb },
        { "sd_varlink_reply", sd_varlink_reply },
        { "sd_varlink_replyb", sd_varlink_replyb },
        { "sd_varlink_error", sd_varlink_error },
        { "sd_varlink_errorb", sd_varlink_errorb },
        { "sd_varlink_error_invalid_parameter", sd_varlink_error_invalid_parameter },
        { "sd_varlink_error_invalid_parameter_name", sd_varlink_error_invalid_parameter_name },
        { "sd_varlink_error_errno", sd_varlink_error_errno },
        { "sd_varlink_notify", sd_varlink_notify },
        { "sd_varlink_notifyb", sd_varlink_notifyb },
        { "sd_varlink_dispatch_again", sd_varlink_dispatch_again },
        { "sd_varlink_get_current_method", sd_varlink_get_current_method },
        { "sd_varlink_get_current_parameters", sd_varlink_get_current_parameters },
        { "sd_varlink_dispatch", sd_varlink_dispatch },
        { "sd_varlink_push_fd", sd_varlink_push_fd },
        { "sd_varlink_push_dup_fd", sd_varlink_push_dup_fd },
        { "sd_varlink_reset_fds", sd_varlink_reset_fds },
        { "sd_varlink_peek_fd", sd_varlink_peek_fd },
        { "sd_varlink_peek_dup_fd", sd_varlink_peek_dup_fd },
        { "sd_varlink_take_fd", sd_varlink_take_fd },
        { "sd_varlink_get_n_fds", sd_varlink_get_n_fds },
        { "sd_varlink_set_allow_fd_passing_input", sd_varlink_set_allow_fd_passing_input },
        { "sd_varlink_set_allow_fd_passing_output", sd_varlink_set_allow_fd_passing_output },
        { "sd_varlink_bind_reply", sd_varlink_bind_reply },
        { "sd_varlink_set_userdata", sd_varlink_set_userdata },
        { "sd_varlink_get_userdata", sd_varlink_get_userdata },
        { "sd_varlink_get_peer_uid", sd_varlink_get_peer_uid },
        { "sd_varlink_get_peer_gid", sd_varlink_get_peer_gid },
        { "sd_varlink_get_peer_pid", sd_varlink_get_peer_pid },
        { "sd_varlink_get_peer_pidfd", sd_varlink_get_peer_pidfd },
        { "sd_varlink_set_relative_timeout", sd_varlink_set_relative_timeout },
        { "sd_varlink_get_server", sd_varlink_get_server },
        { "sd_varlink_set_description", sd_varlink_set_description },
        { "sd_varlink_get_description", sd_varlink_get_description },
        { "sd_varlink_set_input_sensitive", sd_varlink_set_input_sensitive },
        { "sd_varlink_server_new", sd_varlink_server_new },
        { "sd_varlink_server_ref", sd_varlink_server_ref },
        { "sd_varlink_server_unref", sd_varlink_server_unref },
        { "sd_varlink_server_set_info", sd_varlink_server_set_info },
        { "sd_varlink_server_listen_address", sd_varlink_server_listen_address },
        { "sd_varlink_server_listen_fd", sd_varlink_server_listen_fd },
        { "sd_varlink_server_listen_auto", sd_varlink_server_listen_auto },
        { "sd_varlink_server_listen_name", sd_varlink_server_listen_name },
        { "sd_varlink_server_add_connection", sd_varlink_server_add_connection },
        { "sd_varlink_server_add_connection_pair", sd_varlink_server_add_connection_pair },
        { "sd_varlink_server_add_connection_stdio", sd_varlink_server_add_connection_stdio },
        { "sd_varlink_server_bind_method", sd_varlink_server_bind_method },
        { "sd_varlink_server_bind_method_many_internal", sd_varlink_server_bind_method_many_internal },
        { "sd_varlink_server_bind_connect", sd_varlink_server_bind_connect },
        { "sd_varlink_server_bind_disconnect", sd_varlink_server_bind_disconnect },
        { "sd_varlink_server_add_interface", sd_varlink_server_add_interface },
        { "sd_varlink_server_add_interface_many_internal", sd_varlink_server_add_interface_many_internal },
        { "sd_varlink_server_set_userdata", sd_varlink_server_set_userdata },
        { "sd_varlink_server_get_userdata", sd_varlink_server_get_userdata },
        { "sd_varlink_server_attach_event", sd_varlink_server_attach_event },
        { "sd_varlink_server_detach_event", sd_varlink_server_detach_event },
        { "sd_varlink_server_get_event", sd_varlink_server_get_event },
        { "sd_varlink_server_loop_auto", sd_varlink_server_loop_auto },
        { "sd_varlink_server_shutdown", sd_varlink_server_shutdown },
        { "sd_varlink_server_set_exit_on_idle", sd_varlink_server_set_exit_on_idle },
        { "sd_varlink_server_connections_max", sd_varlink_server_connections_max },
        { "sd_varlink_server_connections_per_uid_max", sd_varlink_server_connections_per_uid_max },
        { "sd_varlink_server_set_connections_per_uid_max", sd_varlink_server_set_connections_per_uid_max },
        { "sd_varlink_server_set_connections_max", sd_varlink_server_set_connections_max },
        { "sd_varlink_server_current_connections", sd_varlink_server_current_connections },
        { "sd_varlink_server_set_description", sd_varlink_server_set_description },
        { "sd_varlink_invocation", sd_varlink_invocation },
        { "sd_varlink_error_to_errno", sd_varlink_error_to_errno },
        { "sd_varlink_error_is_invalid_parameter", sd_varlink_error_is_invalid_parameter },
        { "sd_varlink_unref", sd_varlink_unref },
        { "sd_varlink_close_unref", sd_varlink_close_unref },
        { "sd_varlink_flush_close_unref", sd_varlink_flush_close_unref },
        { "sd_varlink_server_unref", sd_varlink_server_unref },
        { "sd_varlink_idl_dump", sd_varlink_idl_dump },
        { "sd_varlink_idl_format_full", sd_varlink_idl_format_full },
        { "sd_varlink_idl_format", sd_varlink_idl_format },
        { "sd_varlink_idl_parse", sd_varlink_idl_parse },
        { "sd_varlink_interface_free", sd_varlink_interface_free },
        { "sd_varlink_interface_free", sd_varlink_interface_free },
        {}
}, symbols_from_source[] = {
        { "sd_bus_get_unique_name", sd_bus_get_unique_name },
        { "sd_bus_request_name", sd_bus_request_name },
        { "sd_bus_request_name_async", sd_bus_request_name_async },
        { "sd_bus_release_name", sd_bus_release_name },
        { "sd_bus_release_name_async", sd_bus_release_name_async },
        { "sd_bus_list_names", sd_bus_list_names },
        { "sd_bus_get_name_creds", sd_bus_get_name_creds },
        { "sd_bus_get_owner_creds", sd_bus_get_owner_creds },
        { "sd_bus_get_name_machine_id", sd_bus_get_name_machine_id },
        { "sd_bus_message_send", sd_bus_message_send },
        { "sd_bus_emit_signal_tov", sd_bus_emit_signal_tov },
        { "sd_bus_emit_signal_to", sd_bus_emit_signal_to },
        { "sd_bus_emit_signalv", sd_bus_emit_signalv },
        { "sd_bus_emit_signal", sd_bus_emit_signal },
        { "sd_bus_call_method_asyncv", sd_bus_call_method_asyncv },
        { "sd_bus_call_method_async", sd_bus_call_method_async },
        { "sd_bus_call_methodv", sd_bus_call_methodv },
        { "sd_bus_call_method", sd_bus_call_method },
        { "sd_bus_reply_method_returnv", sd_bus_reply_method_returnv },
        { "sd_bus_reply_method_return", sd_bus_reply_method_return },
        { "sd_bus_reply_method_error", sd_bus_reply_method_error },
        { "sd_bus_reply_method_errorfv", sd_bus_reply_method_errorfv },
        { "sd_bus_reply_method_errorf", sd_bus_reply_method_errorf },
        { "sd_bus_reply_method_errno", sd_bus_reply_method_errno },
        { "sd_bus_reply_method_errnofv", sd_bus_reply_method_errnofv },
        { "sd_bus_reply_method_errnof", sd_bus_reply_method_errnof },
        { "sd_bus_get_property", sd_bus_get_property },
        { "sd_bus_get_property_trivial", sd_bus_get_property_trivial },
        { "sd_bus_get_property_string", sd_bus_get_property_string },
        { "sd_bus_get_property_strv", sd_bus_get_property_strv },
        { "sd_bus_set_propertyv", sd_bus_set_propertyv },
        { "sd_bus_set_property", sd_bus_set_property },
        { "sd_bus_query_sender_creds", sd_bus_query_sender_creds },
        { "sd_bus_query_sender_privilege", sd_bus_query_sender_privilege },
        { "sd_bus_match_signal", sd_bus_match_signal },
        { "sd_bus_match_signal_async", sd_bus_match_signal_async },
        { "sd_bus_creds_ref", sd_bus_creds_ref },
        { "sd_bus_creds_unref", sd_bus_creds_unref },
        { "sd_bus_creds_get_mask", sd_bus_creds_get_mask },
        { "sd_bus_creds_get_augmented_mask", sd_bus_creds_get_augmented_mask },
        { "sd_bus_creds_new_from_pid", sd_bus_creds_new_from_pid },
        { "sd_bus_creds_new_from_pidfd", sd_bus_creds_new_from_pidfd },
        { "sd_bus_creds_get_uid", sd_bus_creds_get_uid },
        { "sd_bus_creds_get_euid", sd_bus_creds_get_euid },
        { "sd_bus_creds_get_suid", sd_bus_creds_get_suid },
        { "sd_bus_creds_get_fsuid", sd_bus_creds_get_fsuid },
        { "sd_bus_creds_get_gid", sd_bus_creds_get_gid },
        { "sd_bus_creds_get_egid", sd_bus_creds_get_egid },
        { "sd_bus_creds_get_sgid", sd_bus_creds_get_sgid },
        { "sd_bus_creds_get_fsgid", sd_bus_creds_get_fsgid },
        { "sd_bus_creds_get_supplementary_gids", sd_bus_creds_get_supplementary_gids },
        { "sd_bus_creds_get_pid", sd_bus_creds_get_pid },
        { "sd_bus_creds_get_pidfd_dup", sd_bus_creds_get_pidfd_dup },
        { "sd_bus_creds_get_ppid", sd_bus_creds_get_ppid },
        { "sd_bus_creds_get_tid", sd_bus_creds_get_tid },
        { "sd_bus_creds_get_selinux_context", sd_bus_creds_get_selinux_context },
        { "sd_bus_creds_get_comm", sd_bus_creds_get_comm },
        { "sd_bus_creds_get_tid_comm", sd_bus_creds_get_tid_comm },
        { "sd_bus_creds_get_exe", sd_bus_creds_get_exe },
        { "sd_bus_creds_get_cgroup", sd_bus_creds_get_cgroup },
        { "sd_bus_creds_get_unit", sd_bus_creds_get_unit },
        { "sd_bus_creds_get_user_unit", sd_bus_creds_get_user_unit },
        { "sd_bus_creds_get_slice", sd_bus_creds_get_slice },
        { "sd_bus_creds_get_user_slice", sd_bus_creds_get_user_slice },
        { "sd_bus_creds_get_session", sd_bus_creds_get_session },
        { "sd_bus_creds_get_owner_uid", sd_bus_creds_get_owner_uid },
        { "sd_bus_creds_get_cmdline", sd_bus_creds_get_cmdline },
        { "sd_bus_creds_get_audit_session_id", sd_bus_creds_get_audit_session_id },
        { "sd_bus_creds_get_audit_login_uid", sd_bus_creds_get_audit_login_uid },
        { "sd_bus_creds_get_tty", sd_bus_creds_get_tty },
        { "sd_bus_creds_get_unique_name", sd_bus_creds_get_unique_name },
        { "sd_bus_creds_get_well_known_names", sd_bus_creds_get_well_known_names },
        { "sd_bus_creds_get_description", sd_bus_creds_get_description },
        { "sd_bus_creds_has_effective_cap", sd_bus_creds_has_effective_cap },
        { "sd_bus_creds_has_permitted_cap", sd_bus_creds_has_permitted_cap },
        { "sd_bus_creds_has_inheritable_cap", sd_bus_creds_has_inheritable_cap },
        { "sd_bus_creds_has_bounding_cap", sd_bus_creds_has_bounding_cap },
        { "sd_bus_message_dump_json", sd_bus_message_dump_json },
        { "sd_bus_message_dump", sd_bus_message_dump },
        { "sd_bus_error_free", sd_bus_error_free },
        { "sd_bus_error_set", sd_bus_error_set },
        { "sd_bus_error_setfv", sd_bus_error_setfv },
        { "sd_bus_error_setf", sd_bus_error_setf },
        { "sd_bus_error_copy", sd_bus_error_copy },
        { "sd_bus_error_move", sd_bus_error_move },
        { "sd_bus_error_set_const", sd_bus_error_set_const },
        { "sd_bus_error_is_set", sd_bus_error_is_set },
        { "sd_bus_error_has_name", sd_bus_error_has_name },
        { "sd_bus_error_has_names_sentinel", sd_bus_error_has_names_sentinel },
        { "sd_bus_error_get_errno", sd_bus_error_get_errno },
        { "sd_bus_error_set_errno", sd_bus_error_set_errno },
        { "sd_bus_error_set_errnofv", sd_bus_error_set_errnofv },
        { "sd_bus_error_set_errnof", sd_bus_error_set_errnof },
        { "sd_bus_error_add_map", sd_bus_error_add_map },
        { "sd_bus_message_new", sd_bus_message_new },
        { "sd_bus_message_new_signal_to", sd_bus_message_new_signal_to },
        { "sd_bus_message_new_signal", sd_bus_message_new_signal },
        { "sd_bus_message_new_method_call", sd_bus_message_new_method_call },
        { "sd_bus_message_new_method_return", sd_bus_message_new_method_return },
        { "sd_bus_message_new_method_error", sd_bus_message_new_method_error },
        { "sd_bus_message_new_method_errorf", sd_bus_message_new_method_errorf },
        { "sd_bus_message_new_method_errno", sd_bus_message_new_method_errno },
        { "sd_bus_message_new_method_errnof", sd_bus_message_new_method_errnof },
        { "sd_bus_message_ref", sd_bus_message_ref },
        { "sd_bus_message_unref", sd_bus_message_unref },
        { "sd_bus_message_get_type", sd_bus_message_get_type },
        { "sd_bus_message_get_cookie", sd_bus_message_get_cookie },
        { "sd_bus_message_get_reply_cookie", sd_bus_message_get_reply_cookie },
        { "sd_bus_message_get_expect_reply", sd_bus_message_get_expect_reply },
        { "sd_bus_message_get_auto_start", sd_bus_message_get_auto_start },
        { "sd_bus_message_get_allow_interactive_authorization", sd_bus_message_get_allow_interactive_authorization },
        { "sd_bus_message_get_path", sd_bus_message_get_path },
        { "sd_bus_message_get_interface", sd_bus_message_get_interface },
        { "sd_bus_message_get_member", sd_bus_message_get_member },
        { "sd_bus_message_get_destination", sd_bus_message_get_destination },
        { "sd_bus_message_get_sender", sd_bus_message_get_sender },
        { "sd_bus_message_get_error", sd_bus_message_get_error },
        { "sd_bus_message_get_monotonic_usec", sd_bus_message_get_monotonic_usec },
        { "sd_bus_message_get_realtime_usec", sd_bus_message_get_realtime_usec },
        { "sd_bus_message_get_seqnum", sd_bus_message_get_seqnum },
        { "sd_bus_message_get_creds", sd_bus_message_get_creds },
        { "sd_bus_message_is_signal", sd_bus_message_is_signal },
        { "sd_bus_message_is_method_call", sd_bus_message_is_method_call },
        { "sd_bus_message_is_method_error", sd_bus_message_is_method_error },
        { "sd_bus_message_set_expect_reply", sd_bus_message_set_expect_reply },
        { "sd_bus_message_set_auto_start", sd_bus_message_set_auto_start },
        { "sd_bus_message_set_allow_interactive_authorization", sd_bus_message_set_allow_interactive_authorization },
        { "sd_bus_message_append_basic", sd_bus_message_append_basic },
        { "sd_bus_message_append_string_space", sd_bus_message_append_string_space },
        { "sd_bus_message_append_string_iovec", sd_bus_message_append_string_iovec },
        { "sd_bus_message_open_container", sd_bus_message_open_container },
        { "sd_bus_message_close_container", sd_bus_message_close_container },
        { "sd_bus_message_appendv", sd_bus_message_appendv },
        { "sd_bus_message_append", sd_bus_message_append },
        { "sd_bus_message_append_array_space", sd_bus_message_append_array_space },
        { "sd_bus_message_append_array", sd_bus_message_append_array },
        { "sd_bus_message_append_array_iovec", sd_bus_message_append_array_iovec },
        { "sd_bus_message_append_array_memfd", sd_bus_message_append_array_memfd },
        { "sd_bus_message_append_string_memfd", sd_bus_message_append_string_memfd },
        { "sd_bus_message_append_strv", sd_bus_message_append_strv },
        { "sd_bus_message_seal", sd_bus_message_seal },
        { "sd_bus_message_at_end", sd_bus_message_at_end },
        { "sd_bus_message_read_basic", sd_bus_message_read_basic },
        { "sd_bus_message_enter_container", sd_bus_message_enter_container },
        { "sd_bus_message_exit_container", sd_bus_message_exit_container },
        { "sd_bus_message_peek_type", sd_bus_message_peek_type },
        { "sd_bus_message_rewind", sd_bus_message_rewind },
        { "sd_bus_message_readv", sd_bus_message_readv },
        { "sd_bus_message_read", sd_bus_message_read },
        { "sd_bus_message_skip", sd_bus_message_skip },
        { "sd_bus_message_read_array", sd_bus_message_read_array },
        { "sd_bus_message_set_destination", sd_bus_message_set_destination },
        { "sd_bus_message_set_sender", sd_bus_message_set_sender },
        { "sd_bus_message_read_strv_extend", sd_bus_message_read_strv_extend },
        { "sd_bus_message_read_strv", sd_bus_message_read_strv },
        { "sd_bus_message_get_errno", sd_bus_message_get_errno },
        { "sd_bus_message_get_signature", sd_bus_message_get_signature },
        { "sd_bus_message_is_empty", sd_bus_message_is_empty },
        { "sd_bus_message_has_signature", sd_bus_message_has_signature },
        { "sd_bus_message_copy", sd_bus_message_copy },
        { "sd_bus_message_verify_type", sd_bus_message_verify_type },
        { "sd_bus_message_get_bus", sd_bus_message_get_bus },
        { "sd_bus_message_get_priority", sd_bus_message_get_priority },
        { "sd_bus_message_set_priority", sd_bus_message_set_priority },
        { "sd_bus_message_sensitive", sd_bus_message_sensitive },
        { "sd_bus_add_object", sd_bus_add_object },
        { "sd_bus_add_fallback", sd_bus_add_fallback },
        { "sd_bus_object_vtable_format", &sd_bus_object_vtable_format },
        { "sd_bus_add_object_vtable", sd_bus_add_object_vtable },
        { "sd_bus_add_fallback_vtable", sd_bus_add_fallback_vtable },
        { "sd_bus_add_node_enumerator", sd_bus_add_node_enumerator },
        { "sd_bus_emit_properties_changed_strv", sd_bus_emit_properties_changed_strv },
        { "sd_bus_emit_properties_changed", sd_bus_emit_properties_changed },
        { "sd_bus_emit_object_added", sd_bus_emit_object_added },
        { "sd_bus_emit_object_removed", sd_bus_emit_object_removed },
        { "sd_bus_emit_interfaces_added_strv", sd_bus_emit_interfaces_added_strv },
        { "sd_bus_emit_interfaces_added", sd_bus_emit_interfaces_added },
        { "sd_bus_emit_interfaces_removed_strv", sd_bus_emit_interfaces_removed_strv },
        { "sd_bus_emit_interfaces_removed", sd_bus_emit_interfaces_removed },
        { "sd_bus_add_object_manager", sd_bus_add_object_manager },
        { "sd_bus_slot_ref", sd_bus_slot_ref },
        { "sd_bus_slot_unref", sd_bus_slot_unref },
        { "sd_bus_slot_get_bus", sd_bus_slot_get_bus },
        { "sd_bus_slot_get_userdata", sd_bus_slot_get_userdata },
        { "sd_bus_slot_set_userdata", sd_bus_slot_set_userdata },
        { "sd_bus_slot_set_destroy_callback", sd_bus_slot_set_destroy_callback },
        { "sd_bus_slot_get_destroy_callback", sd_bus_slot_get_destroy_callback },
        { "sd_bus_slot_get_current_message", sd_bus_slot_get_current_message },
        { "sd_bus_slot_get_current_handler", sd_bus_slot_get_current_handler },
        { "sd_bus_slot_get_current_userdata", sd_bus_slot_get_current_userdata },
        { "sd_bus_slot_get_floating", sd_bus_slot_get_floating },
        { "sd_bus_slot_set_floating", sd_bus_slot_set_floating },
        { "sd_bus_slot_set_description", sd_bus_slot_set_description },
        { "sd_bus_slot_get_description", sd_bus_slot_get_description },
        { "sd_bus_track_new", sd_bus_track_new },
        { "sd_bus_track_ref", sd_bus_track_ref },
        { "sd_bus_track_unref", sd_bus_track_unref },
        { "sd_bus_track_add_name", sd_bus_track_add_name },
        { "sd_bus_track_remove_name", sd_bus_track_remove_name },
        { "sd_bus_track_count", sd_bus_track_count },
        { "sd_bus_track_contains", sd_bus_track_contains },
        { "sd_bus_track_first", sd_bus_track_first },
        { "sd_bus_track_next", sd_bus_track_next },
        { "sd_bus_track_add_sender", sd_bus_track_add_sender },
        { "sd_bus_track_remove_sender", sd_bus_track_remove_sender },
        { "sd_bus_track_get_bus", sd_bus_track_get_bus },
        { "sd_bus_track_get_userdata", sd_bus_track_get_userdata },
        { "sd_bus_track_set_userdata", sd_bus_track_set_userdata },
        { "sd_bus_track_set_destroy_callback", sd_bus_track_set_destroy_callback },
        { "sd_bus_track_get_destroy_callback", sd_bus_track_get_destroy_callback },
        { "sd_bus_track_set_recursive", sd_bus_track_set_recursive },
        { "sd_bus_track_get_recursive", sd_bus_track_get_recursive },
        { "sd_bus_track_count_sender", sd_bus_track_count_sender },
        { "sd_bus_track_count_name", sd_bus_track_count_name },
        { "sd_bus_interface_name_is_valid", sd_bus_interface_name_is_valid },
        { "sd_bus_service_name_is_valid", sd_bus_service_name_is_valid },
        { "sd_bus_member_name_is_valid", sd_bus_member_name_is_valid },
        { "sd_bus_object_path_is_valid", sd_bus_object_path_is_valid },
        { "sd_bus_new", sd_bus_new },
        { "sd_bus_set_address", sd_bus_set_address },
        { "sd_bus_set_fd", sd_bus_set_fd },
        { "sd_bus_set_exec", sd_bus_set_exec },
        { "sd_bus_set_bus_client", sd_bus_set_bus_client },
        { "sd_bus_set_monitor", sd_bus_set_monitor },
        { "sd_bus_negotiate_fds", sd_bus_negotiate_fds },
        { "sd_bus_negotiate_timestamp", sd_bus_negotiate_timestamp },
        { "sd_bus_negotiate_creds", sd_bus_negotiate_creds },
        { "sd_bus_set_server", sd_bus_set_server },
        { "sd_bus_set_anonymous", sd_bus_set_anonymous },
        { "sd_bus_set_trusted", sd_bus_set_trusted },
        { "sd_bus_set_description", sd_bus_set_description },
        { "sd_bus_set_allow_interactive_authorization", sd_bus_set_allow_interactive_authorization },
        { "sd_bus_get_allow_interactive_authorization", sd_bus_get_allow_interactive_authorization },
        { "sd_bus_set_watch_bind", sd_bus_set_watch_bind },
        { "sd_bus_get_watch_bind", sd_bus_get_watch_bind },
        { "sd_bus_set_connected_signal", sd_bus_set_connected_signal },
        { "sd_bus_get_connected_signal", sd_bus_get_connected_signal },
        { "sd_bus_start", sd_bus_start },
        { "sd_bus_open_with_description", sd_bus_open_with_description },
        { "sd_bus_open", sd_bus_open },
        { "sd_bus_open_system_with_description", sd_bus_open_system_with_description },
        { "sd_bus_open_system", sd_bus_open_system },
        { "sd_bus_open_user_with_description", sd_bus_open_user_with_description },
        { "sd_bus_open_user", sd_bus_open_user },
        { "sd_bus_open_system_remote", sd_bus_open_system_remote },
        { "sd_bus_open_system_machine", sd_bus_open_system_machine },
        { "sd_bus_open_user_machine", sd_bus_open_user_machine },
        { "sd_bus_close", sd_bus_close },
        { "sd_bus_close_unref", sd_bus_close_unref },
        { "sd_bus_flush_close_unref", sd_bus_flush_close_unref },
        { "sd_bus_ref", sd_bus_ref },
        { "sd_bus_unref", sd_bus_unref },
        { "sd_bus_is_open", sd_bus_is_open },
        { "sd_bus_is_ready", sd_bus_is_ready },
        { "sd_bus_can_send", sd_bus_can_send },
        { "sd_bus_get_bus_id", sd_bus_get_bus_id },
        { "sd_bus_send", sd_bus_send },
        { "sd_bus_send_to", sd_bus_send_to },
        { "sd_bus_call_async", sd_bus_call_async },
        { "sd_bus_call", sd_bus_call },
        { "sd_bus_get_fd", sd_bus_get_fd },
        { "sd_bus_get_events", sd_bus_get_events },
        { "sd_bus_get_timeout", sd_bus_get_timeout },
        { "sd_bus_process", sd_bus_process },
        { "sd_bus_process_priority", sd_bus_process_priority },
        { "sd_bus_wait", sd_bus_wait },
        { "sd_bus_flush", sd_bus_flush },
        { "sd_bus_add_filter", sd_bus_add_filter },
        { "sd_bus_add_match", sd_bus_add_match },
        { "sd_bus_add_match_async", sd_bus_add_match_async },
        { "sd_bus_attach_event", sd_bus_attach_event },
        { "sd_bus_detach_event", sd_bus_detach_event },
        { "sd_bus_get_event", sd_bus_get_event },
        { "sd_bus_get_current_message", sd_bus_get_current_message },
        { "sd_bus_get_current_slot", sd_bus_get_current_slot },
        { "sd_bus_get_current_handler", sd_bus_get_current_handler },
        { "sd_bus_get_current_userdata", sd_bus_get_current_userdata },
        { "sd_bus_default_system", sd_bus_default_system },
        { "sd_bus_default_user", sd_bus_default_user },
        { "sd_bus_default", sd_bus_default },
        { "sd_bus_get_tid", sd_bus_get_tid },
        { "sd_bus_path_encode", sd_bus_path_encode },
        { "sd_bus_path_decode", sd_bus_path_decode },
        { "sd_bus_path_encode_many", sd_bus_path_encode_many },
        { "sd_bus_path_decode_many", sd_bus_path_decode_many },
        { "sd_bus_try_close", sd_bus_try_close },
        { "sd_bus_get_description", sd_bus_get_description },
        { "sd_bus_get_scope", sd_bus_get_scope },
        { "sd_bus_get_address", sd_bus_get_address },
        { "sd_bus_get_creds_mask", sd_bus_get_creds_mask },
        { "sd_bus_is_bus_client", sd_bus_is_bus_client },
        { "sd_bus_is_server", sd_bus_is_server },
        { "sd_bus_is_anonymous", sd_bus_is_anonymous },
        { "sd_bus_is_trusted", sd_bus_is_trusted },
        { "sd_bus_is_monitor", sd_bus_is_monitor },
        { "sd_bus_default_flush_close", sd_bus_default_flush_close },
        { "sd_bus_set_exit_on_disconnect", sd_bus_set_exit_on_disconnect },
        { "sd_bus_get_exit_on_disconnect", sd_bus_get_exit_on_disconnect },
        { "sd_bus_set_sender", sd_bus_set_sender },
        { "sd_bus_get_sender", sd_bus_get_sender },
        { "sd_bus_get_n_queued_read", sd_bus_get_n_queued_read },
        { "sd_bus_get_n_queued_write", sd_bus_get_n_queued_write },
        { "sd_bus_set_method_call_timeout", sd_bus_set_method_call_timeout },
        { "sd_bus_get_method_call_timeout", sd_bus_get_method_call_timeout },
        { "sd_bus_set_close_on_exit", sd_bus_set_close_on_exit },
        { "sd_bus_get_close_on_exit", sd_bus_get_close_on_exit },
        { "sd_bus_enqueue_for_read", sd_bus_enqueue_for_read },
        { "sd_bus_pending_method_calls", sd_bus_pending_method_calls },
        { "sd_listen_fds", sd_listen_fds },
        { "sd_listen_fds_with_names", sd_listen_fds_with_names },
        { "sd_is_fifo", sd_is_fifo },
        { "sd_is_special", sd_is_special },
        { "sd_is_socket", sd_is_socket },
        { "sd_is_socket_inet", sd_is_socket_inet },
        { "sd_is_socket_sockaddr", sd_is_socket_sockaddr },
        { "sd_is_socket_unix", sd_is_socket_unix },
        { "sd_is_mq", sd_is_mq },
        { "sd_pid_notify_with_fds", sd_pid_notify_with_fds },
        { "sd_pid_notify_barrier", sd_pid_notify_barrier },
        { "sd_notify_barrier", sd_notify_barrier },
        { "sd_pid_notify", sd_pid_notify },
        { "sd_notify", sd_notify },
        { "sd_pid_notifyf", sd_pid_notifyf },
        { "sd_notifyf", sd_notifyf },
        { "sd_pid_notifyf_with_fds", sd_pid_notifyf_with_fds },
        { "sd_pidfd_get_inode_id", sd_pidfd_get_inode_id },
        { "sd_booted", sd_booted },
        { "sd_watchdog_enabled", sd_watchdog_enabled },
        { "sd_device_enumerator_new", sd_device_enumerator_new },
        { "sd_device_enumerator_ref", sd_device_enumerator_ref },
        { "sd_device_enumerator_unref", sd_device_enumerator_unref },
        { "sd_device_enumerator_add_match_subsystem", sd_device_enumerator_add_match_subsystem },
        { "sd_device_enumerator_add_match_sysattr", sd_device_enumerator_add_match_sysattr },
        { "sd_device_enumerator_add_match_property", sd_device_enumerator_add_match_property },
        { "sd_device_enumerator_add_match_property_required", sd_device_enumerator_add_match_property_required },
        { "sd_device_enumerator_add_match_sysname", sd_device_enumerator_add_match_sysname },
        { "sd_device_enumerator_add_nomatch_sysname", sd_device_enumerator_add_nomatch_sysname },
        { "sd_device_enumerator_add_match_tag", sd_device_enumerator_add_match_tag },
        { "sd_device_enumerator_add_match_parent", sd_device_enumerator_add_match_parent },
        { "sd_device_enumerator_allow_uninitialized", sd_device_enumerator_allow_uninitialized },
        { "sd_device_enumerator_add_all_parents", sd_device_enumerator_add_all_parents },
        { "sd_device_enumerator_get_device_first", sd_device_enumerator_get_device_first },
        { "sd_device_enumerator_get_device_next", sd_device_enumerator_get_device_next },
        { "sd_device_enumerator_get_subsystem_first", sd_device_enumerator_get_subsystem_first },
        { "sd_device_enumerator_get_subsystem_next", sd_device_enumerator_get_subsystem_next },
        { "sd_device_monitor_set_receive_buffer_size", sd_device_monitor_set_receive_buffer_size },
        { "sd_device_monitor_get_fd", sd_device_monitor_get_fd },
        { "sd_device_monitor_get_events", sd_device_monitor_get_events },
        { "sd_device_monitor_get_timeout", sd_device_monitor_get_timeout },
        { "sd_device_monitor_new", sd_device_monitor_new },
        { "sd_device_monitor_is_running", sd_device_monitor_is_running },
        { "sd_device_monitor_stop", sd_device_monitor_stop },
        { "sd_device_monitor_start", sd_device_monitor_start },
        { "sd_device_monitor_detach_event", sd_device_monitor_detach_event },
        { "sd_device_monitor_attach_event", sd_device_monitor_attach_event },
        { "sd_device_monitor_get_event", sd_device_monitor_get_event },
        { "sd_device_monitor_get_event_source", sd_device_monitor_get_event_source },
        { "sd_device_monitor_set_description", sd_device_monitor_set_description },
        { "sd_device_monitor_get_description", sd_device_monitor_get_description },
        { "sd_device_monitor_ref", sd_device_monitor_ref },
        { "sd_device_monitor_unref", sd_device_monitor_unref },
        { "sd_device_monitor_receive", sd_device_monitor_receive },
        { "sd_device_monitor_filter_update", sd_device_monitor_filter_update },
        { "sd_device_monitor_filter_add_match_subsystem_devtype", sd_device_monitor_filter_add_match_subsystem_devtype },
        { "sd_device_monitor_filter_add_match_tag", sd_device_monitor_filter_add_match_tag },
        { "sd_device_monitor_filter_add_match_sysattr", sd_device_monitor_filter_add_match_sysattr },
        { "sd_device_monitor_filter_add_match_parent", sd_device_monitor_filter_add_match_parent },
        { "sd_device_monitor_filter_remove", sd_device_monitor_filter_remove },
        { "sd_device_ref", sd_device_ref },
        { "sd_device_unref", sd_device_unref },
        { "sd_device_new_from_syspath", sd_device_new_from_syspath },
        { "sd_device_new_from_devnum", sd_device_new_from_devnum },
        { "sd_device_new_from_ifname", sd_device_new_from_ifname },
        { "sd_device_new_from_ifindex", sd_device_new_from_ifindex },
        { "sd_device_new_from_subsystem_sysname", sd_device_new_from_subsystem_sysname },
        { "sd_device_new_from_stat_rdev", sd_device_new_from_stat_rdev },
        { "sd_device_new_from_devname", sd_device_new_from_devname },
        { "sd_device_new_from_path", sd_device_new_from_path },
        { "sd_device_get_ifindex", sd_device_get_ifindex },
        { "sd_device_new_from_device_id", sd_device_new_from_device_id },
        { "sd_device_get_syspath", sd_device_get_syspath },
        { "sd_device_get_child_first", sd_device_get_child_first },
        { "sd_device_get_child_next", sd_device_get_child_next },
        { "sd_device_new_child", sd_device_new_child },
        { "sd_device_get_parent", sd_device_get_parent },
        { "sd_device_get_subsystem", sd_device_get_subsystem },
        { "sd_device_get_driver_subsystem", sd_device_get_driver_subsystem },
        { "sd_device_get_devtype", sd_device_get_devtype },
        { "sd_device_get_parent_with_subsystem_devtype", sd_device_get_parent_with_subsystem_devtype },
        { "sd_device_get_devnum", sd_device_get_devnum },
        { "sd_device_get_driver", sd_device_get_driver },
        { "sd_device_get_devpath", sd_device_get_devpath },
        { "sd_device_get_devname", sd_device_get_devname },
        { "sd_device_get_sysname", sd_device_get_sysname },
        { "sd_device_get_sysnum", sd_device_get_sysnum },
        { "sd_device_get_action", sd_device_get_action },
        { "sd_device_get_seqnum", sd_device_get_seqnum },
        { "sd_device_get_diskseq", sd_device_get_diskseq },
        { "sd_device_get_device_id", sd_device_get_device_id },
        { "sd_device_get_is_initialized", sd_device_get_is_initialized },
        { "sd_device_get_usec_initialized", sd_device_get_usec_initialized },
        { "sd_device_get_usec_since_initialized", sd_device_get_usec_since_initialized },
        { "sd_device_get_tag_first", sd_device_get_tag_first },
        { "sd_device_get_tag_next", sd_device_get_tag_next },
        { "sd_device_get_current_tag_first", sd_device_get_current_tag_first },
        { "sd_device_get_current_tag_next", sd_device_get_current_tag_next },
        { "sd_device_get_devlink_first", sd_device_get_devlink_first },
        { "sd_device_get_devlink_next", sd_device_get_devlink_next },
        { "sd_device_get_property_first", sd_device_get_property_first },
        { "sd_device_get_property_next", sd_device_get_property_next },
        { "sd_device_get_sysattr_first", sd_device_get_sysattr_first },
        { "sd_device_get_sysattr_next", sd_device_get_sysattr_next },
        { "sd_device_has_tag", sd_device_has_tag },
        { "sd_device_has_current_tag", sd_device_has_current_tag },
        { "sd_device_get_property_value", sd_device_get_property_value },
        { "sd_device_get_trigger_uuid", sd_device_get_trigger_uuid },
        { "sd_device_get_sysattr_value_with_size", sd_device_get_sysattr_value_with_size },
        { "sd_device_get_sysattr_value", sd_device_get_sysattr_value },
        { "sd_device_set_sysattr_value", sd_device_set_sysattr_value },
        { "sd_device_set_sysattr_valuef", sd_device_set_sysattr_valuef },
        { "sd_device_trigger", sd_device_trigger },
        { "sd_device_trigger_with_uuid", sd_device_trigger_with_uuid },
        { "sd_device_open", sd_device_open },
        { "sd_event_new", sd_event_new },
        { "sd_event_ref", sd_event_ref },
        { "sd_event_unref", sd_event_unref },
        { "sd_event_source_disable_unref", sd_event_source_disable_unref },
        { "sd_event_add_io", sd_event_add_io },
        { "sd_event_add_time", sd_event_add_time },
        { "sd_event_add_time_relative", sd_event_add_time_relative },
        { "sd_event_add_signal", sd_event_add_signal },
        { "sd_event_add_child", sd_event_add_child },
        { "sd_event_add_child_pidfd", sd_event_add_child_pidfd },
        { "sd_event_add_defer", sd_event_add_defer },
        { "sd_event_add_post", sd_event_add_post },
        { "sd_event_add_exit", sd_event_add_exit },
        { "sd_event_trim_memory", sd_event_trim_memory },
        { "sd_event_add_memory_pressure", sd_event_add_memory_pressure },
        { "sd_event_add_inotify_fd", sd_event_add_inotify_fd },
        { "sd_event_add_inotify", sd_event_add_inotify },
        { "sd_event_source_ref", sd_event_source_ref },
        { "sd_event_source_unref", sd_event_source_unref },
        { "sd_event_source_set_description", sd_event_source_set_description },
        { "sd_event_source_get_description", sd_event_source_get_description },
        { "sd_event_source_get_event", sd_event_source_get_event },
        { "sd_event_source_get_pending", sd_event_source_get_pending },
        { "sd_event_source_get_io_fd", sd_event_source_get_io_fd },
        { "sd_event_source_set_io_fd", sd_event_source_set_io_fd },
        { "sd_event_source_get_io_fd_own", sd_event_source_get_io_fd_own },
        { "sd_event_source_set_io_fd_own", sd_event_source_set_io_fd_own },
        { "sd_event_source_get_io_events", sd_event_source_get_io_events },
        { "sd_event_source_set_io_events", sd_event_source_set_io_events },
        { "sd_event_source_get_io_revents", sd_event_source_get_io_revents },
        { "sd_event_source_get_signal", sd_event_source_get_signal },
        { "sd_event_source_get_priority", sd_event_source_get_priority },
        { "sd_event_source_set_priority", sd_event_source_set_priority },
        { "sd_event_source_get_enabled", sd_event_source_get_enabled },
        { "sd_event_source_set_enabled", sd_event_source_set_enabled },
        { "sd_event_source_get_time", sd_event_source_get_time },
        { "sd_event_source_set_time", sd_event_source_set_time },
        { "sd_event_source_set_time_relative", sd_event_source_set_time_relative },
        { "sd_event_source_get_time_accuracy", sd_event_source_get_time_accuracy },
        { "sd_event_source_set_time_accuracy", sd_event_source_set_time_accuracy },
        { "sd_event_source_get_time_clock", sd_event_source_get_time_clock },
        { "sd_event_source_get_child_pid", sd_event_source_get_child_pid },
        { "sd_event_source_get_child_pidfd", sd_event_source_get_child_pidfd },
        { "sd_event_source_send_child_signal", sd_event_source_send_child_signal },
        { "sd_event_source_get_child_pidfd_own", sd_event_source_get_child_pidfd_own },
        { "sd_event_source_set_child_pidfd_own", sd_event_source_set_child_pidfd_own },
        { "sd_event_source_get_child_process_own", sd_event_source_get_child_process_own },
        { "sd_event_source_set_child_process_own", sd_event_source_set_child_process_own },
        { "sd_event_source_get_inotify_mask", sd_event_source_get_inotify_mask },
        { "sd_event_source_get_inotify_path", sd_event_source_get_inotify_path },
        { "sd_event_source_set_prepare", sd_event_source_set_prepare },
        { "sd_event_source_get_userdata", sd_event_source_get_userdata },
        { "sd_event_source_set_userdata", sd_event_source_set_userdata },
        { "sd_event_prepare", sd_event_prepare },
        { "sd_event_wait", sd_event_wait },
        { "sd_event_dispatch", sd_event_dispatch },
        { "sd_event_run", sd_event_run },
        { "sd_event_loop", sd_event_loop },
        { "sd_event_get_fd", sd_event_get_fd },
        { "sd_event_get_state", sd_event_get_state },
        { "sd_event_get_exit_code", sd_event_get_exit_code },
        { "sd_event_exit", sd_event_exit },
        { "sd_event_now", sd_event_now },
        { "sd_event_default", sd_event_default },
        { "sd_event_get_tid", sd_event_get_tid },
        { "sd_event_set_watchdog", sd_event_set_watchdog },
        { "sd_event_get_watchdog", sd_event_get_watchdog },
        { "sd_event_get_iteration", sd_event_get_iteration },
        { "sd_event_source_set_destroy_callback", sd_event_source_set_destroy_callback },
        { "sd_event_source_get_destroy_callback", sd_event_source_get_destroy_callback },
        { "sd_event_source_get_floating", sd_event_source_get_floating },
        { "sd_event_source_set_floating", sd_event_source_set_floating },
        { "sd_event_source_get_exit_on_failure", sd_event_source_get_exit_on_failure },
        { "sd_event_source_set_exit_on_failure", sd_event_source_set_exit_on_failure },
        { "sd_event_source_set_ratelimit", sd_event_source_set_ratelimit },
        { "sd_event_source_set_ratelimit_expire_callback", sd_event_source_set_ratelimit_expire_callback },
        { "sd_event_source_get_ratelimit", sd_event_source_get_ratelimit },
        { "sd_event_source_is_ratelimited", sd_event_source_is_ratelimited },
        { "sd_event_source_leave_ratelimit", sd_event_source_leave_ratelimit },
        { "sd_event_set_signal_exit", sd_event_set_signal_exit },
        { "sd_event_source_set_memory_pressure_type", sd_event_source_set_memory_pressure_type },
        { "sd_event_source_set_memory_pressure_period", sd_event_source_set_memory_pressure_period },
        { "sd_hwdb_new_from_path", sd_hwdb_new_from_path },
        { "sd_hwdb_new", sd_hwdb_new },
        { "sd_hwdb_ref", sd_hwdb_ref },
        { "sd_hwdb_unref", sd_hwdb_unref },
        { "sd_hwdb_get", sd_hwdb_get },
        { "sd_hwdb_seek", sd_hwdb_seek },
        { "sd_hwdb_enumerate", sd_hwdb_enumerate },
        { "sd_id128_to_string", sd_id128_to_string },
        { "sd_id128_to_uuid_string", sd_id128_to_uuid_string },
        { "sd_id128_from_string", sd_id128_from_string },
        { "sd_id128_string_equal", sd_id128_string_equal },
        { "sd_id128_get_machine", sd_id128_get_machine },
        { "sd_id128_get_boot", sd_id128_get_boot },
        { "sd_id128_get_invocation", sd_id128_get_invocation },
        { "sd_id128_randomize", sd_id128_randomize },
        { "sd_id128_get_app_specific", sd_id128_get_app_specific },
        { "sd_id128_get_machine_app_specific", sd_id128_get_machine_app_specific },
        { "sd_id128_get_boot_app_specific", sd_id128_get_boot_app_specific },
        { "sd_id128_get_invocation_app_specific", sd_id128_get_invocation_app_specific },
        { "sd_journal_print", sd_journal_print },
        { "sd_journal_printv", sd_journal_printv },
        { "sd_journal_send", sd_journal_send },
        { "sd_journal_sendv", sd_journal_sendv },
        { "sd_journal_perror", sd_journal_perror },
        { "sd_journal_stream_fd_with_namespace", sd_journal_stream_fd_with_namespace },
        { "sd_journal_stream_fd", sd_journal_stream_fd },
        { "sd_journal_print_with_location", sd_journal_print_with_location },
        { "sd_journal_printv_with_location", sd_journal_printv_with_location },
        { "sd_journal_send_with_location", sd_journal_send_with_location },
        { "sd_journal_sendv_with_location", sd_journal_sendv_with_location },
        { "sd_journal_perror_with_location", sd_journal_perror_with_location },
        { "sd_journal_add_match", sd_journal_add_match },
        { "sd_journal_add_conjunction", sd_journal_add_conjunction },
        { "sd_journal_add_disjunction", sd_journal_add_disjunction },
        { "sd_journal_flush_matches", sd_journal_flush_matches },
        { "sd_journal_next", sd_journal_next },
        { "sd_journal_previous", sd_journal_previous },
        { "sd_journal_step_one", sd_journal_step_one },
        { "sd_journal_next_skip", sd_journal_next_skip },
        { "sd_journal_previous_skip", sd_journal_previous_skip },
        { "sd_journal_get_cursor", sd_journal_get_cursor },
        { "sd_journal_seek_cursor", sd_journal_seek_cursor },
        { "sd_journal_test_cursor", sd_journal_test_cursor },
        { "sd_journal_seek_monotonic_usec", sd_journal_seek_monotonic_usec },
        { "sd_journal_seek_realtime_usec", sd_journal_seek_realtime_usec },
        { "sd_journal_seek_head", sd_journal_seek_head },
        { "sd_journal_seek_tail", sd_journal_seek_tail },
        { "sd_journal_open_namespace", sd_journal_open_namespace },
        { "sd_journal_open", sd_journal_open },
        { "sd_journal_open_container", sd_journal_open_container },
        { "sd_journal_open_directory", sd_journal_open_directory },
        { "sd_journal_open_files", sd_journal_open_files },
        { "sd_journal_open_directory_fd", sd_journal_open_directory_fd },
        { "sd_journal_open_files_fd", sd_journal_open_files_fd },
        { "sd_journal_close", sd_journal_close },
        { "sd_journal_get_realtime_usec", sd_journal_get_realtime_usec },
        { "sd_journal_get_monotonic_usec", sd_journal_get_monotonic_usec },
        { "sd_journal_get_seqnum", sd_journal_get_seqnum },
        { "sd_journal_get_data", sd_journal_get_data },
        { "sd_journal_enumerate_data", sd_journal_enumerate_data },
        { "sd_journal_enumerate_available_data", sd_journal_enumerate_available_data },
        { "sd_journal_restart_data", sd_journal_restart_data },
        { "sd_journal_get_fd", sd_journal_get_fd },
        { "sd_journal_get_events", sd_journal_get_events },
        { "sd_journal_get_timeout", sd_journal_get_timeout },
        { "sd_journal_process", sd_journal_process },
        { "sd_journal_wait", sd_journal_wait },
        { "sd_journal_get_cutoff_realtime_usec", sd_journal_get_cutoff_realtime_usec },
        { "sd_journal_get_cutoff_monotonic_usec", sd_journal_get_cutoff_monotonic_usec },
        { "sd_journal_get_usage", sd_journal_get_usage },
        { "sd_journal_query_unique", sd_journal_query_unique },
        { "sd_journal_enumerate_unique", sd_journal_enumerate_unique },
        { "sd_journal_enumerate_available_unique", sd_journal_enumerate_available_unique },
        { "sd_journal_restart_unique", sd_journal_restart_unique },
        { "sd_journal_enumerate_fields", sd_journal_enumerate_fields },
        { "sd_journal_restart_fields", sd_journal_restart_fields },
        { "sd_journal_reliable_fd", sd_journal_reliable_fd },
        { "sd_journal_get_catalog", sd_journal_get_catalog },
        { "sd_journal_get_catalog_for_message_id", sd_journal_get_catalog_for_message_id },
        { "sd_journal_set_data_threshold", sd_journal_set_data_threshold },
        { "sd_journal_get_data_threshold", sd_journal_get_data_threshold },
        { "sd_journal_has_runtime_files", sd_journal_has_runtime_files },
        { "sd_journal_has_persistent_files", sd_journal_has_persistent_files },
        { "sd_json_variant_new_integer", sd_json_variant_new_integer },
        { "sd_json_variant_new_unsigned", sd_json_variant_new_unsigned },
        { "sd_json_variant_new_real", sd_json_variant_new_real },
        { "sd_json_variant_new_boolean", sd_json_variant_new_boolean },
        { "sd_json_variant_new_null", sd_json_variant_new_null },
        { "sd_json_variant_new_stringn", sd_json_variant_new_stringn },
        { "sd_json_variant_new_string", sd_json_variant_new_string },
        { "sd_json_variant_new_base64", sd_json_variant_new_base64 },
        { "sd_json_variant_new_base32hex", sd_json_variant_new_base32hex },
        { "sd_json_variant_new_hex", sd_json_variant_new_hex },
        { "sd_json_variant_new_octescape", sd_json_variant_new_octescape },
        { "sd_json_variant_new_id128", sd_json_variant_new_id128 },
        { "sd_json_variant_new_uuid", sd_json_variant_new_uuid },
        { "sd_json_variant_new_array", sd_json_variant_new_array },
        { "sd_json_variant_new_array_bytes", sd_json_variant_new_array_bytes },
        { "sd_json_variant_new_array_strv", sd_json_variant_new_array_strv },
        { "sd_json_variant_new_object", sd_json_variant_new_object },
        { "sd_json_variant_ref", sd_json_variant_ref },
        { "sd_json_variant_unref", sd_json_variant_unref },
        { "sd_json_variant_unref_many", sd_json_variant_unref_many },
        { "sd_json_variant_string", sd_json_variant_string },
        { "sd_json_variant_boolean", sd_json_variant_boolean },
        { "sd_json_variant_integer", sd_json_variant_integer },
        { "sd_json_variant_unsigned", sd_json_variant_unsigned },
        { "sd_json_variant_real", sd_json_variant_real },
        { "sd_json_variant_is_negative", sd_json_variant_is_negative },
        { "sd_json_variant_is_blank_object", sd_json_variant_is_blank_object },
        { "sd_json_variant_is_blank_array", sd_json_variant_is_blank_array },
        { "sd_json_variant_type", sd_json_variant_type },
        { "sd_json_variant_has_type", sd_json_variant_has_type },
        { "sd_json_variant_is_string", sd_json_variant_is_string },
        { "sd_json_variant_is_integer", sd_json_variant_is_integer },
        { "sd_json_variant_is_unsigned", sd_json_variant_is_unsigned },
        { "sd_json_variant_is_real", sd_json_variant_is_real },
        { "sd_json_variant_is_number", sd_json_variant_is_number },
        { "sd_json_variant_is_boolean", sd_json_variant_is_boolean },
        { "sd_json_variant_is_array", sd_json_variant_is_array },
        { "sd_json_variant_is_object", sd_json_variant_is_object },
        { "sd_json_variant_is_null", sd_json_variant_is_null },
        { "sd_json_variant_elements", sd_json_variant_elements },
        { "sd_json_variant_by_index", sd_json_variant_by_index },
        { "sd_json_variant_by_key_full", sd_json_variant_by_key_full },
        { "sd_json_variant_by_key", sd_json_variant_by_key },
        { "sd_json_variant_equal", sd_json_variant_equal },
        { "sd_json_variant_sensitive", sd_json_variant_sensitive },
        { "sd_json_variant_is_sensitive", sd_json_variant_is_sensitive },
        { "sd_json_variant_is_sensitive_recursive", sd_json_variant_is_sensitive_recursive },
        { "sd_json_variant_get_source", sd_json_variant_get_source },
        { "sd_json_variant_format", sd_json_variant_format },
        { "sd_json_variant_dump", sd_json_variant_dump },
        { "sd_json_variant_filter", sd_json_variant_filter },
        { "sd_json_variant_set_field", sd_json_variant_set_field },
        { "sd_json_variant_set_fieldb", sd_json_variant_set_fieldb },
        { "sd_json_variant_set_field_string", sd_json_variant_set_field_string },
        { "sd_json_variant_set_field_id128", sd_json_variant_set_field_id128 },
        { "sd_json_variant_set_field_uuid", sd_json_variant_set_field_uuid },
        { "sd_json_variant_set_field_integer", sd_json_variant_set_field_integer },
        { "sd_json_variant_set_field_unsigned", sd_json_variant_set_field_unsigned },
        { "sd_json_variant_set_field_boolean", sd_json_variant_set_field_boolean },
        { "sd_json_variant_set_field_strv", sd_json_variant_set_field_strv },
        { "sd_json_variant_merge_object", sd_json_variant_merge_object },
        { "sd_json_variant_merge_objectb", sd_json_variant_merge_objectb },
        { "sd_json_variant_append_array", sd_json_variant_append_array },
        { "sd_json_variant_append_arrayb", sd_json_variant_append_arrayb },
        { "sd_json_variant_find", sd_json_variant_find },
        { "sd_json_variant_append_array_nodup", sd_json_variant_append_array_nodup },
        { "sd_json_variant_strv", sd_json_variant_strv },
        { "sd_json_parse_with_source", sd_json_parse_with_source },
        { "sd_json_parse_with_source_continue", sd_json_parse_with_source_continue },
        { "sd_json_parse", sd_json_parse },
        { "sd_json_parse_continue", sd_json_parse_continue },
        { "sd_json_parse_file_at", sd_json_parse_file_at },
        { "sd_json_parse_file", sd_json_parse_file },
        { "sd_json_buildv", sd_json_buildv },
        { "sd_json_build", sd_json_build },
        { "sd_json_dispatch_full", sd_json_dispatch_full },
        { "sd_json_dispatch", sd_json_dispatch },
        { "sd_json_dispatch_stdbool", sd_json_dispatch_stdbool },
        { "sd_json_dispatch_intbool", sd_json_dispatch_intbool },
        { "sd_json_dispatch_tristate", sd_json_dispatch_tristate },
        { "sd_json_dispatch_int64", sd_json_dispatch_int64 },
        { "sd_json_dispatch_uint64", sd_json_dispatch_uint64 },
        { "sd_json_dispatch_uint32", sd_json_dispatch_uint32 },
        { "sd_json_dispatch_int32", sd_json_dispatch_int32 },
        { "sd_json_dispatch_int16", sd_json_dispatch_int16 },
        { "sd_json_dispatch_uint16", sd_json_dispatch_uint16 },
        { "sd_json_dispatch_int8", sd_json_dispatch_int8 },
        { "sd_json_dispatch_uint8", sd_json_dispatch_uint8 },
        { "sd_json_dispatch_double", sd_json_dispatch_double },
        { "sd_json_dispatch_string", sd_json_dispatch_string },
        { "sd_json_dispatch_const_string", sd_json_dispatch_const_string },
        { "sd_json_dispatch_strv", sd_json_dispatch_strv },
        { "sd_json_dispatch_variant", sd_json_dispatch_variant },
        { "sd_json_dispatch_variant_noref", sd_json_dispatch_variant_noref },
        { "sd_json_dispatch_uid_gid", sd_json_dispatch_uid_gid },
        { "sd_json_dispatch_id128", sd_json_dispatch_id128 },
        { "sd_json_dispatch_signal", sd_json_dispatch_signal },
        { "sd_json_dispatch_unsupported", sd_json_dispatch_unsupported },
        { "sd_json_variant_sort", sd_json_variant_sort },
        { "sd_json_variant_normalize", sd_json_variant_normalize },
        { "sd_json_variant_is_normalized", sd_json_variant_is_normalized },
        { "sd_json_variant_is_sorted", sd_json_variant_is_sorted },
        { "sd_json_variant_unbase64", sd_json_variant_unbase64 },
        { "sd_json_variant_unhex", sd_json_variant_unhex },
        { "sd_json_variant_type_from_string", sd_json_variant_type_from_string },
        { "sd_json_variant_type_to_string", sd_json_variant_type_to_string },
        { "sd_pid_get_session", sd_pid_get_session },
        { "sd_pid_get_unit", sd_pid_get_unit },
        { "sd_pid_get_user_unit", sd_pid_get_user_unit },
        { "sd_pid_get_machine_name", sd_pid_get_machine_name },
        { "sd_pid_get_slice", sd_pid_get_slice },
        { "sd_pid_get_user_slice", sd_pid_get_user_slice },
        { "sd_pid_get_owner_uid", sd_pid_get_owner_uid },
        { "sd_pid_get_cgroup", sd_pid_get_cgroup },
        { "sd_pidfd_get_session", sd_pidfd_get_session },
        { "sd_pidfd_get_unit", sd_pidfd_get_unit },
        { "sd_pidfd_get_user_unit", sd_pidfd_get_user_unit },
        { "sd_pidfd_get_machine_name", sd_pidfd_get_machine_name },
        { "sd_pidfd_get_slice", sd_pidfd_get_slice },
        { "sd_pidfd_get_user_slice", sd_pidfd_get_user_slice },
        { "sd_pidfd_get_owner_uid", sd_pidfd_get_owner_uid },
        { "sd_pidfd_get_cgroup", sd_pidfd_get_cgroup },
        { "sd_peer_get_session", sd_peer_get_session },
        { "sd_peer_get_owner_uid", sd_peer_get_owner_uid },
        { "sd_peer_get_unit", sd_peer_get_unit },
        { "sd_peer_get_user_unit", sd_peer_get_user_unit },
        { "sd_peer_get_machine_name", sd_peer_get_machine_name },
        { "sd_peer_get_slice", sd_peer_get_slice },
        { "sd_peer_get_user_slice", sd_peer_get_user_slice },
        { "sd_peer_get_cgroup", sd_peer_get_cgroup },
        { "sd_uid_get_state", sd_uid_get_state },
        { "sd_uid_get_display", sd_uid_get_display },
        { "sd_uid_get_login_time", sd_uid_get_login_time },
        { "sd_uid_is_on_seat", sd_uid_is_on_seat },
        { "sd_uid_get_sessions", sd_uid_get_sessions },
        { "sd_uid_get_seats", sd_uid_get_seats },
        { "sd_session_is_active", sd_session_is_active },
        { "sd_session_is_remote", sd_session_is_remote },
        { "sd_session_get_state", sd_session_get_state },
        { "sd_session_get_uid", sd_session_get_uid },
        { "sd_session_get_username", sd_session_get_username },
        { "sd_session_get_seat", sd_session_get_seat },
        { "sd_session_get_start_time", sd_session_get_start_time },
        { "sd_session_get_tty", sd_session_get_tty },
        { "sd_session_get_vt", sd_session_get_vt },
        { "sd_session_get_service", sd_session_get_service },
        { "sd_session_get_type", sd_session_get_type },
        { "sd_session_get_class", sd_session_get_class },
        { "sd_session_get_desktop", sd_session_get_desktop },
        { "sd_session_get_display", sd_session_get_display },
        { "sd_session_get_remote_user", sd_session_get_remote_user },
        { "sd_session_get_remote_host", sd_session_get_remote_host },
        { "sd_session_get_leader", sd_session_get_leader },
        { "sd_seat_get_active", sd_seat_get_active },
        { "sd_seat_get_sessions", sd_seat_get_sessions },
        { "sd_seat_can_multi_session", sd_seat_can_multi_session },
        { "sd_seat_can_tty", sd_seat_can_tty },
        { "sd_seat_can_graphical", sd_seat_can_graphical },
        { "sd_get_seats", sd_get_seats },
        { "sd_get_sessions", sd_get_sessions },
        { "sd_get_uids", sd_get_uids },
        { "sd_get_machine_names", sd_get_machine_names },
        { "sd_machine_get_class", sd_machine_get_class },
        { "sd_machine_get_ifindices", sd_machine_get_ifindices },
        { "sd_login_monitor_new", sd_login_monitor_new },
        { "sd_login_monitor_unref", sd_login_monitor_unref },
        { "sd_login_monitor_flush", sd_login_monitor_flush },
        { "sd_login_monitor_get_fd", sd_login_monitor_get_fd },
        { "sd_login_monitor_get_events", sd_login_monitor_get_events },
        { "sd_login_monitor_get_timeout", sd_login_monitor_get_timeout },
        { "sd_path_lookup", sd_path_lookup },
        { "sd_path_lookup_strv", sd_path_lookup_strv },
        { "sd_varlink_idl_dump", sd_varlink_idl_dump },
        { "sd_varlink_idl_format_full", sd_varlink_idl_format_full },
        { "sd_varlink_idl_format", sd_varlink_idl_format },
        { "sd_varlink_interface_free", sd_varlink_interface_free },
        { "sd_varlink_idl_parse", sd_varlink_idl_parse },
        { "sd_varlink_connect_address", sd_varlink_connect_address },
        { "sd_varlink_connect_exec", sd_varlink_connect_exec },
        { "sd_varlink_connect_url", sd_varlink_connect_url },
        { "sd_varlink_connect_fd_pair", sd_varlink_connect_fd_pair },
        { "sd_varlink_connect_fd", sd_varlink_connect_fd },
        { "sd_varlink_ref", sd_varlink_ref },
        { "sd_varlink_unref", sd_varlink_unref },
        { "sd_varlink_process", sd_varlink_process },
        { "sd_varlink_dispatch_again", sd_varlink_dispatch_again },
        { "sd_varlink_get_current_method", sd_varlink_get_current_method },
        { "sd_varlink_get_current_parameters", sd_varlink_get_current_parameters },
        { "sd_varlink_wait", sd_varlink_wait },
        { "sd_varlink_is_idle", sd_varlink_is_idle },
        { "sd_varlink_get_fd", sd_varlink_get_fd },
        { "sd_varlink_get_input_fd", sd_varlink_get_input_fd },
        { "sd_varlink_get_output_fd", sd_varlink_get_output_fd },
        { "sd_varlink_get_events", sd_varlink_get_events },
        { "sd_varlink_get_timeout", sd_varlink_get_timeout },
        { "sd_varlink_flush", sd_varlink_flush },
        { "sd_varlink_close", sd_varlink_close },
        { "sd_varlink_close_unref", sd_varlink_close_unref },
        { "sd_varlink_flush_close_unref", sd_varlink_flush_close_unref },
        { "sd_varlink_send", sd_varlink_send },
        { "sd_varlink_sendb", sd_varlink_sendb },
        { "sd_varlink_invoke", sd_varlink_invoke },
        { "sd_varlink_invokeb", sd_varlink_invokeb },
        { "sd_varlink_observe", sd_varlink_observe },
        { "sd_varlink_observeb", sd_varlink_observeb },
        { "sd_varlink_call_full", sd_varlink_call_full },
        { "sd_varlink_call", sd_varlink_call },
        { "sd_varlink_callb_ap", sd_varlink_callb_ap },
        { "sd_varlink_callb", sd_varlink_callb },
        { "sd_varlink_callb_full", sd_varlink_callb_full },
        { "sd_varlink_collect_full", sd_varlink_collect_full },
        { "sd_varlink_collect", sd_varlink_collect },
        { "sd_varlink_collectb", sd_varlink_collectb },
        { "sd_varlink_reply", sd_varlink_reply },
        { "sd_varlink_replyb", sd_varlink_replyb },
        { "sd_varlink_reset_fds", sd_varlink_reset_fds },
        { "sd_varlink_error", sd_varlink_error },
        { "sd_varlink_errorb", sd_varlink_errorb },
        { "sd_varlink_error_invalid_parameter", sd_varlink_error_invalid_parameter },
        { "sd_varlink_error_invalid_parameter_name", sd_varlink_error_invalid_parameter_name },
        { "sd_varlink_error_errno", sd_varlink_error_errno },
        { "sd_varlink_notify", sd_varlink_notify },
        { "sd_varlink_notifyb", sd_varlink_notifyb },
        { "sd_varlink_dispatch", sd_varlink_dispatch },
        { "sd_varlink_bind_reply", sd_varlink_bind_reply },
        { "sd_varlink_set_userdata", sd_varlink_set_userdata },
        { "sd_varlink_get_userdata", sd_varlink_get_userdata },
        { "sd_varlink_get_peer_uid", sd_varlink_get_peer_uid },
        { "sd_varlink_get_peer_gid", sd_varlink_get_peer_gid },
        { "sd_varlink_get_peer_pid", sd_varlink_get_peer_pid },
        { "sd_varlink_get_peer_pidfd", sd_varlink_get_peer_pidfd },
        { "sd_varlink_set_relative_timeout", sd_varlink_set_relative_timeout },
        { "sd_varlink_get_server", sd_varlink_get_server },
        { "sd_varlink_set_description", sd_varlink_set_description },
        { "sd_varlink_get_description", sd_varlink_get_description },
        { "sd_varlink_attach_event", sd_varlink_attach_event },
        { "sd_varlink_detach_event", sd_varlink_detach_event },
        { "sd_varlink_get_event", sd_varlink_get_event },
        { "sd_varlink_push_fd", sd_varlink_push_fd },
        { "sd_varlink_push_dup_fd", sd_varlink_push_dup_fd },
        { "sd_varlink_peek_fd", sd_varlink_peek_fd },
        { "sd_varlink_peek_dup_fd", sd_varlink_peek_dup_fd },
        { "sd_varlink_take_fd", sd_varlink_take_fd },
        { "sd_varlink_get_n_fds", sd_varlink_get_n_fds },
        { "sd_varlink_set_allow_fd_passing_input", sd_varlink_set_allow_fd_passing_input },
        { "sd_varlink_set_allow_fd_passing_output", sd_varlink_set_allow_fd_passing_output },
        { "sd_varlink_set_input_sensitive", sd_varlink_set_input_sensitive },
        { "sd_varlink_server_new", sd_varlink_server_new },
        { "sd_varlink_server_ref", sd_varlink_server_ref },
        { "sd_varlink_server_unref", sd_varlink_server_unref },
        { "sd_varlink_server_set_info", sd_varlink_server_set_info },
        { "sd_varlink_server_add_connection_pair", sd_varlink_server_add_connection_pair },
        { "sd_varlink_server_add_connection", sd_varlink_server_add_connection },
        { "sd_varlink_server_listen_fd", sd_varlink_server_listen_fd },
        { "sd_varlink_server_listen_address", sd_varlink_server_listen_address },
        { "sd_varlink_server_add_connection_stdio", sd_varlink_server_add_connection_stdio },
        { "sd_varlink_server_listen_name", sd_varlink_server_listen_name },
        { "sd_varlink_server_listen_auto", sd_varlink_server_listen_auto },
        { "sd_varlink_server_set_userdata", sd_varlink_server_set_userdata },
        { "sd_varlink_server_get_userdata", sd_varlink_server_get_userdata },
        { "sd_varlink_server_loop_auto", sd_varlink_server_loop_auto },
        { "sd_varlink_server_shutdown", sd_varlink_server_shutdown },
        { "sd_varlink_server_set_exit_on_idle", sd_varlink_server_set_exit_on_idle },
        { "sd_varlink_server_attach_event", sd_varlink_server_attach_event },
        { "sd_varlink_server_detach_event", sd_varlink_server_detach_event },
        { "sd_varlink_server_get_event", sd_varlink_server_get_event },
        { "sd_varlink_server_bind_method", sd_varlink_server_bind_method },
        { "sd_varlink_server_bind_method_many_internal", sd_varlink_server_bind_method_many_internal },
        { "sd_varlink_server_bind_connect", sd_varlink_server_bind_connect },
        { "sd_varlink_server_bind_disconnect", sd_varlink_server_bind_disconnect },
        { "sd_varlink_server_add_interface", sd_varlink_server_add_interface },
        { "sd_varlink_server_add_interface_many_internal", sd_varlink_server_add_interface_many_internal },
        { "sd_varlink_server_connections_max", sd_varlink_server_connections_max },
        { "sd_varlink_server_connections_per_uid_max", sd_varlink_server_connections_per_uid_max },
        { "sd_varlink_server_set_connections_per_uid_max", sd_varlink_server_set_connections_per_uid_max },
        { "sd_varlink_server_set_connections_max", sd_varlink_server_set_connections_max },
        { "sd_varlink_server_current_connections", sd_varlink_server_current_connections },
        { "sd_varlink_server_set_description", sd_varlink_server_set_description },
        { "sd_varlink_invocation", sd_varlink_invocation },
        { "sd_varlink_error_to_errno", sd_varlink_error_to_errno },
        { "sd_varlink_error_is_invalid_parameter", sd_varlink_error_is_invalid_parameter },
        {}
};

static int sort_callback(const void *a, const void *b) {
        const struct symbol *x = a, *y = b;
        return strcmp(x->name, y->name);
}

int main(void) {
        size_t size = sizeof(symbols_from_sym[0]),
                n_sym = sizeof(symbols_from_sym)/sizeof(symbols_from_sym[0]) - 1,
                n_header = sizeof(symbols_from_header)/sizeof(symbols_from_header[0]) - 1,
                n_source = sizeof(symbols_from_source)/sizeof(symbols_from_source[0]) - 1;

        qsort(symbols_from_sym, n_sym, size, sort_callback);
        qsort(symbols_from_header, n_header, size, sort_callback);
        qsort(symbols_from_source, n_source, size, sort_callback);

        puts("From symbol file:");
        for (size_t i = 0; i < n_sym; i++)
                printf("%p: %s\n", symbols_from_sym[i].symbol, symbols_from_sym[i].name);

        puts("\nFrom header files:");
        for (size_t i = 0; i < n_header; i++)
                printf("%p: %s\n", symbols_from_header[i].symbol, symbols_from_header[i].name);

        puts("\nFrom source files:");
        for (size_t i = 0; i < n_source; i++)
                printf("%p: %s\n", symbols_from_source[i].symbol, symbols_from_source[i].name);

        puts("");
        printf("Found %zu symbols from symbol file.\n", n_sym);
        printf("Found %zu symbols from header files.\n", n_header);
        printf("Found %zu symbols from source files.\n", n_source);

        unsigned n_error = 0;

        for (size_t i = 0; i < n_sym; i++) {
                if (!bsearch(symbols_from_sym+i, symbols_from_header, n_header, size, sort_callback)) {
                        printf("Found in symbol file, but not in headers: %s\n", symbols_from_sym[i].name);
                        n_error++;
                }
                if (!bsearch(symbols_from_sym+i, symbols_from_source, n_source, size, sort_callback)) {
                        printf("Found in symbol file, but not in sources: %s\n", symbols_from_sym[i].name);
                        n_error++;
                }
        }

        for (size_t i = 0; i < n_header; i++) {
                if (!bsearch(symbols_from_header+i, symbols_from_sym, n_sym, size, sort_callback)) {
                        printf("Found in header file, but not in symbol file: %s\n", symbols_from_header[i].name);
                        n_error++;
                }
                if (!bsearch(symbols_from_header+i, symbols_from_source, n_source, size, sort_callback)) {
                        printf("Found in header file, but not in sources: %s\n", symbols_from_header[i].name);
                        n_error++;
                }
        }

        for (size_t i = 0; i < n_source; i++) {
                if (!bsearch(symbols_from_source+i, symbols_from_sym, n_sym, size, sort_callback)) {
                        printf("Found in source file, but not in symbol file: %s\n", symbols_from_source[i].name);
                        n_error++;
                }
                if (!bsearch(symbols_from_source+i, symbols_from_header, n_header, size, sort_callback)) {
                        printf("Found in source file, but not in header: %s\n", symbols_from_source[i].name);
                        n_error++;
                }
        }

        return n_error == 0 ? EXIT_SUCCESS : EXIT_FAILURE;
}
