/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUCanvasContext.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUCanvasConfiguration.h"
#include "JSGPUTexture.h"
#include "JSHTMLCanvasElement.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPUCanvasContextPrototypeFunction_configure);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCanvasContextPrototypeFunction_unconfigure);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCanvasContextPrototypeFunction_getCurrentTexture);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUCanvasContextConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUCanvasContext_canvas);

class JSGPUCanvasContextPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUCanvasContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUCanvasContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUCanvasContextPrototype>(vm)) JSGPUCanvasContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUCanvasContextPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUCanvasContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUCanvasContextPrototype, JSGPUCanvasContextPrototype::Base);

using JSGPUCanvasContextDOMConstructor = JSDOMConstructorNotConstructable<JSGPUCanvasContext>;

template<> const ClassInfo JSGPUCanvasContextDOMConstructor::s_info = { "GPUCanvasContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCanvasContextDOMConstructor) };

template<> JSValue JSGPUCanvasContextDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUCanvasContextDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUCanvasContext"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUCanvasContext::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUCanvasContextPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCanvasContextConstructor, 0 } },
    { "canvas"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCanvasContext_canvas, 0 } },
    { "configure"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCanvasContextPrototypeFunction_configure, 1 } },
    { "unconfigure"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCanvasContextPrototypeFunction_unconfigure, 0 } },
    { "getCurrentTexture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCanvasContextPrototypeFunction_getCurrentTexture, 0 } },
};

const ClassInfo JSGPUCanvasContextPrototype::s_info = { "GPUCanvasContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCanvasContextPrototype) };

void JSGPUCanvasContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUCanvasContext::info(), JSGPUCanvasContextPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUCanvasContext::s_info = { "GPUCanvasContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCanvasContext) };

JSGPUCanvasContext::JSGPUCanvasContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUCanvasContext>&& impl)
    : JSDOMWrapper<GPUCanvasContext>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, GPUCanvasContext>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSGPUCanvasContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUCanvasContextPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUCanvasContextPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUCanvasContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUCanvasContext>(vm, globalObject);
}

JSValue JSGPUCanvasContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUCanvasContextDOMConstructor, DOMConstructorID::GPUCanvasContext>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUCanvasContext::destroy(JSC::JSCell* cell)
{
    JSGPUCanvasContext* thisObject = static_cast<JSGPUCanvasContext*>(cell);
    thisObject->JSGPUCanvasContext::~JSGPUCanvasContext();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCanvasContextConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUCanvasContextPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUCanvasContext::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGPUCanvasContext_canvasGetter(JSGlobalObject& lexicalGlobalObject, JSGPUCanvasContext& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLInterface<HTMLCanvasElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCanvasContext_canvas, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUCanvasContext>::get<jsGPUCanvasContext_canvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPUCanvasContextPrototypeFunction_configureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCanvasContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto configuration = convert<IDLDictionary<GPUCanvasConfiguration>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.configure(WTFMove(configuration)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCanvasContextPrototypeFunction_configure, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCanvasContext>::call<jsGPUCanvasContextPrototypeFunction_configureBody>(*lexicalGlobalObject, *callFrame, "configure");
}

static inline JSC::EncodedJSValue jsGPUCanvasContextPrototypeFunction_unconfigureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCanvasContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.unconfigure(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCanvasContextPrototypeFunction_unconfigure, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCanvasContext>::call<jsGPUCanvasContextPrototypeFunction_unconfigureBody>(*lexicalGlobalObject, *callFrame, "unconfigure");
}

static inline JSC::EncodedJSValue jsGPUCanvasContextPrototypeFunction_getCurrentTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCanvasContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUTexture>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCurrentTexture())));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCanvasContextPrototypeFunction_getCurrentTexture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCanvasContext>::call<jsGPUCanvasContextPrototypeFunction_getCurrentTextureBody>(*lexicalGlobalObject, *callFrame, "getCurrentTexture");
}

JSC::GCClient::IsoSubspace* JSGPUCanvasContext::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUCanvasContext, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUCanvasContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUCanvasContext = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUCanvasContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUCanvasContext = std::forward<decltype(space)>(space); }
    );
}

void JSGPUCanvasContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUCanvasContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUCanvasContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsGPUCanvasContext = jsCast<JSGPUCanvasContext*>(handle.slot()->asCell());
    auto& wrapped = jsGPUCanvasContext->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUCanvasContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUCanvasContext = static_cast<JSGPUCanvasContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUCanvasContext->wrapped(), jsGPUCanvasContext);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUCanvasContext>&& impl)
{
    return createWrapper<GPUCanvasContext>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUCanvasContext& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUCanvasContext* JSGPUCanvasContext::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUCanvasContext*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
