/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUCompilationMessage.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUCompilationMessageType.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUCompilationMessageConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUCompilationMessage_message);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUCompilationMessage_type);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUCompilationMessage_lineNum);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUCompilationMessage_linePos);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUCompilationMessage_offset);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUCompilationMessage_length);

class JSGPUCompilationMessagePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUCompilationMessagePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUCompilationMessagePrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUCompilationMessagePrototype>(vm)) JSGPUCompilationMessagePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUCompilationMessagePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUCompilationMessagePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUCompilationMessagePrototype, JSGPUCompilationMessagePrototype::Base);

using JSGPUCompilationMessageDOMConstructor = JSDOMConstructorNotConstructable<JSGPUCompilationMessage>;

template<> const ClassInfo JSGPUCompilationMessageDOMConstructor::s_info = { "GPUCompilationMessage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCompilationMessageDOMConstructor) };

template<> JSValue JSGPUCompilationMessageDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUCompilationMessageDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUCompilationMessage"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUCompilationMessage::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUCompilationMessagePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCompilationMessageConstructor, 0 } },
    { "message"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCompilationMessage_message, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCompilationMessage_type, 0 } },
    { "lineNum"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCompilationMessage_lineNum, 0 } },
    { "linePos"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCompilationMessage_linePos, 0 } },
    { "offset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCompilationMessage_offset, 0 } },
    { "length"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCompilationMessage_length, 0 } },
};

const ClassInfo JSGPUCompilationMessagePrototype::s_info = { "GPUCompilationMessage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCompilationMessagePrototype) };

void JSGPUCompilationMessagePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUCompilationMessage::info(), JSGPUCompilationMessagePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUCompilationMessage::s_info = { "GPUCompilationMessage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCompilationMessage) };

JSGPUCompilationMessage::JSGPUCompilationMessage(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUCompilationMessage>&& impl)
    : JSDOMWrapper<GPUCompilationMessage>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUCompilationMessage>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUCompilationMessage::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUCompilationMessagePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUCompilationMessagePrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUCompilationMessage::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUCompilationMessage>(vm, globalObject);
}

JSValue JSGPUCompilationMessage::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUCompilationMessageDOMConstructor, DOMConstructorID::GPUCompilationMessage>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUCompilationMessage::destroy(JSC::JSCell* cell)
{
    JSGPUCompilationMessage* thisObject = static_cast<JSGPUCompilationMessage*>(cell);
    thisObject->JSGPUCompilationMessage::~JSGPUCompilationMessage();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCompilationMessageConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUCompilationMessagePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUCompilationMessage::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGPUCompilationMessage_messageGetter(JSGlobalObject& lexicalGlobalObject, JSGPUCompilationMessage& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.message())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCompilationMessage_message, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUCompilationMessage>::get<jsGPUCompilationMessage_messageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUCompilationMessage_typeGetter(JSGlobalObject& lexicalGlobalObject, JSGPUCompilationMessage& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<GPUCompilationMessageType>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCompilationMessage_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUCompilationMessage>::get<jsGPUCompilationMessage_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUCompilationMessage_lineNumGetter(JSGlobalObject& lexicalGlobalObject, JSGPUCompilationMessage& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.lineNum())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCompilationMessage_lineNum, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUCompilationMessage>::get<jsGPUCompilationMessage_lineNumGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUCompilationMessage_linePosGetter(JSGlobalObject& lexicalGlobalObject, JSGPUCompilationMessage& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.linePos())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCompilationMessage_linePos, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUCompilationMessage>::get<jsGPUCompilationMessage_linePosGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUCompilationMessage_offsetGetter(JSGlobalObject& lexicalGlobalObject, JSGPUCompilationMessage& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.offset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCompilationMessage_offset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUCompilationMessage>::get<jsGPUCompilationMessage_offsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUCompilationMessage_lengthGetter(JSGlobalObject& lexicalGlobalObject, JSGPUCompilationMessage& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.length())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCompilationMessage_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUCompilationMessage>::get<jsGPUCompilationMessage_lengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGPUCompilationMessage::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUCompilationMessage, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUCompilationMessage.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUCompilationMessage = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUCompilationMessage.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUCompilationMessage = std::forward<decltype(space)>(space); }
    );
}

void JSGPUCompilationMessage::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUCompilationMessage*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUCompilationMessageOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUCompilationMessageOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUCompilationMessage = static_cast<JSGPUCompilationMessage*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUCompilationMessage->wrapped(), jsGPUCompilationMessage);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUCompilationMessage@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21GPUCompilationMessageE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUCompilationMessage>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPUCompilationMessage>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUCompilationMessage@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21GPUCompilationMessageE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUCompilationMessage has subclasses. If GPUCompilationMessage has subclasses that get passed
        // to toJS() we currently require GPUCompilationMessage you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPUCompilationMessage>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUCompilationMessage& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUCompilationMessage* JSGPUCompilationMessage::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUCompilationMessage*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
