/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUDeviceLostInfo.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUDeviceLostReason.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUDeviceLostInfoConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUDeviceLostInfo_reason);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUDeviceLostInfo_message);

class JSGPUDeviceLostInfoPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUDeviceLostInfoPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUDeviceLostInfoPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUDeviceLostInfoPrototype>(vm)) JSGPUDeviceLostInfoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUDeviceLostInfoPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUDeviceLostInfoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUDeviceLostInfoPrototype, JSGPUDeviceLostInfoPrototype::Base);

using JSGPUDeviceLostInfoDOMConstructor = JSDOMConstructorNotConstructable<JSGPUDeviceLostInfo>;

template<> const ClassInfo JSGPUDeviceLostInfoDOMConstructor::s_info = { "GPUDeviceLostInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUDeviceLostInfoDOMConstructor) };

template<> JSValue JSGPUDeviceLostInfoDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUDeviceLostInfoDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUDeviceLostInfo"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUDeviceLostInfo::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUDeviceLostInfoPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUDeviceLostInfoConstructor, 0 } },
    { "reason"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUDeviceLostInfo_reason, 0 } },
    { "message"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUDeviceLostInfo_message, 0 } },
};

const ClassInfo JSGPUDeviceLostInfoPrototype::s_info = { "GPUDeviceLostInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUDeviceLostInfoPrototype) };

void JSGPUDeviceLostInfoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUDeviceLostInfo::info(), JSGPUDeviceLostInfoPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUDeviceLostInfo::s_info = { "GPUDeviceLostInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUDeviceLostInfo) };

JSGPUDeviceLostInfo::JSGPUDeviceLostInfo(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUDeviceLostInfo>&& impl)
    : JSDOMWrapper<GPUDeviceLostInfo>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUDeviceLostInfo>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUDeviceLostInfo::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUDeviceLostInfoPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUDeviceLostInfoPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUDeviceLostInfo::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUDeviceLostInfo>(vm, globalObject);
}

JSValue JSGPUDeviceLostInfo::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUDeviceLostInfoDOMConstructor, DOMConstructorID::GPUDeviceLostInfo>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUDeviceLostInfo::destroy(JSC::JSCell* cell)
{
    JSGPUDeviceLostInfo* thisObject = static_cast<JSGPUDeviceLostInfo*>(cell);
    thisObject->JSGPUDeviceLostInfo::~JSGPUDeviceLostInfo();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUDeviceLostInfoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUDeviceLostInfoPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUDeviceLostInfo::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGPUDeviceLostInfo_reasonGetter(JSGlobalObject& lexicalGlobalObject, JSGPUDeviceLostInfo& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<GPUDeviceLostReason>>(lexicalGlobalObject, throwScope, impl.reason())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUDeviceLostInfo_reason, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUDeviceLostInfo>::get<jsGPUDeviceLostInfo_reasonGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUDeviceLostInfo_messageGetter(JSGlobalObject& lexicalGlobalObject, JSGPUDeviceLostInfo& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.message())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUDeviceLostInfo_message, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUDeviceLostInfo>::get<jsGPUDeviceLostInfo_messageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGPUDeviceLostInfo::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUDeviceLostInfo, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUDeviceLostInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUDeviceLostInfo = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUDeviceLostInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUDeviceLostInfo = std::forward<decltype(space)>(space); }
    );
}

void JSGPUDeviceLostInfo::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUDeviceLostInfo*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUDeviceLostInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUDeviceLostInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUDeviceLostInfo = static_cast<JSGPUDeviceLostInfo*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUDeviceLostInfo->wrapped(), jsGPUDeviceLostInfo);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUDeviceLostInfo@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17GPUDeviceLostInfoE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUDeviceLostInfo>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPUDeviceLostInfo>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUDeviceLostInfo@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17GPUDeviceLostInfoE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUDeviceLostInfo has subclasses. If GPUDeviceLostInfo has subclasses that get passed
        // to toJS() we currently require GPUDeviceLostInfo you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPUDeviceLostInfo>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUDeviceLostInfo& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUDeviceLostInfo* JSGPUDeviceLostInfo::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUDeviceLostInfo*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
