/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPipelineDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUAutoLayoutMode.h"
#include "JSGPUDepthStencilState.h"
#include "JSGPUFragmentState.h"
#include "JSGPUMultisampleState.h"
#include "JSGPUPipelineLayout.h"
#include "JSGPUPrimitiveState.h"
#include "JSGPUVertexState.h"
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> GPURenderPipelineDescriptor convertDictionary<GPURenderPipelineDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPURenderPipelineDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue layoutValue;
    if (isNullOrUndefined)
        layoutValue = jsUndefined();
    else {
        layoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "layout"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!layoutValue.isUndefined()) {
        result.layout = convert<IDLUnion<IDLInterface<GPUPipelineLayout>, IDLEnumeration<GPUAutoLayoutMode>>>(lexicalGlobalObject, layoutValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue depthStencilValue;
    if (isNullOrUndefined)
        depthStencilValue = jsUndefined();
    else {
        depthStencilValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStencil"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthStencilValue.isUndefined()) {
        result.depthStencil = convert<IDLDictionary<GPUDepthStencilState>>(lexicalGlobalObject, depthStencilValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue fragmentValue;
    if (isNullOrUndefined)
        fragmentValue = jsUndefined();
    else {
        fragmentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fragment"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fragmentValue.isUndefined()) {
        result.fragment = convert<IDLDictionary<GPUFragmentState>>(lexicalGlobalObject, fragmentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue multisampleValue;
    if (isNullOrUndefined)
        multisampleValue = jsUndefined();
    else {
        multisampleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "multisample"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!multisampleValue.isUndefined()) {
        result.multisample = convert<IDLDictionary<GPUMultisampleState>>(lexicalGlobalObject, multisampleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue primitiveValue;
    if (isNullOrUndefined)
        primitiveValue = jsUndefined();
    else {
        primitiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "primitive"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!primitiveValue.isUndefined()) {
        result.primitive = convert<IDLDictionary<GPUPrimitiveState>>(lexicalGlobalObject, primitiveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue vertexValue;
    if (isNullOrUndefined)
        vertexValue = jsUndefined();
    else {
        vertexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "vertex"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!vertexValue.isUndefined()) {
        result.vertex = convert<IDLDictionary<GPUVertexState>>(lexicalGlobalObject, vertexValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "vertex", "GPURenderPipelineDescriptor", "GPUVertexState");
        return { };
    }
    return result;
}

} // namespace WebCore
