/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInspectorFrontendHost.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCanvasRenderingContext2D.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEvent.h"
#include "JSFile.h"
#include "JSPath2D.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>

#if ENABLE(INSPECTOR_EXTENSIONS)
#include "JSDOMConvertAny.h"
#include "JSHTMLIFrameElement.h"
#endif


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(InspectorFrontendHost::SaveMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("single-file"),
        MAKE_STATIC_STRING_IMPL("file-variants"),
    };
    static_assert(static_cast<size_t>(InspectorFrontendHost::SaveMode::SingleFile) == 0, "InspectorFrontendHost::SaveMode::SingleFile is not 0 as expected");
    static_assert(static_cast<size_t>(InspectorFrontendHost::SaveMode::FileVariants) == 1, "InspectorFrontendHost::SaveMode::FileVariants is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, InspectorFrontendHost::SaveMode enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<InspectorFrontendHost::SaveMode> parseEnumerationFromString<InspectorFrontendHost::SaveMode>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, InspectorFrontendHost::SaveMode> mappings[] = {
        { "file-variants", InspectorFrontendHost::SaveMode::FileVariants },
        { "single-file", InspectorFrontendHost::SaveMode::SingleFile },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<InspectorFrontendHost::SaveMode> parseEnumeration<InspectorFrontendHost::SaveMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<InspectorFrontendHost::SaveMode>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<InspectorFrontendHost::SaveMode>()
{
    return "\"single-file\", \"file-variants\"";
}

template<> InspectorFrontendHost::SaveData convertDictionary<InspectorFrontendHost::SaveData>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    InspectorFrontendHost::SaveData result;
    JSValue base64EncodedValue;
    if (isNullOrUndefined)
        base64EncodedValue = jsUndefined();
    else {
        base64EncodedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "base64Encoded"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!base64EncodedValue.isUndefined()) {
        result.base64Encoded = convert<IDLBoolean>(lexicalGlobalObject, base64EncodedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue contentValue;
    if (isNullOrUndefined)
        contentValue = jsUndefined();
    else {
        contentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "content"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!contentValue.isUndefined()) {
        result.content = convert<IDLDOMString>(lexicalGlobalObject, contentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displayTypeValue;
    if (isNullOrUndefined)
        displayTypeValue = jsUndefined();
    else {
        displayTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayType"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayTypeValue.isUndefined()) {
        result.displayType = convert<IDLDOMString>(lexicalGlobalObject, displayTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue urlValue;
    if (isNullOrUndefined)
        urlValue = jsUndefined();
    else {
        urlValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "url"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!urlValue.isUndefined()) {
        result.url = convert<IDLDOMString>(lexicalGlobalObject, urlValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

template<> InspectorFrontendHost::ContextMenuItem convertDictionary<InspectorFrontendHost::ContextMenuItem>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    InspectorFrontendHost::ContextMenuItem result;
    JSValue checkedValue;
    if (isNullOrUndefined)
        checkedValue = jsUndefined();
    else {
        checkedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "checked"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!checkedValue.isUndefined()) {
        result.checked = convert<IDLBoolean>(lexicalGlobalObject, checkedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue enabledValue;
    if (isNullOrUndefined)
        enabledValue = jsUndefined();
    else {
        enabledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "enabled"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!enabledValue.isUndefined()) {
        result.enabled = convert<IDLBoolean>(lexicalGlobalObject, enabledValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLLong>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLDOMString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue subItemsValue;
    if (isNullOrUndefined)
        subItemsValue = jsUndefined();
    else {
        subItemsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "subItems"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!subItemsValue.isUndefined()) {
        result.subItems = convert<IDLSequence<IDLDictionary<InspectorFrontendHost::ContextMenuItem>>>(lexicalGlobalObject, subItemsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLDOMString>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

template<> InspectorFrontendHost::DebuggableInfo convertDictionary<InspectorFrontendHost::DebuggableInfo>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    InspectorFrontendHost::DebuggableInfo result;
    JSValue debuggableTypeValue;
    if (isNullOrUndefined)
        debuggableTypeValue = jsUndefined();
    else {
        debuggableTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "debuggableType"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!debuggableTypeValue.isUndefined()) {
        result.debuggableType = convert<IDLDOMString>(lexicalGlobalObject, debuggableTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue targetBuildVersionValue;
    if (isNullOrUndefined)
        targetBuildVersionValue = jsUndefined();
    else {
        targetBuildVersionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetBuildVersion"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetBuildVersionValue.isUndefined()) {
        result.targetBuildVersion = convert<IDLDOMString>(lexicalGlobalObject, targetBuildVersionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue targetIsSimulatorValue;
    if (isNullOrUndefined)
        targetIsSimulatorValue = jsUndefined();
    else {
        targetIsSimulatorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetIsSimulator"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetIsSimulatorValue.isUndefined()) {
        result.targetIsSimulator = convert<IDLBoolean>(lexicalGlobalObject, targetIsSimulatorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue targetPlatformNameValue;
    if (isNullOrUndefined)
        targetPlatformNameValue = jsUndefined();
    else {
        targetPlatformNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetPlatformName"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetPlatformNameValue.isUndefined()) {
        result.targetPlatformName = convert<IDLDOMString>(lexicalGlobalObject, targetPlatformNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue targetProductVersionValue;
    if (isNullOrUndefined)
        targetProductVersionValue = jsUndefined();
    else {
        targetProductVersionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetProductVersion"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetProductVersionValue.isUndefined()) {
        result.targetProductVersion = convert<IDLDOMString>(lexicalGlobalObject, targetProductVersionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const InspectorFrontendHost::DebuggableInfo& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.debuggableType)) {
        auto debuggableTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.debuggableType));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "debuggableType"_s), debuggableTypeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.targetBuildVersion)) {
        auto targetBuildVersionValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.targetBuildVersion));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "targetBuildVersion"_s), targetBuildVersionValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.targetIsSimulator)) {
        auto targetIsSimulatorValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.targetIsSimulator));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "targetIsSimulator"_s), targetIsSimulatorValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.targetPlatformName)) {
        auto targetPlatformNameValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.targetPlatformName));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "targetPlatformName"_s), targetPlatformNameValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.targetProductVersion)) {
        auto targetProductVersionValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.targetProductVersion));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "targetProductVersion"_s), targetProductVersionValue);
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_loaded);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_closeWindow);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_reopen);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_reset);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_bringToFront);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_inspectedURLChanged);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_showCertificate);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setZoomFactor);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_zoomFactor);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setForcedAppearance);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_userInterfaceLayoutDirection);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_supportsDockSide);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_requestSetDockSide);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setAttachedWindowHeight);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setAttachedWindowWidth);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setSheetRect);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_startWindowDrag);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_moveWindowBy);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_copyText);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_killText);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_openURLExternally);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_revealFileExternally);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_canSave);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_save);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_canLoad);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_load);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_canPickColorFromScreen);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_pickColorFromScreen);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_showContextMenu);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_dispatchEventAsContextMenuEvent);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_sendMessageToBackend);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_unbufferedLog);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_isUnderTest);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_beep);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_inspectInspector);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_isBeingInspected);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setAllowsInspectingInspector);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_engineeringSettingsAllowed);
#if ENABLE(INSPECTOR_TELEMETRY)
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_logDiagnosticEvent);
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_didShowExtensionTab);
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_didHideExtensionTab);
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_didNavigateExtensionTab);
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_inspectedPageDidNavigate);
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_evaluateScriptInExtensionTab);
#endif
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_getPath);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_getCurrentX);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_getCurrentY);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setPath);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsInspectorFrontendHost_supportsShowCertificate);
static JSC_DECLARE_CUSTOM_GETTER(jsInspectorFrontendHost_isRemote);
static JSC_DECLARE_CUSTOM_GETTER(jsInspectorFrontendHost_localizedStringsURL);
static JSC_DECLARE_CUSTOM_GETTER(jsInspectorFrontendHost_backendCommandsURL);
static JSC_DECLARE_CUSTOM_GETTER(jsInspectorFrontendHost_inspectionLevel);
static JSC_DECLARE_CUSTOM_GETTER(jsInspectorFrontendHost_debuggableInfo);
static JSC_DECLARE_CUSTOM_GETTER(jsInspectorFrontendHost_platform);
static JSC_DECLARE_CUSTOM_GETTER(jsInspectorFrontendHost_platformVersionName);
static JSC_DECLARE_CUSTOM_GETTER(jsInspectorFrontendHost_supportsDiagnosticLogging);
static JSC_DECLARE_CUSTOM_GETTER(jsInspectorFrontendHost_supportsWebExtensions);

class JSInspectorFrontendHostPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInspectorFrontendHostPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInspectorFrontendHostPrototype* ptr = new (NotNull, JSC::allocateCell<JSInspectorFrontendHostPrototype>(vm)) JSInspectorFrontendHostPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorFrontendHostPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInspectorFrontendHostPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorFrontendHostPrototype, JSInspectorFrontendHostPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSInspectorFrontendHostPrototypeTableValues[] =
{
    { "supportsShowCertificate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInspectorFrontendHost_supportsShowCertificate, 0 } },
    { "isRemote"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInspectorFrontendHost_isRemote, 0 } },
    { "localizedStringsURL"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInspectorFrontendHost_localizedStringsURL, 0 } },
    { "backendCommandsURL"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInspectorFrontendHost_backendCommandsURL, 0 } },
    { "inspectionLevel"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInspectorFrontendHost_inspectionLevel, 0 } },
    { "debuggableInfo"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInspectorFrontendHost_debuggableInfo, 0 } },
    { "platform"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInspectorFrontendHost_platform, 0 } },
    { "platformVersionName"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInspectorFrontendHost_platformVersionName, 0 } },
    { "supportsDiagnosticLogging"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInspectorFrontendHost_supportsDiagnosticLogging, 0 } },
    { "supportsWebExtensions"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInspectorFrontendHost_supportsWebExtensions, 0 } },
    { "loaded"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_loaded, 0 } },
    { "closeWindow"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_closeWindow, 0 } },
    { "reopen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_reopen, 0 } },
    { "reset"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_reset, 0 } },
    { "bringToFront"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_bringToFront, 0 } },
    { "inspectedURLChanged"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_inspectedURLChanged, 1 } },
    { "showCertificate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_showCertificate, 1 } },
    { "setZoomFactor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_setZoomFactor, 1 } },
    { "zoomFactor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_zoomFactor, 0 } },
    { "setForcedAppearance"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_setForcedAppearance, 1 } },
    { "userInterfaceLayoutDirection"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_userInterfaceLayoutDirection, 0 } },
    { "supportsDockSide"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_supportsDockSide, 1 } },
    { "requestSetDockSide"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_requestSetDockSide, 1 } },
    { "setAttachedWindowHeight"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_setAttachedWindowHeight, 1 } },
    { "setAttachedWindowWidth"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_setAttachedWindowWidth, 1 } },
    { "setSheetRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_setSheetRect, 4 } },
    { "startWindowDrag"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_startWindowDrag, 0 } },
    { "moveWindowBy"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_moveWindowBy, 2 } },
    { "copyText"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_copyText, 1 } },
    { "killText"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_killText, 3 } },
    { "openURLExternally"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_openURLExternally, 1 } },
    { "revealFileExternally"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_revealFileExternally, 1 } },
    { "canSave"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_canSave, 1 } },
    { "save"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_save, 2 } },
    { "canLoad"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_canLoad, 0 } },
    { "load"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_load, 1 } },
    { "canPickColorFromScreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_canPickColorFromScreen, 0 } },
    { "pickColorFromScreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_pickColorFromScreen, 0 } },
    { "showContextMenu"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_showContextMenu, 2 } },
    { "dispatchEventAsContextMenuEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_dispatchEventAsContextMenuEvent, 1 } },
    { "sendMessageToBackend"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_sendMessageToBackend, 1 } },
    { "unbufferedLog"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_unbufferedLog, 1 } },
    { "isUnderTest"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_isUnderTest, 0 } },
    { "beep"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_beep, 0 } },
    { "inspectInspector"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_inspectInspector, 0 } },
    { "isBeingInspected"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_isBeingInspected, 0 } },
    { "setAllowsInspectingInspector"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_setAllowsInspectingInspector, 1 } },
    { "engineeringSettingsAllowed"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_engineeringSettingsAllowed, 0 } },
#if ENABLE(INSPECTOR_TELEMETRY)
    { "logDiagnosticEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_logDiagnosticEvent, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
    { "didShowExtensionTab"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_didShowExtensionTab, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
    { "didHideExtensionTab"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_didHideExtensionTab, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
    { "didNavigateExtensionTab"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_didNavigateExtensionTab, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
    { "inspectedPageDidNavigate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_inspectedPageDidNavigate, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
    { "evaluateScriptInExtensionTab"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_evaluateScriptInExtensionTab, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "getPath"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_getPath, 1 } },
    { "getCurrentX"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_getCurrentX, 1 } },
    { "getCurrentY"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_getCurrentY, 1 } },
    { "setPath"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorFrontendHostPrototypeFunction_setPath, 2 } },
};

const ClassInfo JSInspectorFrontendHostPrototype::s_info = { "InspectorFrontendHost"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorFrontendHostPrototype) };

void JSInspectorFrontendHostPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInspectorFrontendHost::info(), JSInspectorFrontendHostPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSInspectorFrontendHost::s_info = { "InspectorFrontendHost"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorFrontendHost) };

JSInspectorFrontendHost::JSInspectorFrontendHost(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InspectorFrontendHost>&& impl)
    : JSDOMWrapper<InspectorFrontendHost>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, InspectorFrontendHost>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSInspectorFrontendHost::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSInspectorFrontendHostPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSInspectorFrontendHostPrototype::create(vm, &globalObject, structure);
}

JSObject* JSInspectorFrontendHost::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInspectorFrontendHost>(vm, globalObject);
}

void JSInspectorFrontendHost::destroy(JSC::JSCell* cell)
{
    JSInspectorFrontendHost* thisObject = static_cast<JSInspectorFrontendHost*>(cell);
    thisObject->JSInspectorFrontendHost::~JSInspectorFrontendHost();
}

static inline JSValue jsInspectorFrontendHost_supportsShowCertificateGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.supportsShowCertificate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInspectorFrontendHost_supportsShowCertificate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHost_supportsShowCertificateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInspectorFrontendHost_isRemoteGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isRemote())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInspectorFrontendHost_isRemote, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHost_isRemoteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInspectorFrontendHost_localizedStringsURLGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.localizedStringsURL())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInspectorFrontendHost_localizedStringsURL, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHost_localizedStringsURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInspectorFrontendHost_backendCommandsURLGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.backendCommandsURL())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInspectorFrontendHost_backendCommandsURL, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHost_backendCommandsURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInspectorFrontendHost_inspectionLevelGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.inspectionLevel())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInspectorFrontendHost_inspectionLevel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHost_inspectionLevelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInspectorFrontendHost_debuggableInfoGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDictionary<InspectorFrontendHost::DebuggableInfo>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.debuggableInfo())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInspectorFrontendHost_debuggableInfo, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHost_debuggableInfoGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInspectorFrontendHost_platformGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.platform())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInspectorFrontendHost_platform, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHost_platformGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInspectorFrontendHost_platformVersionNameGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.platformVersionName())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInspectorFrontendHost_platformVersionName, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHost_platformVersionNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInspectorFrontendHost_supportsDiagnosticLoggingGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.supportsDiagnosticLogging())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInspectorFrontendHost_supportsDiagnosticLogging, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHost_supportsDiagnosticLoggingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInspectorFrontendHost_supportsWebExtensionsGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.supportsWebExtensions())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInspectorFrontendHost_supportsWebExtensions, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHost_supportsWebExtensionsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_loadedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.loaded(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_loaded, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_loadedBody>(*lexicalGlobalObject, *callFrame, "loaded");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_closeWindowBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.closeWindow(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_closeWindow, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_closeWindowBody>(*lexicalGlobalObject, *callFrame, "closeWindow");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_reopenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.reopen(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_reopen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_reopenBody>(*lexicalGlobalObject, *callFrame, "reopen");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_resetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.reset(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_reset, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_resetBody>(*lexicalGlobalObject, *callFrame, "reset");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_bringToFrontBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bringToFront(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_bringToFront, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_bringToFrontBody>(*lexicalGlobalObject, *callFrame, "bringToFront");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_inspectedURLChangedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto newURL = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.inspectedURLChanged(WTFMove(newURL)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_inspectedURLChanged, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_inspectedURLChangedBody>(*lexicalGlobalObject, *callFrame, "inspectedURLChanged");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_showCertificateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto serializedCertificate = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.showCertificate(WTFMove(serializedCertificate)))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_showCertificate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_showCertificateBody>(*lexicalGlobalObject, *callFrame, "showCertificate");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_setZoomFactorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto zoom = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setZoomFactor(WTFMove(zoom)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setZoomFactor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_setZoomFactorBody>(*lexicalGlobalObject, *callFrame, "setZoomFactor");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_zoomFactorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.zoomFactor())));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_zoomFactor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_zoomFactorBody>(*lexicalGlobalObject, *callFrame, "zoomFactor");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_setForcedAppearanceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto appearance = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setForcedAppearance(WTFMove(appearance)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setForcedAppearance, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_setForcedAppearanceBody>(*lexicalGlobalObject, *callFrame, "setForcedAppearance");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_userInterfaceLayoutDirectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.userInterfaceLayoutDirection())));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_userInterfaceLayoutDirection, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_userInterfaceLayoutDirectionBody>(*lexicalGlobalObject, *callFrame, "userInterfaceLayoutDirection");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_supportsDockSideBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dockSide = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.supportsDockSide(WTFMove(dockSide)))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_supportsDockSide, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_supportsDockSideBody>(*lexicalGlobalObject, *callFrame, "supportsDockSide");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_requestSetDockSideBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dockSide = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.requestSetDockSide(WTFMove(dockSide)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_requestSetDockSide, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_requestSetDockSideBody>(*lexicalGlobalObject, *callFrame, "requestSetDockSide");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_setAttachedWindowHeightBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto height = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setAttachedWindowHeight(WTFMove(height)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setAttachedWindowHeight, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_setAttachedWindowHeightBody>(*lexicalGlobalObject, *callFrame, "setAttachedWindowHeight");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_setAttachedWindowWidthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto width = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setAttachedWindowWidth(WTFMove(width)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setAttachedWindowWidth, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_setAttachedWindowWidthBody>(*lexicalGlobalObject, *callFrame, "setAttachedWindowWidth");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_setSheetRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto width = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto height = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setSheetRect(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setSheetRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_setSheetRectBody>(*lexicalGlobalObject, *callFrame, "setSheetRect");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_startWindowDragBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.startWindowDrag(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_startWindowDrag, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_startWindowDragBody>(*lexicalGlobalObject, *callFrame, "startWindowDrag");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_moveWindowByBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.moveWindowBy(WTFMove(x), WTFMove(y)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_moveWindowBy, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_moveWindowByBody>(*lexicalGlobalObject, *callFrame, "moveWindowBy");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_copyTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyText(WTFMove(text)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_copyText, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_copyTextBody>(*lexicalGlobalObject, *callFrame, "copyText");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_killTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto shouldPrependToKillRing = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto shouldStartNewSequence = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.killText(WTFMove(text), WTFMove(shouldPrependToKillRing), WTFMove(shouldStartNewSequence)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_killText, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_killTextBody>(*lexicalGlobalObject, *callFrame, "killText");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_openURLExternallyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.openURLExternally(WTFMove(url)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_openURLExternally, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_openURLExternallyBody>(*lexicalGlobalObject, *callFrame, "openURLExternally");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_revealFileExternallyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto path = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.revealFileExternally(WTFMove(path)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_revealFileExternally, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_revealFileExternallyBody>(*lexicalGlobalObject, *callFrame, "revealFileExternally");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_canSaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto saveMode = convert<IDLEnumeration<InspectorFrontendHost::SaveMode>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "saveMode", "InspectorFrontendHost", "canSave", expectedEnumerationValues<InspectorFrontendHost::SaveMode>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.canSave(WTFMove(saveMode)))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_canSave, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_canSaveBody>(*lexicalGlobalObject, *callFrame, "canSave");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_saveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto saveDatas = convert<IDLSequence<IDLDictionary<InspectorFrontendHost::SaveData>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto forceSaveAs = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.save(WTFMove(saveDatas), WTFMove(forceSaveAs)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_save, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_saveBody>(*lexicalGlobalObject, *callFrame, "save");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_canLoadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.canLoad())));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_canLoad, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_canLoadBody>(*lexicalGlobalObject, *callFrame, "canLoad");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_loadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSInspectorFrontendHost>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto path = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.load(WTFMove(path), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_load, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_loadBody>(*lexicalGlobalObject, *callFrame, "load");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_canPickColorFromScreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.canPickColorFromScreen())));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_canPickColorFromScreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_canPickColorFromScreenBody>(*lexicalGlobalObject, *callFrame, "canPickColorFromScreen");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_pickColorFromScreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSInspectorFrontendHost>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.pickColorFromScreen(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_pickColorFromScreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_pickColorFromScreenBody>(*lexicalGlobalObject, *callFrame, "pickColorFromScreen");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_showContextMenuBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto event = convert<IDLInterface<Event>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "event", "InspectorFrontendHost", "showContextMenu", "Event"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto items = convert<IDLSequence<IDLDictionary<InspectorFrontendHost::ContextMenuItem>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.showContextMenu(*event, WTFMove(items)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_showContextMenu, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_showContextMenuBody>(*lexicalGlobalObject, *callFrame, "showContextMenu");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_dispatchEventAsContextMenuEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto event = convert<IDLInterface<Event>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "event", "InspectorFrontendHost", "dispatchEventAsContextMenuEvent", "Event"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.dispatchEventAsContextMenuEvent(*event); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_dispatchEventAsContextMenuEvent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_dispatchEventAsContextMenuEventBody>(*lexicalGlobalObject, *callFrame, "dispatchEventAsContextMenuEvent");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_sendMessageToBackendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto message = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.sendMessageToBackend(WTFMove(message)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_sendMessageToBackend, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_sendMessageToBackendBody>(*lexicalGlobalObject, *callFrame, "sendMessageToBackend");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_unbufferedLogBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto message = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.unbufferedLog(WTFMove(message)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_unbufferedLog, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_unbufferedLogBody>(*lexicalGlobalObject, *callFrame, "unbufferedLog");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_isUnderTestBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isUnderTest())));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_isUnderTest, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_isUnderTestBody>(*lexicalGlobalObject, *callFrame, "isUnderTest");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_beepBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.beep(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_beep, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_beepBody>(*lexicalGlobalObject, *callFrame, "beep");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_inspectInspectorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.inspectInspector(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_inspectInspector, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_inspectInspectorBody>(*lexicalGlobalObject, *callFrame, "inspectInspector");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_isBeingInspectedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isBeingInspected())));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_isBeingInspected, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_isBeingInspectedBody>(*lexicalGlobalObject, *callFrame, "isBeingInspected");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_setAllowsInspectingInspectorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto allow = convert<IDLBoolean>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setAllowsInspectingInspector(WTFMove(allow)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setAllowsInspectingInspector, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_setAllowsInspectingInspectorBody>(*lexicalGlobalObject, *callFrame, "setAllowsInspectingInspector");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_engineeringSettingsAllowedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.engineeringSettingsAllowed())));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_engineeringSettingsAllowed, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_engineeringSettingsAllowedBody>(*lexicalGlobalObject, *callFrame, "engineeringSettingsAllowed");
}

#if ENABLE(INSPECTOR_TELEMETRY)
static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_logDiagnosticEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto eventName = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto content = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.logDiagnosticEvent(WTFMove(eventName), WTFMove(content)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_logDiagnosticEvent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_logDiagnosticEventBody>(*lexicalGlobalObject, *callFrame, "logDiagnosticEvent");
}

#endif

#if ENABLE(INSPECTOR_EXTENSIONS)
static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_didShowExtensionTabBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto extensionID = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto extensionTabID = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto extensionFrame = convert<IDLInterface<HTMLIFrameElement>>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "extensionFrame", "InspectorFrontendHost", "didShowExtensionTab", "HTMLIFrameElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.didShowExtensionTab(WTFMove(extensionID), WTFMove(extensionTabID), *extensionFrame); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_didShowExtensionTab, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_didShowExtensionTabBody>(*lexicalGlobalObject, *callFrame, "didShowExtensionTab");
}

#endif

#if ENABLE(INSPECTOR_EXTENSIONS)
static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_didHideExtensionTabBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto extensionID = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto extensionTabID = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.didHideExtensionTab(WTFMove(extensionID), WTFMove(extensionTabID)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_didHideExtensionTab, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_didHideExtensionTabBody>(*lexicalGlobalObject, *callFrame, "didHideExtensionTab");
}

#endif

#if ENABLE(INSPECTOR_EXTENSIONS)
static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_didNavigateExtensionTabBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto extensionID = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto extensionTabID = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto newURL = convert<IDLDOMString>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.didNavigateExtensionTab(WTFMove(extensionID), WTFMove(extensionTabID), WTFMove(newURL)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_didNavigateExtensionTab, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_didNavigateExtensionTabBody>(*lexicalGlobalObject, *callFrame, "didNavigateExtensionTab");
}

#endif

#if ENABLE(INSPECTOR_EXTENSIONS)
static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_inspectedPageDidNavigateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto newURL = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.inspectedPageDidNavigate(WTFMove(newURL)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_inspectedPageDidNavigate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_inspectedPageDidNavigateBody>(*lexicalGlobalObject, *callFrame, "inspectedPageDidNavigate");
}

#endif

#if ENABLE(INSPECTOR_EXTENSIONS)
static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_evaluateScriptInExtensionTabBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto extensionFrame = convert<IDLInterface<HTMLIFrameElement>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "extensionFrame", "InspectorFrontendHost", "evaluateScriptInExtensionTab", "HTMLIFrameElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto scriptSource = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, impl.evaluateScriptInExtensionTab(*extensionFrame, WTFMove(scriptSource)))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_evaluateScriptInExtensionTab, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_evaluateScriptInExtensionTabBody>(*lexicalGlobalObject, *callFrame, "evaluateScriptInExtensionTab");
}

#endif

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_getPath1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto file = convert<IDLInterface<File>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "file", "InspectorFrontendHost", "getPath", "File"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.getPath(*file))));
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_getCurrentXBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto context = convert<IDLInterface<CanvasRenderingContext2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context", "InspectorFrontendHost", "getCurrentX", "CanvasRenderingContext2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.getCurrentX(*context))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_getCurrentX, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_getCurrentXBody>(*lexicalGlobalObject, *callFrame, "getCurrentX");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_getCurrentYBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto context = convert<IDLInterface<CanvasRenderingContext2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context", "InspectorFrontendHost", "getCurrentY", "CanvasRenderingContext2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.getCurrentY(*context))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_getCurrentY, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_getCurrentYBody>(*lexicalGlobalObject, *callFrame, "getCurrentY");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_getPath2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto context = convert<IDLInterface<CanvasRenderingContext2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context", "InspectorFrontendHost", "getPath", "CanvasRenderingContext2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Path2D>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getPath(*context))));
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_getPathOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSFile>())
            RELEASE_AND_RETURN(throwScope, (jsInspectorFrontendHostPrototypeFunction_getPath1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSCanvasRenderingContext2D>())
            RELEASE_AND_RETURN(throwScope, (jsInspectorFrontendHostPrototypeFunction_getPath2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_getPath, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_getPathOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getPath");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunction_setPathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto context = convert<IDLInterface<CanvasRenderingContext2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context", "InspectorFrontendHost", "setPath", "CanvasRenderingContext2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "path", "InspectorFrontendHost", "setPath", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setPath(*context, *path); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorFrontendHostPrototypeFunction_setPath, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunction_setPathBody>(*lexicalGlobalObject, *callFrame, "setPath");
}

JSC::GCClient::IsoSubspace* JSInspectorFrontendHost::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSInspectorFrontendHost, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForInspectorFrontendHost.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForInspectorFrontendHost = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForInspectorFrontendHost.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForInspectorFrontendHost = std::forward<decltype(space)>(space); }
    );
}

void JSInspectorFrontendHost::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInspectorFrontendHost*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSInspectorFrontendHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSInspectorFrontendHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsInspectorFrontendHost = static_cast<JSInspectorFrontendHost*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsInspectorFrontendHost->wrapped(), jsInspectorFrontendHost);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7InspectorFrontendHost@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21InspectorFrontendHostE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InspectorFrontendHost>&& impl)
{

    if constexpr (std::is_polymorphic_v<InspectorFrontendHost>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7InspectorFrontendHost@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21InspectorFrontendHostE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // InspectorFrontendHost has subclasses. If InspectorFrontendHost has subclasses that get passed
        // to toJS() we currently require InspectorFrontendHost you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<InspectorFrontendHost>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InspectorFrontendHost& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

InspectorFrontendHost* JSInspectorFrontendHost::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSInspectorFrontendHost*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
