/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSServiceWorkerRegistration.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSNavigationPreloadManager.h"
#include "JSServiceWorker.h"
#include "JSServiceWorkerUpdateViaCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(NOTIFICATION_EVENT)
#include "JSDOMConvertSequences.h"
#include "JSNotification.h"
#include "JSNotificationOptions.h"
#include <JavaScriptCore/JSArray.h>
#endif

#if ENABLE(SERVICE_WORKER)
#include "JSBackgroundFetchManager.h"
#include "JSPushManager.h"
#include "ServiceWorkerRegistrationBackgroundFetchAPI.h"
#include "ServiceWorkerRegistrationPushAPI.h"
#endif


namespace WebCore {
using namespace JSC;

#if ENABLE(NOTIFICATION_EVENT)

template<> ServiceWorkerRegistration::GetNotificationOptions convertDictionary<ServiceWorkerRegistration::GetNotificationOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ServiceWorkerRegistration::GetNotificationOptions result;
    JSValue tagValue;
    if (isNullOrUndefined)
        tagValue = jsUndefined();
    else {
        tagValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tag"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tagValue.isUndefined()) {
        result.tag = convert<IDLDOMString>(lexicalGlobalObject, tagValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tag = emptyString();
    return result;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerRegistrationPrototypeFunction_update);
static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerRegistrationPrototypeFunction_unregister);
#if ENABLE(NOTIFICATION_EVENT)
static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerRegistrationPrototypeFunction_showNotification);
#endif
#if ENABLE(NOTIFICATION_EVENT)
static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerRegistrationPrototypeFunction_getNotifications);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerRegistrationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerRegistration_installing);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerRegistration_waiting);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerRegistration_active);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerRegistration_navigationPreload);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerRegistration_scope);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerRegistration_updateViaCache);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerRegistration_onupdatefound);
static JSC_DECLARE_CUSTOM_SETTER(setJSServiceWorkerRegistration_onupdatefound);
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerRegistration_pushManager);
#endif
#if ENABLE(SERVICE_WORKER)
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerRegistration_backgroundFetch);
#endif

class JSServiceWorkerRegistrationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSServiceWorkerRegistrationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSServiceWorkerRegistrationPrototype* ptr = new (NotNull, JSC::allocateCell<JSServiceWorkerRegistrationPrototype>(vm)) JSServiceWorkerRegistrationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerRegistrationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSServiceWorkerRegistrationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerRegistrationPrototype, JSServiceWorkerRegistrationPrototype::Base);

using JSServiceWorkerRegistrationDOMConstructor = JSDOMConstructorNotConstructable<JSServiceWorkerRegistration>;

template<> const ClassInfo JSServiceWorkerRegistrationDOMConstructor::s_info = { "ServiceWorkerRegistration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerRegistrationDOMConstructor) };

template<> JSValue JSServiceWorkerRegistrationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSServiceWorkerRegistrationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ServiceWorkerRegistration"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSServiceWorkerRegistration::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSServiceWorkerRegistrationPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerRegistrationConstructor, 0 } },
    { "installing"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerRegistration_installing, 0 } },
    { "waiting"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerRegistration_waiting, 0 } },
    { "active"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerRegistration_active, 0 } },
    { "navigationPreload"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerRegistration_navigationPreload, 0 } },
    { "scope"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerRegistration_scope, 0 } },
    { "updateViaCache"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerRegistration_updateViaCache, 0 } },
    { "onupdatefound"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerRegistration_onupdatefound, setJSServiceWorkerRegistration_onupdatefound } },
#if ENABLE(SERVICE_WORKER)
    { "pushManager"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerRegistration_pushManager, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(SERVICE_WORKER)
    { "backgroundFetch"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerRegistration_backgroundFetch, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "update"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerRegistrationPrototypeFunction_update, 0 } },
    { "unregister"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerRegistrationPrototypeFunction_unregister, 0 } },
#if ENABLE(NOTIFICATION_EVENT)
    { "showNotification"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerRegistrationPrototypeFunction_showNotification, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(NOTIFICATION_EVENT)
    { "getNotifications"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerRegistrationPrototypeFunction_getNotifications, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

const ClassInfo JSServiceWorkerRegistrationPrototype::s_info = { "ServiceWorkerRegistration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerRegistrationPrototype) };

void JSServiceWorkerRegistrationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSServiceWorkerRegistration::info(), JSServiceWorkerRegistrationPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(NOTIFICATION_EVENT)
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().notificationEventEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "showNotification"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(NOTIFICATION_EVENT)
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().notificationEventEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "getNotifications"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkerNavigationPreloadEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "navigationPreload"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(SERVICE_WORKER)
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().pushAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "pushManager"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(SERVICE_WORKER)
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkersEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().backgroundFetchAPIEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "backgroundFetch"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSServiceWorkerRegistration::s_info = { "ServiceWorkerRegistration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerRegistration) };

JSServiceWorkerRegistration::JSServiceWorkerRegistration(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ServiceWorkerRegistration>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, ServiceWorkerRegistration>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSServiceWorkerRegistration::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSServiceWorkerRegistrationPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSServiceWorkerRegistrationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSServiceWorkerRegistration::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSServiceWorkerRegistration>(vm, globalObject);
}

JSValue JSServiceWorkerRegistration::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSServiceWorkerRegistrationDOMConstructor, DOMConstructorID::ServiceWorkerRegistration>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerRegistrationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerRegistrationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSServiceWorkerRegistration::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsServiceWorkerRegistration_installingGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<ServiceWorker>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.installing())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerRegistration_installing, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistration_installingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerRegistration_waitingGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<ServiceWorker>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.waiting())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerRegistration_waiting, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistration_waitingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerRegistration_activeGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<ServiceWorker>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.active())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerRegistration_active, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistration_activeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerRegistration_navigationPreloadGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<NavigationPreloadManager>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.navigationPreload())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerRegistration_navigationPreload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistration_navigationPreloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerRegistration_scopeGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.scope())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerRegistration_scope, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistration_scopeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerRegistration_updateViaCacheGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ServiceWorkerUpdateViaCache>>(lexicalGlobalObject, throwScope, impl.updateViaCache())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerRegistration_updateViaCache, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistration_updateViaCacheGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerRegistration_onupdatefoundGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().updatefoundEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerRegistration_onupdatefound, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistration_onupdatefoundGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSServiceWorkerRegistration_onupdatefoundSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().updatefoundEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSServiceWorkerRegistration_onupdatefound, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerRegistration>::set<setJSServiceWorkerRegistration_onupdatefoundSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerRegistration_pushManagerGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<PushManager>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::ServiceWorkerRegistrationPushAPI::pushManager(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerRegistration_pushManager, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistration_pushManagerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerRegistration_backgroundFetchGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerRegistration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<BackgroundFetchManager>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::ServiceWorkerRegistrationBackgroundFetchAPI::backgroundFetch(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerRegistration_backgroundFetch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerRegistration>::get<jsServiceWorkerRegistration_backgroundFetchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsServiceWorkerRegistrationPrototypeFunction_updateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerRegistration>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.update(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerRegistrationPrototypeFunction_update, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSServiceWorkerRegistration>::call<jsServiceWorkerRegistrationPrototypeFunction_updateBody>(*lexicalGlobalObject, *callFrame, "update");
}

static inline JSC::EncodedJSValue jsServiceWorkerRegistrationPrototypeFunction_unregisterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerRegistration>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLBoolean>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.unregister(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerRegistrationPrototypeFunction_unregister, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSServiceWorkerRegistration>::call<jsServiceWorkerRegistrationPrototypeFunction_unregisterBody>(*lexicalGlobalObject, *callFrame, "unregister");
}

#if ENABLE(NOTIFICATION_EVENT)
static inline JSC::EncodedJSValue jsServiceWorkerRegistrationPrototypeFunction_showNotificationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerRegistration>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto title = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<NotificationOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.showNotification(*context, WTFMove(title), WTFMove(options), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerRegistrationPrototypeFunction_showNotification, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSServiceWorkerRegistration>::call<jsServiceWorkerRegistrationPrototypeFunction_showNotificationBody>(*lexicalGlobalObject, *callFrame, "showNotification");
}

#endif

#if ENABLE(NOTIFICATION_EVENT)
static inline JSC::EncodedJSValue jsServiceWorkerRegistrationPrototypeFunction_getNotificationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerRegistration>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto filter = convert<IDLDictionary<ServiceWorkerRegistration::GetNotificationOptions>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLInterface<Notification>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getNotifications(WTFMove(filter), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerRegistrationPrototypeFunction_getNotifications, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSServiceWorkerRegistration>::call<jsServiceWorkerRegistrationPrototypeFunction_getNotificationsBody>(*lexicalGlobalObject, *callFrame, "getNotifications");
}

#endif

JSC::GCClient::IsoSubspace* JSServiceWorkerRegistration::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSServiceWorkerRegistration, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForServiceWorkerRegistration.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForServiceWorkerRegistration = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForServiceWorkerRegistration.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForServiceWorkerRegistration = std::forward<decltype(space)>(space); }
    );
}

void JSServiceWorkerRegistration::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerRegistration*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSServiceWorkerRegistrationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsServiceWorkerRegistration = jsCast<JSServiceWorkerRegistration*>(handle.slot()->asCell());
    auto& wrapped = jsServiceWorkerRegistration->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    ServiceWorkerRegistration* owner = &jsServiceWorkerRegistration->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from ServiceWorkerRegistration";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSServiceWorkerRegistrationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsServiceWorkerRegistration = static_cast<JSServiceWorkerRegistration*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsServiceWorkerRegistration->wrapped(), jsServiceWorkerRegistration);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ServiceWorkerRegistration@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25ServiceWorkerRegistrationE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ServiceWorkerRegistration>&& impl)
{

    if constexpr (std::is_polymorphic_v<ServiceWorkerRegistration>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ServiceWorkerRegistration@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25ServiceWorkerRegistrationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ServiceWorkerRegistration has subclasses. If ServiceWorkerRegistration has subclasses that get passed
        // to toJS() we currently require ServiceWorkerRegistration you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ServiceWorkerRegistration>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ServiceWorkerRegistration& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ServiceWorkerRegistration* JSServiceWorkerRegistration::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSServiceWorkerRegistration*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SERVICE_WORKER)
