/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTexturePVRTC.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLCompressedTexturePVRTCPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLCompressedTexturePVRTCPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTexturePVRTCPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTexturePVRTCPrototype>(vm)) JSWebGLCompressedTexturePVRTCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTexturePVRTCPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTexturePVRTCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTexturePVRTCPrototype, JSWebGLCompressedTexturePVRTCPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTexturePVRTCPrototypeTableValues[] =
{
    { "COMPRESSED_RGB_PVRTC_4BPPV1_IMG"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8C00 } },
    { "COMPRESSED_RGB_PVRTC_2BPPV1_IMG"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8C01 } },
    { "COMPRESSED_RGBA_PVRTC_4BPPV1_IMG"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8C02 } },
    { "COMPRESSED_RGBA_PVRTC_2BPPV1_IMG"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8C03 } },
};

const ClassInfo JSWebGLCompressedTexturePVRTCPrototype::s_info = { "WebGLCompressedTexturePVRTC"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTexturePVRTCPrototype) };

void JSWebGLCompressedTexturePVRTCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTexturePVRTC::info(), JSWebGLCompressedTexturePVRTCPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLCompressedTexturePVRTC::s_info = { "WebGLCompressedTexturePVRTC"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTexturePVRTC) };

JSWebGLCompressedTexturePVRTC::JSWebGLCompressedTexturePVRTC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTexturePVRTC>&& impl)
    : JSDOMWrapper<WebGLCompressedTexturePVRTC>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLCompressedTexturePVRTC>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLCompressedTexturePVRTC::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLCompressedTexturePVRTCPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLCompressedTexturePVRTCPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLCompressedTexturePVRTC::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTexturePVRTC>(vm, globalObject);
}

void JSWebGLCompressedTexturePVRTC::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTexturePVRTC* thisObject = static_cast<JSWebGLCompressedTexturePVRTC*>(cell);
    thisObject->JSWebGLCompressedTexturePVRTC::~JSWebGLCompressedTexturePVRTC();
}

JSC::GCClient::IsoSubspace* JSWebGLCompressedTexturePVRTC::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLCompressedTexturePVRTC, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLCompressedTexturePVRTC.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLCompressedTexturePVRTC = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLCompressedTexturePVRTC.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLCompressedTexturePVRTC = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLCompressedTexturePVRTC::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLCompressedTexturePVRTC*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLCompressedTexturePVRTCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLCompressedTexturePVRTC = jsCast<JSWebGLCompressedTexturePVRTC*>(handle.slot()->asCell());
    WebGLRenderingContextBase* owner = WTF::getPtr(jsWebGLCompressedTexturePVRTC->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLCompressedTexturePVRTC";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLCompressedTexturePVRTCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTexturePVRTC = static_cast<JSWebGLCompressedTexturePVRTC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLCompressedTexturePVRTC->wrapped(), jsWebGLCompressedTexturePVRTC);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTexturePVRTC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27WebGLCompressedTexturePVRTCE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLCompressedTexturePVRTC>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebGLCompressedTexturePVRTC>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLCompressedTexturePVRTC@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27WebGLCompressedTexturePVRTCE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLCompressedTexturePVRTC has subclasses. If WebGLCompressedTexturePVRTC has subclasses that get passed
        // to toJS() we currently require WebGLCompressedTexturePVRTC you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebGLCompressedTexturePVRTC>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLCompressedTexturePVRTC& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLCompressedTexturePVRTC* JSWebGLCompressedTexturePVRTC::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTexturePVRTC*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
