/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathResult.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsXPathResultPrototypeFunction_iterateNext);
static JSC_DECLARE_HOST_FUNCTION(jsXPathResultPrototypeFunction_snapshotItem);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsXPathResultConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsXPathResult_resultType);
static JSC_DECLARE_CUSTOM_GETTER(jsXPathResult_numberValue);
static JSC_DECLARE_CUSTOM_GETTER(jsXPathResult_stringValue);
static JSC_DECLARE_CUSTOM_GETTER(jsXPathResult_booleanValue);
static JSC_DECLARE_CUSTOM_GETTER(jsXPathResult_singleNodeValue);
static JSC_DECLARE_CUSTOM_GETTER(jsXPathResult_invalidIteratorState);
static JSC_DECLARE_CUSTOM_GETTER(jsXPathResult_snapshotLength);

class JSXPathResultPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXPathResultPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathResultPrototype* ptr = new (NotNull, JSC::allocateCell<JSXPathResultPrototype>(vm)) JSXPathResultPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXPathResultPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXPathResultPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXPathResultPrototype, JSXPathResultPrototype::Base);

using JSXPathResultDOMConstructor = JSDOMConstructorNotConstructable<JSXPathResult>;

/* Hash table for constructor */

static const HashTableValue JSXPathResultConstructorTableValues[] =
{
    { "ANY_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "NUMBER_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "STRING_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "BOOLEAN_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "UNORDERED_NODE_ITERATOR_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    { "ORDERED_NODE_ITERATOR_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    { "UNORDERED_NODE_SNAPSHOT_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    { "ORDERED_NODE_SNAPSHOT_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    { "ANY_UNORDERED_NODE_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    { "FIRST_ORDERED_NODE_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
};

static_assert(XPathResult::ANY_TYPE == 0, "ANY_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::NUMBER_TYPE == 1, "NUMBER_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::STRING_TYPE == 2, "STRING_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::BOOLEAN_TYPE == 3, "BOOLEAN_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::UNORDERED_NODE_ITERATOR_TYPE == 4, "UNORDERED_NODE_ITERATOR_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::ORDERED_NODE_ITERATOR_TYPE == 5, "ORDERED_NODE_ITERATOR_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::UNORDERED_NODE_SNAPSHOT_TYPE == 6, "UNORDERED_NODE_SNAPSHOT_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::ORDERED_NODE_SNAPSHOT_TYPE == 7, "ORDERED_NODE_SNAPSHOT_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::ANY_UNORDERED_NODE_TYPE == 8, "ANY_UNORDERED_NODE_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::FIRST_ORDERED_NODE_TYPE == 9, "FIRST_ORDERED_NODE_TYPE in XPathResult does not match value from IDL");

template<> const ClassInfo JSXPathResultDOMConstructor::s_info = { "XPathResult"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathResultDOMConstructor) };

template<> JSValue JSXPathResultDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXPathResultDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "XPathResult"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSXPathResult::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSXPathResult::info(), JSXPathResultConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSXPathResultPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsXPathResultConstructor, 0 } },
    { "resultType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXPathResult_resultType, 0 } },
    { "numberValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXPathResult_numberValue, 0 } },
    { "stringValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXPathResult_stringValue, 0 } },
    { "booleanValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXPathResult_booleanValue, 0 } },
    { "singleNodeValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXPathResult_singleNodeValue, 0 } },
    { "invalidIteratorState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXPathResult_invalidIteratorState, 0 } },
    { "snapshotLength"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXPathResult_snapshotLength, 0 } },
    { "iterateNext"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXPathResultPrototypeFunction_iterateNext, 0 } },
    { "snapshotItem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXPathResultPrototypeFunction_snapshotItem, 1 } },
    { "ANY_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "NUMBER_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "STRING_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "BOOLEAN_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "UNORDERED_NODE_ITERATOR_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    { "ORDERED_NODE_ITERATOR_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    { "UNORDERED_NODE_SNAPSHOT_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    { "ORDERED_NODE_SNAPSHOT_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    { "ANY_UNORDERED_NODE_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    { "FIRST_ORDERED_NODE_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
};

const ClassInfo JSXPathResultPrototype::s_info = { "XPathResult"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathResultPrototype) };

void JSXPathResultPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXPathResult::info(), JSXPathResultPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSXPathResult::s_info = { "XPathResult"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathResult) };

JSXPathResult::JSXPathResult(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XPathResult>&& impl)
    : JSDOMWrapper<XPathResult>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, XPathResult>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSXPathResult::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSXPathResultPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSXPathResultPrototype::create(vm, &globalObject, structure);
}

JSObject* JSXPathResult::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXPathResult>(vm, globalObject);
}

JSValue JSXPathResult::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathResultDOMConstructor, DOMConstructorID::XPathResult>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSXPathResult::destroy(JSC::JSCell* cell)
{
    JSXPathResult* thisObject = static_cast<JSXPathResult*>(cell);
    thisObject->JSXPathResult::~JSXPathResult();
}

JSC_DEFINE_CUSTOM_GETTER(jsXPathResultConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXPathResultPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXPathResult::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsXPathResult_resultTypeGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.resultType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXPathResult_resultType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResult_resultTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXPathResult_numberValueGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.numberValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXPathResult_numberValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResult_numberValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXPathResult_stringValueGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.stringValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXPathResult_stringValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResult_stringValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXPathResult_booleanValueGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.booleanValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXPathResult_booleanValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResult_booleanValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXPathResult_singleNodeValueGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.singleNodeValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXPathResult_singleNodeValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResult_singleNodeValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXPathResult_invalidIteratorStateGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.invalidIteratorState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXPathResult_invalidIteratorState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResult_invalidIteratorStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXPathResult_snapshotLengthGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.snapshotLength())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXPathResult_snapshotLength, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResult_snapshotLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsXPathResultPrototypeFunction_iterateNextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXPathResult>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.iterateNext())));
}

JSC_DEFINE_HOST_FUNCTION(jsXPathResultPrototypeFunction_iterateNext, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXPathResult>::call<jsXPathResultPrototypeFunction_iterateNextBody>(*lexicalGlobalObject, *callFrame, "iterateNext");
}

static inline JSC::EncodedJSValue jsXPathResultPrototypeFunction_snapshotItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXPathResult>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.snapshotItem(WTFMove(index)))));
}

JSC_DEFINE_HOST_FUNCTION(jsXPathResultPrototypeFunction_snapshotItem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXPathResult>::call<jsXPathResultPrototypeFunction_snapshotItemBody>(*lexicalGlobalObject, *callFrame, "snapshotItem");
}

JSC::GCClient::IsoSubspace* JSXPathResult::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSXPathResult, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForXPathResult.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForXPathResult = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForXPathResult.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForXPathResult = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSXPathResult::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSXPathResult*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSXPathResult);

template<typename Visitor>
void JSXPathResult::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSXPathResult*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSXPathResult::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSXPathResult::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSXPathResult::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXPathResult*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXPathResultOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSXPathResultOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXPathResult = static_cast<JSXPathResult*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXPathResult->wrapped(), jsXPathResult);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7XPathResult@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11XPathResultE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XPathResult>&& impl)
{

    if constexpr (std::is_polymorphic_v<XPathResult>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7XPathResult@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11XPathResultE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // XPathResult has subclasses. If XPathResult has subclasses that get passed
        // to toJS() we currently require XPathResult you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<XPathResult>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XPathResult& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

XPathResult* JSXPathResult::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXPathResult*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
