/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVTTCue.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocumentFragment.h"
#include "JSVTTRegion.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(VTTCue::AutoKeyword enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("auto"),
    };
    static_assert(static_cast<size_t>(VTTCue::AutoKeyword::Auto) == 0, "VTTCue::AutoKeyword::Auto is not 0 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, VTTCue::AutoKeyword enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<VTTCue::AutoKeyword> parseEnumerationFromString<VTTCue::AutoKeyword>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, VTTCue::AutoKeyword> mappings[] = {
        { "auto", VTTCue::AutoKeyword::Auto },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<VTTCue::AutoKeyword> parseEnumeration<VTTCue::AutoKeyword>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<VTTCue::AutoKeyword>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<VTTCue::AutoKeyword>()
{
    return "\"auto\""_s;
}

String convertEnumerationToString(VTTCue::DirectionSetting enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        emptyString(),
        MAKE_STATIC_STRING_IMPL("rl"),
        MAKE_STATIC_STRING_IMPL("lr"),
    };
    static_assert(static_cast<size_t>(VTTCue::DirectionSetting::EmptyString) == 0, "VTTCue::DirectionSetting::EmptyString is not 0 as expected");
    static_assert(static_cast<size_t>(VTTCue::DirectionSetting::Rl) == 1, "VTTCue::DirectionSetting::Rl is not 1 as expected");
    static_assert(static_cast<size_t>(VTTCue::DirectionSetting::Lr) == 2, "VTTCue::DirectionSetting::Lr is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, VTTCue::DirectionSetting enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<VTTCue::DirectionSetting> parseEnumerationFromString<VTTCue::DirectionSetting>(const String& stringValue)
{
    if (stringValue.isEmpty())
        return VTTCue::DirectionSetting::EmptyString;
    static constexpr std::pair<ComparableASCIILiteral, VTTCue::DirectionSetting> mappings[] = {
        { "lr", VTTCue::DirectionSetting::Lr },
        { "rl", VTTCue::DirectionSetting::Rl },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<VTTCue::DirectionSetting> parseEnumeration<VTTCue::DirectionSetting>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<VTTCue::DirectionSetting>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<VTTCue::DirectionSetting>()
{
    return "\"\", \"rl\", \"lr\""_s;
}

String convertEnumerationToString(VTTCue::LineAlignSetting enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("start"),
        MAKE_STATIC_STRING_IMPL("center"),
        MAKE_STATIC_STRING_IMPL("end"),
    };
    static_assert(static_cast<size_t>(VTTCue::LineAlignSetting::Start) == 0, "VTTCue::LineAlignSetting::Start is not 0 as expected");
    static_assert(static_cast<size_t>(VTTCue::LineAlignSetting::Center) == 1, "VTTCue::LineAlignSetting::Center is not 1 as expected");
    static_assert(static_cast<size_t>(VTTCue::LineAlignSetting::End) == 2, "VTTCue::LineAlignSetting::End is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, VTTCue::LineAlignSetting enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<VTTCue::LineAlignSetting> parseEnumerationFromString<VTTCue::LineAlignSetting>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, VTTCue::LineAlignSetting> mappings[] = {
        { "center", VTTCue::LineAlignSetting::Center },
        { "end", VTTCue::LineAlignSetting::End },
        { "start", VTTCue::LineAlignSetting::Start },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<VTTCue::LineAlignSetting> parseEnumeration<VTTCue::LineAlignSetting>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<VTTCue::LineAlignSetting>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<VTTCue::LineAlignSetting>()
{
    return "\"start\", \"center\", \"end\""_s;
}

String convertEnumerationToString(VTTCue::PositionAlignSetting enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("line-left"),
        MAKE_STATIC_STRING_IMPL("center"),
        MAKE_STATIC_STRING_IMPL("line-right"),
        MAKE_STATIC_STRING_IMPL("auto"),
    };
    static_assert(static_cast<size_t>(VTTCue::PositionAlignSetting::LineLeft) == 0, "VTTCue::PositionAlignSetting::LineLeft is not 0 as expected");
    static_assert(static_cast<size_t>(VTTCue::PositionAlignSetting::Center) == 1, "VTTCue::PositionAlignSetting::Center is not 1 as expected");
    static_assert(static_cast<size_t>(VTTCue::PositionAlignSetting::LineRight) == 2, "VTTCue::PositionAlignSetting::LineRight is not 2 as expected");
    static_assert(static_cast<size_t>(VTTCue::PositionAlignSetting::Auto) == 3, "VTTCue::PositionAlignSetting::Auto is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, VTTCue::PositionAlignSetting enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<VTTCue::PositionAlignSetting> parseEnumerationFromString<VTTCue::PositionAlignSetting>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, VTTCue::PositionAlignSetting> mappings[] = {
        { "auto", VTTCue::PositionAlignSetting::Auto },
        { "center", VTTCue::PositionAlignSetting::Center },
        { "line-left", VTTCue::PositionAlignSetting::LineLeft },
        { "line-right", VTTCue::PositionAlignSetting::LineRight },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<VTTCue::PositionAlignSetting> parseEnumeration<VTTCue::PositionAlignSetting>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<VTTCue::PositionAlignSetting>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<VTTCue::PositionAlignSetting>()
{
    return "\"line-left\", \"center\", \"line-right\", \"auto\""_s;
}

String convertEnumerationToString(VTTCue::AlignSetting enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("start"),
        MAKE_STATIC_STRING_IMPL("center"),
        MAKE_STATIC_STRING_IMPL("end"),
        MAKE_STATIC_STRING_IMPL("left"),
        MAKE_STATIC_STRING_IMPL("right"),
    };
    static_assert(static_cast<size_t>(VTTCue::AlignSetting::Start) == 0, "VTTCue::AlignSetting::Start is not 0 as expected");
    static_assert(static_cast<size_t>(VTTCue::AlignSetting::Center) == 1, "VTTCue::AlignSetting::Center is not 1 as expected");
    static_assert(static_cast<size_t>(VTTCue::AlignSetting::End) == 2, "VTTCue::AlignSetting::End is not 2 as expected");
    static_assert(static_cast<size_t>(VTTCue::AlignSetting::Left) == 3, "VTTCue::AlignSetting::Left is not 3 as expected");
    static_assert(static_cast<size_t>(VTTCue::AlignSetting::Right) == 4, "VTTCue::AlignSetting::Right is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, VTTCue::AlignSetting enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<VTTCue::AlignSetting> parseEnumerationFromString<VTTCue::AlignSetting>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, VTTCue::AlignSetting> mappings[] = {
        { "center", VTTCue::AlignSetting::Center },
        { "end", VTTCue::AlignSetting::End },
        { "left", VTTCue::AlignSetting::Left },
        { "right", VTTCue::AlignSetting::Right },
        { "start", VTTCue::AlignSetting::Start },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<VTTCue::AlignSetting> parseEnumeration<VTTCue::AlignSetting>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<VTTCue::AlignSetting>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<VTTCue::AlignSetting>()
{
    return "\"start\", \"center\", \"end\", \"left\", \"right\""_s;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsVTTCuePrototypeFunction_getCueAsHTML);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsVTTCueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsVTTCue_region);
static JSC_DECLARE_CUSTOM_SETTER(setJSVTTCue_region);
static JSC_DECLARE_CUSTOM_GETTER(jsVTTCue_vertical);
static JSC_DECLARE_CUSTOM_SETTER(setJSVTTCue_vertical);
static JSC_DECLARE_CUSTOM_GETTER(jsVTTCue_snapToLines);
static JSC_DECLARE_CUSTOM_SETTER(setJSVTTCue_snapToLines);
static JSC_DECLARE_CUSTOM_GETTER(jsVTTCue_line);
static JSC_DECLARE_CUSTOM_SETTER(setJSVTTCue_line);
static JSC_DECLARE_CUSTOM_GETTER(jsVTTCue_lineAlign);
static JSC_DECLARE_CUSTOM_SETTER(setJSVTTCue_lineAlign);
static JSC_DECLARE_CUSTOM_GETTER(jsVTTCue_position);
static JSC_DECLARE_CUSTOM_SETTER(setJSVTTCue_position);
static JSC_DECLARE_CUSTOM_GETTER(jsVTTCue_positionAlign);
static JSC_DECLARE_CUSTOM_SETTER(setJSVTTCue_positionAlign);
static JSC_DECLARE_CUSTOM_GETTER(jsVTTCue_size);
static JSC_DECLARE_CUSTOM_SETTER(setJSVTTCue_size);
static JSC_DECLARE_CUSTOM_GETTER(jsVTTCue_align);
static JSC_DECLARE_CUSTOM_SETTER(setJSVTTCue_align);
static JSC_DECLARE_CUSTOM_GETTER(jsVTTCue_text);
static JSC_DECLARE_CUSTOM_SETTER(setJSVTTCue_text);

class JSVTTCuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVTTCuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVTTCuePrototype* ptr = new (NotNull, JSC::allocateCell<JSVTTCuePrototype>(vm)) JSVTTCuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVTTCuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVTTCuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVTTCuePrototype, JSVTTCuePrototype::Base);

using JSVTTCueDOMConstructor = JSDOMConstructor<JSVTTCue>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSVTTCueDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSVTTCueDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "VTTCue"_s);
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto startTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(startTimeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto endTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(endTimeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto textConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(textConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = VTTCue::create(document, startTimeConversionResult.releaseReturnValue(), endTimeConversionResult.releaseReturnValue(), textConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<VTTCue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<VTTCue>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSVTTCueDOMConstructorConstruct, JSVTTCueDOMConstructor::construct);

template<> const ClassInfo JSVTTCueDOMConstructor::s_info = { "VTTCue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVTTCueDOMConstructor) };

template<> JSValue JSVTTCueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSTextTrackCue::getConstructor(vm, &globalObject);
}

template<> void JSVTTCueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(3), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "VTTCue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSVTTCue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSVTTCuePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCueConstructor, 0 } },
    { "region"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCue_region, setJSVTTCue_region } },
    { "vertical"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCue_vertical, setJSVTTCue_vertical } },
    { "snapToLines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCue_snapToLines, setJSVTTCue_snapToLines } },
    { "line"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCue_line, setJSVTTCue_line } },
    { "lineAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCue_lineAlign, setJSVTTCue_lineAlign } },
    { "position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCue_position, setJSVTTCue_position } },
    { "positionAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCue_positionAlign, setJSVTTCue_positionAlign } },
    { "size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCue_size, setJSVTTCue_size } },
    { "align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCue_align, setJSVTTCue_align } },
    { "text"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVTTCue_text, setJSVTTCue_text } },
    { "getCueAsHTML"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsVTTCuePrototypeFunction_getCueAsHTML, 0 } },
};

const ClassInfo JSVTTCuePrototype::s_info = { "VTTCue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVTTCuePrototype) };

void JSVTTCuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVTTCue::info(), JSVTTCuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSVTTCue::s_info = { "VTTCue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVTTCue) };

JSVTTCue::JSVTTCue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VTTCue>&& impl)
    : JSTextTrackCue(structure, globalObject, WTFMove(impl))
{
}

Ref<VTTCue> JSVTTCue::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSVTTCue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSVTTCuePrototype::createStructure(vm, &globalObject, JSTextTrackCue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSVTTCuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSVTTCue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVTTCue>(vm, globalObject);
}

JSValue JSVTTCue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVTTCueDOMConstructor, DOMConstructorID::VTTCue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVTTCuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSVTTCue::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsVTTCue_regionGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<VTTRegion>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.region())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCue_region, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCue_regionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVTTCue_regionSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLInterface<VTTRegion>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "VTTCue"_s, "region"_s, "VTTRegion"_s); });
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setRegion(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVTTCue_region, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCue_regionSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVTTCue_verticalGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<VTTCue::DirectionSetting>>(lexicalGlobalObject, throwScope, impl.vertical())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCue_vertical, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCue_verticalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVTTCue_verticalSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<VTTCue::DirectionSetting>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setVertical(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVTTCue_vertical, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCue_verticalSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVTTCue_snapToLinesGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.snapToLines())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCue_snapToLines, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCue_snapToLinesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVTTCue_snapToLinesSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSnapToLines(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVTTCue_snapToLines, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCue_snapToLinesSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVTTCue_lineGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLEnumeration<VTTCue::AutoKeyword>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.line())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCue_line, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCue_lineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVTTCue_lineSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLEnumeration<VTTCue::AutoKeyword>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLine(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVTTCue_line, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCue_lineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVTTCue_lineAlignGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<VTTCue::LineAlignSetting>>(lexicalGlobalObject, throwScope, impl.lineAlign())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCue_lineAlign, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCue_lineAlignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVTTCue_lineAlignSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<VTTCue::LineAlignSetting>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineAlign(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVTTCue_lineAlign, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCue_lineAlignSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVTTCue_positionGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLEnumeration<VTTCue::AutoKeyword>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.position())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCue_position, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCue_positionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVTTCue_positionSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLEnumeration<VTTCue::AutoKeyword>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPosition(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVTTCue_position, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCue_positionSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVTTCue_positionAlignGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<VTTCue::PositionAlignSetting>>(lexicalGlobalObject, throwScope, impl.positionAlign())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCue_positionAlign, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCue_positionAlignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVTTCue_positionAlignSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<VTTCue::PositionAlignSetting>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPositionAlign(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVTTCue_positionAlign, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCue_positionAlignSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVTTCue_sizeGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.size())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCue_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCue_sizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVTTCue_sizeSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVTTCue_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCue_sizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVTTCue_alignGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<VTTCue::AlignSetting>>(lexicalGlobalObject, throwScope, impl.align())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCue_align, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCue_alignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVTTCue_alignSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<VTTCue::AlignSetting>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlign(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVTTCue_align, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCue_alignSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVTTCue_textGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.text())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVTTCue_text, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCue_textGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVTTCue_textSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setText(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVTTCue_text, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCue_textSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsVTTCuePrototypeFunction_getCueAsHTMLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSVTTCue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DocumentFragment>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCueAsHTML())));
}

JSC_DEFINE_HOST_FUNCTION(jsVTTCuePrototypeFunction_getCueAsHTML, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSVTTCue>::call<jsVTTCuePrototypeFunction_getCueAsHTMLBody>(*lexicalGlobalObject, *callFrame, "getCueAsHTML");
}

JSC::GCClient::IsoSubspace* JSVTTCue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSVTTCue, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForVTTCue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForVTTCue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForVTTCue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForVTTCue = std::forward<decltype(space)>(space); }
    );
}

void JSVTTCue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVTTCue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VTTCue@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore6VTTCueE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, VTTCue>, void>> static inline void verifyVTable(VTTCue* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7VTTCue@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore6VTTCueE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // VTTCue has subclasses. If VTTCue has subclasses that get passed
        // to toJS() we currently require VTTCue you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VTTCue>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<VTTCue>(impl.ptr());
#endif
    return createWrapper<VTTCue>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VTTCue& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VTTCue* JSVTTCue::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVTTCue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
