/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLProvokingVertex.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebGLProvokingVertexPrototypeFunction_provokingVertexWEBGL);

class JSWebGLProvokingVertexPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLProvokingVertexPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLProvokingVertexPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLProvokingVertexPrototype>(vm)) JSWebGLProvokingVertexPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLProvokingVertexPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLProvokingVertexPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLProvokingVertexPrototype, JSWebGLProvokingVertexPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLProvokingVertexPrototypeTableValues[] =
{
    { "provokingVertexWEBGL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLProvokingVertexPrototypeFunction_provokingVertexWEBGL, 1 } },
    { "FIRST_VERTEX_CONVENTION_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E4D } },
    { "LAST_VERTEX_CONVENTION_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E4E } },
    { "PROVOKING_VERTEX_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E4F } },
};

const ClassInfo JSWebGLProvokingVertexPrototype::s_info = { "WebGLProvokingVertex"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLProvokingVertexPrototype) };

void JSWebGLProvokingVertexPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLProvokingVertex::info(), JSWebGLProvokingVertexPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLProvokingVertex::s_info = { "WebGLProvokingVertex"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLProvokingVertex) };

JSWebGLProvokingVertex::JSWebGLProvokingVertex(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLProvokingVertex>&& impl)
    : JSDOMWrapper<WebGLProvokingVertex>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLProvokingVertex>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLProvokingVertex::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLProvokingVertexPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLProvokingVertexPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLProvokingVertex::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLProvokingVertex>(vm, globalObject);
}

void JSWebGLProvokingVertex::destroy(JSC::JSCell* cell)
{
    JSWebGLProvokingVertex* thisObject = static_cast<JSWebGLProvokingVertex*>(cell);
    thisObject->JSWebGLProvokingVertex::~JSWebGLProvokingVertex();
}

static inline JSC::EncodedJSValue jsWebGLProvokingVertexPrototypeFunction_provokingVertexWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLProvokingVertex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto provokeModeConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(provokeModeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.provokingVertexWEBGL(provokeModeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLProvokingVertexPrototypeFunction_provokingVertexWEBGL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLProvokingVertex>::call<jsWebGLProvokingVertexPrototypeFunction_provokingVertexWEBGLBody>(*lexicalGlobalObject, *callFrame, "provokingVertexWEBGL");
}

JSC::GCClient::IsoSubspace* JSWebGLProvokingVertex::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLProvokingVertex, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLProvokingVertex.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLProvokingVertex = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLProvokingVertex.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLProvokingVertex = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLProvokingVertex::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLProvokingVertex*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLProvokingVertexOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLProvokingVertex = jsCast<JSWebGLProvokingVertex*>(handle.slot()->asCell());
    auto& owner = jsWebGLProvokingVertex->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLProvokingVertex"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLProvokingVertexOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLProvokingVertex = static_cast<JSWebGLProvokingVertex*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLProvokingVertex->protectedWrapped().ptr(), jsWebGLProvokingVertex);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLProvokingVertex@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20WebGLProvokingVertexE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebGLProvokingVertex>, void>> static inline void verifyVTable(WebGLProvokingVertex* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLProvokingVertex@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20WebGLProvokingVertexE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLProvokingVertex has subclasses. If WebGLProvokingVertex has subclasses that get passed
        // to toJS() we currently require WebGLProvokingVertex you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLProvokingVertex>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLProvokingVertex>(impl.ptr());
#endif
    return createWrapper<WebGLProvokingVertex>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLProvokingVertex& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLProvokingVertex* JSWebGLProvokingVertex::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLProvokingVertex*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
