--- pcbnew/import_gfx/dxf_import_plugin.cpp.orig	2023-01-25 22:16:35.742131000 +0100
+++ pcbnew/import_gfx/dxf_import_plugin.cpp	2023-01-25 23:02:52.939723000 +0100
@@ -28,6 +28,9 @@
 // like void DXF_IMPORT_PLUGIN::addLine( const DL_LineData& data ) when a line is read.
 // this function just add the BOARD entity from dxf parameters (start and end point ...)
 
+#ifdef __BSD_VISIBLE
+#undef __BSD_VISIBLE
+#endif
 
 #include "dxf_import_plugin.h"
 #include <wx/arrstr.h>
@@ -580,7 +583,7 @@
     // For now, we assume ellipses in the XY plane.
 
     VECTOR2D center( mapX( centerCoords.x ), mapY( centerCoords.y ) );
-    VECTOR2D major( mapX( majorCoords.x ), mapY( majorCoords.y ) );
+    VECTOR2D vmajor( mapX( majorCoords.x ), mapY( majorCoords.y ) );
 
     // DXF elliptical arcs store their angles in radians (unlike circular arcs which use degrees)
     // The arcs wind CCW as in KiCad.  The end angle must be greater than the start angle, and if
@@ -598,7 +601,7 @@
 
     if( aData.ratio == 1.0 )
     {
-        double radius = major.EuclideanNorm();
+        double radius = vmajor.EuclideanNorm();
 
         if( startAngle == endAngle )
         {
@@ -616,7 +619,7 @@
     }
 
     std::vector<BEZIER<double>> splines;
-    ELLIPSE<double> ellipse( center, major, aData.ratio, startAngle, endAngle );
+    ELLIPSE<double> ellipse( center, vmajor, aData.ratio, startAngle, endAngle );
 
     TransformEllipseToBeziers( ellipse, splines );
 
@@ -630,8 +633,8 @@
         bufferToUse->AddSpline( b.Start, b.C1, b.C2, b.End, lineWidth );
 
     // Naive bounding
-    updateImageLimits( center + major );
-    updateImageLimits( center - major );
+    updateImageLimits( center + vmajor );
+    updateImageLimits( center - vmajor );
 }
 
 
