/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlCompare {
    protected static final String FEATURE_XML_ROUNDTRIP = "http://xmlpull.org/v1/doc/features.html#xml-roundtrip";

    public static void main(String[] args) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XmlPullParser pp = factory.newPullParser();
        try {
            pp.setFeature(FEATURE_XML_ROUNDTRIP, false);
        }
        catch (XmlPullParserException ex) {
            throw new RuntimeException("could nto disable roundtrip feature: " + ex);
        }
        System.out.println("parser implementation class is " + pp.getClass());
        String FILE = "fcked_up2.xml";
        pp.setInput(new FileReader("fcked_up2.xml"));
        String text = XmlCompare.getNextElementText(pp);
        XmlCompare.compareXmlTwoFiles(new FileReader("fcked_up2.xml"), new StringReader(text));
    }

    public static String getNextElementText(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (!parser.getFeature(FEATURE_XML_ROUNDTRIP)) {
            throw new RuntimeException("roundtrip feature must be enabled to get tag content");
        }
        int level = 1;
        StringBuffer buf = new StringBuffer();
        parser.nextTag();
        buf.append(parser.getText());
        while (level > 0) {
            int event = parser.next();
            String text = parser.getText();
            if (event == 2) {
                buf.append(text);
                if (parser.isEmptyElementTag()) {
                    parser.next();
                    continue;
                }
                ++level;
                continue;
            }
            if (event == 3) {
                buf.append(text);
                --level;
                continue;
            }
            if (text.length() <= 0) continue;
            StringBuffer escapedText = new StringBuffer(text.length());
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (ch == '<') {
                    escapedText.append("&lt;");
                    continue;
                }
                if (ch == '&') {
                    escapedText.append("&amp;");
                    continue;
                }
                if (ch == '\"') {
                    escapedText.append("&quot;");
                    continue;
                }
                if (ch == '\'') {
                    escapedText.append("&apos;");
                    continue;
                }
                escapedText.append(ch);
            }
            buf.append(escapedText);
        }
        return buf.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    static void compareXmlTwoFiles(Reader rr, Reader rq) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance("org.xmlpull.mxp1.MXParserFactory", null);
        factory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XmlPullParser r = factory.newPullParser();
        r.setInput(rr);
        XmlPullParser q = factory.newPullParser();
        q.setInput(rq);
        while (true) {
            r.next();
            q.next();
            if (r.getEventType() != q.getEventType()) {
                throw new RuntimeException("inconsistent events");
            }
            if (r.getEventType() == 1) {
                System.err.println("\nOK");
                return;
            }
            if (r.getEventType() == 2 || r.getEventType() == 3) {
                String qName;
                String rName = r.getName();
                if (!rName.equals(qName = q.getName())) {
                    throw new RuntimeException("element names mismatch");
                }
                if (r.getEventType() != 2) {
                    // empty if block
                }
            } else {
                String qText;
                if (r.getEventType() != 4) {
                    throw new RuntimeException("unknown event type " + r.getEventType() + r.getPositionDescription());
                }
                String rText = r.getText();
                if (!rText.equals(qText = q.getText())) {
                    throw new RuntimeException("text content mismatch '" + rText + "' and '" + qText + "'");
                }
            }
            System.err.print(".");
        }
    }
}

