/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteApplicationRequestMarshaller
implements Marshaller<Request<DeleteApplicationRequest>, DeleteApplicationRequest> {
    public Request<DeleteApplicationRequest> marshall(DeleteApplicationRequest deleteApplicationRequest) {
        if (deleteApplicationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteApplicationRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DeleteApplication");
        request.addParameter("Version", "2010-12-01");
        if (deleteApplicationRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)deleteApplicationRequest.getApplicationName()));
        }
        if (deleteApplicationRequest.isTerminateEnvByForce() != null) {
            request.addParameter("TerminateEnvByForce", StringUtils.fromBoolean((Boolean)deleteApplicationRequest.isTerminateEnvByForce()));
        }
        return request;
    }
}

