/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

public abstract class BasicState {
    public static final int BATCH_SIZE = 10000;
    private static final DecoderFactory DECODER_FACTORY = new DecoderFactory();
    private static final EncoderFactory ENCODER_FACTORY = new EncoderFactory();
    private static final OutputStream NULL_OUTPUTSTREAM = new NullOutputStream();
    private final Random random = new Random(13L);
    private final int batchSize = 10000;
    private BinaryDecoder reuseDecoder = null;
    private BinaryEncoder reuseEncoder;
    private BinaryEncoder reuseBlockingEncoder;

    protected Random getRandom() {
        return this.random;
    }

    protected Decoder newDecoder(byte[] buf) {
        this.reuseDecoder = DECODER_FACTORY.binaryDecoder(buf, this.reuseDecoder);
        return this.reuseDecoder;
    }

    protected Encoder newEncoder(boolean direct, OutputStream out) throws IOException {
        this.reuseEncoder = direct ? ENCODER_FACTORY.directBinaryEncoder(out, this.reuseEncoder) : ENCODER_FACTORY.binaryEncoder(out, this.reuseEncoder);
        return this.reuseEncoder;
    }

    protected Encoder newEncoder(int blockSize, OutputStream out) throws IOException {
        this.reuseBlockingEncoder = ENCODER_FACTORY.configureBlockSize(blockSize).blockingBinaryEncoder(out, this.reuseBlockingEncoder);
        return this.reuseBlockingEncoder;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    protected OutputStream getNullOutputStream() {
        return NULL_OUTPUTSTREAM;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }
    }
}

