/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.accesscontrol.policyloader;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.owasp.esapi.AccessControlRule;
import org.owasp.esapi.errors.AccessControlException;

public final class PolicyDTO {
    private Map accessControlRules = new HashMap();

    public Map getAccessControlRules() {
        return this.accessControlRules;
    }

    public void addAccessControlRule(String key, String accessControlRuleClassName, Object policyParameter) throws AccessControlException {
        if (this.accessControlRules.get(key) != null) {
            throw new AccessControlException("Duplicate keys are not allowed. Key: " + key, "");
        }
        try {
            Class<?> accessControlRuleClass = Class.forName(accessControlRuleClassName, false, this.getClass().getClassLoader());
            Constructor<?> accessControlRuleConstructor = accessControlRuleClass.getConstructor(new Class[0]);
            AccessControlRule accessControlRule = (AccessControlRule)accessControlRuleConstructor.newInstance(new Object[0]);
            accessControlRule.setPolicyParameters(policyParameter);
            this.accessControlRules.put(key, accessControlRule);
        }
        catch (Exception e) {
            throw new AccessControlException("Unable to create Access Control Rule for key: \"" + key + "\" with policyParameters: \"" + policyParameter + "\"", "", e);
        }
    }

    public String toString() {
        return this.accessControlRules.toString();
    }
}

