/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.Token;
import org.apache.rampart.ExtendedPolicyValidatorCallbackHandler;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.ServiceNonceCache;
import org.apache.rampart.TokenCallbackHandler;
import org.apache.rampart.ValidatorData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.saml.SAMLAssertionHandlerFactory;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.KerberosToken;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.wss4j.common.NamePasswordCallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.UsernameTokenPrincipal;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.validate.KerberosTokenValidator;
import org.apache.wss4j.dom.validate.Validator;

public class RampartEngine {
    private static Log log = LogFactory.getLog(RampartEngine.class);
    private static Log tlog = LogFactory.getLog((String)"org.apache.rampart.TIME");
    private static ServiceNonceCache serviceNonceCache = new ServiceNonceCache();

    /*
     * Unable to fully structure code
     */
    public List<WSSecurityEngineResult> process(MessageContext msgCtx) throws WSSPolicyException, RampartException, WSSecurityException, AxisFault {
        dotDebug = RampartEngine.tlog.isDebugEnabled();
        RampartEngine.log.debug((Object)"Enter process(MessageContext msgCtx)");
        rmd = new RampartMessageData(msgCtx, false);
        rpd = rmd.getPolicyData();
        msgCtx.setProperty("rampartPolicyData", (Object)rpd);
        RampartUtil.validateTransport(rmd);
        if (rpd == null) {
            return null;
        }
        if (this.isSecurityFault(rmd) || !RampartUtil.isSecHeaderRequired(rpd, rmd.isInitiator(), true)) {
            env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
            msgCtx.setEnvelope(env);
            Axis2Util.useDOOM(false);
            RampartEngine.log.debug((Object)"Return process MessageContext msgCtx)");
            return null;
        }
        engine = new WSSecurityEngine();
        engine.setWssConfig(rmd.getConfig());
        rampartConfig = rpd.getRampartConfig();
        requestData = new RequestData();
        if (rampartConfig != null) {
            config = engine.getWssConfig();
            endSupptokens = rpd.getEndorsingSupportingTokens();
            if (endSupptokens != null && endSupptokens.getTokens() != null && endSupptokens.getTokens().size() > 0) {
                RampartEngine.log.debug((Object)"Processing endorsing supporting tokens");
                for (org.apache.ws.secpolicy.model.Token token : endSupptokens.getTokens()) {
                    if (!(token instanceof KerberosToken)) continue;
                    RampartEngine.log.debug((Object)"KerberosToken is found as part of the endorsing supporting tokens.Check for KerberosConfig.");
                    kerberosConfig = rampartConfig.getKerberosConfig();
                    if (null != kerberosConfig) {
                        RampartEngine.log.debug((Object)"KerberosConfig is found.");
                        RampartEngine.log.debug((Object)"Creating KerberosTokenValidor with the available KerberosConfig.");
                        kerberosValidator = new KerberosTokenValidator();
                        kerberosTokenDecoder = RampartUtil.getKerberosTokenDecoder(msgCtx, kerberosConfig);
                        if (kerberosTokenDecoder != null) {
                            kerberosValidator.setKerberosTokenDecoder(kerberosTokenDecoder);
                        }
                        kerberosValidator.setContextName(kerberosConfig.getJaasContext());
                        kerberosValidator.setServiceName(kerberosConfig.getServicePrincipalName());
                        serviceNameForm = kerberosConfig.getServicePrincipalNameForm();
                        if ("username".equals(serviceNameForm)) {
                            kerberosValidator.setUsernameServiceNameForm(true);
                        }
                        if (null == (principalName = kerberosConfig.getPrincipalName())) {
                            RampartEngine.log.debug((Object)"Principal name is not available in the KerberosConfig.Using the Rampart configuration's user.");
                            principalName = rampartConfig.getUser();
                        }
                        if ((password = kerberosConfig.getPrincipalPassword()) == null) {
                            RampartEngine.log.debug((Object)"Principal password is not available in the KerberosConfig.Trying with the configured Rampart password callback.");
                            handler = RampartUtil.getPasswordCB(rmd);
                            if (handler != null) {
                                cb = new WSPasswordCallback[]{new WSPasswordCallback(principalName, 7)};
                                try {
                                    handler.handle((Callback[])cb);
                                    if (cb[0].getPassword() == null || "".equals(cb[0].getPassword())) ** GOTO lbl59
                                    password = cb[0].getPassword();
                                }
                                catch (IOException e) {
                                    throw new RampartException("errorInGettingPasswordForUser", new String[]{principalName}, e);
                                }
                                catch (UnsupportedCallbackException e) {
                                    throw new RampartException("errorInGettingPasswordForUser", new String[]{principalName}, e);
                                }
                            } else {
                                RampartEngine.log.debug((Object)"No Rampart password handler is configured.");
                            }
                        }
lbl59:
                        // 5 sources

                        if (principalName != null && password != null) {
                            cb = new NamePasswordCallbackHandler(principalName, password);
                            kerberosValidator.setCallbackHandler((CallbackHandler)cb);
                        }
                        config.setValidator(WSConstants.BINARY_TOKEN, (Validator)kerberosValidator);
                        RampartEngine.log.debug((Object)"KerberosTokenValidator is configured and set for BINARY_TOKEN.");
                        continue;
                    }
                    RampartEngine.log.debug((Object)"KerberosConfig is not found.Skipping configurating and setting of a Kerberos validator.");
                }
            }
            engine.setWssConfig(config);
            requestData.setTimeStampStrict(rampartConfig.isTimeStampStrict());
            requestData.setPrecisionInMilliSeconds(rampartConfig.isDefaultTimestampPrecisionInMs());
            requestData.setDisableBSPEnforcement(rampartConfig.isDisableBSPEnforcement());
            requestData.setHandleCustomPasswordTypes(rampartConfig.isHandleCustomPasswordTypes());
            requestData.setAllowNamespaceQualifiedPasswordTypes(rampartConfig.isAllowNamespaceQualifiedPasswordTypes());
            requestData.setValidateSamlSubjectConfirmation(rampartConfig.isValidateSamlSubjectConfirmation());
            requestData.setTimeStampFutureTTL(rampartConfig.getTimeStampFutureTTL());
            requestData.setUtTTL(rampartConfig.getUtTTL());
            requestData.setUtFutureTTL(rampartConfig.getUtFutureTTL());
            requestData.setAllowRSA15KeyTransportAlgorithm(rampartConfig.isAllowRSA15KeyTransportAlgorithm());
            requestData.setEncodePasswords(rampartConfig.isEncodePasswords());
        } else {
            requestData.setAllowRSA15KeyTransportAlgorithm(true);
            requestData.setValidateSamlSubjectConfirmation(false);
            requestData.setEncodePasswords(false);
        }
        data = new ValidatorData(rmd);
        header = rmd.getMsgContext().getEnvelope().getHeader();
        if (header == null) {
            throw new RampartException("missingSOAPHeader");
        }
        headerBlocks = header.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        secHeader = null;
        if (headerBlocks != null) {
            for (SOAPHeaderBlock elem : headerBlocks) {
                if (!elem.getLocalName().equals("Security")) continue;
                secHeader = elem;
                break;
            }
        }
        if (secHeader == null) {
            throw new RampartException("missingSecurityHeader");
        }
        t0 = 0L;
        t1 = 0L;
        t2 = 0L;
        t3 = 0L;
        if (dotDebug) {
            t0 = System.currentTimeMillis();
        }
        signatureCrypto = RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader());
        decCrypto = RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader());
        tokenCallbackHandler = new TokenCallbackHandler(rmd.getTokenStorage(), RampartUtil.getPasswordCB(rmd));
        result = this.processSecurityHeaderWithRSA15(rmd, secHeader, engine, signatureCrypto, decCrypto, tokenCallbackHandler, requestData);
        results = result.getResults();
        if (rpd.isSymmetricBinding() && rmd.isInitiator() && (msgCtx.getFLOW() == 1 || msgCtx.getFLOW() == 3)) {
            tokenCallbackHandler.removeEncryptedToken();
        }
        if (dotDebug) {
            t1 = System.currentTimeMillis();
        }
        if (results != null) {
            for (j = 0; j < results.size(); ++j) {
                wser = (WSSecurityEngineResult)results.get(j);
                actInt = (Integer)wser.get((Object)"action");
                if (8 == actInt) {
                    samlAssertion = wser.get((Object)"saml-assertion");
                    samlAssertionHandler = SAMLAssertionHandlerFactory.createAssertionHandler(samlAssertion);
                    if (samlAssertionHandler.isBearerAssertion()) break;
                    try {
                        store = rmd.getTokenStorage();
                        if (store.getToken(samlAssertionHandler.getAssertionId()) != null) continue;
                        token = new Token(samlAssertionHandler.getAssertionId(), samlAssertionHandler.getAssertionElement(), Date.from(samlAssertionHandler.getDateNotBefore()), Date.from(samlAssertionHandler.getDateNotOnOrAfter()));
                        token.setSecret(samlAssertionHandler.getAssertionKeyInfoSecret(signatureCrypto, tokenCallbackHandler, requestData));
                        store.add(token);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RampartException("errorInAddingTokenIntoStore", e);
                    }
                }
                if (1 == actInt) {
                    principal = (Principal)wser.get((Object)"principal");
                    userNameTokenPrincipal = (UsernameTokenPrincipal)principal;
                    username = userNameTokenPrincipal.getName();
                    msgCtx.setProperty("username", (Object)username);
                    if (userNameTokenPrincipal.getNonce() == null) continue;
                    nonceLifeTimeInSeconds = 0;
                    if (rpd.getRampartConfig() != null) {
                        stringLifeTime = rpd.getRampartConfig().getNonceLifeTime();
                        try {
                            nonceLifeTimeInSeconds = Integer.parseInt(stringLifeTime);
                        }
                        catch (NumberFormatException e) {
                            RampartEngine.log.error((Object)"Invalid value for nonceLifeTime in rampart configuration file.", (Throwable)e);
                            throw new RampartException("invalidNonceLifeTime", e);
                        }
                    }
                    if (valueRepeating = RampartEngine.serviceNonceCache.isNonceRepeatingForService(serviceEndpointName = msgCtx.getAxisService().getEndpointName(), username, new String(userNameTokenPrincipal.getNonce()))) {
                        throw new RampartException("repeatingNonceValue", new Object[]{userNameTokenPrincipal.getNonce(), username});
                    }
                    RampartEngine.serviceNonceCache.addNonceForService(serviceEndpointName, username, new String(userNameTokenPrincipal.getNonce()), nonceLifeTimeInSeconds);
                    continue;
                }
                if (2 != actInt) continue;
                cert = (X509Certificate)wser.get((Object)"x509-certificate");
                if (rpd.isAsymmetricBinding() && cert == null && rpd.getInitiatorToken() != null && !rpd.getInitiatorToken().isDerivedKeys()) {
                    throw new RampartException("invalidSignatureAlgo");
                }
                msgCtx.setProperty("X509Certificate", (Object)cert);
            }
        }
        env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
        if (dotDebug) {
            t2 = System.currentTimeMillis();
        }
        msgCtx.setEnvelope(env);
        Axis2Util.useDOOM(false);
        validator = RampartUtil.getPolicyValidatorCB(msgCtx, rpd);
        if (validator instanceof ExtendedPolicyValidatorCallbackHandler) {
            extendedPolicyValidatorCallbackHandler = (ExtendedPolicyValidatorCallbackHandler)validator;
            extendedPolicyValidatorCallbackHandler.validate(data, results);
        } else {
            resultsVector = new Vector<E>(results);
            validator.validate(data, resultsVector);
        }
        if (dotDebug) {
            t3 = System.currentTimeMillis();
            RampartEngine.tlog.debug((Object)("processHeader by WSSecurityEngine took : " + (t1 - t0) + ", DOOM conversion took :" + (t2 - t1) + ", PolicyBasedResultsValidattor took " + (t3 - t2)));
        }
        RampartEngine.log.debug((Object)"Return process(MessageContext msgCtx)");
        return results;
    }

    private WSHandlerResult processSecurityHeaderWithRSA15(RampartMessageData rmd, SOAPHeaderBlock secHeader, WSSecurityEngine engine, Crypto signatureCrypto, Crypto decCrypto, TokenCallbackHandler tokenCallbackHandler, RequestData requestData) throws WSSecurityException, RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        requestData.setActor(secHeader.getRole());
        requestData.setDecCrypto(decCrypto);
        requestData.setSigVerCrypto(signatureCrypto);
        requestData.setCallbackHandler((CallbackHandler)tokenCallbackHandler);
        if (!rmd.isInitiator()) {
            Collection<UsernameToken> usernameTokens = RampartUtil.getUsernameTokens(rpd);
            for (UsernameToken usernameTok : usernameTokens) {
                if (!usernameTok.isNoPassword()) continue;
                log.debug((Object)"Found UsernameToken with no password assertion in policy, configuring ws security processing to allow username tokens without password.");
                requestData.setAllowUsernameTokenNoPassword(true);
                break;
            }
        }
        return engine.processSecurityHeader(rmd.getDocument(), requestData);
    }

    private boolean isSecurityFault(RampartMessageData rmd) {
        SOAPFault soapFault = rmd.getMsgContext().getEnvelope().getBody().getFault();
        return soapFault == null ? false : RampartUtil.isSecurityFault(soapFault);
    }
}

