/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.client.Options;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.EncryptedKeyToken;
import org.apache.rahas.SimpleTokenStore;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.SupportingPolicyData;
import org.apache.rampart.policy.model.KerberosConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.wss4j.common.NamePasswordCallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.token.SecurityTokenReference;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecBase;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecSignatureConfirmation;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BindingBuilder {
    private static Log log = LogFactory.getLog(BindingBuilder.class);
    private Element insertionLocation;
    protected String mainSigId = null;
    protected ArrayList<String> encryptedTokensIdList = new ArrayList();
    protected Element timestampElement;
    protected Element mainRefListElement;

    protected void addTimestamp(RampartMessageData rmd) {
        log.debug((Object)"Adding timestamp");
        WSSecTimestamp timestampBuilder = new WSSecTimestamp(rmd.getSecHeader());
        timestampBuilder.setTimeToLive(RampartUtil.getTimeToLive(rmd));
        timestampBuilder.build();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Timestamp id: " + timestampBuilder.getId()));
        }
        rmd.setTimestampId(timestampBuilder.getId());
        this.timestampElement = timestampBuilder.getElement();
        log.debug((Object)"Adding timestamp: DONE");
    }

    protected WSSecUsernameToken addUsernameToken(RampartMessageData rmd, UsernameToken token) throws RampartException {
        log.debug((Object)"Adding a UsernameToken");
        RampartPolicyData rpd = rmd.getPolicyData();
        Options options = rmd.getMsgContext().getOptions();
        String user = options.getUserName();
        if ((user == null || user.length() == 0) && rpd.getRampartConfig() != null) {
            user = rpd.getRampartConfig().getUser();
        }
        if (user != null && !"".equals(user)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User : " + user));
            }
            if (token.isNoPassword()) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(rmd.getSecHeader());
                utBuilder.setUserInfo(user, null);
                utBuilder.setPasswordType(null);
                return utBuilder;
            }
            String password = options.getPassword();
            if (password == null || password.length() == 0) {
                CallbackHandler handler = RampartUtil.getPasswordCB(rmd);
                if (handler == null) {
                    throw new RampartException("cbHandlerMissing");
                }
                WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(user, 2)};
                try {
                    handler.handle((Callback[])cb);
                }
                catch (Exception e) {
                    throw new RampartException("errorInGettingPasswordForUser", new String[]{user}, e);
                }
                password = cb[0].getPassword();
            }
            if (password != null && !"".equals(password)) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(rmd.getSecHeader());
                if (token.isHashPassword()) {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                } else {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                }
                utBuilder.setUserInfo(user, password);
                return utBuilder;
            }
            throw new RampartException("noPasswordForUser", new String[]{user});
        }
        log.debug((Object)"No user value specified in the configuration");
        throw new RampartException("userMissing");
    }

    protected WSSecEncryptedKey getEncryptedKeyBuilder(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token token, SecretKey symmetricKey) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        WSSecEncryptedKey encrKey = new WSSecEncryptedKey(rmd.getSecHeader());
        try {
            RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)encrKey, token);
            RampartUtil.setEncryptionUser(rmd, encrKey);
            encrKey.setKeyEncAlgo(rpd.getAlgorithmSuite().getAsymmetricKeyWrap());
            log.debug((Object)("getEncryptedKeyBuilder() setting KeyEncAlgo to value: " + rpd.getAlgorithmSuite().getAsymmetricKeyWrap()));
            encrKey.prepare(RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()), symmetricKey);
            return encrKey;
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorCreatingEncryptedKey", e);
        }
    }

    protected WSSecSignature getSignatureBuilder(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token token) throws RampartException {
        return this.getSignatureBuilder(rmd, token, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected WSSecSignature getSignatureBuilder(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token token, String userCertAlias) throws RampartException {
        String password;
        RampartConfig rampartConfig;
        String user;
        WSSecSignature sig;
        RampartPolicyData rpd;
        block15: {
            rpd = rmd.getPolicyData();
            sig = new WSSecSignature(rmd.getSecHeader());
            this.checkForX509PkiPath(sig, token);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token inclusion: " + token.getInclusion()));
            }
            RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)sig, token);
            user = null;
            if (userCertAlias != null) {
                user = userCertAlias;
            }
            if ((rampartConfig = rpd.getRampartConfig()) == null) {
                throw new RampartException("rampartConfigMissing");
            }
            if (user == null) {
                user = rampartConfig.getUserCertAlias();
            }
            if (user == null) {
                user = rampartConfig.getUser();
            }
            password = null;
            if (user != null && !"".equals(user)) {
                CallbackHandler handler;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User : " + user));
                }
                if ((handler = RampartUtil.getPasswordCB(rmd)) == null) {
                    throw new RampartException("cbHandlerMissing");
                }
                WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(user, 3)};
                try {
                    handler.handle((Callback[])cb);
                    if (cb[0].getPassword() != null && !"".equals(cb[0].getPassword())) {
                        password = cb[0].getPassword();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Password : " + password));
                        }
                        break block15;
                    }
                    throw new RampartException("noPasswordForUser", new String[]{user});
                }
                catch (IOException e) {
                    throw new RampartException("errorInGettingPasswordForUser", new String[]{user}, e);
                }
                catch (UnsupportedCallbackException e) {
                    throw new RampartException("errorInGettingPasswordForUser", new String[]{user}, e);
                }
            }
            log.debug((Object)"No user value specified in the configuration");
            throw new RampartException("userMissing");
        }
        sig.setUserInfo(user, password);
        AlgorithmSuite algorithmSuite = rpd.getAlgorithmSuite();
        sig.setSignatureAlgorithm(algorithmSuite.getAsymmetricSignature());
        sig.setSigCanonicalization(algorithmSuite.getInclusiveC14n());
        sig.setDigestAlgo(algorithmSuite.getDigest());
        try {
            sig.prepare(RampartUtil.getSignatureCrypto(rampartConfig, rmd.getCustomClassLoader()));
            return sig;
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithX509Token", e);
        }
    }

    protected HashMap<org.apache.ws.secpolicy.model.Token, Object> handleSupportingTokens(RampartMessageData rmd, SupportingToken suppTokens) throws RampartException {
        HashMap<org.apache.ws.secpolicy.model.Token, Object> endSuppTokMap = new HashMap<org.apache.ws.secpolicy.model.Token, Object>();
        if (suppTokens != null && suppTokens.getTokens() != null && suppTokens.getTokens().size() > 0) {
            log.debug((Object)"Processing supporting tokens");
            for (org.apache.ws.secpolicy.model.Token token : suppTokens.getTokens()) {
                Token endSuppTok = null;
                if (token instanceof IssuedToken && rmd.isInitiator()) {
                    String id = RampartUtil.getIssuedToken(rmd, (IssuedToken)token);
                    try {
                        endSuppTok = rmd.getTokenStorage().getToken(id);
                    }
                    catch (TrustException e) {
                        throw new RampartException("errorInRetrievingTokenId", new String[]{id}, e);
                    }
                    if (endSuppTok == null) {
                        throw new RampartException("errorInRetrievingTokenId", new String[]{id});
                    }
                    Element siblingElem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), (Element)endSuppTok.getToken());
                    this.setInsertionLocation(siblingElem);
                    if (suppTokens.isEncryptedToken()) {
                        this.encryptedTokensIdList.add(endSuppTok.getId());
                    }
                    endSuppTokMap.put(token, endSuppTok);
                    continue;
                }
                if (token instanceof X509Token) {
                    WSSecSignature sig = this.getSignatureBuilder(rmd, token);
                    Element bstElem = sig.getBinarySecurityTokenElement();
                    if (bstElem != null) {
                        bstElem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), bstElem);
                        this.setInsertionLocation(bstElem);
                        SupportingPolicyData supportingPolcy = new SupportingPolicyData();
                        supportingPolcy.build(suppTokens);
                        supportingPolcy.setSignatureToken(token);
                        supportingPolcy.setEncryptionToken(token);
                        rmd.getPolicyData().addSupportingPolicyData(supportingPolcy);
                        if (suppTokens.isEncryptedToken()) {
                            this.encryptedTokensIdList.add(sig.getBSTTokenId());
                        }
                    }
                    endSuppTokMap.put(token, sig);
                    continue;
                }
                if (!(token instanceof UsernameToken)) continue;
                WSSecUsernameToken utBuilder = this.addUsernameToken(rmd, (UsernameToken)token);
                utBuilder.prepare();
                Element elem = utBuilder.getUsernameTokenElement();
                elem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), elem);
                if (suppTokens.isEncryptedToken()) {
                    this.encryptedTokensIdList.add(utBuilder.getId());
                }
                this.setInsertionLocation(elem);
                Date now = new Date();
                try {
                    Token tempTok = new Token(utBuilder.getId(), (OMElement)elem, now, new Date(now.getTime() + 300000L));
                    endSuppTokMap.put(token, tempTok);
                }
                catch (TrustException e) {
                    throw new RampartException("errorCreatingRahasToken", e);
                }
            }
        }
        return endSuppTokMap;
    }

    protected List<WSEncryptionPart> addSignatureParts(HashMap tokenMap, List<WSEncryptionPart> sigParts) throws RampartException {
        Set entrySet = tokenMap.entrySet();
        for (Map.Entry anEntrySet : entrySet) {
            Object tempTok = anEntrySet.getValue();
            WSEncryptionPart part = null;
            if (tempTok instanceof Token) {
                part = new WSEncryptionPart(((Token)tempTok).getId());
            } else if (tempTok instanceof WSSecSignature) {
                WSSecSignature tempSig = (WSSecSignature)tempTok;
                if (tempSig.getBSTTokenId() != null) {
                    part = new WSEncryptionPart(tempSig.getBSTTokenId());
                }
            } else {
                throw new RampartException("UnsupportedTokenInSupportingToken");
            }
            sigParts.add(part);
        }
        return sigParts;
    }

    public Element getInsertionLocation() {
        return this.insertionLocation;
    }

    public void setInsertionLocation(Element insertionLocation) {
        this.insertionLocation = insertionLocation;
    }

    protected List<byte[]> doEndorsedSignatures(RampartMessageData rmd, HashMap<org.apache.ws.secpolicy.model.Token, Object> tokenMap) throws RampartException {
        ArrayList<byte[]> sigValues = new ArrayList<byte[]>();
        for (Map.Entry<org.apache.ws.secpolicy.model.Token, Object> entry : tokenMap.entrySet()) {
            org.apache.ws.secpolicy.model.Token token = entry.getKey();
            Object tempTok = entry.getValue();
            ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
            sigParts.add(new WSEncryptionPart(this.mainSigId));
            if (tempTok instanceof Token) {
                Token tok = (Token)tempTok;
                if (rmd.getPolicyData().isTokenProtection()) {
                    sigParts.add(new WSEncryptionPart(tok.getId()));
                }
                this.doSymmSignature(rmd, token, (Token)tempTok, sigParts);
                continue;
            }
            if (!(tempTok instanceof WSSecSignature)) continue;
            WSSecSignature sig = (WSSecSignature)tempTok;
            if (rmd.getPolicyData().isTokenProtection() && sig.getBSTTokenId() != null) {
                sigParts.add(new WSEncryptionPart(sig.getBSTTokenId()));
            }
            try {
                List referenceList = sig.addReferencesToSign(sigParts);
                sig.computeSignature(referenceList, false, this.getInsertionLocation());
                this.setInsertionLocation(sig.getSignatureElement());
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInSignatureWithX509Token", e);
            }
            sigValues.add(sig.getSignatureValue());
        }
        return sigValues;
    }

    protected byte[] doSymmSignature(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token policyToken, Token tok, List<WSEncryptionPart> sigParts) throws RampartException {
        Document doc = rmd.getDocument();
        RampartPolicyData rpd = rmd.getPolicyData();
        AlgorithmSuite algorithmSuite = rpd.getAlgorithmSuite();
        if (policyToken.isDerivedKeys()) {
            try {
                OMElement ref;
                WSSecDKSign dkSign = new WSSecDKSign(rmd.getSecHeader());
                if (2 == policyToken.getVersion()) {
                    dkSign.setWscVersion(2);
                }
                boolean attached = false;
                if (5 == policyToken.getInclusion() || 2 == policyToken.getInclusion() || rmd.isInitiator() && 3 == policyToken.getInclusion()) {
                    attached = true;
                }
                if ((ref = attached ? tok.getAttachedReference() : tok.getUnattachedReference()) != null) {
                    dkSign.setStrElem((Element)doc.importNode((Element)ref, true));
                    dkSign.prepare(tok.getSecret());
                } else if (!rmd.isInitiator() && policyToken.isDerivedKeys()) {
                    SecurityTokenReference tokenRef = new SecurityTokenReference(doc);
                    if (tok instanceof EncryptedKeyToken) {
                        tokenRef.setKeyIdentifierEncKeySHA1(((EncryptedKeyToken)tok).getSHA1());
                    }
                    dkSign.setStrElem(tokenRef.getElement());
                    dkSign.prepare(tok.getSecret());
                    tokenRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                } else {
                    dkSign.setTokenIdentifier(tok.getId());
                    dkSign.prepare(tok.getSecret());
                }
                dkSign.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
                dkSign.setDerivedKeyLength(algorithmSuite.getSignatureDerivedKeyLength() / 8);
                if (tok instanceof EncryptedKeyToken) {
                    dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                }
                if (rpd.isTokenProtection()) {
                    String sigTokId = tok.getId();
                    if (sigTokId.startsWith("#")) {
                        sigTokId = sigTokId.substring(1);
                    }
                    sigParts.add(new WSEncryptionPart(sigTokId));
                }
                dkSign.getParts().addAll(sigParts);
                List referenceList = dkSign.addReferencesToSign(sigParts);
                if (rpd.getProtectionOrder().equals("EncryptBeforeSigning") && this.mainRefListElement != null) {
                    RampartUtil.insertSiblingBefore(rmd, this.mainRefListElement, dkSign.getdktElement());
                    dkSign.computeSignature(referenceList, true, dkSign.getdktElement());
                    this.setInsertionLocation(this.mainRefListElement);
                } else {
                    dkSign.appendDKElementToHeader();
                    this.setInsertionLocation(dkSign.getdktElement());
                    dkSign.computeSignature(referenceList, false, this.getInsertionLocation());
                    this.setInsertionLocation(dkSign.getSignatureElement());
                }
                return dkSign.getSignatureValue();
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        try {
            String sigTokId;
            WSSecSignature sig = new WSSecSignature(rmd.getSecHeader());
            if (policyToken instanceof X509Token) {
                if (rmd.isInitiator()) {
                    sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    sig.setKeyIdentifierType(9);
                } else {
                    sig.setEncrKeySha1value(((EncryptedKeyToken)tok).getSHA1());
                    sig.setKeyIdentifierType(10);
                }
            } else if (policyToken instanceof IssuedToken) {
                sig.setCustomTokenValueType(RampartUtil.getSAML10AssertionNamespace());
                sig.setKeyIdentifierType(9);
            }
            if (policyToken instanceof SecureConversationToken) {
                sig.setKeyIdentifierType(9);
                OMElement ref = tok.getAttachedReference();
                if (ref == null) {
                    ref = tok.getUnattachedReference();
                }
                sigTokId = ref != null ? SimpleTokenStore.getIdFromSTR((OMElement)ref) : tok.getId();
            } else {
                sigTokId = tok.getId();
            }
            if (sigTokId.startsWith("#")) {
                sigTokId = sigTokId.substring(1);
            }
            sig.setCustomTokenId(sigTokId);
            sig.setSecretKey(tok.getSecret());
            sig.setSignatureAlgorithm(algorithmSuite.getAsymmetricSignature());
            sig.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
            sig.setDigestAlgo(algorithmSuite.getDigest());
            sig.prepare(RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()));
            sig.getParts().addAll(sigParts);
            List referenceList = sig.addReferencesToSign(sigParts);
            if (rpd.getProtectionOrder().equals("EncryptBeforeSigning") && this.mainRefListElement != null) {
                sig.computeSignature(referenceList, true, this.mainRefListElement);
                this.setInsertionLocation(this.mainRefListElement);
            } else {
                sig.computeSignature(referenceList, false, this.getInsertionLocation());
                this.setInsertionLocation(sig.getSignatureElement());
            }
            return sig.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithACustomToken", e);
        }
    }

    protected Token getToken(RampartMessageData rmd, String tokenId) throws RampartException {
        Token tok;
        try {
            tok = rmd.getTokenStorage().getToken(tokenId);
        }
        catch (TrustException e) {
            throw new RampartException("errorInRetrievingTokenId", new String[]{tokenId}, e);
        }
        if (tok == null) {
            throw new RampartException("errorInRetrievingTokenId", new String[]{tokenId});
        }
        return tok;
    }

    protected void addSignatureConfirmation(RampartMessageData rmd, List<WSEncryptionPart> sigParts) {
        if (!rmd.getPolicyData().isSignatureConfirmation()) {
            return;
        }
        Document doc = rmd.getDocument();
        List results = (List)rmd.getMsgContext().getProperty("RECV_RESULTS");
        ArrayList signatureActions = new ArrayList();
        for (Object result : results) {
            WSHandlerResult wshResult = (WSHandlerResult)result;
            if (null == wshResult.getActionResults()) continue;
            if (null != wshResult.getActionResults().get(2)) {
                signatureActions.addAll((Collection)wshResult.getActionResults().get(2));
            }
            if (null != wshResult.getActionResults().get(16)) {
                signatureActions.addAll((Collection)wshResult.getActionResults().get(16));
            }
            if (null == wshResult.getActionResults().get(64)) continue;
            signatureActions.addAll((Collection)wshResult.getActionResults().get(64));
        }
        WSSecSignatureConfirmation wsc = new WSSecSignatureConfirmation(doc);
        if (signatureActions.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Signature Confirmation: number of Signature results: " + signatureActions.size()));
            }
            for (WSSecurityEngineResult signatureAction : signatureActions) {
                byte[] sigVal = (byte[])signatureAction.get((Object)"signature-value");
                wsc.setSignatureValue(sigVal);
                wsc.prepare();
                RampartUtil.appendChildToSecHeader(rmd, wsc.getSignatureConfirmationElement());
                if (sigParts == null) continue;
                sigParts.add(new WSEncryptionPart(wsc.getId()));
            }
        } else {
            wsc.prepare();
            RampartUtil.appendChildToSecHeader(rmd, wsc.getSignatureConfirmationElement());
            if (sigParts != null) {
                sigParts.add(new WSEncryptionPart(wsc.getId()));
            }
        }
    }

    private void checkForX509PkiPath(WSSecSignature sig, org.apache.ws.secpolicy.model.Token token) {
        X509Token x509Token;
        if (token instanceof X509Token && ((x509Token = (X509Token)token).getTokenVersionAndType().equals("WssX509PkiPathV1Token10") || x509Token.getTokenVersionAndType().equals("WssX509PkiPathV1Token11"))) {
            sig.setUseSingleCertificate(false);
        }
    }

    protected KerberosSecurity addKerberosToken(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token token) throws RampartException {
        CallbackHandler handler;
        String password;
        RampartPolicyData rpd = rmd.getPolicyData();
        KerberosConfig krbConfig = rpd.getRampartConfig().getKerberosConfig();
        if (krbConfig == null) {
            throw new RampartException("noKerberosConfigDefined");
        }
        log.debug((Object)("Token inclusion: " + token.getInclusion()));
        String user = krbConfig.getPrincipalName();
        if (user == null) {
            user = rpd.getRampartConfig().getUser();
        }
        if ((password = krbConfig.getPrincipalPassword()) == null && (handler = RampartUtil.getPasswordCB(rmd)) != null) {
            if (user == null) {
                log.debug((Object)"Password callback is configured but no user value is specified in the configuration");
                throw new RampartException("userMissing");
            }
            WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(user, 7)};
            try {
                handler.handle((Callback[])cb);
                if (cb[0].getPassword() != null && !"".equals(cb[0].getPassword())) {
                    password = cb[0].getPassword();
                }
            }
            catch (IOException e) {
                throw new RampartException("errorInGettingPasswordForUser", new String[]{user}, e);
            }
            catch (UnsupportedCallbackException e) {
                throw new RampartException("errorInGettingPasswordForUser", new String[]{user}, e);
            }
        }
        String principalName = null;
        boolean isUsernameServiceNameForm = "username".equals(krbConfig.getServicePrincipalNameForm());
        AxisEndpoint endpoint = rmd.getMsgContext().findEndpoint();
        if (endpoint != null) {
            OMElement addressingIdentity;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Identified endpoint: " + endpoint.getName() + ". Looking for SPN identity claim."));
            }
            if ((addressingIdentity = AddressingHelper.getAddressingIdentityParameterValue((AxisEndpoint)endpoint)) != null) {
                OMElement spnClaim = addressingIdentity.getFirstChildWithName(AddressingConstants.QNAME_IDENTITY_SPN);
                if (spnClaim != null) {
                    principalName = spnClaim.getText();
                    isUsernameServiceNameForm = false;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found SPN identity claim: " + principalName));
                    }
                } else {
                    OMElement upnClaim = addressingIdentity.getFirstChildWithName(AddressingConstants.QNAME_IDENTITY_UPN);
                    if (upnClaim != null) {
                        principalName = upnClaim.getText();
                        isUsernameServiceNameForm = true;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found UPN identity claim: " + principalName));
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Neither SPN nor UPN identity claim found in %s EPR element for endpoint %s.", addressingIdentity.getQName().toString(), endpoint.getName()));
                    }
                }
            }
        }
        if (principalName == null) {
            principalName = krbConfig.getServicePrincipalName();
        }
        try {
            KerberosSecurity bst = new KerberosSecurity(rmd.getDocument());
            NamePasswordCallbackHandler cb = new NamePasswordCallbackHandler(user, password);
            bst.retrieveServiceTicket(krbConfig.getJaasContext(), (CallbackHandler)cb, principalName, isUsernameServiceNameForm, krbConfig.isRequstCredentialDelegation(), krbConfig.getDelegationCredential());
            return bst;
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInBuildingKereberosToken", e);
        }
    }
}

