/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.FaultData;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.wsrm.FaultCode;
import org.apache.sandesha2.wsrm.SequenceFault;

public class SOAPFaultEnvelopeCreator {
    public static void addSOAPFaultEnvelope(MessageContext faultMsgContext, int SOAPVersion2, FaultData faultData, String rmNamespaceValue) throws SandeshaException {
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
        SOAPEnvelope env = factory.getDefaultFaultEnvelope();
        try {
            faultMsgContext.setEnvelope(env);
        }
        catch (AxisFault e) {
            throw new SandeshaException(e.getMessage());
        }
        if (SOAPVersion2 == 1) {
            SOAPFaultEnvelopeCreator.doSOAP11Encoding(faultMsgContext, faultData, rmNamespaceValue);
        } else {
            SOAPFaultEnvelopeCreator.doSOAP12Encoding(faultMsgContext, faultData, rmNamespaceValue);
        }
    }

    private static boolean isSequenceFault(FaultData faultData) {
        boolean sequenceFault = false;
        int faultType = faultData.getType();
        if (faultType <= 0) {
            return false;
        }
        if (faultType == 4) {
            sequenceFault = true;
        } else if (faultType == 1) {
            sequenceFault = true;
        } else if (faultType == 3) {
            sequenceFault = true;
        } else if (faultType == 2) {
            sequenceFault = true;
        } else if (faultType == 6) {
            sequenceFault = true;
        } else if (faultType == 7) {
            sequenceFault = true;
        }
        return sequenceFault;
    }

    private static void addSequenceFaultHeader(MessageContext faultMessageContext, FaultData faultData, SOAPFactory factory, String rmNamespaceValue) throws SandeshaException {
        SequenceFault sequenceFault = new SequenceFault(rmNamespaceValue);
        FaultCode faultCode = new FaultCode(rmNamespaceValue);
        faultCode.setFaultCode(faultData.getSubcode());
        if (faultData.getDetailString() != null) {
            faultCode.setDetail(faultData.getDetailString());
        } else {
            faultCode.setDetailOMElement(faultData.getDetail());
            faultCode.setExtendedDetailOMElement(faultData.getDetail2());
        }
        sequenceFault.setFaultCode(faultCode);
        sequenceFault.toHeader(faultMessageContext.getEnvelope().getHeader());
    }

    private static void doSOAP11Encoding(MessageContext faultMsgContext, FaultData data, String rmNamespaceValue) throws SandeshaException {
        SOAPEnvelope faultMsgEnvelope = faultMsgContext.getEnvelope();
        if (faultMsgEnvelope == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("soapEnvNotSet"));
        }
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(faultMsgEnvelope));
        SOAPFault fault = faultMsgEnvelope.getBody().getFault();
        SOAPFaultCode code = fault.getCode();
        if (data.getCode() != null) {
            code.setText(data.getCode());
        }
        if (data.getExceptionString() != null) {
            fault.getDetail().setText(data.getExceptionString());
        }
        if (SOAPFaultEnvelopeCreator.isSequenceFault(data)) {
            SOAPFaultEnvelopeCreator.addSequenceFaultHeader(faultMsgContext, data, factory, rmNamespaceValue);
        }
    }

    private static void doSOAP12Encoding(MessageContext faultMsgContext, FaultData data, String rmNamespaceValue) throws SandeshaException {
        SOAPEnvelope faultEnvelope = faultMsgContext.getEnvelope();
        if (faultEnvelope == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("soapEnvNotSet"));
        }
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(faultEnvelope));
        SOAPFault fault = faultEnvelope.getBody().getFault();
        if (fault == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("noFaultCode", faultEnvelope.toString()));
        }
        SOAPFaultCode faultCode = fault.getCode();
        SOAPFaultValue codeValue = faultCode.getValue();
        codeValue.setText(data.getCode());
        SOAPFaultSubCode faultSubCode = factory.createSOAPFaultSubCode(faultCode);
        SOAPFaultValue subCodeValue = factory.createSOAPFaultValue(faultSubCode);
        subCodeValue.setText(data.getSubcode());
        SOAPFaultReason faultReason = fault.getReason();
        SOAPFaultText faultText = faultReason.getSOAPFaultText("en");
        if (faultText == null) {
            faultText = factory.createSOAPFaultText();
            faultReason.addSOAPText(faultText);
        }
        if (data.getReason() != null) {
            faultText.setText(data.getReason());
        }
        SOAPFaultDetail faultDetail = fault.getDetail();
        OMElement detailElement = data.getDetail();
        if (detailElement != null) {
            faultDetail.addChild((OMNode)detailElement);
        }
        faultMsgContext.setWSAAction("http://www.w3.org/2005/08/addressing/fault");
    }
}

