/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.external.vault;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.config.external.AbstractExternalConfigSupplier;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.Strings;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VaultExternalConfigSupplier
extends AbstractExternalConfigSupplier {
    public static final String CHARSET_NAME = "UTF-8";
    public static final ImmutableMap<String, String> MINIMAL_HEADERS = ImmutableMap.of((Object)"Content-Type", (Object)"application/json; charset=UTF-8", (Object)"Accept", (Object)"application/json", (Object)"Accept-Charset", (Object)"UTF-8");
    private static final Logger LOG = LoggerFactory.getLogger(VaultExternalConfigSupplier.class);
    protected final Map<String, String> config;
    protected final String name;
    protected final HttpClient httpClient;
    protected final Gson gson;
    protected final String endpoint;
    protected final String path;
    protected final String token;
    protected final ImmutableMap<String, String> headersWithToken;

    public VaultExternalConfigSupplier(ManagementContext managementContext, String name, Map<String, String> config) {
        super(managementContext, name);
        this.config = config;
        this.name = name;
        this.httpClient = HttpTool.httpClientBuilder().build();
        this.gson = new GsonBuilder().create();
        ArrayList errors = Lists.newArrayListWithCapacity((int)2);
        this.endpoint = config.get("endpoint");
        if (Strings.isBlank((CharSequence)this.endpoint)) {
            errors.add("missing configuration 'endpoint'");
        }
        this.path = config.get("path");
        if (Strings.isBlank((CharSequence)this.path)) {
            errors.add("missing configuration 'path'");
        }
        if (!errors.isEmpty()) {
            String message = String.format("Problem configuration Vault external config supplier '%s': %s", name, Joiner.on((String)System.lineSeparator()).join((Iterable)errors));
            throw new IllegalArgumentException(message);
        }
        this.token = this.initAndLogIn(config);
        this.headersWithToken = ImmutableMap.builder().putAll(MINIMAL_HEADERS).put((Object)"X-Vault-Token", (Object)this.token).build();
    }

    protected abstract String initAndLogIn(Map<String, String> var1);

    @Override
    public String get(String key) {
        JsonObject response = this.apiGet(Urls.mergePaths((String[])new String[]{"v1", this.path}), this.headersWithToken);
        return response.getAsJsonObject("data").get(key).getAsString();
    }

    public Map<String, String> getDataAsStringMap() {
        JsonObject response = this.apiGet(Urls.mergePaths((String[])new String[]{"v1", this.path}), this.headersWithToken);
        Map<String, JsonElement> dataMap = response.getAsJsonObject("data").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Maps.transformValues(dataMap, jsonElement -> jsonElement.getAsString());
    }

    protected JsonObject apiGet(String path, ImmutableMap<String, String> headers) {
        try {
            String uri = Urls.mergePaths((String[])new String[]{this.endpoint, path});
            LOG.trace("Vault request - GET: {}", (Object)uri);
            HttpToolResponse response = HttpTool.httpGet((HttpClient)this.httpClient, (URI)Urls.toUri((String)uri), headers);
            LOG.trace("Vault response - code: {} {}", (Object)response.getResponseCode(), (Object)response.getReasonPhrase());
            String responseBody = new String(response.getContent(), CHARSET_NAME);
            if (HttpTool.isStatusCodeHealthy((int)response.getResponseCode())) {
                return (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
            }
            throw new IllegalStateException("HTTP request returned error");
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected JsonObject apiPost(String path, ImmutableMap<String, String> headers, ImmutableMap<String, String> requestData) {
        try {
            String body = this.gson.toJson(requestData);
            String uri = Urls.mergePaths((String[])new String[]{this.endpoint, path});
            LOG.trace("Vault request - POST: {}", (Object)uri);
            HttpToolResponse response = HttpTool.httpPost((HttpClient)this.httpClient, (URI)Urls.toUri((String)uri), headers, (byte[])body.getBytes(CHARSET_NAME));
            LOG.trace("Vault response - code: {} {}", (Object)response.getResponseCode(), (Object)response.getReasonPhrase());
            String responseBody = new String(response.getContent(), CHARSET_NAME);
            if (HttpTool.isStatusCodeHealthy((int)response.getResponseCode())) {
                return (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
            }
            throw new IllegalStateException("HTTP request returned error");
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

