/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import org.ops4j.pax.web.extender.whiteboard.internal.ExtendedHttpServiceRuntime;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.HttpContextElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractHttpContextTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.util.ServicePropertiesUtils;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultHttpContextMapping;
import org.ops4j.pax.web.service.SharedWebContainerContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContextTracker
extends AbstractHttpContextTracker<HttpContext> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpContextTracker.class);

    private HttpContextTracker(ExtenderContext extenderContext, BundleContext bundleContext, ExtendedHttpServiceRuntime httpServiceRuntime) {
        super(extenderContext, bundleContext, httpServiceRuntime);
    }

    public static ServiceTracker<HttpContext, HttpContextElement> createTracker(ExtenderContext extenderContext, BundleContext bundleContext, ExtendedHttpServiceRuntime httpServiceRuntime) {
        return new HttpContextTracker(extenderContext, bundleContext, httpServiceRuntime).create(HttpContext.class);
    }

    @Override
    HttpContextElement createHttpContextElement(ServiceReference<HttpContext> serviceReference, HttpContext published) {
        String httpContextId = ServicePropertiesUtils.getStringProperty(serviceReference, "httpContext.id");
        String httpContextPath = ServicePropertiesUtils.getStringProperty(serviceReference, "httpContext.path");
        Boolean httpContextShared = ServicePropertiesUtils.extractSharedHttpContext(serviceReference);
        DefaultHttpContextMapping mapping = new DefaultHttpContextMapping();
        mapping.setHttpContextId(httpContextId);
        if (!httpContextShared.booleanValue() && published instanceof SharedWebContainerContext) {
            httpContextShared = true;
        } else if (httpContextShared.booleanValue() && !(published instanceof SharedWebContainerContext)) {
            httpContextShared = false;
        }
        mapping.setHttpContextShared(httpContextShared);
        mapping.setPath(httpContextPath);
        mapping.setHttpContext(published);
        LOG.debug("Create new HttpContext with mapping: " + mapping);
        return new HttpContextElement(serviceReference, mapping);
    }
}

